/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.openide.util.Exceptions;

public class MagicCache {
    private static final int BUF_LENGTH = 4000;
    private static final String cacheName = ".rfs_magic";
    private final RemoteDirectory dir;
    private Map<String, byte[]> cache;

    public MagicCache(RemoteDirectory dir) {
        this.dir = dir;
    }

    public synchronized byte[] get(String fileName) {
        if (this.cache == null) {
            this.cache = new HashMap<String, byte[]>();
            if (!this.readCache()) {
                this.cache = null;
                return null;
            }
        }
        return this.cache.get(fileName);
    }

    public synchronized void clean(String fileName) {
        File od = new File(this.dir.getCache(), cacheName);
        if (od.exists()) {
            od.delete();
            if (this.cache != null) {
                if (fileName == null) {
                    this.cache.clear();
                } else {
                    this.cache.remove(fileName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readCache() {
        File od = new File(this.dir.getCache(), cacheName);
        if (!od.exists()) {
            try {
                if (!ConnectionManager.getInstance().isConnectedTo(this.dir.getExecutionEnvironment())) {
                    return false;
                }
                this.updateCache();
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (UnsupportedEncodingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (od.exists()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(od));
                String line = null;
                String file = null;
                byte[] res = null;
                int pos = 0;
                while ((line = in.readLine()) != null) {
                    String[] split;
                    if (line.startsWith("./")) {
                        this.createEntry(file, res, pos);
                        file = line.substring(2);
                        res = new byte[4000];
                        pos = 0;
                        continue;
                    }
                    if (!line.startsWith("000") || (split = line.split(" ")).length <= 1) continue;
                    for (int i = 1; i < split.length; ++i) {
                        String s = split[i];
                        long L = Long.parseLong(s, 16);
                        res[pos++] = (byte)(L & 0xFFL);
                        res[pos++] = (byte)(L >> 8 & 0xFFL);
                        res[pos++] = (byte)(L >> 16 & 0xFFL);
                        res[pos++] = (byte)(L >> 24 & 0xFFL);
                    }
                }
                this.createEntry(file, res, pos);
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return true;
    }

    private void createEntry(String file, byte[] res, int pos) {
        if (file != null) {
            if (pos < res.length) {
                byte[] ares = new byte[pos];
                System.arraycopy(res, 0, ares, 0, pos);
                res = ares;
            }
            this.cache.put(file, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() throws FileNotFoundException, UnsupportedEncodingException, IOException {
        String command = "/usr/bin/find . ! -name . -prune -type f -print -exec od -X -N 4000 {} \\;";
        String path = this.dir.getPath();
        if (path.isEmpty()) {
            path = "/";
        }
        ProcessUtils.ExitStatus result = ProcessUtils.executeInDir((String)path, (ExecutionEnvironment)this.dir.getExecutionEnvironment(), (String)"/bin/sh", (String[])new String[]{"-c", command});
        File od = new File(this.dir.getCache(), cacheName);
        OutputStreamWriter os = null;
        try {
            os = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(od)));
            os.write(result.output);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

