/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.logging.Level;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.util.FindTypesSupport;
import org.netbeans.modules.bugtracking.util.StackTraceSupport;
import org.netbeans.modules.bugtracking.util.WebUrlHyperlinkSupport;
import org.openide.util.RequestProcessor;

public final class HyperlinkSupport {
    private static HyperlinkSupport instance = new HyperlinkSupport();
    static final String STACKTRACE_ATTRIBUTE = "attribute.stacktrace.link";
    static final String TYPE_ATTRIBUTE = "attribute.type.link";
    static final String URL_ATTRIBUTE = "attribute.url.link";
    public static final String LINK_ATTRIBUTE = "attribute.simple.link";
    private final MotionListener motionListener;
    private final java.awt.event.MouseListener mouseListener;
    private RequestProcessor rp = new RequestProcessor("Bugtracking hyperlinks", 50);

    private HyperlinkSupport() {
        this.motionListener = new MotionListener();
        this.mouseListener = new MouseListener();
    }

    public static HyperlinkSupport getInstance() {
        return instance;
    }

    public void registerForStacktraces(final JTextPane pane) {
        pane.removeMouseMotionListener(this.motionListener);
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                StackTraceSupport.register(pane);
                pane.addMouseMotionListener(HyperlinkSupport.this.motionListener);
            }
        });
    }

    public void registerForTypes(final JTextPane pane) {
        pane.removeMouseMotionListener(this.motionListener);
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                FindTypesSupport.getInstance().register(pane);
                pane.addMouseMotionListener(HyperlinkSupport.this.motionListener);
            }
        });
    }

    public void registerForURLs(final JTextPane pane) {
        pane.removeMouseMotionListener(this.motionListener);
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                WebUrlHyperlinkSupport.register(pane);
                pane.addMouseMotionListener(HyperlinkSupport.this.motionListener);
            }
        });
    }

    public void registerLink(final JTextPane pane, final int[] pos, final Link link) {
        pane.removeMouseMotionListener(this.motionListener);
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                HyperlinkSupport.this.registerLinkIntern(pane, pos, link);
                pane.addMouseMotionListener(HyperlinkSupport.this.motionListener);
            }
        });
    }

    public void registerForIssueLinks(final JTextPane pane, final Link issueLink, final IssueFinder issueFinder) {
        pane.removeMouseMotionListener(this.motionListener);
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                HyperlinkSupport.this.registerLinkIntern(pane, issueFinder.getIssueSpans(pane.getText()), issueLink);
                pane.addMouseMotionListener(HyperlinkSupport.this.motionListener);
            }
        });
    }

    private void registerLinkIntern(JTextPane pane, final int[] pos, Link link) {
        final StyledDocument doc = pane.getStyledDocument();
        if (pos.length > 0) {
            Style defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
            final Style hlStyle = doc.addStyle("regularBlue-link", defStyle);
            hlStyle.addAttribute(LINK_ATTRIBUTE, link);
            StyleConstants.setForeground(hlStyle, Color.BLUE);
            StyleConstants.setUnderline(hlStyle, true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < pos.length; i += 2) {
                        int off = pos[i];
                        int length = pos[i + 1] - pos[i];
                        doc.setCharacterAttributes(off, length, hlStyle, true);
                    }
                }
            });
            pane.addMouseListener(this.mouseListener);
        }
    }

    public static interface Link {
        public void onClick(String var1);
    }

    private class MotionListener
    extends MouseMotionAdapter {
        private MotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTextPane pane = (JTextPane)e.getSource();
            StyledDocument doc = pane.getStyledDocument();
            Element elem = doc.getCharacterElement(pane.viewToModel(e.getPoint()));
            AttributeSet as = elem.getAttributes();
            if (StyleConstants.isUnderline(as)) {
                pane.setCursor(new Cursor(12));
            } else {
                pane.setCursor(new Cursor(0));
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                JTextPane pane;
                StyledDocument doc;
                Element elem;
                AttributeSet as;
                Link link;
                if (SwingUtilities.isLeftMouseButton(e) && (link = (Link)(as = (elem = (doc = (pane = (JTextPane)e.getSource()).getStyledDocument()).getCharacterElement(pane.viewToModel(e.getPoint()))).getAttributes()).getAttribute(HyperlinkSupport.LINK_ATTRIBUTE)) != null) {
                    link.onClick(elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset()));
                }
            }
            catch (Exception ex) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
            }
        }
    }
}

