/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.jira.JiraUpdater;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.nodes.BugtrackingRootNode;
import org.netbeans.modules.bugtracking.ui.selectors.SelectorPanel;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;

public class RepositorySelector {
    private SelectorPanel selectorPanel = new SelectorPanel();

    public Repository create() {
        BugtrackingConnector[] connectors = BugtrackingManager.getInstance().getConnectors();
        connectors = this.addJiraProxyIfNeeded(connectors);
        this.selectorPanel.setConnectors(connectors);
        if (!this.selectorPanel.open()) {
            return null;
        }
        final Repository repo = this.selectorPanel.getRepository();
        try {
            repo.getController().applyChanges();
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
            return null;
        }
        BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                BugtrackingRootNode.selectNode(repo.getDisplayName());
            }
        });
        return repo;
    }

    public boolean edit(Repository repository, String errorMessage) {
        if (!this.selectorPanel.edit(repository, errorMessage)) {
            return false;
        }
        Repository repo = this.selectorPanel.getRepository();
        try {
            repo.getController().applyChanges();
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    private BugtrackingConnector[] addJiraProxyIfNeeded(BugtrackingConnector[] connectors) {
        if (!BugtrackingUtil.isJiraInstalled()) {
            BugtrackingConnector[] ret = new BugtrackingConnector[connectors.length + 1];
            System.arraycopy(connectors, 0, ret, 0, connectors.length);
            ret[ret.length - 1] = JiraUpdater.getInstance().getConnector();
            connectors = ret;
        }
        return connectors;
    }
}

