/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai.spi;

import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JLabel;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiAccessor;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiRepositories;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.nodes.Node;

public class KenaiUtil {
    public static KenaiAccessor getKenaiAccessor() {
        return BugtrackingManager.getInstance().getKenaiAccessor();
    }

    public static boolean isLoggedIn(URL url) {
        return KenaiUtil.isLoggedIn(url.toString());
    }

    public static boolean isLoggedIn(String url) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.isLoggedIn(url) : false;
    }

    public static boolean isKenai(Repository repo) {
        return repo.getLookup().lookup(KenaiProject.class) != null;
    }

    public static PasswordAuthentication getPasswordAuthentication(String url, boolean forceLogin) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getPasswordAuthentication(url, forceLogin) : null;
    }

    public static boolean showLogin() {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.showLogin() : false;
    }

    public static Repository getRepository(String repositoryUrl) throws IOException {
        KenaiProject project = KenaiUtil.getKenaiProjectForRepository(repositoryUrl);
        return project != null ? KenaiUtil.getRepository(project) : null;
    }

    public static Repository getRepository(String url, String projectName) throws IOException {
        KenaiProject p = KenaiUtil.getKenaiProject(url, projectName);
        return p != null ? KenaiUtil.getRepository(p) : null;
    }

    public static Repository getRepository(KenaiProject project) {
        return KenaiRepositories.getInstance().getRepository(project);
    }

    public static Repository getRepository(KenaiProject project, boolean forceCreate) {
        return KenaiRepositories.getInstance().getRepository(project, forceCreate);
    }

    public static Repository[] getRepositories(boolean pingOpenProjects) {
        return KenaiRepositories.getInstance().getRepositories(pingOpenProjects);
    }

    public static Collection<RepositoryUser> getProjectMembers(KenaiProject kp) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        try {
            return ka != null ? ka.getProjectMembers(kp) : Collections.EMPTY_LIST;
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.WARNING, null, ex);
            return Collections.EMPTY_LIST;
        }
    }

    public static String getChatLink(Issue issue) {
        return "ISSUE:" + issue.getID();
    }

    public static void refreshOpenedQueries() {
        Set<QueryTopComponent> tcs = QueryTopComponent.getOpenQueries();
        for (QueryTopComponent tc : tcs) {
            tc.updateSavedQueries();
        }
    }

    public static boolean isNetbeansKenaiRegistered() {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.isNetbeansKenaiRegistered() : false;
    }

    public static JLabel createUserWidget(String userName, String host, String chatMessage) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        assert (ka != null);
        return ka.createUserWidget(userName, host, chatMessage);
    }

    public static OwnerInfo getOwnerInfo(Node node) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getOwnerInfo(node) : null;
    }

    public static OwnerInfo getOwnerInfo(File file) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getOwnerInfo(file) : null;
    }

    public static void logKenaiUsage(Object ... parameters) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        if (ka != null) {
            ka.logKenaiUsage(parameters);
        }
    }

    public static KenaiProject getKenaiProjectForRepository(String repositoryUrl) throws IOException {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getKenaiProjectForRepository(repositoryUrl) : null;
    }

    public static KenaiProject getKenaiProject(String url, String projectName) throws IOException {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getKenaiProject(url, projectName) : null;
    }

    public static KenaiProject[] getDashboardProjects() {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getDashboardProjects() : new KenaiProject[]{};
    }

    public static Repository findNBRepository() {
        BugtrackingConnector[] connectors;
        for (BugtrackingConnector c : connectors = BugtrackingUtil.getBugtrackingConnectors()) {
            KenaiSupport support = (KenaiSupport)c.getLookup().lookup(KenaiSupport.class);
            if (support == null || support.getType() != KenaiSupport.BugtrackingType.BUGZILLA) continue;
            return support.findNBRepository();
        }
        return null;
    }
}

