/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class UnusedVariableHint
extends AbstractRule {
    private static final String HINT_ID = "Unused.Variable.Hint";
    private static final List<String> UNCHECKED_VARIABLES = new LinkedList<String>();

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        VariablesHeap variablesHeap = new VariablesHeap(phpParseResult.getModel(), context.doc);
        HintsCreator hintsCreator = new HintsCreator(variablesHeap, fileObject, context.doc);
        CheckVisitor checkVisitor = new CheckVisitor(variablesHeap);
        phpParseResult.getProgram().accept(checkVisitor);
        hints.addAll(hintsCreator.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.UnusedVariableHintDesc();
    }

    public String getDisplayName() {
        return Bundle.UnusedVariableHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @CheckForNull
    static Identifier getIdentifier(ASTNode node) {
        Variable variable = null;
        Identifier retval = null;
        if (node instanceof FormalParameter) {
            Reference reference;
            FormalParameter formalParameter = (FormalParameter)node;
            if (formalParameter.getParameterName() instanceof Variable) {
                variable = (Variable)formalParameter.getParameterName();
            } else if (formalParameter.getParameterName() instanceof Reference && (reference = (Reference)formalParameter.getParameterName()).getExpression() instanceof Variable) {
                variable = (Variable)reference.getExpression();
            }
        } else if (node instanceof Variable) {
            variable = (Variable)node;
        }
        if (variable != null && variable.isDollared() && variable.getName() instanceof Identifier) {
            retval = (Identifier)variable.getName();
        }
        return retval;
    }

    static {
        UNCHECKED_VARIABLES.add("this");
        UNCHECKED_VARIABLES.add("GLOBALS");
        UNCHECKED_VARIABLES.add("_SERVER");
        UNCHECKED_VARIABLES.add("_GET");
        UNCHECKED_VARIABLES.add("_POST");
        UNCHECKED_VARIABLES.add("_FILES");
        UNCHECKED_VARIABLES.add("_COOKIE");
        UNCHECKED_VARIABLES.add("_SESSION");
        UNCHECKED_VARIABLES.add("_REQUEST");
        UNCHECKED_VARIABLES.add("_ENV");
    }

    private class HintsCreator {
        private final List<Hint> hints = new LinkedList<Hint>();
        private final VariablesHeap variablesHeap;
        private final FileObject fileObject;
        private final BaseDocument doc;

        public HintsCreator(VariablesHeap variablesHeap, FileObject fileObject, BaseDocument doc) {
            this.variablesHeap = variablesHeap;
            this.fileObject = fileObject;
            this.doc = doc;
        }

        public List<Hint> getHints() {
            for (VariableScope variableScope : this.variablesHeap.getVariableScopes()) {
                this.checkVariableScope(variableScope);
            }
            return this.hints;
        }

        private void checkVariableScope(VariableScope variableScope) {
            Collection<? extends VariableName> declaredVariables = variableScope.getDeclaredVariables();
            for (VariableName variableName : declaredVariables) {
                if (UNCHECKED_VARIABLES.contains(this.getPureName(variableName)) || this.isInPhpComment(variableName.getOffset())) continue;
                this.checkVariableName(variableName, variableScope);
            }
        }

        private boolean isInPhpComment(int offset) {
            Token<? extends PHPTokenId> token = LexUtilities.getToken(this.doc, offset);
            PHPTokenId id = (PHPTokenId)token.id();
            return id == PHPTokenId.PHP_COMMENT || id == PHPTokenId.PHPDOC_COMMENT;
        }

        private void checkVariableName(VariableName variableName, VariableScope variableScope) {
            Map<String, List<Identifier>> scopeVars = this.variablesHeap.getScopeVariables(variableScope);
            if (this.isParam(variableName) && this.variablesHeap.isUsedParamInScope(variableScope)) {
                scopeVars.remove(this.getPureName(variableName));
            } else {
                this.checkIdentifiers(variableName, scopeVars);
            }
        }

        private boolean isParam(VariableName variableName) {
            boolean retval = false;
            if (variableName.getInScope() instanceof FunctionScope) {
                FunctionScope scope = (FunctionScope)variableName.getInScope();
                if (variableName.getNameRange().getStart() > scope.getOffset() && variableName.getNameRange().getEnd() < scope.getBlockRange().getStart()) {
                    retval = true;
                }
            }
            return retval;
        }

        private void checkIdentifiers(VariableName variableName, Map<String, List<Identifier>> scopeVars) {
            List<Identifier> identifiers = scopeVars.get(this.getPureName(variableName));
            if (identifiers != null && identifiers.size() > 1) {
                scopeVars.remove(this.getPureName(variableName));
            } else {
                this.hints.add(this.createHint(variableName));
            }
        }

        private String getPureName(VariableName variableName) {
            return variableName.getName().substring(1);
        }

        private Hint createHint(VariableName variableName) {
            String varName = this.getPureName(variableName);
            int start = variableName.getNameRange().getStart();
            int end = start + varName.length();
            OffsetRange offsetRange = new OffsetRange(start, end);
            Hint hint = new Hint((Rule)UnusedVariableHint.this, Bundle.UnusedVariableHintCustom(varName), this.fileObject, offsetRange, null, 500);
            return hint;
        }
    }

    private class VariablesHeap {
        private final Map<VariableScope, Map<String, List<Identifier>>> allVariables = new HashMap<VariableScope, Map<String, List<Identifier>>>();
        private final Set<VariableScope> scopesWithUsedParams = new HashSet<VariableScope>();
        private final Model model;
        private final BaseDocument doc;

        public VariablesHeap(Model model, BaseDocument doc) {
            this.model = model;
            this.doc = doc;
        }

        public void setParamUsageInScope(int inScopeOffset) {
            VariableScope variableScope = this.model.getVariableScope(inScopeOffset);
            this.scopesWithUsedParams.add(variableScope);
        }

        public boolean isUsedParamInScope(VariableScope variableScope) {
            return this.scopesWithUsedParams.contains(variableScope);
        }

        public void addNodeUsage(ASTNode node) {
            Identifier identifier = UnusedVariableHint.getIdentifier(node);
            if (identifier != null && !UNCHECKED_VARIABLES.contains(identifier.getName())) {
                int inScopeOffset = this.resolveInScopeOffset(node);
                VariableScope variableScope = this.model.getVariableScope(inScopeOffset);
                Map<String, List<Identifier>> scopeVars = this.getScopeVariables(variableScope);
                List<Identifier> identifiers = this.getIdentifiersOfName(scopeVars, identifier.getName());
                identifiers.add(identifier);
            }
        }

        private int resolveInScopeOffset(ASTNode node) {
            int retval = 0;
            if (node instanceof FormalParameter) {
                retval = this.getOffsetAfterBlockCurlyOpen(this.doc, node.getEndOffset());
            } else if (node instanceof Variable) {
                retval = node.getEndOffset();
            }
            return retval;
        }

        private int getOffsetAfterBlockCurlyOpen(BaseDocument doc, int offset) {
            int retval = offset;
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, retval);
            if (ts != null) {
                ts.move(retval);
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (t.id() != PHPTokenId.PHP_CURLY_OPEN) continue;
                    ts.moveNext();
                    retval = ts.offset();
                    break;
                }
            }
            return retval;
        }

        public Map<String, List<Identifier>> getScopeVariables(VariableScope variableScope) {
            Map<String, List<Identifier>> scopeVars = this.allVariables.get(variableScope);
            if (scopeVars == null) {
                scopeVars = new HashMap<String, List<Identifier>>();
                this.allVariables.put(variableScope, scopeVars);
            }
            return scopeVars;
        }

        private List<Identifier> getIdentifiersOfName(Map<String, List<Identifier>> scopeVars, String name) {
            List<Identifier> identifiers = scopeVars.get(name);
            if (identifiers == null) {
                identifiers = new LinkedList<Identifier>();
                scopeVars.put(name, identifiers);
            }
            return identifiers;
        }

        public Set<VariableScope> getVariableScopes() {
            return this.allVariables.keySet();
        }
    }

    private class CheckVisitor
    extends DefaultTreePathVisitor {
        private static final String FUNC_GET_ARG = "func_get_arg";
        private final VariablesHeap variablesHeap;

        public CheckVisitor(VariablesHeap variablesHeap) {
            this.variablesHeap = variablesHeap;
        }

        @Override
        public void visit(FormalParameter node) {
            super.visit(node);
            this.processNode(node);
        }

        @Override
        public void visit(Variable node) {
            super.visit(node);
            this.processNode(node);
        }

        private void processNode(ASTNode node) {
            Identifier identifier = UnusedVariableHint.getIdentifier(node);
            if (identifier != null) {
                this.variablesHeap.addNodeUsage(node);
            }
        }

        @Override
        public void visit(FunctionInvocation node) {
            Identifier functionIdentifier;
            NamespaceName namespaceName;
            super.visit(node);
            if (node.getFunctionName().getName() instanceof NamespaceName && (namespaceName = (NamespaceName)node.getFunctionName().getName()).getSegments().size() == 1 && (functionIdentifier = ModelUtils.getFirst(namespaceName.getSegments())).getName().startsWith(FUNC_GET_ARG)) {
                this.variablesHeap.setParamUsageInScope(node.getStartOffset());
            }
        }
    }
}

