/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.CheckPHPVersionVisitor;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.PHPRuleWithPreferences;
import org.netbeans.modules.php.editor.verification.PHPVerificationVisitor;
import org.netbeans.modules.php.editor.verification.VarStackReadingRule;
import org.openide.filesystems.FileObject;

public class PHPHintsProvider
implements HintsProvider {
    public static final String FIRST_PASS_HINTS = "1st pass";
    public static final String SECOND_PASS_HINTS = "2nd pass";
    public static final String DEFAULT_LINE_HINTS = "default.line.hints";
    private static final Logger LOGGER = Logger.getLogger(PHPHintsProvider.class.getName());

    public void computeHints(HintsProvider.HintsManager mgr, RuleContext context, List<Hint> hints) {
        long startTime = LOGGER.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        ParserResult info = context.parserResult;
        Map allHints = mgr.getHints(false, context);
        List modelHints = (List)allHints.get(DEFAULT_LINE_HINTS);
        if (modelHints != null) {
            FileScope modelScope;
            PHPRuleContext ruleContext = (PHPRuleContext)context;
            PHPParseResult result = (PHPParseResult)info;
            Model model = result.getModel();
            ruleContext.fileScope = modelScope = model.getFileScope();
            for (Rule.AstRule astRule : modelHints) {
                if (!mgr.isEnabled((Rule.UserConfigurableRule)astRule) || !(astRule instanceof AbstractRule)) continue;
                AbstractRule icm = (AbstractRule)astRule;
                try {
                    icm.computeHintsImpl(ruleContext, hints, Kind.HINT);
                }
                catch (BadLocationException ex) {
                    return;
                }
            }
        }
        this.computeExperimentalHints(context, allHints, mgr, hints);
        if (LOGGER.isLoggable(Level.FINE)) {
            long execTime = Calendar.getInstance().getTimeInMillis() - startTime;
            FileObject fobj = info.getSnapshot().getSource().getFileObject();
            LOGGER.fine(String.format("Computing PHP hints for %s.%s took %d ms", fobj.getName(), fobj.getExt(), execTime));
        }
    }

    public void computeSuggestions(HintsProvider.HintsManager mgr, RuleContext context, List<Hint> suggestions, int caretOffset) {
        Map allHints = mgr.getHints(true, context);
        List modelHints = (List)allHints.get(DEFAULT_LINE_HINTS);
        if (modelHints != null) {
            FileScope modelScope;
            PHPRuleContext ruleContext = (PHPRuleContext)context;
            ParserResult info = context.parserResult;
            if (!(info instanceof PHPParseResult)) {
                return;
            }
            PHPParseResult result = (PHPParseResult)info;
            Model model = result.getModel();
            ruleContext.fileScope = modelScope = model.getFileScope();
            for (Rule.AstRule astRule : modelHints) {
                if (!mgr.isEnabled((Rule.UserConfigurableRule)astRule) || !(astRule instanceof AbstractRule)) continue;
                AbstractRule icm = (AbstractRule)astRule;
                try {
                    icm.computeHintsImpl(ruleContext, suggestions, Kind.SUGGESTION);
                }
                catch (BadLocationException ex) {
                    return;
                }
            }
        }
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        PHPParseResult phpParseResult;
        FileObject fobj;
        ParserResult parserResult = context.parserResult;
        if (parserResult != null) {
            List errors = parserResult.getDiagnostics();
            unhandled.addAll(errors);
        }
        if ((fobj = NbEditorUtilities.getFileObject((Document)context.doc)) != null && CheckPHPVersionVisitor.appliesTo(fobj) && (phpParseResult = (PHPParseResult)context.parserResult).getProgram() != null) {
            CheckPHPVersionVisitor visitor = new CheckPHPVersionVisitor(fobj);
            phpParseResult.getProgram().accept(visitor);
            unhandled.addAll(visitor.getErrors());
        }
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return Collections.emptyList();
    }

    public RuleContext createRuleContext() {
        return new PHPRuleContext();
    }

    private void computeExperimentalHints(RuleContext context, Map<?, List<? extends Rule.AstRule>> allHints, HintsProvider.HintsManager mgr, List<Hint> hints) {
        ArrayList<PHPRule> firstPassHints = new ArrayList<PHPRule>();
        for (Rule.AstRule astRule : allHints.get(FIRST_PASS_HINTS)) {
            PHPRule rule;
            if (!(astRule instanceof PHPRule) || !mgr.isEnabled((Rule.UserConfigurableRule)(rule = (PHPRule)astRule))) continue;
            firstPassHints.add(rule);
            if (!(rule instanceof PHPRuleWithPreferences)) continue;
            PHPRuleWithPreferences ruleWithPrefs = (PHPRuleWithPreferences)((Object)rule);
            ruleWithPrefs.setPreferences(mgr.getPreferences((Rule.UserConfigurableRule)rule));
        }
        boolean maintainVarStack = false;
        block1: for (List<Rule.AstRule> list : allHints.values()) {
            for (Rule.AstRule astRule : list) {
                VarStackReadingRule rule;
                if (!(astRule instanceof VarStackReadingRule) || !mgr.isEnabled((Rule.UserConfigurableRule)(rule = (VarStackReadingRule)astRule))) continue;
                maintainVarStack = true;
                LOGGER.fine(rule.getClass().getName() + " is enabled, turning on the VarStack");
                continue block1;
            }
        }
        PHPVerificationVisitor pHPVerificationVisitor = new PHPVerificationVisitor((PHPRuleContext)context, firstPassHints, maintainVarStack);
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null) {
            phpParseResult.getProgram().accept(pHPVerificationVisitor);
        }
        hints.addAll(pHPVerificationVisitor.getResult());
    }

    static enum Kind {
        HINT,
        SUGGESTION,
        SELECTION,
        ERROR;

    }
}

