/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.UseElement;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class VariousUtils {
    public static final String CONSTRUCTOR_TYPE_PREFIX = "constuct:";
    public static final String FUNCTION_TYPE_PREFIX = "fn:";
    public static final String METHOD_TYPE_PREFIX = "mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "static.mtd:";
    public static final String FIELD_TYPE_PREFIX = "fld:";
    public static final String STATIC_FIELD__TYPE_PREFIX = "static.fld:";
    public static final String VAR_TYPE_PREFIX = "var:";
    public static final String ARRAY_TYPE_PREFIX = "array:";
    private static Set<String> recursionDetection = new HashSet<String>();
    private static final Collection<PHPTokenId> CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE);

    public static String extractTypeFroVariableBase(VariableBase varBase) {
        return VariousUtils.extractTypeFroVariableBase(varBase, Collections.<String, AssignmentImpl>emptyMap());
    }

    static String extractTypeFroVariableBase(VariableBase varBase, Map<String, AssignmentImpl> allAssignments) {
        Stack<VariableBase> stack = new Stack<VariableBase>();
        String typeName = null;
        VariousUtils.createVariableBaseChain(varBase, stack);
        while (!stack.isEmpty() && stack.peek() != null) {
            varBase = stack.pop();
            String tmpType = VariousUtils.extractVariableTypeFromVariableBase(varBase, allAssignments);
            if (tmpType == null) {
                typeName = tmpType;
                break;
            }
            if (typeName == null) {
                typeName = tmpType;
                continue;
            }
            typeName = typeName + tmpType;
        }
        return typeName;
    }

    private VariousUtils() {
    }

    public static String getReturnTypeFromPHPDoc(Program root, FunctionDeclaration functionDeclaration) {
        return VariousUtils.getTypeFromPHPDoc(root, functionDeclaration, PHPDocTag.Type.RETURN);
    }

    public static String getFieldTypeFromPHPDoc(Program root, SingleFieldDeclaration field) {
        return VariousUtils.getTypeFromPHPDoc(root, field, PHPDocTag.Type.VAR);
    }

    public static Map<String, List<QualifiedName>> getParamTypesFromPHPDoc(Program root, ASTNode node) {
        HashMap<String, List<QualifiedName>> retval = new HashMap<String, List<QualifiedName>>();
        Comment comment = Utils.getCommentForNode(root, node);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock phpDoc = (PHPDocBlock)comment;
            for (PHPDocTag tag : phpDoc.getTags()) {
                if (tag.getKind() != PHPDocTag.Type.PARAM) continue;
                ArrayList<QualifiedName> types = new ArrayList<QualifiedName>();
                PHPDocVarTypeTag paramTag = (PHPDocVarTypeTag)tag;
                for (PHPDocTypeNode type : paramTag.getTypes()) {
                    types.add(QualifiedName.create(type.getValue()));
                }
                retval.put(paramTag.getVariable().getValue(), types);
            }
        }
        return retval;
    }

    public static String getTypeFromPHPDoc(Program root, ASTNode node, PHPDocTag.Type tagType) {
        Comment comment = Utils.getCommentForNode(root, node);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock phpDoc = (PHPDocBlock)comment;
            for (PHPDocTag tag : phpDoc.getTags()) {
                if (tag.getKind() != tagType) continue;
                String[] parts = tag.getValue().trim().split("\\s+", 2);
                if (parts.length <= 0) break;
                String type = parts[0].split("\\;", 2)[0];
                return type;
            }
        }
        return null;
    }

    @CheckForNull
    static String extractVariableTypeFromAssignment(Assignment assignment, Map<String, AssignmentImpl> allAssignments) {
        Expression expression = assignment.getRightHandSide();
        return VariousUtils.extractVariableTypeFromExpression(expression, allAssignments);
    }

    static String extractVariableTypeFromExpression(Expression expression, Map<String, AssignmentImpl> allAssignments) {
        InfixExpression infixExpression;
        InfixExpression.OperatorType operator;
        if (expression instanceof Assignment) {
            return VariousUtils.extractVariableTypeFromAssignment((Assignment)expression, allAssignments);
        }
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            expression = ref.getExpression();
        }
        if (expression instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
            ClassName className = classInstanceCreation.getClassName();
            Expression name = className.getName();
            if (name instanceof NamespaceName) {
                QualifiedName qn = QualifiedName.create(name);
                return qn.toString();
            }
            return CodeUtils.extractClassName(className);
        }
        if (expression instanceof ArrayCreation) {
            return "array";
        }
        if (expression instanceof VariableBase) {
            return VariousUtils.extractTypeFroVariableBase((VariableBase)expression, allAssignments);
        }
        if (expression instanceof Scalar) {
            Scalar scalar = (Scalar)expression;
            Scalar.Type scalarType = scalar.getScalarType();
            if (scalarType.equals((Object)Scalar.Type.STRING)) {
                String stringValue = scalar.getStringValue().toLowerCase();
                if (stringValue.equals("false") || stringValue.equals("true")) {
                    return "boolean";
                }
                if (stringValue.equals("null")) {
                    return "null";
                }
            }
            return scalarType.toString().toLowerCase();
        }
        if (expression instanceof InfixExpression && (operator = (infixExpression = (InfixExpression)expression).getOperator()).equals((Object)InfixExpression.OperatorType.CONCAT)) {
            return Scalar.Type.STRING.toString().toLowerCase();
        }
        return null;
    }

    public static String replaceVarNames(String semiTypeName, Map<String, String> var2Type) {
        StringBuilder retval = new StringBuilder();
        String[] fragments = semiTypeName.split("[@:]");
        for (int i = 0; i < fragments.length; ++i) {
            String frag = fragments[i];
            if (frag.trim().length() == 0) continue;
            if (VAR_TYPE_PREFIX.startsWith(frag)) {
                String varName;
                String type;
                if (i + 1 < fragments.length && (type = var2Type.get(varName = fragments[++i])) != null) {
                    retval.append(type);
                    continue;
                }
                return null;
            }
            Kind[] values = Kind.values();
            boolean isPrefix = false;
            for (Kind kind : values) {
                if (!kind.toString().startsWith(frag)) continue;
                isPrefix = true;
                break;
            }
            if (isPrefix) {
                retval.append("@");
                retval.append(frag);
                retval.append(":");
                isPrefix = true;
                continue;
            }
            retval.append(frag);
        }
        return retval.toString();
    }

    public static Collection<? extends VariableName> getAllVariables(VariableScope varScope, String semiTypeName) {
        ArrayList<VariableName> retval = new ArrayList<VariableName>();
        String[] fragments = semiTypeName.split("[@:]");
        for (int i = 0; i < fragments.length; ++i) {
            String varName;
            VariableName var;
            String frag = fragments[i];
            if (frag.trim().length() == 0 || !VAR_TYPE_PREFIX.startsWith(frag) || i + 1 >= fragments.length) continue;
            VariableName variableName = var = (varName = fragments[++i]) != null ? ModelUtils.getFirst(varScope.getDeclaredVariables(), varName) : null;
            if (var != null) {
                retval.add(var);
                continue;
            }
            return Collections.emptyList();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends TypeScope> getType(VariableScope varScope, String semiTypeName, int offset, boolean justDispatcher) throws IllegalStateException {
        Collection<Object> recentTypes = Collections.emptyList();
        List<TypeScope> oldRecentTypes = Collections.emptyList();
        Stack<VariableName> fldVarStack = new Stack<VariableName>();
        if (semiTypeName != null && semiTypeName.contains("@")) {
            String operation = null;
            String[] fragments = semiTypeName.split("[@:]");
            int len = justDispatcher ? fragments.length - 1 : fragments.length;
            for (int i = 0; i < len; ++i) {
                HashSet<TypeScope> newRecentTypes;
                String operationPrefix;
                oldRecentTypes = recentTypes;
                String frag = fragments[i].trim();
                if (frag.length() == 0) continue;
                String string = operationPrefix = frag.endsWith(":") ? frag : String.format("%s:", frag);
                if (METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = METHOD_TYPE_PREFIX;
                    continue;
                }
                if (FUNCTION_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FUNCTION_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = STATIC_METHOD_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_FIELD__TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (VAR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = VAR_TYPE_PREFIX;
                    continue;
                }
                if (ARRAY_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = ARRAY_TYPE_PREFIX;
                    continue;
                }
                if (FIELD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (CONSTRUCTOR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = CONSTRUCTOR_TYPE_PREFIX;
                    continue;
                }
                if (operation == null) {
                    assert (i == 0) : frag;
                    recentTypes = IndexScopeImpl.getTypes(QualifiedName.create(frag), varScope);
                    continue;
                }
                if (operation.startsWith(CONSTRUCTOR_TYPE_PREFIX)) {
                    return Collections.emptyList();
                }
                if (operation.startsWith(METHOD_TYPE_PREFIX)) {
                    newRecentTypes = new HashSet<TypeScope>();
                    for (TypeScope tScope : oldRecentTypes) {
                        Collection<? extends MethodScope> inheritedMethods = IndexScopeImpl.getMethods(tScope, frag, varScope, -1);
                        for (MethodScope methodScope : inheritedMethods) {
                            newRecentTypes.addAll(methodScope.getReturnTypes(true));
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FUNCTION_TYPE_PREFIX)) {
                    newRecentTypes = new HashSet();
                    FunctionScope fnc = ModelUtils.getFirst(IndexScopeImpl.getFunctions(QualifiedName.create(frag), varScope));
                    if (fnc != null) {
                        newRecentTypes.addAll(fnc.getReturnTypes(true));
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                    newRecentTypes = new HashSet();
                    String[] frgs = frag.split("\\.");
                    assert (frgs.length == 2);
                    String clsName = frgs[0];
                    if (clsName != null) {
                        List<? extends ClassScope> classes = IndexScopeImpl.getClasses(VariousUtils.createQuery(clsName, varScope), varScope);
                        for (ClassScope classScope : classes) {
                            Collection<? extends MethodScope> inheritedMethods = IndexScopeImpl.getMethods(classScope, frgs[1], varScope, -1);
                            for (MethodScope methodScope : inheritedMethods) {
                                newRecentTypes.addAll(methodScope.getReturnTypes(true));
                            }
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(VAR_TYPE_PREFIX) || operation.startsWith(ARRAY_TYPE_PREFIX)) {
                    newRecentTypes = new HashSet();
                    String varName = frag;
                    VariableName var = ModelUtils.getFirst(varScope.getDeclaredVariables(), varName);
                    if (var != null) {
                        if (i + 2 < len && FIELD_TYPE_PREFIX.startsWith(fragments[i + 1])) {
                            fldVarStack.push(var);
                        }
                        String checkName = var.getName() + String.valueOf(offset);
                        boolean added = recursionDetection.add(checkName);
                        try {
                            if (added) {
                                boolean bl = operation.startsWith(ARRAY_TYPE_PREFIX);
                                if (bl) {
                                    newRecentTypes.addAll(var.getArrayAccessTypes(offset));
                                } else {
                                    newRecentTypes.addAll(var.getTypes(offset));
                                }
                            }
                        }
                        finally {
                            recursionDetection.remove(checkName);
                        }
                    }
                    if (newRecentTypes.isEmpty() && varScope instanceof MethodScope) {
                        Scope inScope;
                        MethodScope mScope = (MethodScope)varScope;
                        if ((frag.equals("this") || frag.equals("$this")) && (inScope = mScope.getInScope()) instanceof ClassScope) {
                            String string2 = ((ClassScope)inScope).getName();
                            newRecentTypes.addAll(IndexScopeImpl.getClasses(QualifiedName.create(string2), varScope));
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FIELD_TYPE_PREFIX)) {
                    VariableName var = fldVarStack.isEmpty() ? null : (VariableName)fldVarStack.pop();
                    HashSet<? extends TypeScope> newRecentTypes2 = new HashSet<TypeScope>();
                    String fldName = frag;
                    if (!fldName.startsWith("$")) {
                        fldName = "$" + fldName;
                    }
                    for (TypeScope type : oldRecentTypes) {
                        Collection<? extends FieldElement> collection = IndexScopeImpl.getFields(type, fldName, varScope, -1);
                        for (FieldElement fieldElement : collection) {
                            if (var != null) {
                                Collection collection2 = var.getFieldTypes(fieldElement, offset);
                                if (collection2.isEmpty() && fieldElement instanceof FieldElementImpl) {
                                    newRecentTypes2.addAll(((FieldElementImpl)fieldElement).getDefaultTypes());
                                    continue;
                                }
                                newRecentTypes2.addAll(collection2);
                                continue;
                            }
                            newRecentTypes2.addAll(fieldElement.getTypes(offset));
                        }
                    }
                    recentTypes = newRecentTypes2;
                    operation = null;
                    continue;
                }
                throw new UnsupportedOperationException(operation);
            }
        } else if (semiTypeName != null) {
            QualifiedName qn = QualifiedName.create(semiTypeName);
            qn = qn.toNamespaceName().append(VariousUtils.translateSpecialClassName(varScope, qn.getName()));
            if (semiTypeName.startsWith("\\")) {
                qn = qn.toFullyQualified();
            } else {
                Collection<QualifiedName> possibleFQN;
                NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(varScope);
                if (namespaceScope != null && !(possibleFQN = VariousUtils.getPossibleFQN(qn, offset, namespaceScope)).isEmpty()) {
                    qn = ModelUtils.getFirst(possibleFQN);
                }
            }
            IndexScope indexScope = ModelUtils.getIndexScope(varScope);
            return indexScope.findTypes(qn);
        }
        return recentTypes;
    }

    private static QualifiedName createQuery(String semiTypeName, Scope scope) {
        QualifiedName query = QualifiedName.create(semiTypeName);
        return query.toNamespaceName().append(VariousUtils.translateSpecialClassName(scope, query.getName()));
    }

    public static Stack<? extends ModelElement> getElemenst(FileScope topScope, VariableScope varScope, String semiTypeName, int offset) throws IllegalStateException {
        Stack emptyStack = new Stack();
        Stack<ModelElement> retval = new Stack<ModelElement>();
        Stack<Collection> stack = new Stack<Collection>();
        TypeScope type = null;
        if (semiTypeName != null && semiTypeName.contains("@")) {
            String operation = null;
            String[] fragments = semiTypeName.split("[@:]");
            int len = fragments.length;
            for (int i = 0; i < len; ++i) {
                MethodScope meth;
                TypeScope cls;
                Collection<? extends TypeScope> types;
                String operationPrefix;
                String frag = fragments[i];
                if (frag.trim().length() == 0) continue;
                String string = operationPrefix = frag.endsWith(":") ? frag : String.format("%s:", frag);
                if (METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = METHOD_TYPE_PREFIX;
                    continue;
                }
                if (FUNCTION_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = FUNCTION_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = STATIC_METHOD_TYPE_PREFIX;
                    continue;
                }
                if (VAR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = VAR_TYPE_PREFIX;
                    continue;
                }
                if (FIELD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (CONSTRUCTOR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = CONSTRUCTOR_TYPE_PREFIX;
                    continue;
                }
                if (operation == null) {
                    assert (i == 0);
                    types = IndexScopeImpl.getTypes(QualifiedName.create(frag), topScope);
                    if (types.isEmpty()) continue;
                    stack.push(types);
                    continue;
                }
                if (operation.startsWith(METHOD_TYPE_PREFIX)) {
                    Collection<? extends TypeScope> collection = types = stack.isEmpty() ? null : (Collection<? extends TypeScope>)stack.pop();
                    if (types == null || types.isEmpty()) {
                        return emptyStack;
                    }
                    cls = ModelUtils.getFirst(types);
                    if (cls == null) {
                        return emptyStack;
                    }
                    Collection<? extends MethodScope> methods = IndexScopeImpl.getMethods(cls, frag, topScope, -1);
                    meth = ModelUtils.getFirst(methods);
                    if (methods.isEmpty()) {
                        return emptyStack;
                    }
                    retval.push(meth);
                    types = meth.getReturnTypes(true);
                    if (types == null || types.isEmpty()) break;
                    stack.push(types);
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FUNCTION_TYPE_PREFIX)) {
                    FunctionScope fnc = ModelUtils.getFirst(IndexScopeImpl.getFunctions(QualifiedName.create(frag), topScope));
                    if (fnc == null) break;
                    retval.push(fnc);
                    Collection<? extends TypeScope> returnTypes = fnc.getReturnTypes(true);
                    type = ModelUtils.getFirst(returnTypes);
                    if (type == null) break;
                    stack.push(returnTypes);
                    operation = null;
                    continue;
                }
                if (operation.startsWith(CONSTRUCTOR_TYPE_PREFIX)) {
                    ClassScope cls2 = ModelUtils.getFirst(IndexScopeImpl.getClasses(QualifiedName.create(frag), topScope));
                    if (cls2 == null) break;
                    MethodScope meth2 = ModelUtils.getFirst(IndexScopeImpl.getMethods(cls2, "__construct", topScope, -1));
                    if (meth2 == null) {
                        return emptyStack;
                    }
                    retval.push(meth2);
                    stack.push(Collections.singletonList(cls2));
                    operation = null;
                    continue;
                }
                if (operation.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                    String[] frgs = frag.split("\\.");
                    assert (frgs.length == 2);
                    String clsName = frgs[0];
                    if (clsName == null) {
                        return emptyStack;
                    }
                    ClassScope cls3 = ModelUtils.getFirst(IndexScopeImpl.getClasses(QualifiedName.create(clsName), topScope));
                    if (cls3 == null) {
                        return emptyStack;
                    }
                    meth = ModelUtils.getFirst(IndexScopeImpl.getMethods(cls3, frgs[1], topScope, -1));
                    if (meth == null) {
                        return emptyStack;
                    }
                    retval.push(meth);
                    Collection<? extends TypeScope> returnTypes = meth.getReturnTypes(true);
                    type = ModelUtils.getFirst(returnTypes);
                    if (type == null) break;
                    stack.push(returnTypes);
                    operation = null;
                    continue;
                }
                if (operation.startsWith(VAR_TYPE_PREFIX)) {
                    List<? extends VariableName> variables;
                    Collection types2;
                    NamespaceScope nScope;
                    VariableName varName;
                    type = null;
                    if (varScope instanceof MethodScope) {
                        MethodScope mScope = (MethodScope)varScope;
                        if (frag.equals("this") || frag.equals("$this")) {
                            type = (ClassScope)mScope.getInScope();
                        }
                        if (type != null) {
                            stack.push(Collections.singletonList(type));
                            operation = null;
                        }
                    } else if (varScope instanceof NamespaceScope && (varName = ModelUtils.getFirst((nScope = (NamespaceScope)varScope).getDeclaredVariables(), frag)) != null && (type = (TypeScope)ModelUtils.getFirst(types2 = varName.getTypes(offset))) != null) {
                        stack.push(types2);
                        operation = null;
                    }
                    if (type != null || (variables = ModelUtils.filter(varScope.getDeclaredVariables(), frag)).isEmpty()) continue;
                    varName = ModelUtils.getFirst(variables);
                    types2 = varName != null ? varName.getTypes(offset) : null;
                    TypeScope typeScope = type = types2 != null ? (TypeScope)ModelUtils.getFirst(types2) : null;
                    if (varName != null) {
                        retval.push(varName);
                    }
                    if (type == null) break;
                    stack.push(types2);
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FIELD_TYPE_PREFIX)) {
                    Collection<? extends TypeScope> collection = types = stack.isEmpty() ? null : (Collection<? extends TypeScope>)stack.pop();
                    if (types == null || types.isEmpty()) {
                        return emptyStack;
                    }
                    cls = ModelUtils.getFirst(types);
                    if (cls == null || !(cls instanceof ClassScope)) {
                        return emptyStack;
                    }
                    FieldElement fieldElement = ModelUtils.getFirst(IndexScopeImpl.getFields((ClassScope)cls, !frag.startsWith("$") ? String.format("%s%s", "$", frag) : frag, topScope, -1));
                    if (fieldElement == null) {
                        return emptyStack;
                    }
                    retval.push(fieldElement);
                    Collection fieldTypes = fieldElement.getTypes(offset);
                    type = (TypeScope)ModelUtils.getFirst(fieldTypes);
                    if (type == null) break;
                    stack.push(fieldTypes);
                    operation = null;
                    continue;
                }
                throw new UnsupportedOperationException(operation);
            }
        }
        return retval;
    }

    private static void createVariableBaseChain(VariableBase node, Stack<VariableBase> stack) {
        stack.push(node);
        if (node instanceof MethodInvocation) {
            VariousUtils.createVariableBaseChain(((MethodInvocation)node).getDispatcher(), stack);
        } else if (node instanceof FieldAccess) {
            VariousUtils.createVariableBaseChain(((FieldAccess)node).getDispatcher(), stack);
        }
    }

    private static String extractVariableTypeFromVariableBase(VariableBase varBase, Map<String, AssignmentImpl> allAssignments) {
        if (varBase instanceof Variable) {
            String semiTypeName;
            String varName = CodeUtils.extractVariableName((Variable)varBase);
            AssignmentImpl assignmentImpl = allAssignments.get(varName);
            if (assignmentImpl != null && (semiTypeName = assignmentImpl.typeNameFromUnion()) != null) {
                return semiTypeName;
            }
            return "@var:" + varName;
        }
        if (varBase instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)varBase;
            String fname = CodeUtils.extractFunctionName(functionInvocation);
            return "@fn:" + fname;
        }
        if (varBase instanceof StaticMethodInvocation) {
            StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)varBase;
            String className = CodeUtils.extractUnqualifiedClassName(staticMethodInvocation);
            String methodName = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
            if (className != null && methodName != null) {
                return "@static.mtd:" + className + '.' + methodName;
            }
        } else if (varBase instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)varBase;
            String methodName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
            if (methodName != null) {
                return "@mtd:" + methodName;
            }
        } else if (varBase instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)varBase;
            String filedName = CodeUtils.extractVariableName(fieldAccess.getField());
            if (filedName != null) {
                return "@fld:" + filedName;
            }
        } else if (varBase instanceof StaticFieldAccess) {
            StaticFieldAccess fieldAccess = (StaticFieldAccess)varBase;
            String clsName = CodeUtils.extractUnqualifiedName(fieldAccess.getClassName());
            String fldName = CodeUtils.extractVariableName(fieldAccess.getField());
            if (clsName != null && fldName != null) {
                return clsName + "@" + STATIC_FIELD__TYPE_PREFIX + fldName;
            }
        }
        return null;
    }

    public static String resolveFileName(Include include) {
        Scalar s;
        Expression e = include.getExpression();
        if (e instanceof ParenthesisExpression) {
            e = ((ParenthesisExpression)e).getExpression();
        }
        if (e instanceof Scalar && Scalar.Type.STRING == (s = (Scalar)e).getScalarType()) {
            String fileName = s.getStringValue();
            fileName = fileName.length() >= 2 ? fileName.substring(1, fileName.length() - 1) : fileName;
            return fileName;
        }
        return null;
    }

    public static FileObject resolveInclude(FileObject sourceFile, Include include) {
        Parameters.notNull((CharSequence)"sourceFile", (Object)sourceFile);
        if (sourceFile.isFolder()) {
            throw new IllegalArgumentException(FileUtil.getFileDisplayName((FileObject)sourceFile));
        }
        return VariousUtils.resolveInclude(sourceFile, VariousUtils.resolveFileName(include));
    }

    public static FileObject resolveInclude(FileObject sourceFile, String fileName) {
        FileObject retval = null;
        if (fileName != null) {
            File absoluteFile = new File(fileName);
            if (absoluteFile.exists()) {
                retval = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)absoluteFile));
            } else {
                FileObject parent = sourceFile.getParent();
                if (parent != null) {
                    retval = PhpSourcePath.resolveFile((FileObject)parent, (String)fileName);
                }
            }
        }
        return retval;
    }

    public static String getSemiType(TokenSequence<PHPTokenId> tokenSequence, State state, VariableScope varScope) throws IllegalStateException {
        String retval;
        int commasCount = 0;
        int anchor = -1;
        int leftBraces = 0;
        int rightBraces = State.PARAMS.equals((Object)state) ? 1 : 0;
        StringBuilder metaAll = new StringBuilder();
        while (!state.equals((Object)State.INVALID) && !state.equals((Object)State.STOP) && tokenSequence.movePrevious() && VariousUtils.skipWhitespaces(tokenSequence)) {
            Token token = tokenSequence.token();
            if (!CTX_DELIMITERS.contains(token.id())) {
                switch (state) {
                    case METHOD: 
                    case START: {
                        State state2 = state = state.equals((Object)State.METHOD) ? State.STOP : State.INVALID;
                        if (VariousUtils.isReference((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@mtd:");
                            state = State.REFERENCE;
                            break;
                        }
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@mtd:");
                            state = State.STATIC_REFERENCE;
                            break;
                        }
                        if (!state.equals((Object)State.STOP)) break;
                        metaAll.insert(0, "@fn:");
                        break;
                    }
                    case IDX: {
                        if (VariousUtils.isLeftArryBracket((Token<PHPTokenId>)token)) {
                            state = State.ARRAYREFERENCE;
                            break;
                        }
                        if (!CTX_DELIMITERS.contains(token.id())) break;
                        state = State.INVALID;
                        break;
                    }
                    case ARRAYREFERENCE: 
                    case REFERENCE: {
                        boolean isArray = state.equals((Object)State.ARRAYREFERENCE);
                        state = State.INVALID;
                        if (VariousUtils.isRightBracket((Token<PHPTokenId>)token)) {
                            ++rightBraces;
                            state = State.PARAMS;
                            break;
                        }
                        if (VariousUtils.isRightArryBracket((Token<PHPTokenId>)token)) {
                            state = State.IDX;
                            break;
                        }
                        if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, ((Object)token.text()).toString());
                            state = isArray ? State.ARRAY_FIELD : State.FIELD;
                            break;
                        }
                        if (!VariousUtils.isVariable((Token<PHPTokenId>)token)) break;
                        metaAll.insert(0, ((Object)token.text()).toString());
                        state = isArray ? State.ARRAY_VARIABLE : State.VARBASE;
                        break;
                    }
                    case STATIC_REFERENCE: {
                        state = State.INVALID;
                        if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@fld:");
                            metaAll.insert(0, ((Object)token.text()).toString());
                            state = State.CLASSNAME;
                            break;
                        }
                        if (!VariousUtils.isSelf((Token<PHPTokenId>)token) && !VariousUtils.isParent((Token<PHPTokenId>)token) && !VariousUtils.isStatic((Token<PHPTokenId>)token)) break;
                        metaAll.insert(0, "@fld:");
                        metaAll.insert(0, VariousUtils.translateSpecialClassName(varScope, ((Object)token.text()).toString()));
                        state = State.CLASSNAME;
                        break;
                    }
                    case PARAMS: {
                        if (VariousUtils.isWhiteSpace((Token<PHPTokenId>)token)) {
                            state = State.PARAMS;
                        } else if (VariousUtils.isComma((Token<PHPTokenId>)token)) {
                            if (metaAll.length() == 0) {
                                ++commasCount;
                            }
                        } else if (CTX_DELIMITERS.contains(token.id())) {
                            state = State.INVALID;
                        } else if (VariousUtils.isLeftBracket((Token<PHPTokenId>)token)) {
                            ++leftBraces;
                        } else if (VariousUtils.isRightBracket((Token<PHPTokenId>)token)) {
                            ++rightBraces;
                        }
                        if (leftBraces != rightBraces) break;
                        state = State.FUNCTION;
                        break;
                    }
                    case FUNCTION: {
                        state = State.INVALID;
                        if (!VariousUtils.isString((Token<PHPTokenId>)token)) break;
                        metaAll.insert(0, ((Object)token.text()).toString());
                        if (anchor == -1) {
                            anchor = tokenSequence.offset();
                        }
                        state = State.METHOD;
                        break;
                    }
                    case ARRAY_FIELD: 
                    case FIELD: {
                        state = State.INVALID;
                        if (!VariousUtils.isReference((Token<PHPTokenId>)token)) break;
                        metaAll.insert(0, "@fld:");
                        state = State.REFERENCE;
                        break;
                    }
                    case VARBASE: {
                        state = State.INVALID;
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)token)) {
                            state = State.STATIC_REFERENCE;
                            break;
                        }
                        state = State.VARIABLE;
                    }
                    case ARRAY_VARIABLE: 
                    case VARIABLE: {
                        if (state.equals((Object)State.ARRAY_VARIABLE)) {
                            metaAll.insert(0, "@array:");
                        } else {
                            metaAll.insert(0, "@var:");
                        }
                    }
                    case CLASSNAME: {
                        if (VariousUtils.isNamespaceSeparator((Token<PHPTokenId>)token) && tokenSequence.movePrevious()) {
                            metaAll.insert(0, ((Object)token.text()).toString());
                            token = tokenSequence.token();
                            if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                                metaAll.insert(0, ((Object)token.text()).toString());
                                break;
                            }
                        }
                        state = State.STOP;
                    }
                }
                continue;
            }
            if (state.equals((Object)State.CLASSNAME)) {
                state = State.STOP;
                break;
            }
            if (!state.equals((Object)State.METHOD)) continue;
            state = State.STOP;
            PHPTokenId id = (PHPTokenId)token.id();
            if (id != null && PHPTokenId.PHP_NEW.equals((Object)id)) {
                metaAll.insert(0, "@constuct:");
                break;
            }
            metaAll.insert(0, "@fn:");
            break;
        }
        if (state.equals((Object)State.STOP) && (retval = metaAll.toString()) != null) {
            return retval;
        }
        return null;
    }

    public static String getVariableName(String semiType) {
        String prefix;
        if (semiType != null && semiType.startsWith(prefix = "@var:")) {
            return semiType.substring(prefix.length(), semiType.lastIndexOf("@"));
        }
        return null;
    }

    private static boolean skipWhitespaces(TokenSequence<PHPTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        while (token != null && VariousUtils.isWhiteSpace((Token<PHPTokenId>)token)) {
            boolean retval = tokenSequence.movePrevious();
            token = tokenSequence.token();
            if (retval) continue;
            return false;
        }
        return true;
    }

    private static String translateSpecialClassName(Scope scp, String clsName) {
        ClassScope classScope = null;
        if (scp instanceof ClassScope) {
            classScope = (ClassScope)scp;
        } else if (scp instanceof MethodScope) {
            MethodScope msi = (MethodScope)scp;
            classScope = (ClassScope)msi.getInScope();
        }
        if (classScope != null) {
            ClassScope clzScope;
            if ("self".equals(clsName) || "this".equals(clsName) || "static".equals(clsName)) {
                clsName = classScope.getName();
            } else if ("parent".equals(clsName) && (clzScope = ModelUtils.getFirst(classScope.getSuperClasses())) != null) {
                clsName = clzScope.getName();
            }
        }
        return clsName;
    }

    private static boolean moveToOffset(TokenSequence<PHPTokenId> tokenSequence, int offset) {
        return tokenSequence == null || tokenSequence.move(offset) < 0;
    }

    private static boolean isDolar(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "$".contentEquals(token.text());
    }

    private static boolean isLeftBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "(".contentEquals(token.text());
    }

    private static boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ")".contentEquals(token.text());
    }

    private static boolean isRightArryBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "]".contentEquals(token.text());
    }

    private static boolean isLeftArryBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "[".contentEquals(token.text());
    }

    private static boolean isComma(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ",".contentEquals(token.text());
    }

    private static boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OBJECT_OPERATOR);
    }

    private static boolean isNamespaceSeparator(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_NS_SEPARATOR);
    }

    private static boolean isWhiteSpace(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.WHITESPACE);
    }

    private static boolean isStaticReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM);
    }

    private static boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private static boolean isSelf(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_SELF);
    }

    private static boolean isStatic(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STATIC);
    }

    private static boolean isParent(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PARENT);
    }

    private static boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    public static Collection<? extends TypeScope> getStaticTypeName(Scope inScope, String staticTypeName) {
        TypeScope csi = null;
        if (inScope instanceof MethodScope) {
            MethodScope msi = (MethodScope)inScope;
            csi = (ClassScope)msi.getInScope();
        }
        if (inScope instanceof ClassScope || inScope instanceof InterfaceScope) {
            csi = (TypeScope)inScope;
        }
        if (csi != null) {
            if ("self".equals(staticTypeName)) {
                return Collections.singletonList(csi);
            }
            if ("parent".equals(staticTypeName) && csi instanceof ClassScope) {
                return ((ClassScope)csi).getSuperClasses();
            }
        }
        return IndexScopeImpl.getTypes(QualifiedName.create(staticTypeName), inScope);
    }

    public static QualifiedName getPreferredName(QualifiedName fullName, NamespaceScope contextNamespace) {
        Collection<QualifiedName> allNames = VariousUtils.getAllNames(fullName, contextNamespace);
        int segmentCount = Integer.MAX_VALUE;
        QualifiedName retval = null;
        for (QualifiedName qualifiedName : allNames) {
            int size = qualifiedName.getSegments().size();
            if (size >= segmentCount) continue;
            retval = qualifiedName;
            segmentCount = size;
        }
        return retval;
    }

    public static Collection<QualifiedName> getAllNames(QualifiedName fullName, NamespaceScope contextNamespace) {
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        namesProposals.addAll(VariousUtils.getRelatives(contextNamespace, fullName));
        namesProposals.add(fullName.toFullyQualified());
        return namesProposals;
    }

    public static Collection<QualifiedName> getRelativesToUses(NamespaceScope contextNamespace, QualifiedName fullName) {
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        Collection<? extends UseElement> declaredUses = contextNamespace.getDeclaredUses();
        for (UseElement useElement : declaredUses) {
            QualifiedName proposedName = QualifiedName.getSuffix(fullName, QualifiedName.create(useElement.getName()), true);
            if (proposedName == null) continue;
            namesProposals.add(proposedName);
        }
        return namesProposals;
    }

    public static Collection<QualifiedName> getRelativesToNamespace(NamespaceScope contextNamespace, QualifiedName fullName) {
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        QualifiedName proposedName = QualifiedName.getSuffix(fullName, QualifiedName.create(contextNamespace), false);
        if (proposedName != null) {
            namesProposals.add(proposedName);
        }
        return namesProposals;
    }

    public static Collection<QualifiedName> getRelatives(NamespaceScope contextNamespace, QualifiedName fullName) {
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        namesProposals.addAll(VariousUtils.getRelativesToNamespace(contextNamespace, fullName));
        namesProposals.addAll(VariousUtils.getRelativesToUses(contextNamespace, fullName));
        return namesProposals;
    }

    public static Collection<QualifiedName> getComposedNames(QualifiedName name, NamespaceScope contextNamespace) {
        Collection<? extends UseElement> declaredUses = contextNamespace.getDeclaredUses();
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        if (!name.getKind().isFullyQualified()) {
            QualifiedName proposedName = QualifiedName.create(contextNamespace).append(name).toFullyQualified();
            if (proposedName != null) {
                namesProposals.add(proposedName);
            }
            for (UseElement useElement : declaredUses) {
                QualifiedName useQName = QualifiedName.create(useElement.getName());
                proposedName = useQName.toNamespaceName().append(name).toFullyQualified();
                if (proposedName != null) {
                    namesProposals.add(proposedName);
                }
                if (useQName.getName().equalsIgnoreCase(name.getName()) || (proposedName = useQName.append(name).toFullyQualified()) == null) continue;
                namesProposals.add(proposedName);
            }
        }
        namesProposals.add(name);
        return namesProposals;
    }

    public static Collection<QualifiedName> getPossibleFQN(QualifiedName name, int nameOffset, NamespaceScope contextNamespace) {
        HashSet<QualifiedName> namespaces = new HashSet<QualifiedName>();
        boolean resolved = false;
        if (name.getKind() == QualifiedNameKind.FULLYQUALIFIED) {
            namespaces.add(name);
            resolved = true;
        } else {
            Collection<? extends UseElement> uses = contextNamespace.getDeclaredUses();
            if (uses.size() > 0) {
                for (UseElement useElement : contextNamespace.getDeclaredUses()) {
                    if (useElement.getOffset() >= nameOffset) continue;
                    String firstNameSegment = name.getSegments().getFirst();
                    QualifiedName returnName = null;
                    if (useElement.getAliasedName() != null && firstNameSegment.equals(useElement.getAliasedName().getAliasName())) {
                        returnName = useElement.getAliasedName().getRealName();
                    } else {
                        returnName = QualifiedName.create(useElement.getName());
                        if (!firstNameSegment.equals(returnName.getSegments().getLast())) {
                            returnName = null;
                        }
                    }
                    if (returnName == null) continue;
                    for (int i = 1; i < name.getSegments().size(); ++i) {
                        returnName = returnName.append(name.getSegments().get(i));
                    }
                    namespaces.add(returnName.toFullyQualified());
                    resolved = true;
                }
            }
        }
        if (!resolved) {
            if (name.getKind() == QualifiedNameKind.UNQUALIFIED) {
                namespaces.add(contextNamespace.getNamespaceName().append(name).toFullyQualified());
            } else {
                namespaces.add(QualifiedName.create(contextNamespace).append(name).toFullyQualified());
            }
        }
        return namespaces;
    }

    public static enum State {
        START,
        METHOD,
        INVALID,
        VARBASE,
        DOLAR,
        PARAMS,
        ARRAYREFERENCE,
        REFERENCE,
        STATIC_REFERENCE,
        FUNCTION,
        FIELD,
        VARIABLE,
        ARRAY_FIELD,
        ARRAY_VARIABLE,
        CLASSNAME,
        STOP,
        IDX;

    }

    public static enum Kind {
        CONSTRUCTOR,
        FUNCTION,
        METHOD,
        STATIC_METHOD,
        FIELD,
        STATIC_FIELD,
        VAR;


        public String toString() {
            switch (this) {
                case CONSTRUCTOR: {
                    return VariousUtils.CONSTRUCTOR_TYPE_PREFIX;
                }
                case FUNCTION: {
                    return VariousUtils.FUNCTION_TYPE_PREFIX;
                }
                case METHOD: {
                    return VariousUtils.METHOD_TYPE_PREFIX;
                }
                case STATIC_METHOD: {
                    return VariousUtils.STATIC_METHOD_TYPE_PREFIX;
                }
                case FIELD: {
                    return VariousUtils.FIELD_TYPE_PREFIX;
                }
                case STATIC_FIELD: {
                    return VariousUtils.STATIC_FIELD__TYPE_PREFIX;
                }
                case VAR: {
                    return VariousUtils.VAR_TYPE_PREFIX;
                }
            }
            return super.toString();
        }
    }
}

