/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.indent.FormatToken;
import org.netbeans.modules.php.editor.indent.FormatVisitor;
import org.netbeans.modules.php.editor.indent.IndentUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.util.Exceptions;

public class TokenFormatter {
    protected static String TEMPLATE_HANDLER_PROPERTY = "code-template-insert-handler";
    private static String EMPTY_STRING = "";
    private static final Logger LOGGER = Logger.getLogger(TokenFormatter.class.getName());
    protected static int unitTestCarretPosition = -1;

    private int countOfNewLines(CharSequence chs) {
        int count = 0;
        if (chs != null) {
            for (int i = 0; i < chs.length(); ++i) {
                if (chs.charAt(i) != '\n') continue;
                ++count;
            }
        }
        return count;
    }

    public void reformat(Context context, ParserResult info) {
        final Context formatContext = context;
        final BaseDocument doc = (BaseDocument)context.document();
        final PHPParseResult phpParseResult = (PHPParseResult)info;
        final DocumentOptions docOptions = new DocumentOptions(doc);
        doc.runAtomic(new Runnable(){
            private int startOffset = -1;
            private int endOffset = -1;
            private int previousIndentDelta = 0;
            private String previousOldIndentText = "";
            private String previousNewIndentText = "";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicLong start = new AtomicLong(System.currentTimeMillis());
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, 0);
                FormatVisitor fv = new FormatVisitor(doc);
                phpParseResult.getProgram().accept(fv);
                List<FormatToken> formatTokens = fv.getFormatTokens();
                if (LOGGER.isLoggable(Level.FINE)) {
                    long end = System.currentTimeMillis();
                    LOGGER.log(Level.FINE, "Creating formating stream took: {0} ms", end - start.get());
                }
                if (ts == null) {
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Tokens in TS: {0}", ts.tokenCount());
                    LOGGER.log(Level.FINE, "Format tokens: {0}", formatTokens.size());
                }
                MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                try {
                    boolean templateEdit;
                    mti.tokenHierarchyControl().setActive(false);
                    start.set(System.currentTimeMillis());
                    int delta = 0;
                    int indent = docOptions.initialIndent;
                    int lastPHPIndent = 0;
                    boolean bl = templateEdit = doc.getProperty((Object)TEMPLATE_HANDLER_PROPERTY) != null;
                    int caretOffset = EditorRegistry.lastFocusedComponent() != null ? EditorRegistry.lastFocusedComponent().getCaretPosition() : (unitTestCarretPosition == -1 ? 0 : unitTestCarretPosition);
                    boolean caretInTemplateSolved = false;
                    int htmlIndent = -1;
                    int newLines = 0;
                    int countSpaces = 0;
                    int column = 0;
                    int indentOfOpenTag = 0;
                    String newText = null;
                    String oldText = null;
                    int changeOffset = -1;
                    int deltaForLastMoveBeforeLineComment = 0;
                    FormatToken.AnchorToken lastAnchor = null;
                    for (int index = 0; index < formatTokens.size(); ++index) {
                        int lines;
                        FormatToken formatToken = formatTokens.get(index);
                        oldText = null;
                        if (formatToken.isWhitespace()) {
                            int hIndex;
                            newLines = -1;
                            countSpaces = 0;
                            boolean wasARule = false;
                            boolean indentLine = false;
                            boolean indentRule = false;
                            boolean afterSemi = false;
                            boolean wsBetweenBraces = false;
                            CodeStyle.BracePlacement lastBracePlacement = CodeStyle.BracePlacement.SAME_LINE;
                            changeOffset = formatToken.getOffset();
                            while (index < formatTokens.size() && (formatToken.isWhitespace() || formatToken.getId() == FormatToken.Kind.INDENT || formatToken.getId() == FormatToken.Kind.ANCHOR)) {
                                if (oldText == null && formatToken.getOldText() != null) {
                                    oldText = formatToken.getOldText();
                                }
                                if (formatToken.getId() != FormatToken.Kind.INDENT && formatToken.getId() != FormatToken.Kind.WHITESPACE_INDENT && formatToken.getId() != FormatToken.Kind.ANCHOR && formatToken.getId() != FormatToken.Kind.WHITESPACE) {
                                    wasARule = true;
                                }
                                switch (formatToken.getId()) {
                                    case WHITESPACE: {
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_CLASS_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.classDeclBracePlacement, docOptions.spaceBeforeClassDeclLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_FUNCTION_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.methodDeclBracePlacement, docOptions.spaceBeforeMethodDeclLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_IF_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.ifBracePlacement, docOptions.spaceBeforeIfLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_ELSE_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.ifBracePlacement, docOptions.spaceBeforeElseLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_FOR_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.forBracePlacement, docOptions.spaceBeforeForLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_WHILE_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.whileBracePlacement, docOptions.spaceBeforeWhileLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_DO_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.whileBracePlacement, docOptions.spaceBeforeDoLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_SWITCH_LEFT_BACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.switchBracePlacement, docOptions.spaceBeforeSwitchLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_TRY_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.catchBracePlacement, docOptions.spaceBeforeTryLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_CATCH_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.catchBracePlacement, docOptions.spaceBeforeCatchLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_OTHER_LEFT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeLeftBrace(docOptions.otherBracePlacement, docOptions.spaceBeforeTryLeftBrace, oldText, indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_AFTER_OTHER_LEFT_BRACE: {
                                        indentRule = docOptions.wrapBlockBrace;
                                        int wrap = docOptions.wrapBlockBrace ? 1 : 0;
                                        newLines = this.countLinesAfter(formatTokens, index);
                                        newLines = wrap > newLines ? wrap : newLines;
                                        countSpaces = newLines > 0 ? indent : 1;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_IF_RIGHT_BRACE: {
                                        indentRule = oldText != null && TokenFormatter.this.countOfNewLines(oldText) > 0 ? true : docOptions.wrapBlockBrace;
                                        indentLine = indentRule;
                                        Whitespace ws = this.countWhiteSpaceBeforeRightBrace(docOptions.ifBracePlacement, newLines, 0, indent, formatTokens, index - 1);
                                        newLines = ws.lines;
                                        countSpaces = indentRule ? ws.spaces : 1;
                                        lastBracePlacement = docOptions.ifBracePlacement;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_FOR_RIGHT_BRACE: {
                                        indentRule = oldText != null && TokenFormatter.this.countOfNewLines(oldText) > 0 ? true : docOptions.wrapBlockBrace;
                                        indentLine = indentRule;
                                        Whitespace ws = this.countWhiteSpaceBeforeRightBrace(docOptions.forBracePlacement, newLines, 0, indent, formatTokens, index - 1);
                                        newLines = ws.lines;
                                        countSpaces = indentRule ? ws.spaces : 1;
                                        lastBracePlacement = docOptions.forBracePlacement;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_WHILE_RIGHT_BRACE: {
                                        indentRule = oldText != null && TokenFormatter.this.countOfNewLines(oldText) > 0 ? true : docOptions.wrapBlockBrace;
                                        indentLine = indentRule;
                                        Whitespace ws = this.countWhiteSpaceBeforeRightBrace(docOptions.whileBracePlacement, newLines, 0, indent, formatTokens, index - 1);
                                        newLines = ws.lines;
                                        countSpaces = indentRule ? ws.spaces : 1;
                                        lastBracePlacement = docOptions.whileBracePlacement;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_SWITCH_RIGHT_BACE: {
                                        indentRule = oldText != null && TokenFormatter.this.countOfNewLines(oldText) > 0 ? true : docOptions.wrapBlockBrace;
                                        indentLine = indentRule;
                                        Whitespace ws = this.countWhiteSpaceBeforeRightBrace(docOptions.switchBracePlacement, newLines, 0, indent, formatTokens, index - 1);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        lastBracePlacement = docOptions.switchBracePlacement;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_CATCH_RIGHT_BRACE: {
                                        indentRule = oldText != null && TokenFormatter.this.countOfNewLines(oldText) > 0 ? true : docOptions.wrapBlockBrace;
                                        indentLine = indentRule;
                                        Whitespace ws = this.countWhiteSpaceBeforeRightBrace(docOptions.catchBracePlacement, newLines, 0, indent, formatTokens, index - 1);
                                        newLines = ws.lines;
                                        countSpaces = indentRule ? ws.spaces : 1;
                                        lastBracePlacement = docOptions.catchBracePlacement;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_OTHER_RIGHT_BRACE: {
                                        indentRule = oldText != null && TokenFormatter.this.countOfNewLines(oldText) > 0 ? true : docOptions.wrapBlockBrace;
                                        indentLine = indentRule;
                                        Whitespace ws = this.countWhiteSpaceBeforeRightBrace(docOptions.otherBracePlacement, newLines, 0, indent, formatTokens, index - 1);
                                        newLines = ws.lines;
                                        countSpaces = indentRule ? ws.spaces : 1;
                                        lastBracePlacement = docOptions.otherBracePlacement;
                                        break;
                                    }
                                    case WHITESPACE_BETWEEN_OPEN_CLOSE_BRACES: {
                                        wsBetweenBraces = true;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_CLASS: {
                                        indentRule = true;
                                        newLines = docOptions.blankLinesBeforeClass + 1 > newLines ? docOptions.blankLinesBeforeClass + 1 : newLines;
                                        countSpaces = indent;
                                        break;
                                    }
                                    case WHITESPACE_AFTER_CLASS_LEFT_BRACE: {
                                        indentRule = true;
                                        newLines = docOptions.blankLinesAfterClassHeader + 1 > newLines ? docOptions.blankLinesAfterClassHeader + 1 : newLines;
                                        countSpaces = indent;
                                        break;
                                    }
                                    case WHITESPACE_AFTER_CLASS: {
                                        indentRule = true;
                                        newLines = docOptions.blankLinesAfterClass + 1 > newLines ? docOptions.blankLinesAfterClass + 1 : newLines;
                                        countSpaces = indent;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_CLASS_RIGHT_BRACE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWhiteSpaceBeforeRightBrace(docOptions.classDeclBracePlacement, newLines, docOptions.blankLinesBeforeClassEnd, indent, formatTokens, index - 1);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        lastBracePlacement = docOptions.classDeclBracePlacement;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_FUNCTION: {
                                        indentRule = true;
                                        newLines = docOptions.blankLinesBeforeFunction + 1 > newLines ? docOptions.blankLinesBeforeFunction + 1 : newLines;
                                        countSpaces = indent;
                                        break;
                                    }
                                    case WHITESPACE_AFTER_FUNCTION: {
                                        newLines = docOptions.blankLinesAfterFunction + 1 > newLines ? docOptions.blankLinesAfterFunction + 1 : newLines;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_FUNCTION_RIGHT_BRACE: {
                                        indentRule = oldText != null && TokenFormatter.this.countOfNewLines(oldText) > 0 ? true : docOptions.wrapBlockBrace;
                                        indentLine = indentRule;
                                        Whitespace ws = this.countWhiteSpaceBeforeRightBrace(docOptions.methodDeclBracePlacement, newLines, docOptions.blankLinesBeforeFunctionEnd, indent, formatTokens, index - 1);
                                        newLines = ws.lines;
                                        countSpaces = indentRule ? ws.spaces : 1;
                                        lastBracePlacement = docOptions.methodDeclBracePlacement;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_FIELDS: {
                                        newLines = docOptions.blankLinesBeforeFields + 1 > newLines ? docOptions.blankLinesBeforeFields + 1 : newLines;
                                        indentRule = true;
                                        countSpaces = indent;
                                        break;
                                    }
                                    case WHITESPACE_AFTER_FIELDS: {
                                        newLines = docOptions.blankLinesAfterFields + 1 > newLines ? docOptions.blankLinesAfterFields + 1 : newLines;
                                        indentRule = true;
                                        countSpaces = indent;
                                        break;
                                    }
                                    case WHITESPACE_BETWEEN_FIELDS: {
                                        indentRule = true;
                                        newLines = docOptions.blankLinesGroupFields && !TokenFormatter.this.isBeforePHPDoc(formatTokens, index) ? 1 : (docOptions.blankLinesBetweenFields + 1 > newLines ? docOptions.blankLinesBetweenFields + 1 : newLines);
                                        countSpaces = indent;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_NAMESPACE: {
                                        indentRule = true;
                                        newLines = docOptions.blankLinesBeforeNamespace + 1;
                                        countSpaces = Math.max(indent, countSpaces);
                                        break;
                                    }
                                    case WHITESPACE_AFTER_NAMESPACE: {
                                        indentRule = true;
                                        newLines = docOptions.blankLinesAfterNamespace + 1;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_USE: {
                                        indentRule = true;
                                        newLines = docOptions.blankLinesBeforeUse + 1;
                                        break;
                                    }
                                    case WHITESPACE_BETWEEN_USE: {
                                        indentRule = true;
                                        newLines = 1;
                                        break;
                                    }
                                    case WHITESPACE_AFTER_USE: {
                                        indentRule = true;
                                        newLines = docOptions.blankLinesAfterUse + 1;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_USES_PART: {
                                        indentRule = true;
                                        if (formatTokens.get(index - 1).getId() == FormatToken.Kind.ANCHOR) {
                                            newLines = 0;
                                            countSpaces = 1;
                                            break;
                                        }
                                        newLines = 1;
                                        countSpaces = lastAnchor.getAnchorColumn();
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_EXTENDS_IMPLEMENTS: {
                                        indentRule = true;
                                        switch (docOptions.wrapExtendsImplementsKeyword) {
                                            case WRAP_ALWAYS: {
                                                newLines = 1;
                                                countSpaces = docOptions.continualIndentSize;
                                                break;
                                            }
                                            case WRAP_NEVER: {
                                                newLines = 0;
                                                countSpaces = 1;
                                                break;
                                            }
                                            case WRAP_IF_LONG: {
                                                if (column + 1 + this.countLengthOfNextSequence(formatTokens, index + 1) > docOptions.margin) {
                                                    newLines = 1;
                                                    countSpaces = docOptions.continualIndentSize;
                                                    break;
                                                }
                                                newLines = 0;
                                                countSpaces = 1;
                                            }
                                        }
                                        break;
                                    }
                                    case WHITESPACE_IN_INTERFACE_LIST: {
                                        indentRule = true;
                                        switch (docOptions.wrapExtendsImplementsList) {
                                            case WRAP_ALWAYS: {
                                                newLines = 1;
                                                countSpaces = docOptions.alignMultilineImplements ? lastAnchor.getAnchorColumn() : docOptions.continualIndentSize;
                                                break;
                                            }
                                            case WRAP_NEVER: {
                                                newLines = 0;
                                                countSpaces = 1;
                                                break;
                                            }
                                            case WRAP_IF_LONG: {
                                                if (column + 1 + this.countUnbreakableTextAfter(formatTokens, index + 1) > docOptions.margin) {
                                                    newLines = 1;
                                                    countSpaces = docOptions.continualIndentSize;
                                                    break;
                                                }
                                                newLines = 0;
                                                countSpaces = 1;
                                            }
                                        }
                                        break;
                                    }
                                    case WHITESPACE_IN_PARAMETER_LIST: {
                                        indentRule = true;
                                        switch (docOptions.wrapMethodParams) {
                                            case WRAP_ALWAYS: {
                                                newLines = 1;
                                                countSpaces = docOptions.alignMultilineMethodParams ? lastAnchor.getAnchorColumn() : indent + docOptions.continualIndentSize;
                                                break;
                                            }
                                            case WRAP_NEVER: {
                                                if (TokenFormatter.this.isAfterLineComment(formatTokens, index)) {
                                                    newLines = 1;
                                                    countSpaces = docOptions.alignMultilineMethodParams ? lastAnchor.getAnchorColumn() : indent + docOptions.continualIndentSize;
                                                    break;
                                                }
                                                newLines = 0;
                                                countSpaces = docOptions.spaceAfterComma ? 1 : 0;
                                                break;
                                            }
                                            case WRAP_IF_LONG: {
                                                if (column + 1 + this.countLengthOfNextSequence(formatTokens, index + 1) > docOptions.margin) {
                                                    newLines = 1;
                                                    countSpaces = docOptions.alignMultilineMethodParams ? lastAnchor.getAnchorColumn() : indent + docOptions.continualIndentSize;
                                                    break;
                                                }
                                                newLines = 0;
                                                countSpaces = 1;
                                            }
                                        }
                                        break;
                                    }
                                    case WHITESPACE_IN_ARGUMENT_LIST: {
                                        indentRule = true;
                                        switch (docOptions.wrapMethodCallArgs) {
                                            case WRAP_ALWAYS: {
                                                newLines = 1;
                                                countSpaces = docOptions.alignMultilineCallArgs ? lastAnchor.getAnchorColumn() : indent;
                                                break;
                                            }
                                            case WRAP_NEVER: {
                                                if (TokenFormatter.this.isAfterLineComment(formatTokens, index)) {
                                                    newLines = 1;
                                                    countSpaces = docOptions.alignMultilineCallArgs ? lastAnchor.getAnchorColumn() : indent;
                                                    break;
                                                }
                                                newLines = 0;
                                                countSpaces = docOptions.spaceAfterComma ? 1 : 0;
                                                break;
                                            }
                                            case WRAP_IF_LONG: {
                                                if (column + 1 + this.countLengthOfNextSequence(formatTokens, index + 1) > docOptions.margin) {
                                                    newLines = 1;
                                                    countSpaces = docOptions.alignMultilineCallArgs ? lastAnchor.getAnchorColumn() : indent;
                                                    break;
                                                }
                                                newLines = 0;
                                                countSpaces = 1;
                                            }
                                        }
                                        break;
                                    }
                                    case WHITESPACE_AROUND_OBJECT_OP: {
                                        countSpaces = docOptions.spaceAroundObjectOp ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_AROUND_CONCAT_OP: {
                                        countSpaces = docOptions.spaceAroundStringConcatOp ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_AROUND_UNARY_OP: {
                                        countSpaces = docOptions.spaceAroundUnaryOps ? 1 : countSpaces;
                                        break;
                                    }
                                    case WHITESPACE_AROUND_BINARY_OP: {
                                        countSpaces = docOptions.spaceAroundBinaryOps ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_AROUND_TERNARY_OP: {
                                        countSpaces = docOptions.spaceAroundTernaryOps ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_AROUND_ASSIGN_OP: {
                                        countSpaces = docOptions.spaceAroundAssignOps ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_AROUND_KEY_VALUE_OP: {
                                        countSpaces = docOptions.spaceAroundKeyValueOps ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_METHOD_DEC_PAREN: {
                                        countSpaces = docOptions.spaceBeforeMethodDeclParen ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_METHOD_CALL_PAREN: {
                                        countSpaces = docOptions.spaceBeforeMethodCallParen ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_IF_PAREN: {
                                        countSpaces = docOptions.spaceBeforeIfParen ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_FOR_PAREN: {
                                        countSpaces = docOptions.spaceBeforeForParen ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_WHILE_PAREN: {
                                        countSpaces = docOptions.spaceBeforeWhileParen ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_CATCH_PAREN: {
                                        countSpaces = docOptions.spaceBeforeCatchParen ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_SWITCH_PAREN: {
                                        countSpaces = docOptions.spaceBeforeSwitchParen ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_ARRAY_DECL_PAREN: {
                                        countSpaces = docOptions.spaceBeforeArrayDeclParen ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_COMMA: {
                                        countSpaces = docOptions.spaceBeforeComma ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_AFTER_COMMA: {
                                        countSpaces = docOptions.spaceAfterComma ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_SEMI: {
                                        countSpaces = docOptions.spaceBeforeSemi ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_AFTER_SEMI: {
                                        afterSemi = true;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_ARRAY_DECL_PARENS: {
                                        FormatToken token;
                                        hIndex = index - 1;
                                        while ((token = formatTokens.get(hIndex)).getId() != FormatToken.Kind.WHITESPACE_INDENT && token.getId() != FormatToken.Kind.TEXT && --hIndex > 0) {
                                        }
                                        if (token.getId() == FormatToken.Kind.WHITESPACE_INDENT) {
                                            countSpaces = indent;
                                            break;
                                        }
                                        countSpaces = docOptions.spaceWithinArrayDeclParens ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_METHOD_DECL_PARENS: {
                                        int helpIndex;
                                        for (helpIndex = index - 1; helpIndex > 0 && formatTokens.get(helpIndex).getId() != FormatToken.Kind.WHITESPACE_WITHIN_METHOD_DECL_PARENS && formatTokens.get(helpIndex).getId() == FormatToken.Kind.WHITESPACE; --helpIndex) {
                                        }
                                        if (helpIndex > 0 && formatTokens.get(helpIndex).getId() == FormatToken.Kind.WHITESPACE_WITHIN_METHOD_DECL_PARENS) {
                                            countSpaces = 0;
                                            break;
                                        }
                                        countSpaces = docOptions.spaceWithinMethodDeclParens ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_METHOD_CALL_PARENS: {
                                        int helpIndex;
                                        for (helpIndex = index - 1; helpIndex > 0 && formatTokens.get(helpIndex).getId() != FormatToken.Kind.WHITESPACE_WITHIN_METHOD_CALL_PARENS && (formatTokens.get(helpIndex).getId() == FormatToken.Kind.WHITESPACE || formatTokens.get(helpIndex).getId() == FormatToken.Kind.WHITESPACE_INDENT); --helpIndex) {
                                        }
                                        if (index > 0 && formatTokens.get(helpIndex).getId() == FormatToken.Kind.WHITESPACE_WITHIN_METHOD_CALL_PARENS) {
                                            countSpaces = 0;
                                            break;
                                        }
                                        countSpaces = docOptions.spaceWithinMethodCallParens ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_IF_PARENS: {
                                        countSpaces = docOptions.spaceWithinIfParens ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_FOR_PARENS: {
                                        countSpaces = docOptions.spaceWithinForParens ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_WHILE_PARENS: {
                                        countSpaces = docOptions.spaceWithinWhileParens ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_SWITCH_PARENS: {
                                        countSpaces = docOptions.spaceWithinSwitchParens ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_CATCH_PARENS: {
                                        countSpaces = docOptions.spaceWithinCatchParens ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_ARRAY_BRACKETS_PARENS: {
                                        countSpaces = docOptions.spaceWithinArrayBrackets ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_WITHIN_TYPE_CAST_PARENS: {
                                        countSpaces = docOptions.spaceWithinTypeCastParens ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_AFTER_TYPE_CAST: {
                                        countSpaces = docOptions.spaceAfterTypeCast ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_FOR_STATEMENT: {
                                        indentRule = true;
                                        Whitespace ws = this.countWSBeforeAStatement(docOptions.wrapForStatement, true, column, this.countLengthOfNextSequence(formatTokens, index + 1), indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_WHILE_STATEMENT: {
                                        Whitespace ws;
                                        indentRule = true;
                                        if (!this.isBeforeEmptyStatement(formatTokens, index)) {
                                            ws = this.countWSBeforeAStatement(docOptions.wrapWhileStatement, true, column, this.countLengthOfNextSequence(formatTokens, index + 1), indent);
                                            newLines = ws.lines;
                                            countSpaces = ws.spaces;
                                            break;
                                        }
                                        newLines = 0;
                                        countSpaces = docOptions.spaceBeforeSemi ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_DO_STATEMENT: {
                                        indentRule = true;
                                        Whitespace ws = this.countWSBeforeAStatement(docOptions.wrapDoWhileStatement, true, column, this.countLengthOfNextSequence(formatTokens, index + 1), indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_IF_ELSE_STATEMENT: {
                                        indentRule = true;
                                        if (this.isCloseAndOpenTagOnOneLine(formatTokens, index)) {
                                            newLines = 0;
                                            countSpaces = 1;
                                            break;
                                        }
                                        Whitespace ws = this.countWSBeforeAStatement(docOptions.wrapIfStatement, true, column, this.countLengthOfNextSequence(formatTokens, index + 1), indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_IN_FOR: {
                                        indentRule = true;
                                        Whitespace ws = this.countWSBeforeAStatement(docOptions.wrapFor, true, column, this.countLengthOfNextSequence(formatTokens, index + 1), indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_IN_TERNARY_OP: {
                                        indentRule = true;
                                        Whitespace ws = this.countWSBeforeAStatement(docOptions.wrapTernaryOps, docOptions.spaceAroundTernaryOps, column, this.countLengthOfNextSequence(formatTokens, index + 1), indent);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_IN_CHAINED_METHOD_CALLS: {
                                        indentRule = true;
                                        switch (docOptions.wrapChainedMethodCalls) {
                                            case WRAP_ALWAYS: {
                                                newLines = 1;
                                                countSpaces = indent + docOptions.continualIndentSize;
                                                break;
                                            }
                                            case WRAP_NEVER: {
                                                newLines = 0;
                                                countSpaces = 0;
                                                break;
                                            }
                                            case WRAP_IF_LONG: {
                                                if (column + 1 + this.countLengthOfNextSequence(formatTokens, index + 1) > docOptions.margin) {
                                                    newLines = 1;
                                                    countSpaces = indent + docOptions.continualIndentSize;
                                                    break;
                                                }
                                                newLines = 0;
                                                countSpaces = 1;
                                            }
                                        }
                                        break;
                                    }
                                    case WHITESPACE_BETWEEN_LINE_COMMENTS: {
                                        newLines = 1;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_CATCH: {
                                        indentRule = true;
                                        Whitespace ws = this.countWSBeforeKeyword(docOptions.placeCatchOnNewLine, docOptions.spaceBeforeCatch, indent, formatTokens, index);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_WHILE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWSBeforeKeyword(docOptions.placeWhileOnNewLine, docOptions.spaceBeforeWhile, indent, formatTokens, index);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_ELSE: {
                                        indentRule = true;
                                        Whitespace ws = this.countWSBeforeKeyword(docOptions.placeElseOnNewLine, docOptions.spaceBeforeElse, indent, formatTokens, index);
                                        newLines = ws.lines;
                                        countSpaces = ws.spaces;
                                        break;
                                    }
                                    case WHITESPACE_INDENT: {
                                        indentLine = true;
                                        break;
                                    }
                                    case INDENT: {
                                        int indentDelta = ((FormatToken.IndentToken)formatToken).getDelta();
                                        indent += indentDelta;
                                        lastPHPIndent += indentDelta;
                                        break;
                                    }
                                    case ANCHOR: {
                                        lastAnchor = (FormatToken.AnchorToken)formatToken;
                                        lastAnchor.setAnchorColumn(column + 1);
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_OPEN_PHP_TAG: {
                                        int lineOffset;
                                        int firstNW;
                                        Integer suggestedIndent;
                                        int lineNumber;
                                        Map suggestedLineIndents = (Map)doc.getProperty((Object)"AbstractIndenter.lineIndents");
                                        if (oldText != null) break;
                                        try {
                                            String text;
                                            int indentIndex;
                                            int offset = formatToken.getOffset() + delta;
                                            lineNumber = Utilities.getLineOffset((BaseDocument)doc, (int)offset);
                                            Integer n = suggestedIndent = suggestedLineIndents != null ? (Integer)suggestedLineIndents.get(lineNumber) : new Integer(0);
                                            if (suggestedIndent == null) {
                                                Integer n2 = suggestedIndent = suggestedLineIndents.get(lineNumber + 1) != null ? (Integer)suggestedLineIndents.get(lineNumber + 1) : new Integer(0);
                                            }
                                            if ((firstNW = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(lineOffset = Utilities.getRowStart((BaseDocument)doc, (int)offset)))) != offset) break;
                                            indentRule = true;
                                            changeOffset = lineOffset - delta;
                                            oldText = doc.getText(lineOffset, firstNW - lineOffset);
                                            htmlIndent = suggestedIndent;
                                            indent = htmlIndent + docOptions.initialIndent + lastPHPIndent;
                                            countSpaces = lastPHPIndent == 0 ? htmlIndent : indent;
                                            int helpSpaces = 0;
                                            for (indentIndex = index; indentIndex < formatTokens.size() && formatTokens.get(indentIndex).getId() != FormatToken.Kind.TEXT && formatTokens.get(indentIndex).getId() != FormatToken.Kind.WHITESPACE_INDENT && formatTokens.get(indentIndex).getId() != FormatToken.Kind.CLOSE_TAG; ++indentIndex) {
                                                if (formatTokens.get(indentIndex).getId() != FormatToken.Kind.INDENT) continue;
                                                helpSpaces += ((FormatToken.IndentToken)formatTokens.get(indentIndex)).getDelta();
                                            }
                                            if (indentIndex < formatTokens.size() && formatTokens.get(indentIndex).getId() == FormatToken.Kind.TEXT && ("}".equals(text = formatTokens.get(indentIndex).getOldText()) || "endif".equals(text) || "else".equals(text) || "elseif".equals(text) || "endfor".equals(text) || "endforeach".equals(text) || "endwhile".equals(text) || "endswitch".equals(text))) {
                                                countSpaces += helpSpaces;
                                            }
                                            indentOfOpenTag = countSpaces;
                                        }
                                        catch (BadLocationException ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                        }
                                        break;
                                    }
                                    case WHITESPACE_AFTER_OPEN_PHP_TAG: {
                                        FormatToken ft;
                                        int helpIndex;
                                        indentRule = true;
                                        indent = Math.max(lastPHPIndent, indent);
                                        if (!this.isOpenAndCloseTagOnOneLine(formatTokens, index)) {
                                            newLines = ((FormatToken.InitToken)formatTokens.get(0)).hasHTML() ? docOptions.blankLinesAfterOpenPHPTagInHTML + 1 : docOptions.blankLinesAfterOpenPHPTag + 1;
                                            countSpaces = indent;
                                            for (helpIndex = index + 1; helpIndex < formatTokens.size() && formatTokens.get(helpIndex).isWhitespace(); ++helpIndex) {
                                            }
                                            if (helpIndex >= formatTokens.size() || formatTokens.get(helpIndex).getId() != FormatToken.Kind.INDENT) break;
                                            countSpaces += ((FormatToken.IndentToken)formatTokens.get(helpIndex)).getDelta();
                                            break;
                                        }
                                        newLines = 0;
                                        countSpaces = 1;
                                        if (index <= 0 || (ft = formatTokens.get(index - 1)).getId() != FormatToken.Kind.OPEN_TAG || ft.getOldText().length() >= 4) break;
                                        countSpaces = docOptions.spaceAfterShortTag ? 1 : 0;
                                        break;
                                    }
                                    case WHITESPACE_BEFORE_CLOSE_PHP_TAG: {
                                        int lineOffset;
                                        int firstNW;
                                        Integer suggestedIndent;
                                        int lineNumber;
                                        Map suggestedLineIndents = (Map)doc.getProperty((Object)"AbstractIndenter.lineIndents");
                                        indentRule = true;
                                        if (suggestedLineIndents != null) {
                                            try {
                                                int offset = formatToken.getOffset() + delta;
                                                lineNumber = Utilities.getLineOffset((BaseDocument)doc, (int)offset);
                                                suggestedIndent = (Integer)suggestedLineIndents.get(lineNumber);
                                                if (suggestedIndent != null) {
                                                    lineOffset = Utilities.getRowStart((BaseDocument)doc, (int)offset);
                                                    firstNW = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)lineOffset);
                                                    if (firstNW == offset) {
                                                        countSpaces = lastPHPIndent == 0 ? htmlIndent : lastPHPIndent + htmlIndent + docOptions.initialIndent;
                                                        newLines = docOptions.blankLinesBeforeClosePHPTag + 1;
                                                    } else {
                                                        if (TokenFormatter.this.isAfterLineComment(formatTokens, index)) {
                                                            countSpaces = 0;
                                                        } else {
                                                            int n = countSpaces = docOptions.spaceBeforeClosePHPTag ? 1 : 0;
                                                        }
                                                        if (!this.isCloseAndOpenTagOnOneLine(formatTokens, index)) {
                                                            newLines = docOptions.blankLinesBeforeClosePHPTag + 1;
                                                            countSpaces = lastPHPIndent == 0 ? htmlIndent : lastPHPIndent + htmlIndent + docOptions.initialIndent;
                                                        } else {
                                                            newLines = 0;
                                                        }
                                                    }
                                                    indent = suggestedIndent;
                                                    break;
                                                }
                                                if (!this.isCloseAndOpenTagOnOneLine(formatTokens, index)) {
                                                    newLines = docOptions.blankLinesBeforeClosePHPTag + 1;
                                                    countSpaces = lastPHPIndent == 0 ? htmlIndent : indent;
                                                    break;
                                                }
                                                newLines = 0;
                                                countSpaces = docOptions.spaceBeforeClosePHPTag ? 1 : 0;
                                            }
                                            catch (BadLocationException ex) {
                                                Exceptions.printStackTrace((Throwable)ex);
                                            }
                                            break;
                                        }
                                        if (!this.isCloseAndOpenTagOnOneLine(formatTokens, index)) {
                                            newLines = Math.max(newLines, docOptions.blankLinesBeforeClosePHPTag + 1);
                                            countSpaces = indentOfOpenTag;
                                            break;
                                        }
                                        newLines = 0;
                                        countSpaces = docOptions.spaceBeforeClosePHPTag ? 1 : 0;
                                        break;
                                    }
                                }
                                if (++index >= formatTokens.size()) continue;
                                formatToken = formatTokens.get(index);
                            }
                            if (changeOffset > -1) {
                                int caretPosition;
                                boolean isBeforeLineComment = TokenFormatter.this.isBeforeLineComment(formatTokens, index - 1);
                                if (wasARule) {
                                    if ((!indentRule || newLines == -1) && indentLine) {
                                        boolean handlingSpecialCases = false;
                                        if (FormatToken.Kind.TEXT == formatToken.getId() && ")".equals(formatToken.getOldText())) {
                                            hIndex = index + 1;
                                            int hindent = indent;
                                            if (hIndex < formatTokens.size()) {
                                                FormatToken token;
                                                do {
                                                    if ((token = formatTokens.get(hIndex)).getId() != FormatToken.Kind.INDENT) continue;
                                                    hindent += ((FormatToken.IndentToken)token).getDelta();
                                                } while (++hIndex < formatTokens.size() && token.getId() != FormatToken.Kind.WHITESPACE_INDENT && token.getId() != FormatToken.Kind.WHITESPACE && (token.isWhitespace() || token.getId() == FormatToken.Kind.INDENT));
                                                if (FormatToken.Kind.TEXT == token.getId() && (")".equals(token.getOldText()) || ";".equals(token.getOldText()))) {
                                                    countSpaces = hindent;
                                                    handlingSpecialCases = true;
                                                }
                                            }
                                        }
                                        if (!handlingSpecialCases) {
                                            countSpaces = Math.max(countSpaces, indent);
                                        }
                                        newLines = Math.max(1, newLines);
                                    }
                                } else if (indentLine) {
                                    countSpaces = indent;
                                    int n = newLines = oldText == null ? 1 : TokenFormatter.this.countOfNewLines(oldText);
                                    if (index > 1 && index < formatTokens.size() && formatTokens.get(index - 2).getId() == FormatToken.Kind.TEXT && formatTokens.get(index).getId() == FormatToken.Kind.TEXT && "(".equals(formatTokens.get(index - 2).getOldText()) && ")".equals(formatTokens.get(index).getOldText())) {
                                        newLines = 0;
                                    } else if (index - 2 > -1) {
                                        newLines = TokenFormatter.this.getPreviousNonWhite(formatTokens, index - 2).getId() == FormatToken.Kind.DOC_COMMENT_END ? 1 : newLines;
                                    }
                                } else {
                                    boolean isBeginLine = TokenFormatter.this.isBeginLine(formatTokens, index - 1);
                                    if (isBeforeLineComment) {
                                        countSpaces = isBeginLine ? indent : oldText.length();
                                    } else {
                                        int n = isBeginLine ? (isBeforeLineComment ? 0 : Math.max(countSpaces, indent)) : (countSpaces = Math.max(countSpaces, 1));
                                    }
                                }
                                if (isBeforeLineComment && oldText != null && oldText.endsWith("\n")) {
                                    countSpaces = 0;
                                }
                                if (wsBetweenBraces && newLines > 1) {
                                    newLines = 1;
                                }
                                if (afterSemi) {
                                    if (oldText == null || oldText != null && TokenFormatter.this.countOfNewLines(oldText) == 0) {
                                        if (formatToken.getId() == FormatToken.Kind.TEXT) {
                                            if (docOptions.wrapStatementsOnTheSameLine) {
                                                if (docOptions.wrapBlockBrace || !"}".equals(formatToken.getOldText())) {
                                                    newLines = Math.max(1, newLines);
                                                    countSpaces = indent;
                                                }
                                            } else if (!indentRule) {
                                                countSpaces = docOptions.spaceAfterSemi ? 1 : 0;
                                            }
                                        } else if (formatToken.getId() == FormatToken.Kind.LINE_COMMENT || formatToken.getId() == FormatToken.Kind.COMMENT_START) {
                                            countSpaces = oldText == null || oldText.length() == 0 ? (docOptions.spaceAfterSemi ? 1 : 0) : oldText.length();
                                        }
                                    } else if (!indentRule) {
                                        newLines = TokenFormatter.this.countOfNewLines(oldText);
                                    }
                                    afterSemi = false;
                                }
                                newText = TokenFormatter.this.createWhitespace(docOptions, newLines, countSpaces);
                                if (wsBetweenBraces) {
                                    newText = TokenFormatter.this.createWhitespace(docOptions, 1, indent + docOptions.indentSize) + TokenFormatter.this.createWhitespace(docOptions, 1, lastBracePlacement == CodeStyle.BracePlacement.NEW_LINE_INDENTED ? indent + docOptions.indentSize : indent);
                                }
                                int realOffset = changeOffset + delta;
                                if (templateEdit && !caretInTemplateSolved && oldText != null && formatContext.startOffset() - 1 <= realOffset && realOffset <= formatContext.endOffset() + 1 && (caretPosition = caretOffset + delta) == formatContext.endOffset() && oldText.length() > 0 && newText.length() > 0 && oldText.charAt(0) == ' ' && newText.charAt(0) != ' ' && 0 != TokenFormatter.this.countOfNewLines(oldText)) {
                                    newText = ' ' + newText;
                                    caretInTemplateSolved = true;
                                }
                                if (formatToken.getId() == FormatToken.Kind.TEXT && "{".equals(formatToken.getOldText()) && newLines == 0 && TokenFormatter.this.isAfterLineComment(formatTokens, index - 2)) {
                                    for (hIndex = index - 2; hIndex > 0 && formatTokens.get(hIndex).getId() != FormatToken.Kind.TEXT; --hIndex) {
                                    }
                                    if (hIndex > 0 && formatTokens.get(hIndex).getId() == FormatToken.Kind.TEXT && (")".equals(formatTokens.get(hIndex).getOldText()) || "else".equals(formatTokens.get(hIndex).getOldText()))) {
                                        delta = this.replaceString(doc, formatTokens.get(hIndex).getOffset() + formatTokens.get(hIndex).getOldText().length() - (delta - deltaForLastMoveBeforeLineComment), hIndex + 1, "", newText + "{", delta, templateEdit);
                                        delta = this.replaceString(doc, changeOffset, index, oldText, "", delta, templateEdit);
                                        delta = this.replaceString(doc, formatToken.getOffset(), index, formatToken.getOldText(), "", delta, templateEdit);
                                        newText = null;
                                    }
                                }
                            }
                            --index;
                        } else {
                            switch (formatToken.getId()) {
                                case INDENT: {
                                    indent += ((FormatToken.IndentToken)formatToken).getDelta();
                                    lastPHPIndent += ((FormatToken.IndentToken)formatToken).getDelta();
                                    break;
                                }
                                case COMMENT: 
                                case DOC_COMMENT: {
                                    oldText = formatToken.getOldText() != null ? formatToken.getOldText() : "";
                                    changeOffset = formatToken.getOffset();
                                    newText = this.formatComment(index, indent, oldText);
                                    if (!newText.equals(oldText)) break;
                                    newText = null;
                                    break;
                                }
                                case ANCHOR: {
                                    lastAnchor = (FormatToken.AnchorToken)formatToken;
                                    lastAnchor.setAnchorColumn(column);
                                    break;
                                }
                                case HTML: {
                                    if (htmlIndent <= -1) break;
                                    oldText = formatToken.getOldText();
                                    for (int firstNW = 0; firstNW < oldText.length() && Character.isWhitespace(oldText.charAt(firstNW)); ++firstNW) {
                                    }
                                    int lineOffset = formatToken.getOffset() + delta;
                                    try {
                                        int firstLine = Utilities.getLineOffset((BaseDocument)doc, (int)lineOffset);
                                        boolean countInitialIndent = docOptions.initialIndent > 0 && lastPHPIndent > 0;
                                        int indexInST = 0;
                                        StringTokenizer st = new StringTokenizer(oldText, "\n", true);
                                        while (st.hasMoreTokens()) {
                                            String token = st.nextToken();
                                            int currentOffset = formatToken.getOffset() + delta + indexInST;
                                            indexInST += token.length();
                                            int currentLine = Utilities.getLineOffset((BaseDocument)doc, (int)currentOffset);
                                            if (firstLine >= currentLine || token.equals("\n")) continue;
                                            int lineIndent = Utilities.getRowIndent((BaseDocument)doc, (int)(currentOffset + 1));
                                            int finalIndent = lastPHPIndent + lineIndent + (countInitialIndent ? docOptions.initialIndent : 0);
                                            if (finalIndent == docOptions.initialIndent && finalIndent != 0) {
                                                finalIndent = 0;
                                            }
                                            if (lineIndent >= finalIndent) continue;
                                            delta = this.replaceString(doc, currentOffset - delta, index, "", TokenFormatter.this.createWhitespace(docOptions, 0, finalIndent - lineIndent), delta, false);
                                        }
                                    }
                                    catch (BadLocationException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                    oldText = null;
                                    newText = null;
                                    break;
                                }
                                case TEXT: {
                                    if (!")".equals(formatToken.getOldText()) && !"else".equals(formatToken.getOldText())) break;
                                    deltaForLastMoveBeforeLineComment = delta;
                                }
                            }
                        }
                        delta = this.replaceString(doc, changeOffset, index, oldText, newText, delta, templateEdit);
                        column = newText == null ? (column += formatToken.getOldText() == null ? 0 : formatToken.getOldText().length()) : ((lines = TokenFormatter.this.countOfNewLines(newText)) > 0 ? newText.length() - lines : (column += newText.length()));
                        newText = null;
                    }
                }
                finally {
                    mti.tokenHierarchyControl().setActive(true);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    long end = System.currentTimeMillis();
                    LOGGER.log(Level.FINE, "Applaying format stream took: {0} ms", end - start.get());
                }
            }

            private Whitespace countWhiteSpaceBeforeLeftBrace(CodeStyle.BracePlacement placement, boolean spaceBefore, CharSequence text, int indent) {
                int lines = 0;
                int spaces = 0;
                int n = lines = placement == CodeStyle.BracePlacement.SAME_LINE ? 0 : 1;
                if (placement == CodeStyle.BracePlacement.PRESERVE_EXISTING) {
                    int n2 = lines = TokenFormatter.this.countOfNewLines(text) > 0 ? 1 : 0;
                }
                spaces = lines > 0 ? (placement == CodeStyle.BracePlacement.NEW_LINE_INDENTED ? indent + docOptions.indentSize : indent) : (spaceBefore ? 1 : 0);
                return new Whitespace(lines, spaces);
            }

            private Whitespace countWSBeforeAStatement(CodeStyle.WrapStyle style, boolean addSpaceIfNoLine, int column, int lengthOfNexSequence, int currentIndent) {
                int lines = 0;
                int spaces = 0;
                switch (style) {
                    case WRAP_ALWAYS: {
                        lines = 1;
                        spaces = currentIndent;
                        break;
                    }
                    case WRAP_NEVER: {
                        lines = 0;
                        spaces = addSpaceIfNoLine ? 1 : 0;
                        break;
                    }
                    case WRAP_IF_LONG: {
                        if (column + 1 + lengthOfNexSequence > docOptions.margin) {
                            lines = 1;
                            spaces = currentIndent + docOptions.indentSize;
                            break;
                        }
                        lines = 0;
                        spaces = addSpaceIfNoLine ? 1 : 0;
                    }
                }
                return new Whitespace(lines, spaces);
            }

            private Whitespace countWhiteSpaceBeforeRightBrace(CodeStyle.BracePlacement placement, int currentLine, int addLine, int indent, List<FormatToken> formatTokens, int currentIndex) {
                int index;
                int lines = 0;
                int spaces = 0;
                lines = this.addLines(currentLine, addLine);
                for (index = currentIndex; index > 0 && (formatTokens.get(index).isWhitespace() || formatTokens.get(index).getId() == FormatToken.Kind.INDENT); --index) {
                }
                spaces = lines == 0 && formatTokens.get(index).getId() == FormatToken.Kind.OPEN_TAG ? 1 : (placement == CodeStyle.BracePlacement.NEW_LINE_INDENTED ? indent + docOptions.indentSize : indent);
                return new Whitespace(lines, spaces);
            }

            private Whitespace countWSBeforeKeyword(boolean placeOnNewLine, boolean placeSpaceBefore, int currentIndent, List<FormatToken> formatTokens, int currentIndex) {
                int lines = 0;
                int spaces = 0;
                if (placeOnNewLine) {
                    lines = 1;
                    spaces = currentIndent;
                } else if (TokenFormatter.this.isAfterLineComment(formatTokens, currentIndex)) {
                    lines = 1;
                    spaces = currentIndent;
                } else {
                    lines = 0;
                    spaces = placeSpaceBefore ? 1 : 0;
                }
                return new Whitespace(lines, spaces);
            }

            private int countLinesAfter(List<FormatToken> formatTokens, int currentIndex) {
                int lines = -1;
                while (currentIndex < formatTokens.size() && formatTokens.get(currentIndex).isWhitespace() && formatTokens.get(currentIndex).getId() != FormatToken.Kind.WHITESPACE_INDENT) {
                    ++currentIndex;
                }
                if (formatTokens.get(currentIndex).getId() == FormatToken.Kind.WHITESPACE_INDENT) {
                    lines = TokenFormatter.this.countOfNewLines(formatTokens.get(currentIndex).getOldText());
                }
                return lines;
            }

            private boolean isOpenAndCloseTagOnOneLine(List<FormatToken> formatTokens, int currentIndex) {
                boolean result = false;
                FormatToken token = formatTokens.get(currentIndex);
                do {
                    token = formatTokens.get(currentIndex);
                } while (++currentIndex < formatTokens.size() && token.getId() != FormatToken.Kind.WHITESPACE_INDENT && token.getId() != FormatToken.Kind.CLOSE_TAG);
                if (currentIndex < formatTokens.size() && token.getId() == FormatToken.Kind.WHITESPACE_INDENT) {
                    do {
                        token = formatTokens.get(currentIndex);
                    } while (++currentIndex < formatTokens.size() && token.getId() != FormatToken.Kind.WHITESPACE_INDENT && token.getId() != FormatToken.Kind.CLOSE_TAG);
                }
                result = token.getId() == FormatToken.Kind.CLOSE_TAG;
                return result;
            }

            private boolean isCloseAndOpenTagOnOneLine(List<FormatToken> formatTokens, int currentIndex) {
                boolean result = false;
                int helpIndex = currentIndex;
                FormatToken token = formatTokens.get(currentIndex);
                do {
                    token = formatTokens.get(currentIndex);
                } while (--currentIndex > 0 && token.getId() != FormatToken.Kind.WHITESPACE_INDENT && token.getId() != FormatToken.Kind.OPEN_TAG);
                if (currentIndex >= 0 && token.getId() == FormatToken.Kind.OPEN_TAG || currentIndex >= 0 && token.getId() == FormatToken.Kind.WHITESPACE_INDENT && formatTokens.get(currentIndex).getId() == FormatToken.Kind.WHITESPACE_AFTER_OPEN_PHP_TAG) {
                    currentIndex = helpIndex;
                    do {
                        token = formatTokens.get(currentIndex);
                    } while (++currentIndex < formatTokens.size() && token.getId() != FormatToken.Kind.WHITESPACE_INDENT && token.getId() != FormatToken.Kind.OPEN_TAG && token.getId() != FormatToken.Kind.CLOSE_TAG);
                    result = token.getId() == FormatToken.Kind.CLOSE_TAG;
                }
                return result;
            }

            private int addLines(int currentCount, int addLines) {
                if (++addLines > 1) {
                    currentCount = addLines > currentCount ? addLines : currentCount;
                }
                return currentCount;
            }

            private int countUnbreakableTextAfter(List<FormatToken> formatTokens, int index) {
                FormatToken token;
                int result = 0;
                do {
                    token = formatTokens.get(index);
                } while (++index < formatTokens.size() && (token.isWhitespace() || token.getId() == FormatToken.Kind.INDENT));
                --index;
                do {
                    result = (token = formatTokens.get(index)).isWhitespace() ? (result += token.getOldText() == null ? 0 : 1) : (result += token.getOldText() == null ? 0 : token.getOldText().length());
                    ++result;
                } while (++index < formatTokens.size() && !token.isBreakable());
                return --result;
            }

            private String formatComment(int index, int indent, String comment) {
                int indexFirstLine;
                indent = Math.max(indent, 0);
                if (comment == null || comment.length() == 0) {
                    return "";
                }
                StringBuilder sb = new StringBuilder();
                boolean indentLine = false;
                boolean firstLine = true;
                String indentString = TokenFormatter.this.createWhitespace(docOptions, 0, indent + 1);
                for (indexFirstLine = 0; indexFirstLine < comment.length() && comment.charAt(indexFirstLine) == ' '; ++indexFirstLine) {
                }
                if (indexFirstLine < comment.length() && comment.charAt(indexFirstLine) == '\n') {
                    indentLine = true;
                    firstLine = false;
                }
                boolean lastAdded = false;
                StringTokenizer st = new StringTokenizer(comment, "\n", true);
                while (st.hasMoreTokens()) {
                    String part = st.nextToken();
                    String trimPart = part.trim();
                    if (trimPart.length() > 0 && trimPart.charAt(0) == '*') {
                        sb.append(indentString);
                        part = part.substring(part.indexOf(42));
                        if (part.length() > 1 && part.charAt(1) != ' ') {
                            sb.append("* ");
                            part = part.substring(1);
                        }
                    } else if (firstLine) {
                        if (part.charAt(0) != ' ') {
                            sb.append(' ');
                        }
                    } else if (trimPart.length() > 0) {
                        sb.append(indentString);
                        sb.append(' ');
                        part = trimPart;
                    }
                    if (trimPart.length() > 0 || firstLine || "\n".equals(part)) {
                        sb.append(part);
                        lastAdded = true;
                    } else {
                        lastAdded = false;
                    }
                    firstLine = false;
                }
                if (comment.charAt(comment.length() - 1) == '\n') {
                    sb.append(indentString);
                } else if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n' && !lastAdded) {
                    sb.append(indentString);
                } else {
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
                        sb.setLength(sb.length() - 1);
                    }
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
                        sb.append(' ');
                    }
                    if (sb.length() == 0) {
                        sb.append(' ');
                    }
                }
                return sb.toString();
            }

            private boolean isAfterOpenBrace(int offset) {
                boolean value = false;
                if (offset < doc.getLength()) {
                    String ch = "";
                    int index = offset;
                    try {
                        do {
                            ch = doc.getText(index, 1);
                        } while (--index > 0 && "\n\t ".contains(ch));
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    value = "{".equals(ch);
                }
                return value;
            }

            private int replaceString(BaseDocument document, int offset, int indexInFormatTokens, String oldText, String newText, int delta, boolean templateEdit) {
                if (oldText == null) {
                    oldText = "";
                }
                if (this.startOffset == -1) {
                    this.startOffset = formatContext.startOffset();
                    this.endOffset = formatContext.endOffset();
                }
                if (this.startOffset > 0 && this.startOffset - oldText.length() > offset && newText != null && newText.indexOf(10) > -1) {
                    this.previousNewIndentText = newText;
                    this.previousOldIndentText = oldText;
                }
                if (newText != null && (!oldText.equals(newText) || this.startOffset > 0 && this.startOffset - oldText.length() == offset)) {
                    String replaceOld;
                    int indexNewTextLine;
                    int indexOldTextLine;
                    int realOffset = offset + delta;
                    if (this.startOffset > 0 && this.startOffset - oldText.length() == offset) {
                        int replaceOldLength;
                        if (this.previousOldIndentText.length() == 0 && this.previousNewIndentText.length() == 0) {
                            this.previousOldIndentText = oldText;
                            this.previousNewIndentText = newText;
                        }
                        indexOldTextLine = this.previousOldIndentText.lastIndexOf(10);
                        indexNewTextLine = this.previousNewIndentText.lastIndexOf(10);
                        this.previousNewIndentText = indexNewTextLine == -1 ? this.previousNewIndentText : this.previousNewIndentText.substring(indexNewTextLine + 1);
                        this.previousOldIndentText = indexOldTextLine == -1 ? this.previousOldIndentText : this.previousOldIndentText.substring(indexOldTextLine + 1);
                        this.previousIndentDelta = TokenFormatter.this.countOfSpaces(this.previousOldIndentText, docOptions.tabSize) - TokenFormatter.this.countOfSpaces(this.previousNewIndentText, docOptions.tabSize);
                        indexNewTextLine = newText.lastIndexOf(10);
                        String replaceNew = indexNewTextLine == -1 ? newText : newText.substring(indexNewTextLine + 1);
                        int replaceNewLength = TokenFormatter.this.countOfSpaces(replaceNew, docOptions.tabSize);
                        if (this.previousIndentDelta != 0 && indexNewTextLine > -1 && replaceNewLength >= 0) {
                            replaceNew = TokenFormatter.this.createWhitespace(docOptions, 0, Math.max(0, replaceNewLength += this.previousIndentDelta));
                        }
                        if ((replaceOldLength = TokenFormatter.this.countOfSpaces(replaceOld = (indexOldTextLine = oldText.lastIndexOf(10)) == -1 ? oldText : oldText.substring(indexOldTextLine + 1), docOptions.tabSize)) != replaceNewLength) {
                            delta = this.replaceSimpleString(document, realOffset + indexOldTextLine + 1, replaceOld, replaceNew, delta);
                        }
                    }
                    if (this.startOffset <= realOffset && realOffset < this.endOffset + delta) {
                        if (!templateEdit || this.startOffset == 0) {
                            delta = this.replaceSimpleString(document, realOffset, oldText, newText, delta);
                        } else {
                            indexOldTextLine = oldText.indexOf(10);
                            indexNewTextLine = newText.indexOf(10);
                            int indexOldText = 0;
                            int indexNewText = 0;
                            if (indexOldTextLine == -1 && indexNewTextLine == -1) {
                                delta = this.replaceSimpleString(document, realOffset, oldText, newText, delta);
                            } else {
                                String replaceNew;
                                do {
                                    indexOldTextLine = oldText.indexOf(10, indexOldText);
                                    indexNewTextLine = newText.indexOf(10, indexNewText);
                                    if (indexOldTextLine == -1) {
                                        indexOldTextLine = oldText.length();
                                    }
                                    if (indexNewTextLine == -1) {
                                        indexNewTextLine = newText.length();
                                    }
                                    replaceOld = indexOldText == indexOldTextLine && oldText.length() > 0 ? "\n" : oldText.substring(indexOldText, indexOldTextLine);
                                    String string = replaceNew = indexNewText == indexNewTextLine ? "\n" : newText.substring(indexNewText, indexNewTextLine);
                                    if (this.previousIndentDelta != 0 && indexNewText != indexNewTextLine && indexNewText > 0 && indexNewTextLine > -1 && replaceNew.length() > 0) {
                                        int newSpaces = TokenFormatter.this.countOfSpaces(replaceNew, docOptions.tabSize) + this.previousIndentDelta;
                                        replaceNew = TokenFormatter.this.createWhitespace(docOptions, 0, Math.max(0, newSpaces));
                                    }
                                    if (!(replaceOld.equals(replaceNew) || indexOldText + replaceOld.length() > oldText.length() && indexNewText != indexNewTextLine)) {
                                        if (newText.trim().length() == 0) {
                                            delta = this.replaceSimpleString(document, realOffset + indexOldText, replaceOld, replaceNew, delta);
                                        } else {
                                            int indexOldChar = 0;
                                            int indexNewChar = 0;
                                            while (indexNewChar < replaceNew.length() && indexOldChar < replaceOld.length()) {
                                                char oldChar;
                                                char newChar = replaceNew.charAt(indexNewChar);
                                                if (newChar != (oldChar = replaceOld.charAt(indexOldChar))) {
                                                    if (Character.isWhitespace(newChar)) {
                                                        delta = this.replaceSimpleString(document, realOffset + indexOldText + indexNewChar, "", "" + newChar, delta);
                                                        ++indexNewChar;
                                                        continue;
                                                    }
                                                    if (!Character.isWhitespace(oldChar)) continue;
                                                    delta = this.replaceSimpleString(document, realOffset + indexOldText + indexNewChar, "" + oldChar, "", delta);
                                                    ++indexOldChar;
                                                    continue;
                                                }
                                                ++indexNewChar;
                                                ++indexOldChar;
                                            }
                                        }
                                    }
                                    indexOldText = indexOldTextLine + 1;
                                    indexNewText = indexNewTextLine + 1;
                                    realOffset = offset + delta;
                                } while (indexOldText < oldText.length() && indexNewText < newText.length());
                                if (indexOldText >= oldText.length() && indexNewText < newText.length()) {
                                    StringBuilder sb = new StringBuilder();
                                    boolean addNewLine = false;
                                    do {
                                        boolean bl = addNewLine = (indexNewTextLine = newText.indexOf(10, indexNewText)) != -1;
                                        if (!addNewLine) {
                                            indexNewTextLine = newText.length();
                                        }
                                        replaceNew = newText.substring(indexNewText, indexNewTextLine == -1 ? newText.length() : indexNewTextLine);
                                        int newSpaces = TokenFormatter.this.countOfSpaces(replaceNew, docOptions.tabSize);
                                        if (this.previousIndentDelta != 0 && indexNewText != indexNewTextLine && indexNewText > 0 && indexNewTextLine > -1 && newSpaces > 0) {
                                            replaceNew = TokenFormatter.this.createWhitespace(docOptions, 0, Math.max(0, newSpaces += this.previousIndentDelta));
                                        }
                                        sb.append(replaceNew);
                                        if (!addNewLine) continue;
                                        sb.append('\n');
                                    } while ((indexNewText = indexNewTextLine + 1) < newText.length());
                                    if (sb.length() > 0) {
                                        delta = this.replaceSimpleString(document, realOffset + oldText.length(), "", sb.toString(), delta);
                                    }
                                }
                            }
                        }
                    }
                }
                return delta;
            }

            private int replaceSimpleString(BaseDocument document, int realOffset, String oldText, String newText, int delta) {
                try {
                    if (oldText.length() > 0) {
                        int removeLength = realOffset + oldText.length() < document.getLength() ? oldText.length() : document.getLength() - realOffset;
                        document.remove(realOffset, removeLength);
                    }
                    document.insertString(realOffset, newText, null);
                    delta = delta - oldText.length() + newText.length();
                }
                catch (BadLocationException ex) {
                    LOGGER.throwing(TokenFormatter.this.getClass().getName(), "replaceSimpleSring", ex);
                }
                return delta;
            }

            private int countLengthOfNextSequence(List<FormatToken> formatTokens, int index) {
                FormatToken token = formatTokens.get(index);
                int length = 0;
                if (token.getId() == FormatToken.Kind.UNBREAKABLE_SEQUENCE_START) {
                    token = formatTokens.get(++index);
                    int balance = 0;
                    while (index < formatTokens.size() && (token.getId() != FormatToken.Kind.UNBREAKABLE_SEQUENCE_END || balance != 0)) {
                        if (token.getId() == FormatToken.Kind.WHITESPACE) {
                            ++length;
                        } else if (token.getId() == FormatToken.Kind.UNBREAKABLE_SEQUENCE_START) {
                            ++balance;
                        } else if (token.getId() == FormatToken.Kind.UNBREAKABLE_SEQUENCE_END) {
                            --balance;
                        } else if (token.getOldText() != null) {
                            length += token.getOldText().length();
                        }
                        if (++index >= formatTokens.size()) continue;
                        token = formatTokens.get(index);
                    }
                }
                return length;
            }

            private boolean isBeforeEmptyStatement(List<FormatToken> formatTokens, int index) {
                FormatToken token = formatTokens.get(index);
                boolean value = false;
                ++index;
                while (index < formatTokens.size() && token.getOldText() == null && token.getId() != FormatToken.Kind.WHITESPACE) {
                    token = formatTokens.get(index);
                    ++index;
                }
                value = index < formatTokens.size() && ";".equals(token.getOldText());
                return value;
            }
        });
    }

    private boolean isBeforeLineComment(List<FormatToken> tokens, int index) {
        FormatToken token = tokens.get(index);
        while (index < tokens.size() - 1 && (token.isWhitespace() || token.getId() == FormatToken.Kind.INDENT)) {
            token = tokens.get(++index);
        }
        return token.getId() == FormatToken.Kind.LINE_COMMENT;
    }

    private int countOfSpaces(String text, int tabSize) {
        int spaces = 0;
        for (int index = 0; index < text.length(); ++index) {
            if (text.charAt(index) == '\t') {
                spaces += tabSize;
                continue;
            }
            ++spaces;
        }
        return spaces;
    }

    private FormatToken getPreviousNonWhite(List<FormatToken> tokens, int index) {
        if (index < 0) {
            return null;
        }
        FormatToken token = tokens.get(index);
        while (index < tokens.size() - 1 && (token.isWhitespace() || token.getId() == FormatToken.Kind.INDENT)) {
            token = tokens.get(++index);
        }
        return token;
    }

    private boolean isAfterLineComment(List<FormatToken> tokens, int index) {
        FormatToken token = tokens.get(index);
        while (index > 0 && (token.isWhitespace() || token.getId() == FormatToken.Kind.INDENT || token.getId() == FormatToken.Kind.UNBREAKABLE_SEQUENCE_END)) {
            token = tokens.get(--index);
        }
        return token.getId() == FormatToken.Kind.LINE_COMMENT;
    }

    private boolean isBeforePHPDoc(List<FormatToken> tokens, int index) {
        FormatToken token = tokens.get(index);
        while (index > 0 && (token.isWhitespace() || token.getId() == FormatToken.Kind.INDENT || token.getId() == FormatToken.Kind.UNBREAKABLE_SEQUENCE_END)) {
            token = tokens.get(++index);
        }
        return token.getId() == FormatToken.Kind.DOC_COMMENT_START;
    }

    private boolean isBeginLine(List<FormatToken> tokens, int index) {
        FormatToken token = tokens.get(index);
        while (index > 0 && (token.isWhitespace() || token.getId() == FormatToken.Kind.INDENT) && token.getId() != FormatToken.Kind.WHITESPACE_INDENT) {
            token = tokens.get(--index);
        }
        return token.getId() == FormatToken.Kind.WHITESPACE_INDENT || token.getId() == FormatToken.Kind.LINE_COMMENT;
    }

    private String createWhitespace(DocumentOptions docOptions, int lines, int spaces) {
        if (lines == 0 && spaces == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines; ++i) {
            sb.append('\n');
        }
        if (spaces > 0) {
            sb.append(IndentUtils.cachedOrCreatedIndentString(spaces, docOptions.expandTabsToSpaces, docOptions.tabSize));
        }
        return sb.toString();
    }

    private static class Whitespace {
        int lines;
        int spaces;

        public Whitespace(int lines, int spaces) {
            this.lines = lines;
            this.spaces = spaces;
        }
    }

    protected static class DocumentOptions {
        public int continualIndentSize;
        public int initialIndent;
        public int indentSize;
        public int indentArrayItems;
        public int margin;
        public int tabSize;
        public boolean expandTabsToSpaces;
        public CodeStyle.BracePlacement classDeclBracePlacement;
        public CodeStyle.BracePlacement methodDeclBracePlacement;
        public CodeStyle.BracePlacement ifBracePlacement;
        public CodeStyle.BracePlacement forBracePlacement;
        public CodeStyle.BracePlacement whileBracePlacement;
        public CodeStyle.BracePlacement switchBracePlacement;
        public CodeStyle.BracePlacement catchBracePlacement;
        public CodeStyle.BracePlacement otherBracePlacement;
        public boolean spaceBeforeClassDeclLeftBrace;
        public boolean spaceBeforeMethodDeclLeftBrace;
        public boolean spaceBeforeIfLeftBrace;
        public boolean spaceBeforeElseLeftBrace;
        public boolean spaceBeforeWhileLeftBrace;
        public boolean spaceBeforeForLeftBrace;
        public boolean spaceBeforeDoLeftBrace;
        public boolean spaceBeforeSwitchLeftBrace;
        public boolean spaceBeforeTryLeftBrace;
        public boolean spaceBeforeCatchLeftBrace;
        public boolean spaceBeforeMethodDeclParen;
        public boolean spaceBeforeMethodCallParen;
        public boolean spaceBeforeIfParen;
        public boolean spaceBeforeForParen;
        public boolean spaceBeforeWhileParen;
        public boolean spaceBeforeCatchParen;
        public boolean spaceBeforeSwitchParen;
        public boolean spaceBeforeArrayDeclParen;
        public boolean spaceBeforeWhile;
        public boolean spaceBeforeElse;
        public boolean spaceBeforeCatch;
        public boolean spaceAroundObjectOp;
        public boolean spaceAroundStringConcatOp;
        public boolean spaceAroundUnaryOps;
        public boolean spaceAroundBinaryOps;
        public boolean spaceAroundTernaryOps;
        public boolean spaceAroundAssignOps;
        public boolean spaceAroundKeyValueOps;
        public boolean spaceWithinArrayDeclParens;
        public boolean spaceWithinMethodDeclParens;
        public boolean spaceWithinMethodCallParens;
        public boolean spaceWithinIfParens;
        public boolean spaceWithinForParens;
        public boolean spaceWithinWhileParens;
        public boolean spaceWithinSwitchParens;
        public boolean spaceWithinCatchParens;
        public boolean spaceWithinArrayBrackets;
        public boolean spaceWithinTypeCastParens;
        public boolean spaceBeforeComma;
        public boolean spaceAfterComma;
        public boolean spaceBeforeSemi;
        public boolean spaceAfterSemi;
        public boolean spaceAfterTypeCast;
        public boolean spaceAfterShortTag;
        public boolean spaceBeforeClosePHPTag;
        public boolean placeElseOnNewLine;
        public boolean placeWhileOnNewLine;
        public boolean placeCatchOnNewLine;
        public boolean placeNewLineAfterModifiers;
        public int blankLinesBeforeNamespace;
        public int blankLinesAfterNamespace;
        public int blankLinesBeforeUse;
        public int blankLinesAfterUse;
        public int blankLinesBeforeClass;
        public int blankLinesBeforeClassEnd;
        public int blankLinesAfterClass;
        public int blankLinesAfterClassHeader;
        public int blankLinesBeforeFields;
        public int blankLinesBetweenFields;
        public boolean blankLinesGroupFields;
        public int blankLinesAfterFields;
        public int blankLinesBeforeFunction;
        public int blankLinesAfterFunction;
        public int blankLinesBeforeFunctionEnd;
        public int blankLinesAfterOpenPHPTag;
        public int blankLinesAfterOpenPHPTagInHTML;
        public int blankLinesBeforeClosePHPTag;
        public CodeStyle.WrapStyle wrapExtendsImplementsKeyword;
        public CodeStyle.WrapStyle wrapExtendsImplementsList;
        public CodeStyle.WrapStyle wrapMethodParams;
        public CodeStyle.WrapStyle wrapMethodCallArgs;
        public CodeStyle.WrapStyle wrapChainedMethodCalls;
        public CodeStyle.WrapStyle wrapArrayInit;
        public CodeStyle.WrapStyle wrapFor;
        public CodeStyle.WrapStyle wrapForStatement;
        public CodeStyle.WrapStyle wrapIfStatement;
        public CodeStyle.WrapStyle wrapWhileStatement;
        public CodeStyle.WrapStyle wrapDoWhileStatement;
        public CodeStyle.WrapStyle wrapBinaryOps;
        public CodeStyle.WrapStyle wrapTernaryOps;
        public CodeStyle.WrapStyle wrapAssignOps;
        public boolean wrapBlockBrace;
        public boolean wrapStatementsOnTheSameLine;
        public boolean alignMultilineMethodParams;
        public boolean alignMultilineCallArgs;
        public boolean alignMultilineImplements;
        public boolean alignMultilineParenthesized;
        public boolean alignMultilineBinaryOp;
        public boolean alignMultilineTernaryOp;
        public boolean alignMultilineAssignment;
        public boolean alignMultilineFor;
        public boolean alignMultilineArrayInit;

        public DocumentOptions(BaseDocument doc) {
            CodeStyle codeStyle = CodeStyle.get((Document)doc);
            this.continualIndentSize = codeStyle.getContinuationIndentSize();
            this.initialIndent = codeStyle.getInitialIndent();
            this.indentSize = codeStyle.getIndentSize();
            this.indentArrayItems = codeStyle.getItemsInArrayDeclarationIndentSize();
            this.margin = codeStyle.getRightMargin();
            this.tabSize = codeStyle.getTabSize();
            this.expandTabsToSpaces = codeStyle.expandTabToSpaces();
            this.classDeclBracePlacement = codeStyle.getClassDeclBracePlacement();
            this.methodDeclBracePlacement = codeStyle.getMethodDeclBracePlacement();
            this.ifBracePlacement = codeStyle.getIfBracePlacement();
            this.forBracePlacement = codeStyle.getForBracePlacement();
            this.whileBracePlacement = codeStyle.getWhileBracePlacement();
            this.switchBracePlacement = codeStyle.getSwitchBracePlacement();
            this.catchBracePlacement = codeStyle.getCatchBracePlacement();
            this.otherBracePlacement = codeStyle.getOtherBracePlacement();
            this.spaceBeforeClassDeclLeftBrace = codeStyle.spaceBeforeClassDeclLeftBrace();
            this.spaceBeforeMethodDeclLeftBrace = codeStyle.spaceBeforeMethodDeclLeftBrace();
            this.spaceBeforeIfLeftBrace = codeStyle.spaceBeforeIfLeftBrace();
            this.spaceBeforeElseLeftBrace = codeStyle.spaceBeforeElseLeftBrace();
            this.spaceBeforeWhileLeftBrace = codeStyle.spaceBeforeWhileLeftBrace();
            this.spaceBeforeForLeftBrace = codeStyle.spaceBeforeForLeftBrace();
            this.spaceBeforeDoLeftBrace = codeStyle.spaceBeforeDoLeftBrace();
            this.spaceBeforeSwitchLeftBrace = codeStyle.spaceBeforeSwitchLeftBrace();
            this.spaceBeforeTryLeftBrace = codeStyle.spaceBeforeTryLeftBrace();
            this.spaceBeforeCatchLeftBrace = codeStyle.spaceBeforeCatchLeftBrace();
            this.spaceBeforeMethodDeclParen = codeStyle.spaceBeforeMethodDeclParen();
            this.spaceBeforeMethodCallParen = codeStyle.spaceBeforeMethodCallParen();
            this.spaceBeforeIfParen = codeStyle.spaceBeforeIfParen();
            this.spaceBeforeForParen = codeStyle.spaceBeforeForParen();
            this.spaceBeforeWhileParen = codeStyle.spaceBeforeWhileParen();
            this.spaceBeforeCatchParen = codeStyle.spaceBeforeCatchParen();
            this.spaceBeforeSwitchParen = codeStyle.spaceBeforeSwitchParen();
            this.spaceBeforeArrayDeclParen = codeStyle.spaceBeforeArrayDeclParen();
            this.spaceBeforeWhile = codeStyle.spaceBeforeWhile();
            this.spaceBeforeElse = codeStyle.spaceBeforeElse();
            this.spaceBeforeCatch = codeStyle.spaceBeforeCatch();
            this.spaceAroundObjectOp = codeStyle.spaceAroundObjectOps();
            this.spaceAroundStringConcatOp = codeStyle.spaceAroundStringConcatOps();
            this.spaceAroundUnaryOps = codeStyle.spaceAroundUnaryOps();
            this.spaceAroundBinaryOps = codeStyle.spaceAroundBinaryOps();
            this.spaceAroundTernaryOps = codeStyle.spaceAroundTernaryOps();
            this.spaceAroundAssignOps = codeStyle.spaceAroundAssignOps();
            this.spaceAroundKeyValueOps = codeStyle.spaceAroundKeyValueOps();
            this.spaceWithinArrayDeclParens = codeStyle.spaceWithinArrayDeclParens();
            this.spaceWithinMethodDeclParens = codeStyle.spaceWithinMethodDeclParens();
            this.spaceWithinMethodCallParens = codeStyle.spaceWithinMethodCallParens();
            this.spaceWithinIfParens = codeStyle.spaceWithinIfParens();
            this.spaceWithinForParens = codeStyle.spaceWithinForParens();
            this.spaceWithinWhileParens = codeStyle.spaceWithinWhileParens();
            this.spaceWithinSwitchParens = codeStyle.spaceWithinSwitchParens();
            this.spaceWithinCatchParens = codeStyle.spaceWithinCatchParens();
            this.spaceWithinArrayBrackets = codeStyle.spaceWithinArrayBrackets();
            this.spaceWithinTypeCastParens = codeStyle.spaceWithinTypeCastParens();
            this.spaceBeforeComma = codeStyle.spaceBeforeComma();
            this.spaceAfterComma = codeStyle.spaceAfterComma();
            this.spaceBeforeSemi = codeStyle.spaceBeforeSemi();
            this.spaceAfterSemi = codeStyle.spaceAfterSemi();
            this.spaceAfterTypeCast = codeStyle.spaceAfterTypeCast();
            this.spaceAfterShortTag = codeStyle.spaceAfterShortPHPTag();
            this.spaceBeforeClosePHPTag = codeStyle.spaceBeforeClosePHPTag();
            this.placeElseOnNewLine = codeStyle.placeElseOnNewLine();
            this.placeWhileOnNewLine = codeStyle.placeWhileOnNewLine();
            this.placeCatchOnNewLine = codeStyle.placeCatchOnNewLine();
            this.placeNewLineAfterModifiers = codeStyle.placeNewLineAfterModifiers();
            this.blankLinesBeforeNamespace = codeStyle.getBlankLinesBeforeNamespace();
            this.blankLinesAfterNamespace = codeStyle.getBlankLinesAfterNamespace();
            this.blankLinesBeforeUse = codeStyle.getBlankLinesBeforeUse();
            this.blankLinesAfterUse = codeStyle.getBlankLinesAfterUse();
            this.blankLinesBeforeClass = codeStyle.getBlankLinesBeforeClass();
            this.blankLinesBeforeClassEnd = codeStyle.getBlankLinesBeforeClassEnd();
            this.blankLinesAfterClass = codeStyle.getBlankLinesAfterClass();
            this.blankLinesAfterClassHeader = codeStyle.getBlankLinesAfterClassHeader();
            this.blankLinesBeforeFields = codeStyle.getBlankLinesBeforeFields();
            this.blankLinesBetweenFields = codeStyle.getBlankLinesBetweenFields();
            this.blankLinesGroupFields = codeStyle.getBlankLinesGroupFieldsWithoutDoc();
            this.blankLinesAfterFields = codeStyle.getBlankLinesAfterFields();
            this.blankLinesBeforeFunction = codeStyle.getBlankLinesBeforeFunction();
            this.blankLinesAfterFunction = codeStyle.getBlankLinesAfterFunction();
            this.blankLinesBeforeFunctionEnd = codeStyle.getBlankLinesBeforeFunctionEnd();
            this.blankLinesAfterOpenPHPTag = codeStyle.getBlankLinesAfterOpenPHPTag();
            this.blankLinesAfterOpenPHPTagInHTML = codeStyle.getBlankLinesAfterOpenPHPTagInHTML();
            this.blankLinesBeforeClosePHPTag = codeStyle.getBlankLinesBeforeClosePHPTag();
            this.wrapExtendsImplementsKeyword = codeStyle.wrapExtendsImplementsKeyword();
            this.wrapExtendsImplementsList = codeStyle.wrapExtendsImplementsList();
            this.wrapMethodParams = codeStyle.wrapMethodParams();
            this.wrapMethodCallArgs = codeStyle.wrapMethodCallArgs();
            this.wrapChainedMethodCalls = codeStyle.wrapChainedMethodCalls();
            this.wrapArrayInit = codeStyle.wrapArrayInit();
            this.wrapFor = codeStyle.wrapFor();
            this.wrapForStatement = codeStyle.wrapForStatement();
            this.wrapIfStatement = codeStyle.wrapIfStatement();
            this.wrapWhileStatement = codeStyle.wrapWhileStatement();
            this.wrapDoWhileStatement = codeStyle.wrapDoWhileStatement();
            this.wrapBinaryOps = codeStyle.wrapBinaryOps();
            this.wrapTernaryOps = codeStyle.wrapTernaryOps();
            this.wrapAssignOps = codeStyle.wrapAssignOps();
            this.wrapBlockBrace = codeStyle.wrapBlockBrace();
            this.wrapStatementsOnTheSameLine = codeStyle.wrapStatementsOnTheSameLine();
            this.alignMultilineMethodParams = codeStyle.alignMultilineMethodParams();
            this.alignMultilineCallArgs = codeStyle.alignMultilineCallArgs();
            this.alignMultilineImplements = codeStyle.alignMultilineImplements();
            this.alignMultilineParenthesized = codeStyle.alignMultilineParenthesized();
            this.alignMultilineBinaryOp = codeStyle.alignMultilineBinaryOp();
            this.alignMultilineTernaryOp = codeStyle.alignMultilineTernaryOp();
            this.alignMultilineAssignment = codeStyle.alignMultilineAssignment();
            this.alignMultilineFor = codeStyle.alignMultilineFor();
            this.alignMultilineArrayInit = codeStyle.alignMultilineArrayInit();
        }
    }
}

