/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.editor.api.AbstractElementQuery;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.AliasedClass;
import org.netbeans.modules.php.editor.api.elements.AliasedConstant;
import org.netbeans.modules.php.editor.api.elements.AliasedElement;
import org.netbeans.modules.php.editor.api.elements.AliasedFunction;
import org.netbeans.modules.php.editor.api.elements.AliasedInterface;
import org.netbeans.modules.php.editor.api.elements.AliasedNamespace;
import org.netbeans.modules.php.editor.api.elements.AliasedType;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TreeElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.api.elements.VariableElement;
import org.netbeans.modules.php.editor.elements.ClassElementImpl;
import org.netbeans.modules.php.editor.elements.ConstantElementImpl;
import org.netbeans.modules.php.editor.elements.FieldElementImpl;
import org.netbeans.modules.php.editor.elements.FunctionElementImpl;
import org.netbeans.modules.php.editor.elements.InterfaceElementImpl;
import org.netbeans.modules.php.editor.elements.MethodElementImpl;
import org.netbeans.modules.php.editor.elements.NamespaceElementImpl;
import org.netbeans.modules.php.editor.elements.TypeConstantElementImpl;
import org.netbeans.modules.php.editor.elements.TypeTreeElementImpl;
import org.netbeans.modules.php.editor.elements.VariableElementImpl;
import org.netbeans.modules.php.editor.index.PHPIndexer;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.UseElement;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public final class IndexQueryImpl
implements ElementQuery.Index {
    public static final String FIELD_TOP_LEVEL = "top";
    private static final Logger LOG = Logger.getLogger(IndexQueryImpl.class.getName());
    private static Collection<NamespaceElement> namespacesCache = null;
    private final QuerySupport index;
    private final Set<AliasedName> aliases = new HashSet<AliasedName>();
    private AbstractElementQuery extendedQuery = new AbstractElementQuery(ElementQuery.QueryScope.VIRTUAL_SCOPE);

    private IndexQueryImpl(QuerySupport index, Model model) {
        this.index = index;
        if (model != null) {
            this.init(model);
        }
    }

    private void init(Model model) {
        this.initExtendedQuery(model);
        this.initAliases(model);
    }

    private void initAliases(Model model) {
        for (NamespaceScope namespaceScope : model.getFileScope().getDeclaredNamespaces()) {
            if (namespaceScope == null) continue;
            Collection<? extends UseElement> declaredUses = namespaceScope.getDeclaredUses();
            for (UseElement useElement : declaredUses) {
                AliasedName aliasedName = useElement.getAliasedName();
                if (aliasedName == null) continue;
                this.aliases.add(aliasedName);
            }
        }
    }

    private void initExtendedQuery(Model model) {
        List<PhpBaseElement> extendedElements = model.getExtendedElements();
        for (PhpBaseElement phpBaseElement : extendedElements) {
            if (!(phpBaseElement instanceof PhpVariable)) continue;
            PhpVariable variable = (PhpVariable)phpBaseElement;
            this.extendedQuery.addElement(VariableElementImpl.fromFrameworks(variable, this.extendedQuery));
            PhpClass type = variable.getType();
            if (type == null) continue;
            ClassElement classElement = ClassElementImpl.fromFrameworks(type, this.extendedQuery);
            this.extendedQuery.addElement(classElement);
            for (PhpClass.Field field : type.getFields()) {
                FieldElement fieldElement = FieldElementImpl.fromFrameworks(classElement, field, this.extendedQuery);
                this.extendedQuery.addElement(fieldElement);
            }
        }
    }

    private IndexQueryImpl(QuerySupport index) {
        this(index, null);
    }

    public static ElementQuery.Index create(QuerySupport querySupport) {
        return new IndexQueryImpl(querySupport);
    }

    public static ElementQuery.Index create(QuerySupport querySupport, Model model) {
        return new IndexQueryImpl(querySupport, model);
    }

    public static ElementQuery.Index getModelInstance(PHPParseResult parseResult) {
        return parseResult.getModel().getIndexScope().getIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearNamespaceCache() {
        Class<IndexQueryImpl> clazz = IndexQueryImpl.class;
        synchronized (IndexQueryImpl.class) {
            namespacesCache = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private Set<ClassElement> getClassesImpl(NameKind query) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<ClassElement> classes = new HashSet<ClassElement>();
        Collection<? extends IndexResult> result = this.results("clz", query);
        for (IndexResult indexResult : result) {
            Set<ClassElement> allClasses = ClassElementImpl.fromSignature(query, this, indexResult);
            if (query.isPrefix()) {
                classes.addAll(allClasses);
                continue;
            }
            for (ClassElement classElement : allClasses) {
                if (!query.getQuery().getNamespaceName().equals(classElement.getNamespaceName().toString())) continue;
                classes.add(classElement);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<ClassElement> getClasses", query, start);
        }
        return Collections.unmodifiableSet(classes);
    }

    private Set<InterfaceElement> getInterfacesImpl(NameKind query) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<InterfaceElement> ifaces = new HashSet<InterfaceElement>();
        Collection<? extends IndexResult> result = this.results("iface", query);
        for (IndexResult indexResult : result) {
            ifaces.addAll(InterfaceElementImpl.fromSignature(query, this, indexResult));
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<InterfaceElement> getInterfaces", query, start);
        }
        return Collections.unmodifiableSet(ifaces);
    }

    private static Set<NameKind> queriesForAlias(NameKind query, AliasedName aliasedName, PhpElementKind elementKind) {
        HashSet<NameKind> aliasQueries = new HashSet<NameKind>();
        boolean fullyQualified = query.getQuery().getKind().isFullyQualified();
        QuerySupport.Kind queryKind = query.getQueryKind();
        LinkedList<String> segments = query.getQuery().getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            String nextSegment = segments.get(i);
            if (i != 0 && i != segments.size() - 1 || nextSegment.isEmpty() && segments.size() != 1 || !NameKind.create(nextSegment, queryKind).matchesName(elementKind, aliasedName.getAliasName())) continue;
            LinkedList<String> nSegments = new LinkedList<String>();
            nSegments.addAll(segments.subList(0, i));
            nSegments.addAll(aliasedName.getRealName().getSegments());
            if (i + 1 < segments.size()) {
                nSegments.addAll(segments.subList(i + 1, segments.size()));
            }
            aliasQueries.add(NameKind.create(QualifiedName.create(fullyQualified, nSegments), queryKind));
        }
        return aliasQueries;
    }

    private Set<TypeElement> getTypesImpl(NameKind query) {
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        types.addAll(this.getClassesImpl(query));
        types.addAll(this.getInterfacesImpl(query));
        return types;
    }

    @Override
    public final Set<MethodElement> getAccessibleMagicMethods(TypeElement type) {
        return MethodElementImpl.getMagicMethods(type);
    }

    private final Set<FunctionElement> getFunctionsImpl(NameKind query) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<FunctionElement> functions = new HashSet<FunctionElement>();
        Collection<? extends IndexResult> result = this.results("base", query);
        for (IndexResult indexResult : result) {
            functions.addAll(FunctionElementImpl.fromSignature(query, this, indexResult));
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<FunctionElement> getFunctions", query, start);
        }
        return Collections.unmodifiableSet(functions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<NamespaceElement> getNamespacesImpl(NameKind query) {
        HashSet<NamespaceElement> retval = new HashSet<NamespaceElement>();
        Class<IndexQueryImpl> clazz = IndexQueryImpl.class;
        synchronized (IndexQueryImpl.class) {
            if (namespacesCache == null) {
                LinkedHashMap<String, NamespaceElementImpl> namespacesMap = new LinkedHashMap<String, NamespaceElementImpl>();
                for (NamespaceElement namespace : this.namespacesImpl(NameKind.empty())) {
                    NamespaceElement original = null;
                    QualifiedName qn = namespace.getFullyQualifiedName();
                    while (original == null && !qn.isDefaultNamespace()) {
                        original = namespacesMap.put(qn.toFullyQualified().toString().toLowerCase(), new NamespaceElementImpl(qn, namespace.getOffset(), namespace.getFilenameUrl(), namespace.getElementQuery()));
                        qn = qn.toNamespaceName();
                    }
                }
                namespacesCache = namespacesMap.values();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (NamespaceElement indexedNamespace : namespacesCache) {
                if (!query.matchesName(indexedNamespace)) continue;
                retval.add(indexedNamespace);
            }
            return retval;
        }
    }

    private Set<NamespaceElement> namespacesImpl(NameKind query) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<NamespaceElement> namespaces = new HashSet<NamespaceElement>();
        Collection<? extends IndexResult> result = this.results("ns", query);
        for (IndexResult indexResult : result) {
            namespaces.addAll(NamespaceElementImpl.fromSignature(query, this, indexResult));
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<NamespaceElement> getNamespaces", query, start);
        }
        return Collections.unmodifiableSet(namespaces);
    }

    private Set<ConstantElement> getConstantsImpl(NameKind query) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<ConstantElement> constants = new HashSet<ConstantElement>();
        Collection<? extends IndexResult> result = this.results("const", query);
        for (IndexResult indexResult : result) {
            constants.addAll(ConstantElementImpl.fromSignature(query, this, indexResult));
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<ConstantElement> getConstants", query, start);
        }
        return Collections.unmodifiableSet(constants);
    }

    private Set<PhpElement> getTopLevelElementsImpl(NameKind query) {
        String[] stringArray;
        boolean isVariable = query.getQueryName().startsWith("$");
        if (isVariable) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "var";
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "base";
            stringArray3[1] = "const";
            stringArray3[2] = "clz";
            stringArray3[3] = "iface";
            stringArray = stringArray3;
            stringArray3[4] = "ns";
        }
        String[] fieldsToLoad = stringArray;
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<PhpElement> elements = new HashSet<PhpElement>();
        Collection<? extends IndexResult> result = this.results(FIELD_TOP_LEVEL, query, fieldsToLoad);
        for (IndexResult indexResult : result) {
            if (isVariable) {
                elements.addAll(VariableElementImpl.fromSignature(query, this, indexResult));
                continue;
            }
            elements.addAll(ClassElementImpl.fromSignature(query, this, indexResult));
            elements.addAll(InterfaceElementImpl.fromSignature(query, this, indexResult));
            elements.addAll(FunctionElementImpl.fromSignature(query, this, indexResult));
            elements.addAll(ConstantElementImpl.fromSignature(query, this, indexResult));
        }
        if (isVariable) {
            elements.addAll(this.extendedQuery.getTopLevelVariables(query));
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<PhpElement> getTopLevelElements", query, start);
        }
        return Collections.unmodifiableSet(elements);
    }

    @Override
    public final Set<VariableElement> getTopLevelVariables(NameKind query) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<VariableElement> vars = new HashSet<VariableElement>();
        Collection<? extends IndexResult> result = this.results("var", query);
        for (IndexResult indexResult : result) {
            vars.addAll(VariableElementImpl.fromSignature(query, this, indexResult));
        }
        vars.addAll(this.extendedQuery.getTopLevelVariables(query));
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<VariableElement> getTopLevelVariables", query, start);
        }
        return Collections.unmodifiableSet(vars);
    }

    @Override
    public Set<MethodElement> getConstructors(ClassElement classElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        Set<MethodElement> retval = this.getConstructorsImpl(classElement, classElement, new LinkedHashSet<ClassElement>());
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<MethodElement> getConstructors", NameKind.exact(classElement.getFullyQualifiedName()), start);
        }
        return retval.isEmpty() ? this.getDefaultConstructors(classElement) : retval;
    }

    private Set<MethodElement> getConstructorsImpl(NameKind typeQuery) {
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        Set<ClassElement> classes = this.getClassesImpl(typeQuery);
        for (ClassElement classElement : classes) {
            retval.addAll(this.getConstructors(classElement));
        }
        return retval;
    }

    private final Set<MethodElement> getConstructorsImpl(ClassElement originalClass, ClassElement inheritedClass, LinkedHashSet<ClassElement> check) {
        HashSet methods = new HashSet();
        if (!check.contains(inheritedClass)) {
            check.add(inheritedClass);
            NameKind.Exact typeQuery = NameKind.exact(inheritedClass.getFullyQualifiedName());
            Collection<? extends IndexResult> constructorResults = this.results("clz", typeQuery, new String[]{"clz", "constructor", "method"});
            HashSet<MethodElement> methodsForResult = new HashSet<MethodElement>();
            ElementFilter forEqualTypes = ElementFilter.forEqualTypes(inheritedClass);
            for (IndexResult indexResult : constructorResults) {
                Set<ClassElement> classes = ClassElementImpl.fromSignature(this, indexResult);
                for (ClassElement classElement : classes) {
                    if (!forEqualTypes.isAccepted(classElement)) continue;
                    methodsForResult.addAll(MethodElementImpl.fromSignature(originalClass, this, indexResult));
                }
            }
            methods.addAll(ElementFilter.forName(NameKind.exact("__construct")).filter(methodsForResult));
            if (methods.isEmpty()) {
                for (TypeElement typeElement : this.getDirectInheritedTypes(inheritedClass, true, false)) {
                    if (!(typeElement instanceof ClassElement)) continue;
                    methods.addAll(this.getConstructorsImpl(originalClass, (ClassElement)typeElement, check));
                    if (methods.isEmpty()) continue;
                    break;
                }
            }
        }
        return Collections.unmodifiableSet(methods);
    }

    private Set<MethodElement> getDefaultConstructors(ClassElement classElement) {
        Set<MethodElement> magicMethods = this.getAccessibleMagicMethods(classElement);
        for (MethodElement methodElement : magicMethods) {
            if (!methodElement.isConstructor()) continue;
            return Collections.singleton(methodElement);
        }
        throw new IllegalStateException();
    }

    @Override
    public final Set<MethodElement> getMethods(NameKind methodQuery) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<MethodElement> methods = new HashSet<MethodElement>();
        Collection<? extends IndexResult> methResults = this.results("method", methodQuery, new String[]{"clz", "iface", "method"});
        for (IndexResult indexResult : methResults) {
            HashSet<TypeElement> types = new HashSet<TypeElement>();
            types.addAll(ClassElementImpl.fromSignature(this, indexResult));
            types.addAll(InterfaceElementImpl.fromSignature(this, indexResult));
            for (TypeElement typeElement : types) {
                methods.addAll(MethodElementImpl.fromSignature(typeElement, methodQuery, this, indexResult));
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<MethodElement> getMethods", methodQuery, start);
        }
        return Collections.unmodifiableSet(methods);
    }

    @Override
    public Set<TypeMemberElement> getDeclaredTypeMembers(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        QualifiedName fullyQualifiedName = typeElement.getFullyQualifiedName();
        HashSet<TypeMemberElement> members = new HashSet<TypeMemberElement>();
        NameKind.Exact typeQuery = NameKind.exact(fullyQualifiedName);
        NameKind.Empty memberQuery = NameKind.empty();
        FileObject typeFo = typeElement.getFileObject();
        switch (typeElement.getPhpElementKind()) {
            case CLASS: {
                Collection<? extends IndexResult> clzResults = this.results("clz", typeQuery, new String[]{"clz", "field", "clz.const", "method"});
                for (IndexResult indexResult : clzResults) {
                    for (ClassElement clzElement : ClassElementImpl.fromSignature(typeQuery, this, indexResult)) {
                        if (!fullyQualifiedName.getNamespaceName().equals(clzElement.getNamespaceName().toString())) continue;
                        members.addAll(MethodElementImpl.fromSignature(clzElement, memberQuery, this, indexResult));
                        members.addAll(FieldElementImpl.fromSignature(clzElement, memberQuery, this, indexResult));
                        members.addAll(TypeConstantElementImpl.fromSignature(clzElement, memberQuery, this, indexResult));
                    }
                }
                break;
            }
            case IFACE: {
                Collection<? extends IndexResult> ifaceResults = this.results("iface", typeQuery, new String[]{"iface", "clz.const", "method"});
                for (IndexResult indexResult : ifaceResults) {
                    for (InterfaceElement ifaceElement : InterfaceElementImpl.fromSignature(typeQuery, this, indexResult)) {
                        members.addAll(MethodElementImpl.fromSignature(ifaceElement, memberQuery, this, indexResult));
                        members.addAll(TypeConstantElementImpl.fromSignature(ifaceElement, memberQuery, this, indexResult));
                    }
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<PhpElement> getTypeMembers", typeQuery, memberQuery, start);
        }
        HashSet<TypeMemberElement> retval = new HashSet<TypeMemberElement>();
        NameKind.Exact exactTypeName = NameKind.exact(typeElement.getFullyQualifiedName());
        retval.addAll(this.extendedQuery.getFields(exactTypeName, NameKind.empty()));
        retval.addAll(this.extendedQuery.getMethods(exactTypeName, NameKind.empty()));
        retval.addAll(this.extendedQuery.getTypeConstants(exactTypeName, NameKind.empty()));
        retval.addAll(ElementFilter.forFiles(typeFo).filter(members));
        return retval;
    }

    @Override
    public Set<MethodElement> getDeclaredConstructors(ClassElement typeElement) {
        return ElementFilter.forName(NameKind.exact("__construct")).filter(this.getDeclaredMethods(typeElement));
    }

    @Override
    public final Set<MethodElement> getDeclaredMethods(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        QualifiedName fullyQualifiedName = typeElement.getFullyQualifiedName();
        HashSet<MethodElement> methods = new HashSet<MethodElement>();
        NameKind.Exact typeQuery = NameKind.exact(fullyQualifiedName);
        NameKind.Empty methodQuery = NameKind.empty();
        FileObject typeFo = typeElement.getFileObject();
        switch (typeElement.getPhpElementKind()) {
            case CLASS: {
                Collection<? extends IndexResult> clzResults = this.results("clz", typeQuery, new String[]{"clz", "method"});
                for (IndexResult indexResult : clzResults) {
                    for (ClassElement clzElement : ClassElementImpl.fromSignature(typeQuery, this, indexResult)) {
                        methods.addAll(MethodElementImpl.fromSignature(clzElement, methodQuery, this, indexResult));
                    }
                }
                break;
            }
            case IFACE: {
                Collection<? extends IndexResult> ifaceResults = this.results("iface", typeQuery, new String[]{"iface", "method"});
                for (IndexResult indexResult : ifaceResults) {
                    for (InterfaceElement ifaceElement : InterfaceElementImpl.fromSignature(typeQuery, this, indexResult)) {
                        methods.addAll(MethodElementImpl.fromSignature(ifaceElement, methodQuery, this, indexResult));
                    }
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<MethodElement> getMethods", typeQuery, methodQuery, start);
        }
        return ElementFilter.forFiles(typeFo).filter(methods);
    }

    @Override
    public final Set<TypeMemberElement> getTypeMembers(NameKind.Exact typeQuery, NameKind memberQuery) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<TypeMemberElement> members = new HashSet<TypeMemberElement>();
        Collection<? extends IndexResult> clzResults = this.results("clz", typeQuery, new String[]{"clz", "method", "field", "clz.const"});
        for (IndexResult indexResult : clzResults) {
            for (ClassElement typeElement : ClassElementImpl.fromSignature(typeQuery, this, indexResult)) {
                members.addAll(MethodElementImpl.fromSignature(typeElement, memberQuery, this, indexResult));
                members.addAll(FieldElementImpl.fromSignature(typeElement, memberQuery, this, indexResult));
                members.addAll(TypeConstantElementImpl.fromSignature(typeElement, memberQuery, this, indexResult));
            }
        }
        Collection<? extends IndexResult> ifaceResults = this.results("iface", typeQuery, new String[]{"iface", "method", "clz.const"});
        for (IndexResult indexResult : ifaceResults) {
            for (InterfaceElement typeElement : InterfaceElementImpl.fromSignature(typeQuery, this, indexResult)) {
                members.addAll(MethodElementImpl.fromSignature(typeElement, memberQuery, this, indexResult));
                members.addAll(TypeConstantElementImpl.fromSignature(typeElement, memberQuery, this, indexResult));
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<PhpElement> getTypeMembers", typeQuery, memberQuery, start);
        }
        return Collections.unmodifiableSet(members);
    }

    @Override
    public final Set<MethodElement> getMethods(NameKind.Exact typeQuery, NameKind methodQuery) {
        return this.getMethodsImpl(typeQuery, methodQuery, EnumSet.of(PhpElementKind.CLASS, PhpElementKind.IFACE));
    }

    private final Set<MethodElement> getMethodsImpl(NameKind.Exact typeQuery, NameKind methodQuery, EnumSet<PhpElementKind> typeKinds) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<MethodElement> methods = new HashSet<MethodElement>();
        if (typeKinds.contains((Object)PhpElementKind.CLASS)) {
            Collection<? extends IndexResult> clzResults = this.results("clz", typeQuery, new String[]{"clz", "method"});
            for (IndexResult indexResult : clzResults) {
                for (ClassElement classElement : ClassElementImpl.fromSignature(typeQuery, this, indexResult)) {
                    methods.addAll(MethodElementImpl.fromSignature(classElement, methodQuery, this, indexResult));
                }
            }
        }
        if (typeKinds.contains((Object)PhpElementKind.IFACE)) {
            Collection<? extends IndexResult> ifaceResults = this.results("iface", typeQuery, new String[]{"iface", "method"});
            for (IndexResult indexResult : ifaceResults) {
                for (InterfaceElement interfaceElement : InterfaceElementImpl.fromSignature(typeQuery, this, indexResult)) {
                    methods.addAll(MethodElementImpl.fromSignature(interfaceElement, methodQuery, this, indexResult));
                }
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<MethodElement> getMethods", typeQuery, methodQuery, start);
        }
        return Collections.unmodifiableSet(methods);
    }

    @Override
    public Set<FileObject> getLocationsForIdentifiers(String identifierName) {
        HashSet<FileObject> result = new HashSet<FileObject>();
        Collection<? extends IndexResult> idIndexResult = this.search("identifier_used", identifierName.toLowerCase(), QuerySupport.Kind.PREFIX, "base", "identifier_used");
        for (IndexResult indexResult : idIndexResult) {
            String[] values;
            for (String val : values = indexResult.getValues("identifier_used")) {
                Signature sig = Signature.get(val);
                if (!identifierName.equalsIgnoreCase(sig.string(0))) continue;
                URL url = indexResult.getUrl();
                FileObject fo = null;
                try {
                    fo = "file".equals(url.getProtocol()) ? FileUtil.toFileObject((File)new File(url.toURI())) : URLMapper.findFileObject((URL)url);
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (fo == null) continue;
                result.add(fo);
            }
        }
        return result;
    }

    @Override
    public Set<FieldElement> getDeclaredFields(TypeElement classElement) {
        HashSet<FieldElement> retval = new HashSet<FieldElement>();
        NameKind.Exact typeNameQuery = NameKind.exact(classElement.getFullyQualifiedName());
        retval.addAll(ElementFilter.forFiles(classElement.getFileObject()).filter(this.getFields(typeNameQuery, NameKind.empty())));
        retval.addAll(this.extendedQuery.getFields(typeNameQuery, NameKind.empty()));
        return retval;
    }

    @Override
    public final Set<FieldElement> getFields(NameKind fieldQuery) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<FieldElement> fields = new HashSet<FieldElement>();
        Collection<? extends IndexResult> fieldResults = this.results("field", fieldQuery, new String[]{"clz", "field"});
        for (IndexResult indexResult : fieldResults) {
            for (ClassElement typeElement : ClassElementImpl.fromSignature(this, indexResult)) {
                fields.addAll(FieldElementImpl.fromSignature(typeElement, fieldQuery, this, indexResult));
            }
        }
        fields.addAll(this.extendedQuery.getFields(fieldQuery));
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<FieldElement> getFields", fieldQuery, start);
        }
        return Collections.unmodifiableSet(fields);
    }

    @Override
    public final Set<FieldElement> getFields(NameKind.Exact classQuery, NameKind fieldQuery) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<FieldElement> fields = new HashSet<FieldElement>();
        Collection<? extends IndexResult> clzResults = this.results("clz", classQuery, new String[]{"clz", "field"});
        for (IndexResult indexResult : clzResults) {
            for (ClassElement typeElement : ClassElementImpl.fromSignature(classQuery, this, indexResult)) {
                fields.addAll(FieldElementImpl.fromSignature(typeElement, fieldQuery, this, indexResult));
            }
        }
        fields.addAll(this.extendedQuery.getFields(classQuery, fieldQuery));
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<FieldElement> getFields", classQuery, fieldQuery, start);
        }
        return Collections.unmodifiableSet(fields);
    }

    @Override
    public Set<TypeConstantElement> getDeclaredTypeConstants(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        QualifiedName fullyQualifiedName = typeElement.getFullyQualifiedName();
        FileObject typeFo = typeElement.getFileObject();
        HashSet<TypeConstantElement> constants = new HashSet<TypeConstantElement>();
        NameKind.Exact typeQuery = NameKind.exact(fullyQualifiedName);
        NameKind.Empty constantQuery = NameKind.empty();
        switch (typeElement.getPhpElementKind()) {
            case CLASS: {
                Collection<? extends IndexResult> clzResults = this.results("clz", typeQuery, new String[]{"clz", "clz.const"});
                for (IndexResult indexResult : clzResults) {
                    for (ClassElement classElement : ClassElementImpl.fromSignature(typeQuery, this, indexResult)) {
                        constants.addAll(TypeConstantElementImpl.fromSignature(classElement, constantQuery, this, indexResult));
                    }
                }
                break;
            }
            case IFACE: {
                Collection<? extends IndexResult> ifaceResults = this.results("iface", typeQuery, new String[]{"iface", "clz.const"});
                for (IndexResult indexResult : ifaceResults) {
                    for (InterfaceElement ifaceElement : InterfaceElementImpl.fromSignature(typeQuery, this, indexResult)) {
                        constants.addAll(TypeConstantElementImpl.fromSignature(ifaceElement, constantQuery, this, indexResult));
                    }
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<TypeConstantElement> getTypeConstants", typeQuery, constantQuery, start);
        }
        return Collections.unmodifiableSet(ElementFilter.forFiles(typeFo).filter(constants));
    }

    @Override
    public Set<TypeConstantElement> getTypeConstants(NameKind constantQuery) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<TypeConstantElement> constants = new HashSet<TypeConstantElement>();
        Collection<? extends IndexResult> constantResults = this.results("clz.const", constantQuery, new String[]{"clz", "iface", "clz.const"});
        for (IndexResult indexResult : constantResults) {
            HashSet<TypeElement> types = new HashSet<TypeElement>();
            types.addAll(ClassElementImpl.fromSignature(this, indexResult));
            types.addAll(InterfaceElementImpl.fromSignature(this, indexResult));
            for (TypeElement typeElement : types) {
                constants.addAll(TypeConstantElementImpl.fromSignature(typeElement, constantQuery, this, indexResult));
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<TypeConstantElement> getTypeConstants", constantQuery, start);
        }
        return Collections.unmodifiableSet(constants);
    }

    @Override
    public Set<TypeConstantElement> getTypeConstants(NameKind.Exact typeQuery, NameKind constantQuery) {
        return this.getTypeConstantsImpl(typeQuery, constantQuery, EnumSet.of(PhpElementKind.CLASS, PhpElementKind.IFACE));
    }

    private Set<TypeConstantElement> getTypeConstantsImpl(NameKind.Exact typeQuery, NameKind constantQuery, EnumSet<PhpElementKind> typeKinds) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<TypeConstantElement> constants = new HashSet<TypeConstantElement>();
        if (typeKinds.contains((Object)PhpElementKind.CLASS)) {
            Collection<? extends IndexResult> clzResults = this.results("clz", typeQuery, new String[]{"clz", "clz.const"});
            for (IndexResult indexResult : clzResults) {
                for (ClassElement classElement : ClassElementImpl.fromSignature(typeQuery, this, indexResult)) {
                    constants.addAll(TypeConstantElementImpl.fromSignature(classElement, constantQuery, this, indexResult));
                }
            }
        }
        if (typeKinds.contains((Object)PhpElementKind.IFACE)) {
            Collection<? extends IndexResult> ifaceResults = this.results("iface", typeQuery, new String[]{"iface", "clz.const"});
            for (IndexResult indexResult : ifaceResults) {
                for (InterfaceElement interfaceElement : InterfaceElementImpl.fromSignature(typeQuery, this, indexResult)) {
                    constants.addAll(TypeConstantElementImpl.fromSignature(interfaceElement, constantQuery, this, indexResult));
                }
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<TypeConstantElement> getTypeConstants", typeQuery, constantQuery, start);
        }
        return Collections.unmodifiableSet(constants);
    }

    @Override
    public ElementQuery.QueryScope getQueryScope() {
        return ElementQuery.QueryScope.INDEX_SCOPE;
    }

    @Override
    public Set<MethodElement> getStaticInheritedMethods(TypeElement typeElement) {
        return ElementFilter.forStaticModifiers(true).filter(this.getInheritedMethods(typeElement));
    }

    private static ElementFilter forAccessibleTypeMembers(final TypeElement enclosingType, final Collection<TypeElement> inheritedTypes) {
        final ElementFilter publicOnly = ElementFilter.forPublicModifiers(true);
        final ElementFilter publicAndProtectedOnly = ElementFilter.forPrivateModifiers(false);
        final ElementFilter fromEnclosingType = ElementFilter.forMembersOfType(enclosingType);
        return new ElementFilter(){
            private ElementFilter[] subtypesFilters = null;

            @Override
            public boolean isAccepted(PhpElement element) {
                if (element instanceof TypeMemberElement && !element.getPhpElementKind().equals((Object)PhpElementKind.TYPE_CONSTANT)) {
                    if (enclosingType != null) {
                        return this.isFromEnclosingType(element) ? true : (this.isFromSubclassOfEnclosingType(element) ? publicAndProtectedOnly.isAccepted(element) : publicOnly.isAccepted(element));
                    }
                    return publicOnly.isAccepted(element);
                }
                return true;
            }

            private boolean isFromEnclosingType(PhpElement element) {
                return fromEnclosingType.isAccepted(element);
            }

            private boolean isFromSubclassOfEnclosingType(PhpElement element) {
                for (TypeElement nextType : inheritedTypes) {
                    if (!ElementFilter.forMembersOfType(nextType).isAccepted(element)) continue;
                    return true;
                }
                if (this.subtypesFilters == null) {
                    this.subtypesFilters = this.createSubtypeFilters();
                }
                return this.subtypesFilters.length == 0 ? false : ElementFilter.anyOf(this.subtypesFilters).isAccepted(element);
            }

            private ElementFilter[] createSubtypeFilters() {
                ArrayList<ElementFilter> filters = new ArrayList<ElementFilter>();
                ElementQuery elementQuery = enclosingType.getElementQuery();
                if (elementQuery.getQueryScope().isIndexScope()) {
                    ElementQuery.Index index = (ElementQuery.Index)elementQuery;
                    LinkedHashSet<TypeElement> inheritedTypes2 = index.getInheritedTypes(enclosingType);
                    for (TypeElement nextType : inheritedTypes2) {
                        filters.add(ElementFilter.forMembersOfType(nextType));
                    }
                }
                return filters.toArray(new ElementFilter[filters.size()]);
            }
        };
    }

    @Override
    public Set<MethodElement> getAccessibleMethods(TypeElement typeElement, TypeElement calledFromEnclosingType) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        Set<MethodElement> allMethods = this.getAllMethods(typeElement);
        Set<TypeElement> subTypes = Collections.emptySet();
        if (calledFromEnclosingType != null && ElementFilter.forEqualTypes(typeElement).isAccepted(calledFromEnclosingType)) {
            subTypes = IndexQueryImpl.toTypes(allMethods);
        }
        ElementFilter filterForAccessible = IndexQueryImpl.forAccessibleTypeMembers(calledFromEnclosingType, subTypes);
        Set<MethodElement> retval = filterForAccessible.filter(allMethods);
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<MethodElement> getAccessibleMethods", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public Set<FieldElement> getAccessibleFields(TypeElement typeElement, TypeElement calledFromEnclosingType) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        Set<FieldElement> allFields = this.getAlllFields(typeElement);
        Set<TypeElement> subTypes = Collections.emptySet();
        if (calledFromEnclosingType != null && ElementFilter.forEqualTypes(typeElement).isAccepted(calledFromEnclosingType)) {
            subTypes = IndexQueryImpl.toTypes(allFields);
        }
        ElementFilter filterForAccessible = IndexQueryImpl.forAccessibleTypeMembers(calledFromEnclosingType, subTypes);
        Set<FieldElement> retval = filterForAccessible.filter(allFields);
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<FieldElement> getAccessibleFields", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return Collections.unmodifiableSet(retval);
    }

    private LinkedHashSet<TypeMemberElement> getDirectInheritedTypeMembers(TypeElement typeElement, EnumSet<PhpElementKind> typeKinds, EnumSet<PhpElementKind> memberKinds) {
        QualifiedName superClassName;
        LinkedHashSet<TypeMemberElement> directTypes = new LinkedHashSet<TypeMemberElement>();
        if (typeKinds.contains((Object)PhpElementKind.CLASS) && typeElement instanceof ClassElement && (superClassName = ((ClassElement)typeElement).getSuperClassName()) != null) {
            directTypes.addAll(this.extendedQuery.getFields(NameKind.exact(superClassName), NameKind.empty()));
            directTypes.addAll(this.extendedQuery.getMethods(NameKind.exact(superClassName), NameKind.empty()));
            directTypes.addAll(this.extendedQuery.getTypeConstants(NameKind.exact(superClassName), NameKind.empty()));
            if (memberKinds.size() != 1) {
                directTypes.addAll(ElementFilter.forFiles(typeElement.getFileObject()).prefer(this.getTypeMembers(NameKind.exact(superClassName), NameKind.empty())));
            } else {
                switch ((PhpElementKind)((Object)memberKinds.iterator().next())) {
                    case METHOD: {
                        directTypes.addAll(ElementFilter.forFiles(typeElement.getFileObject()).prefer(this.getMethodsImpl(NameKind.exact(superClassName), NameKind.empty(), EnumSet.of(PhpElementKind.CLASS))));
                        break;
                    }
                    case FIELD: {
                        directTypes.addAll(ElementFilter.forFiles(typeElement.getFileObject()).prefer(this.getFields(NameKind.exact(superClassName), NameKind.empty())));
                        break;
                    }
                    case TYPE_CONSTANT: {
                        directTypes.addAll(ElementFilter.forFiles(typeElement.getFileObject()).prefer(this.getTypeConstantsImpl(NameKind.exact(superClassName), NameKind.empty(), EnumSet.of(PhpElementKind.CLASS))));
                    }
                }
            }
        }
        if (typeKinds.contains((Object)PhpElementKind.IFACE)) {
            for (QualifiedName iface : typeElement.getSuperInterfaces()) {
                directTypes.addAll(this.extendedQuery.getFields(NameKind.exact(iface), NameKind.empty()));
                directTypes.addAll(this.extendedQuery.getMethods(NameKind.exact(iface), NameKind.empty()));
                directTypes.addAll(this.extendedQuery.getTypeConstants(NameKind.exact(iface), NameKind.empty()));
                if (memberKinds.size() != 1) {
                    directTypes.addAll(ElementFilter.forFiles(typeElement.getFileObject()).prefer(this.getTypeMembers(NameKind.exact(iface), NameKind.empty())));
                    continue;
                }
                switch ((PhpElementKind)((Object)memberKinds.iterator().next())) {
                    case METHOD: {
                        directTypes.addAll(ElementFilter.forFiles(typeElement.getFileObject()).prefer(this.getMethodsImpl(NameKind.exact(iface), NameKind.empty(), EnumSet.of(PhpElementKind.IFACE))));
                        break;
                    }
                    case TYPE_CONSTANT: {
                        directTypes.addAll(ElementFilter.forFiles(typeElement.getFileObject()).prefer(this.getTypeConstantsImpl(NameKind.exact(iface), NameKind.empty(), EnumSet.of(PhpElementKind.IFACE))));
                    }
                }
            }
        }
        return directTypes;
    }

    @Override
    public Set<MethodElement> getInheritedMethods(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        LinkedHashSet<TypeMemberElement> typeMembers = this.getInheritedTypeMembers(typeElement, new LinkedHashSet<TypeElement>(), new LinkedHashSet<TypeMemberElement>(), EnumSet.of(PhpElementKind.CLASS, PhpElementKind.IFACE), EnumSet.of(PhpElementKind.METHOD));
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        for (TypeMemberElement member : typeMembers) {
            if (!(member instanceof MethodElement)) continue;
            retval.add((MethodElement)member);
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<MethodElement> getInheritedMethods", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public Set<MethodElement> getAllMethods(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        LinkedHashSet<TypeMemberElement> typeMembers = this.getInheritedTypeMembers(typeElement, new LinkedHashSet<TypeElement>(), new LinkedHashSet<TypeMemberElement>(this.getDeclaredMethods(typeElement)), EnumSet.of(PhpElementKind.CLASS, PhpElementKind.IFACE), EnumSet.of(PhpElementKind.METHOD));
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        for (TypeMemberElement member : typeMembers) {
            if (!(member instanceof MethodElement)) continue;
            retval.add((MethodElement)member);
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<MethodElement> getAllMethods", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public Set<FieldElement> getAlllFields(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        LinkedHashSet<TypeMemberElement> typeMembers = this.getInheritedTypeMembers(typeElement, new LinkedHashSet<TypeElement>(), new LinkedHashSet<TypeMemberElement>(this.getDeclaredFields(typeElement)), EnumSet.of(PhpElementKind.CLASS), EnumSet.of(PhpElementKind.FIELD));
        HashSet<FieldElement> retval = new HashSet<FieldElement>();
        for (TypeMemberElement member : typeMembers) {
            if (!(member instanceof FieldElement)) continue;
            retval.add((FieldElement)member);
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<FieldElement> getAlllFields", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public Set<TypeConstantElement> getAllTypeConstants(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        LinkedHashSet<TypeMemberElement> typeMembers = this.getInheritedTypeMembers(typeElement, new LinkedHashSet<TypeElement>(), new LinkedHashSet<TypeMemberElement>(this.getDeclaredTypeConstants(typeElement)), EnumSet.of(PhpElementKind.CLASS, PhpElementKind.IFACE), EnumSet.of(PhpElementKind.TYPE_CONSTANT));
        HashSet<TypeConstantElement> retval = new HashSet<TypeConstantElement>();
        for (TypeMemberElement member : typeMembers) {
            if (!(member instanceof TypeConstantElement)) continue;
            retval.add((TypeConstantElement)member);
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<TypeConstantElement> getAllTypeConstants", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public Set<TypeMemberElement> getAllTypeMembers(TypeElement typeElement) {
        EnumSet<PhpElementKind> typeKinds = EnumSet.of(PhpElementKind.CLASS, PhpElementKind.IFACE);
        EnumSet<PhpElementKind> memberKinds = EnumSet.of(PhpElementKind.METHOD, PhpElementKind.FIELD, PhpElementKind.TYPE_CONSTANT);
        return this.getInheritedTypeMembers(typeElement, new LinkedHashSet<TypeElement>(), new LinkedHashSet<TypeMemberElement>(this.getDeclaredTypeMembers(typeElement)), typeKinds, memberKinds);
    }

    @Override
    public Set<TypeMemberElement> getInheritedTypeMembers(TypeElement typeElement) {
        EnumSet<PhpElementKind> typeKinds = EnumSet.of(PhpElementKind.CLASS, PhpElementKind.IFACE);
        EnumSet<PhpElementKind> memberKinds = EnumSet.of(PhpElementKind.METHOD, PhpElementKind.FIELD, PhpElementKind.TYPE_CONSTANT);
        return this.getInheritedTypeMembers(typeElement, new LinkedHashSet<TypeElement>(), new LinkedHashSet<TypeMemberElement>(), typeKinds, memberKinds);
    }

    @Override
    public Set<TypeMemberElement> getAccessibleTypeMembers(TypeElement typeElement, TypeElement calledFromEnclosingType) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        Set<TypeMemberElement> allTypeMembers = this.getAllTypeMembers(typeElement);
        Set<TypeElement> subTypes = Collections.emptySet();
        if (calledFromEnclosingType != null && ElementFilter.forEqualTypes(typeElement).isAccepted(calledFromEnclosingType)) {
            subTypes = IndexQueryImpl.toTypes(allTypeMembers);
        }
        ElementFilter filterForAccessible = IndexQueryImpl.forAccessibleTypeMembers(calledFromEnclosingType, subTypes);
        HashSet<TypeMemberElement> retval = new HashSet<TypeMemberElement>();
        retval.addAll(filterForAccessible.filter(allTypeMembers));
        ElementFilter allOf = ElementFilter.allOf(ElementFilter.forVirtualExtensions(), ElementFilter.forMembersOfTypeName(typeElement));
        retval.addAll(allOf.filter(allTypeMembers));
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<PhpElement> getAccessibleTypeMembers", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return Collections.unmodifiableSet(retval);
    }

    private LinkedHashSet<TypeMemberElement> getInheritedTypeMembers(TypeElement typeElement, LinkedHashSet<TypeElement> recursionPrevention, LinkedHashSet<TypeMemberElement> retval, EnumSet<PhpElementKind> typeKinds, EnumSet<PhpElementKind> memberKinds) {
        if (recursionPrevention.add(typeElement)) {
            LinkedHashSet<TypeMemberElement> typeMembers = this.getDirectInheritedTypeMembers(typeElement, typeKinds, memberKinds);
            retval.addAll(IndexQueryImpl.forComparingNameKinds(retval).reverseFilter(typeMembers));
            for (TypeElement tp : typeMembers.isEmpty() ? this.getDirectInheritedTypes(typeElement) : IndexQueryImpl.toTypes(typeMembers)) {
                retval.addAll(this.getInheritedTypeMembers(tp, recursionPrevention, retval, typeKinds, memberKinds));
            }
        }
        return retval;
    }

    @Override
    public Set<MethodElement> getAllMethods(NameKind.Exact typeQuery, NameKind methodQuery) {
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        types.addAll(this.getClassesImpl(typeQuery));
        types.addAll(this.getInterfacesImpl(typeQuery));
        for (TypeElement typeElement : types) {
            retval.addAll(ElementFilter.forName(methodQuery).filter(this.getAllMethods(typeElement)));
        }
        return retval;
    }

    @Override
    public Set<FieldElement> getAlllFields(NameKind.Exact typeQuery, NameKind fieldQuery) {
        HashSet<FieldElement> retval = new HashSet<FieldElement>();
        Set<ClassElement> types = this.getClassesImpl(typeQuery);
        for (ClassElement typeElement : types) {
            retval.addAll(ElementFilter.forName(fieldQuery).filter(this.getAlllFields(typeElement)));
        }
        return retval;
    }

    @Override
    public Set<TypeConstantElement> getAllTypeConstants(NameKind.Exact typeQuery, NameKind constantQuery) {
        HashSet<TypeConstantElement> retval = new HashSet<TypeConstantElement>();
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        types.addAll(this.getClassesImpl(typeQuery));
        types.addAll(this.getInterfacesImpl(typeQuery));
        for (TypeElement typeElement : types) {
            retval.addAll(ElementFilter.forName(constantQuery).filter(this.getAllTypeConstants(typeElement)));
        }
        return retval;
    }

    @Override
    public Set<FieldElement> getAccessibleStaticFields(TypeElement classElement, TypeElement calledFromEnclosingType) {
        return ElementFilter.forStaticModifiers(true).filter(this.getAccessibleFields(classElement, calledFromEnclosingType));
    }

    @Override
    public Set<MethodElement> getAccessibleStaticMethods(TypeElement typeElement, TypeElement calledFromEnclosingType) {
        return ElementFilter.forStaticModifiers(true).filter(this.getAccessibleMethods(typeElement, calledFromEnclosingType));
    }

    private Set<TypeConstantElement> getNotPrivateTypeConstants(TypeElement oneType) {
        return ElementFilter.forPublicModifiers(true).filter(this.getDeclaredTypeConstants(oneType));
    }

    private Set<FieldElement> getNotPrivateFields(ClassElement oneClass) {
        return ElementFilter.forPrivateModifiers(false).filter(this.getDeclaredFields(oneClass));
    }

    @Override
    public Set<FieldElement> getStaticInheritedFields(TypeElement classElement) {
        return ElementFilter.forStaticModifiers(true).filter(this.getInheritedFields(classElement));
    }

    @Override
    public Set<FieldElement> getInheritedFields(TypeElement classElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<FieldElement> retval = new HashSet<FieldElement>();
        LinkedHashSet<ClassElement> inheritedClasses = this.getInheritedClasses(classElement);
        Set<String> declaredFieldNames = IndexQueryImpl.toNames(this.getDeclaredFields(classElement));
        for (ClassElement oneClass : inheritedClasses) {
            Set<FieldElement> fields = this.getNotPrivateFields(oneClass);
            for (FieldElement fieldElement : fields) {
                String fieldName = fieldElement.getName();
                if (declaredFieldNames.contains(fieldName)) continue;
                retval.add(fieldElement);
                declaredFieldNames.add(fieldName);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<FieldElement> getInheritedFields", NameKind.exact(classElement.getFullyQualifiedName()), start);
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public Set<TypeConstantElement> getInheritedTypeConstants(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        HashSet<TypeConstantElement> retval = new HashSet<TypeConstantElement>();
        LinkedHashSet<TypeElement> inheritedTypes = this.getInheritedTypes(typeElement);
        Set<String> declaredConstantNames = IndexQueryImpl.toNames(this.getDeclaredTypeConstants(typeElement));
        for (TypeElement oneType : inheritedTypes) {
            Set<TypeConstantElement> constants = this.getNotPrivateTypeConstants(oneType);
            for (TypeConstantElement constantElement : constants) {
                String constantName = constantElement.getName();
                if (declaredConstantNames.contains(constantName)) continue;
                retval.add(constantElement);
                declaredConstantNames.add(constantName);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("Set<TypeConstantElement> getInheritedTypeConstants", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public LinkedHashSet<TypeElement> getInheritedByTypes(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        LinkedHashSet<TypeElement> retval = new LinkedHashSet<TypeElement>();
        this.getInheritedByTypes(typeElement, retval);
        retval.remove(typeElement);
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("LinkedHashSet<TypeElement> getInheritedByTypes", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return retval;
    }

    @Override
    public LinkedHashSet<TypeElement> getInheritedTypes(TypeElement typeElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        LinkedHashSet<TypeElement> retval = new LinkedHashSet<TypeElement>();
        this.getInheritedTypes(typeElement, retval, true, true);
        retval.remove(typeElement);
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("LinkedHashSet<TypeElement> getInheritedTypes", NameKind.exact(typeElement.getFullyQualifiedName()), start);
        }
        return retval;
    }

    @Override
    public LinkedHashSet<ClassElement> getInheritedClasses(TypeElement classElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        LinkedHashSet<ClassElement> retvalClasses = new LinkedHashSet<ClassElement>();
        LinkedHashSet<TypeElement> retvalTypes = new LinkedHashSet<TypeElement>();
        this.getInheritedTypes(classElement, retvalTypes, true, false);
        retvalTypes.remove(classElement);
        for (TypeElement te : retvalTypes) {
            if (te instanceof ClassElement) {
                retvalClasses.add((ClassElement)te);
                continue;
            }
            assert (false) : te.toString();
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("LinkedHashSet<ClassElement> getInheritedClasses", NameKind.exact(classElement.getFullyQualifiedName()), start);
        }
        return retvalClasses;
    }

    @Override
    public LinkedHashSet<InterfaceElement> getInheritedInterfaces(TypeElement ifaceElement) {
        long start = LOG.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        LinkedHashSet<InterfaceElement> retvalIfaces = new LinkedHashSet<InterfaceElement>();
        LinkedHashSet<TypeElement> retvalTypes = new LinkedHashSet<TypeElement>();
        this.getInheritedTypes(ifaceElement, retvalTypes, false, true);
        retvalTypes.remove(ifaceElement);
        for (TypeElement te : retvalTypes) {
            if (te instanceof InterfaceElement) {
                retvalIfaces.add((InterfaceElement)te);
                continue;
            }
            assert (false) : te.toString();
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.logQueryTime("LinkedHashSet<InterfaceElement> getInheritedInterfaces", NameKind.exact(ifaceElement.getFullyQualifiedName()), start);
        }
        return retvalIfaces;
    }

    private static ElementFilter forComparingNameKinds(final Collection<? extends PhpElement> elements) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                ElementFilter forKind = ElementFilter.forKind(element.getPhpElementKind());
                ElementFilter forName = ElementFilter.forName(NameKind.exact(element.getName()));
                for (PhpElement nextElement : elements) {
                    if (!forKind.isAccepted(nextElement) || !forName.isAccepted(nextElement)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static LinkedHashSet<TypeElement> toTypes(Collection<? extends TypeMemberElement> typeMembers) {
        LinkedHashSet<TypeElement> retval = new LinkedHashSet<TypeElement>();
        for (TypeMemberElement typeMemberElement : typeMembers) {
            retval.add(typeMemberElement.getType());
        }
        return retval;
    }

    private void getInheritedTypes(TypeElement typeElement, LinkedHashSet<TypeElement> retval, boolean includeClasses, boolean includeIfaces) {
        if (retval.add(typeElement)) {
            LinkedHashSet<TypeElement> directTypes = this.getDirectInheritedTypes(typeElement, includeClasses, includeIfaces);
            for (TypeElement tp : directTypes) {
                this.getInheritedTypes(tp, retval, includeClasses, includeIfaces);
            }
        }
    }

    @Override
    public LinkedHashSet<ClassElement> getDirectInheritedClasses(TypeElement typeElement) {
        LinkedHashSet<ClassElement> retval = new LinkedHashSet<ClassElement>();
        LinkedHashSet<TypeElement> types = this.getDirectInheritedTypes(typeElement, true, false);
        for (TypeElement nextType : types) {
            if (!(nextType instanceof ClassElement)) continue;
            retval.add((ClassElement)nextType);
        }
        return retval;
    }

    @Override
    public LinkedHashSet<InterfaceElement> getDirectInheritedInterfaces(TypeElement typeElement) {
        LinkedHashSet<InterfaceElement> retval = new LinkedHashSet<InterfaceElement>();
        LinkedHashSet<TypeElement> types = this.getDirectInheritedTypes(typeElement, false, true);
        for (TypeElement nextType : types) {
            if (!(nextType instanceof InterfaceElement)) continue;
            retval.add((InterfaceElement)nextType);
        }
        return retval;
    }

    @Override
    public final LinkedHashSet<TypeElement> getDirectInheritedTypes(TypeElement typeElement) {
        return this.getDirectInheritedTypes(typeElement, true, true);
    }

    private LinkedHashSet<TypeElement> getDirectInheritedTypes(TypeElement typeElement, boolean includeClasses, boolean includeIfaces) {
        QualifiedName superClassName;
        LinkedHashSet<TypeElement> directTypes = new LinkedHashSet<TypeElement>();
        if (includeClasses && typeElement instanceof ClassElement && (superClassName = ((ClassElement)typeElement).getSuperClassName()) != null) {
            directTypes.addAll(ElementFilter.forFiles(typeElement.getFileObject()).prefer(this.getClassesImpl(NameKind.exact(superClassName))));
        }
        if (includeIfaces) {
            for (QualifiedName iface : typeElement.getSuperInterfaces()) {
                directTypes.addAll(ElementFilter.forFiles(typeElement.getFileObject()).prefer(this.getInterfacesImpl(NameKind.exact(iface))));
            }
        }
        return directTypes;
    }

    private void getInheritedByTypes(TypeElement typeElement, LinkedHashSet<TypeElement> retval) {
        if (retval.add(typeElement)) {
            LinkedHashSet<TypeElement> directTypes = this.getDirectInheritedByTypes(typeElement);
            for (TypeElement tp : directTypes) {
                this.getInheritedByTypes(tp, retval);
            }
        }
    }

    @Override
    public LinkedHashSet<TypeElement> getDirectInheritedByTypes(TypeElement typeElement) {
        LinkedHashSet<TypeElement> directTypes;
        block5: {
            NameKind.Exact query;
            block4: {
                directTypes = new LinkedHashSet<TypeElement>();
                query = NameKind.exact(typeElement.getFullyQualifiedName());
                if (!typeElement.isClass()) break block4;
                Collection<? extends IndexResult> result = this.results("superclz", query, new String[]{"superclz", "clz"});
                for (IndexResult indexResult : result) {
                    String[] values;
                    for (String value : values = indexResult.getValues("superclz")) {
                        Signature signature = Signature.get(value);
                        QualifiedName fqnForValue = QualifiedName.createFullyQualified(signature.string(1), signature.string(2));
                        if (!query.matchesName(PhpElementKind.CLASS, fqnForValue)) continue;
                        directTypes.addAll(ClassElementImpl.fromSignature(NameKind.empty(), this, indexResult));
                    }
                }
                break block5;
            }
            if (!typeElement.isInterface()) break block5;
            Collection<? extends IndexResult> result = this.results("superiface", query, new String[]{"superiface", "iface", "clz"});
            for (IndexResult indexResult : result) {
                String[] values;
                for (String value : values = indexResult.getValues("superiface")) {
                    Signature signature = Signature.get(value);
                    QualifiedName fqnForValue = QualifiedName.createFullyQualified(signature.string(1), signature.string(2));
                    if (!query.matchesName(PhpElementKind.IFACE, fqnForValue)) continue;
                    directTypes.addAll(InterfaceElementImpl.fromSignature(NameKind.empty(), this, indexResult));
                    directTypes.addAll(ClassElementImpl.fromSignature(NameKind.empty(), this, indexResult));
                }
            }
        }
        return directTypes;
    }

    private static Set<String> toNames(Set<? extends PhpElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (PhpElement phpElement : elements) {
            names.add(phpElement.getName());
        }
        return names;
    }

    private Collection<? extends IndexResult> search(String key, String name, QuerySupport.Kind kind, String ... terms) {
        try {
            long start = LOG.isLoggable(Level.FINER) ? System.currentTimeMillis() : 0L;
            Collection results = this.index.query(key, name, kind, terms);
            if (LOG.isLoggable(Level.FINER)) {
                String msg = "IndexQuery.search(" + key + ", " + name + ", " + kind + ", " + (terms == null || terms.length == 0 ? "no terms" : Arrays.asList(terms)) + ")";
                LOG.finer(msg);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, null, new Throwable(msg));
                }
                for (IndexResult r : results) {
                    LOG.finer("Fields in " + r + " (" + r.getFile().getPath() + "):");
                    for (String field : PHPIndexer.ALL_FIELDS) {
                        String value = r.getValue(field);
                        if (value == null) continue;
                        LOG.finest(" <" + field + "> = <" + value + ">");
                    }
                    LOG.finer("----");
                }
                LOG.finer(String.format("took: %d [ms]", System.currentTimeMillis() - start));
                LOG.finer("====");
            }
            return results;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return Collections.emptySet();
        }
    }

    private Collection<? extends IndexResult> results(String indexField, NameKind query) {
        return this.results(indexField, query, new String[]{indexField});
    }

    private Collection<? extends IndexResult> results(String indexField, NameKind query, String[] fieldsToLoad) {
        return this.search(indexField, IndexQueryImpl.prepareIdxQuery(query.getQueryName(), query.getQueryKind()), QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, fieldsToLoad);
    }

    private void logQueryTime(String queryDescription, NameKind typeQuery, NameKind memberQuery, long start) {
        LOG.fine(String.format("%s for type query: [%s:%s] and took: member query: [%s:%s] %d [ms]", queryDescription, typeQuery.getQueryKind().toString(), typeQuery.getQuery().toString(), memberQuery.getQueryKind().toString(), memberQuery.getQuery().toString(), System.currentTimeMillis() - start));
    }

    private void logQueryTime(String queryDescription, NameKind query, long start) {
        LOG.fine(String.format("%s for query: [%s:%s] took: %d [ms]", queryDescription, query.getQueryKind().toString(), query.getQuery().toString(), System.currentTimeMillis() - start));
    }

    private static String prepareIdxQuery(String textForQuery, QuerySupport.Kind kind) {
        String query = textForQuery.toLowerCase();
        if (kind.equals((Object)QuerySupport.Kind.CAMEL_CASE)) {
            int length = textForQuery.length();
            query = length > 0 && Character.isLetter(textForQuery.charAt(0)) ? query.substring(0, 1) : (length > 1 && textForQuery.charAt(0) == '$' ? query.substring(0, 1) : "");
        }
        return query;
    }

    @Override
    public TreeElement<TypeElement> getInheritedTypesAsTree(TypeElement typeElement) {
        return new TypeTreeElementImpl(typeElement, true);
    }

    @Override
    public TreeElement<TypeElement> getInheritedTypesAsTree(TypeElement typeElement, Set<TypeElement> preferredTypes) {
        return new TypeTreeElementImpl(typeElement, preferredTypes, true);
    }

    @Override
    public TreeElement<TypeElement> getInheritedByTypesAsTree(TypeElement typeElement) {
        return new TypeTreeElementImpl(typeElement, false);
    }

    @Override
    public TreeElement<TypeElement> getInheritedByTypesAsTree(TypeElement typeElement, Set<TypeElement> preferredTypes) {
        return new TypeTreeElementImpl(typeElement, preferredTypes, false);
    }

    @Override
    public Set<PhpElement> getTopLevelElements(NameKind query) {
        return this.getTopLevelElements(query, this.aliases, null);
    }

    @Override
    public Set<ClassElement> getClasses() {
        return this.getClasses(NameKind.empty(), this.aliases, null);
    }

    @Override
    public Set<ClassElement> getClasses(NameKind query) {
        return this.getClasses(query, this.aliases, null);
    }

    @Override
    public Set<InterfaceElement> getInterfaces() {
        return this.getInterfaces(NameKind.empty(), this.aliases, null);
    }

    @Override
    public Set<InterfaceElement> getInterfaces(NameKind query) {
        return this.getInterfaces(query, this.aliases, null);
    }

    @Override
    public Set<TypeElement> getTypes(NameKind query) {
        return this.getTypes(query, this.aliases, null);
    }

    @Override
    public Set<FunctionElement> getFunctions() {
        return this.getFunctions(NameKind.empty(), this.aliases, null);
    }

    @Override
    public Set<FunctionElement> getFunctions(NameKind query) {
        return this.getFunctions(query, this.aliases, null);
    }

    @Override
    public Set<ConstantElement> getConstants() {
        return this.getConstants(NameKind.empty(), this.aliases, null);
    }

    @Override
    public Set<ConstantElement> getConstants(NameKind query) {
        return this.getConstants(query, this.aliases, null);
    }

    @Override
    public Set<MethodElement> getConstructors(NameKind typeQuery) {
        return this.getConstructors(typeQuery, this.aliases, null);
    }

    @Override
    public Set<NamespaceElement> getNamespaces(NameKind query) {
        return this.getNamespaces(query, this.aliases, null);
    }

    @Override
    public Set<ClassElement> getClasses(NameKind query, Set<AliasedName> aliasedNames, AliasedElement.Trait trait) {
        HashSet<ClassElement> retval = new HashSet<ClassElement>();
        for (AliasedName aliasedName : aliasedNames) {
            for (NameKind nextQuery : IndexQueryImpl.queriesForAlias(query, aliasedName, PhpElementKind.CLASS)) {
                for (ClassElement nextClass : this.getClassesImpl(nextQuery)) {
                    AliasedClass aliasedClass = new AliasedClass(aliasedName, nextClass);
                    if (trait != null) {
                        aliasedClass.setTrait(trait);
                    }
                    retval.add(aliasedClass);
                }
            }
        }
        retval.addAll(this.getClassesImpl(query));
        return retval;
    }

    @Override
    public Set<NamespaceElement> getNamespaces(NameKind query, Set<AliasedName> aliasedNames, AliasedElement.Trait trait) {
        HashSet<NamespaceElement> retval = new HashSet<NamespaceElement>();
        for (AliasedName aliasedName : aliasedNames) {
            Set<NameKind> queriesForAlias = IndexQueryImpl.queriesForAlias(query, aliasedName, PhpElementKind.NAMESPACE_DECLARATION);
            for (NameKind nextQuery : queriesForAlias) {
                for (NamespaceElement nextNamespace : this.getNamespacesImpl(nextQuery)) {
                    AliasedNamespace aliasedNamespace = new AliasedNamespace(aliasedName, nextNamespace);
                    if (trait != null) {
                        aliasedNamespace.setTrait(trait);
                    }
                    retval.add(aliasedNamespace);
                }
            }
        }
        retval.addAll(this.getNamespacesImpl(query));
        return retval;
    }

    @Override
    public Set<FunctionElement> getFunctions(NameKind query, Set<AliasedName> aliasedNames, AliasedElement.Trait trait) {
        HashSet<FunctionElement> retval = new HashSet<FunctionElement>();
        for (AliasedName aliasedName : aliasedNames) {
            for (NameKind nextQuery : IndexQueryImpl.queriesForAlias(query, aliasedName, PhpElementKind.FUNCTION)) {
                for (FunctionElement nextFunction : this.getFunctionsImpl(nextQuery)) {
                    AliasedFunction aliasedFunction = new AliasedFunction(aliasedName, nextFunction);
                    if (trait != null) {
                        aliasedFunction.setTrait(trait);
                    }
                    retval.add(aliasedFunction);
                }
            }
        }
        retval.addAll(this.getFunctionsImpl(query));
        return retval;
    }

    @Override
    public Set<ConstantElement> getConstants(NameKind query, Set<AliasedName> aliasedNames, AliasedElement.Trait trait) {
        HashSet<ConstantElement> retval = new HashSet<ConstantElement>();
        for (AliasedName aliasedName : aliasedNames) {
            for (NameKind nextQuery : IndexQueryImpl.queriesForAlias(query, aliasedName, PhpElementKind.CONSTANT)) {
                for (ConstantElement nextConstant : this.getConstantsImpl(nextQuery)) {
                    AliasedConstant aliasedConstant = new AliasedConstant(aliasedName, nextConstant);
                    if (trait != null) {
                        aliasedConstant.setTrait(trait);
                    }
                    retval.add(aliasedConstant);
                }
            }
        }
        retval.addAll(this.getConstantsImpl(query));
        return retval;
    }

    @Override
    public Set<MethodElement> getConstructors(NameKind typeQuery, Set<AliasedName> aliasedNames, AliasedElement.Trait trait) {
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        for (AliasedName aliasedName : aliasedNames) {
            for (NameKind nextQuery : IndexQueryImpl.queriesForAlias(typeQuery, aliasedName, PhpElementKind.CLASS)) {
                for (ClassElement classElement : this.getClassesImpl(nextQuery)) {
                    Set<MethodElement> constructorsImpl;
                    AliasedClass aliasedClass = new AliasedClass(aliasedName, classElement);
                    if (trait != null) {
                        aliasedClass.setTrait(trait);
                    }
                    retval.addAll((constructorsImpl = this.getConstructorsImpl(aliasedClass, classElement, new LinkedHashSet<ClassElement>())).isEmpty() ? this.getDefaultConstructors(aliasedClass) : constructorsImpl);
                }
            }
        }
        retval.addAll(this.getConstructorsImpl(typeQuery));
        return retval;
    }

    @Override
    public Set<PhpElement> getTopLevelElements(NameKind query, Set<AliasedName> aliasedNames, AliasedElement.Trait trait) {
        HashSet<PhpElement> retval = new HashSet<PhpElement>();
        for (AliasedName aliasedName : aliasedNames) {
            for (NameKind nextQuery : IndexQueryImpl.queriesForAlias(query, aliasedName, PhpElementKind.CLASS)) {
                for (PhpElement nextElement : this.getTopLevelElementsImpl(nextQuery)) {
                    AliasedElement aliasedElement = null;
                    if (nextElement instanceof ConstantElement) {
                        aliasedElement = new AliasedConstant(aliasedName, (ConstantElement)nextElement);
                    } else if (nextElement instanceof FunctionElement) {
                        aliasedElement = new AliasedFunction(aliasedName, (FunctionElement)nextElement);
                    } else if (nextElement instanceof ClassElement) {
                        aliasedElement = new AliasedClass(aliasedName, (ClassElement)nextElement);
                    } else if (nextElement instanceof InterfaceElement) {
                        aliasedElement = new AliasedInterface(aliasedName, (InterfaceElement)nextElement);
                    }
                    if (aliasedElement == null) continue;
                    if (trait != null) {
                        aliasedElement.setTrait(trait);
                    }
                    retval.add(aliasedElement);
                }
            }
        }
        retval.addAll(this.getTopLevelElementsImpl(query));
        return retval;
    }

    @Override
    public Set<InterfaceElement> getInterfaces(NameKind query, Set<AliasedName> aliasedNames, AliasedElement.Trait trait) {
        HashSet<InterfaceElement> retval = new HashSet<InterfaceElement>();
        for (AliasedName aliasedName : aliasedNames) {
            for (NameKind nextQuery : IndexQueryImpl.queriesForAlias(query, aliasedName, PhpElementKind.IFACE)) {
                for (InterfaceElement nextIface : this.getInterfacesImpl(nextQuery)) {
                    AliasedInterface aliasedInterface = new AliasedInterface(aliasedName, nextIface);
                    if (trait != null) {
                        aliasedInterface.setTrait(trait);
                    }
                    retval.add(aliasedInterface);
                }
            }
        }
        retval.addAll(this.getInterfacesImpl(query));
        return retval;
    }

    @Override
    public Set<TypeElement> getTypes(NameKind query, Set<AliasedName> aliasedNames, AliasedElement.Trait trait) {
        HashSet<TypeElement> retval = new HashSet<TypeElement>();
        for (AliasedName aliasedName : aliasedNames) {
            for (NameKind nextQuery : IndexQueryImpl.queriesForAlias(query, aliasedName, PhpElementKind.CLASS)) {
                for (TypeElement nextType : this.getTypesImpl(nextQuery)) {
                    AliasedType aliasedType = null;
                    if (nextType instanceof ClassElement) {
                        aliasedType = new AliasedClass(aliasedName, (ClassElement)nextType);
                    } else if (nextType instanceof InterfaceElement) {
                        aliasedType = new AliasedInterface(aliasedName, (InterfaceElement)nextType);
                    } else assert (false) : nextType.getClass();
                    if (aliasedType == null) continue;
                    if (trait != null) {
                        aliasedType.setTrait(trait);
                    }
                    retval.add(aliasedType);
                }
            }
        }
        retval.addAll(this.getTypesImpl(query));
        return retval;
    }
}

