/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.CompletionContextFinder;
import org.netbeans.modules.php.editor.DocRenderer;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.PHPCompletionResult;
import org.netbeans.modules.php.editor.PHPDOCCodeCompletion;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.api.elements.AliasedElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.api.elements.VariableElement;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.elements.VariableElementImpl;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.ParameterInfoSupport;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.options.CodeCompletionPanel;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;

public class PHPCodeCompletion
implements CodeCompletionHandler {
    private static final Logger LOGGER = Logger.getLogger(PHPCodeCompletion.class.getName());
    static final Map<String, CompletionContextFinder.KeywordCompletionType> PHP_KEYWORDS = new HashMap<String, CompletionContextFinder.KeywordCompletionType>();
    private static final String[] PHP_LANGUAGE_CONSTRUCTS_WITH_QUOTES;
    private static final String[] PHP_LANGUAGE_CONSTRUCTS_WITH_PARENTHESES;
    private static final String[] PHP_LANGUAGE_CONSTRUCTS_WITH_SEMICOLON;
    static final String PHP_CLASS_KEYWORD_THIS = "$this->";
    static final String[] PHP_CLASS_KEYWORDS;
    static final String[] PHP_STATIC_CLASS_KEYWORDS;
    private static final Collection<Character> AUTOPOPUP_STOP_CHARS;
    private static final Collection<PHPTokenId> TOKENS_TRIGGERING_AUTOPUP_TYPES_WS;
    private static final List<String> INVALID_PROPOSALS_FOR_CLS_MEMBERS;
    private static final List<String> CLASS_CONTEXT_KEYWORD_PROPOSAL;
    private static final List<String> INHERITANCE_KEYWORDS;
    private static final String EXCEPTION_CLASS_NAME = "\\Exception";
    private boolean caseSensitive;
    private QuerySupport.Kind nameKind;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeCompletionResult complete(CodeCompletionContext completionContext) {
        String pref;
        PHPCompletionItem.CompletionRequest request;
        CompletionContextFinder.CompletionContext context;
        FileObject fileObject;
        PHPParseResult result;
        int caretOffset;
        ParserResult info;
        PHPCompletionResult completionResult;
        String prefix;
        long startTime;
        block44: {
            block43: {
                block42: {
                    block41: {
                        startTime = 0L;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            startTime = System.currentTimeMillis();
                        }
                        prefix = completionContext.getPrefix();
                        BaseDocument doc = (BaseDocument)completionContext.getParserResult().getSnapshot().getSource().getDocument(false);
                        if (doc == null) {
                            return CodeCompletionResult.NONE;
                        }
                        completionResult = new PHPCompletionResult(completionContext);
                        info = completionContext.getParserResult();
                        caretOffset = completionContext.getCaretOffset();
                        this.caseSensitive = completionContext.isCaseSensitive();
                        this.nameKind = this.caseSensitive ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX;
                        result = (PHPParseResult)info;
                        if (result.getProgram() != null) break block41;
                        CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                        return codeCompletionResult;
                    }
                    fileObject = result.getSnapshot().getSource().getFileObject();
                    if (fileObject != null) break block42;
                    CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                    return codeCompletionResult;
                }
                context = CompletionContextFinder.findCompletionContext(info, caretOffset);
                LOGGER.log(Level.FINE, String.format("CC context: %s", context.toString()));
                if (context != CompletionContextFinder.CompletionContext.NONE) break block43;
                CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                return codeCompletionResult;
            }
            request = new PHPCompletionItem.CompletionRequest();
            request.context = context;
            pref = this.getPrefix(info, caretOffset, true);
            if (pref != null) break block44;
            CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
            return codeCompletionResult;
        }
        request.anchor = caretOffset - pref.length();
        request.result = result;
        request.info = info;
        request.prefix = prefix;
        request.index = ElementQueryFactory.getIndexQuery(info);
        try {
            request.currentlyEditedFileURL = fileObject.getURL().toString();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        switch (context) {
            case DEFAULT_PARAMETER_VALUE: {
                NameKind.Prefix nameKindPrefix = NameKind.prefix(prefix);
                this.autoCompleteKeywords(completionResult, request, Arrays.asList("array"));
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteTypeNames(completionResult, request, null, true);
                ElementFilter forName = ElementFilter.forName(nameKindPrefix);
                Model model = request.result.getModel();
                Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
                Set<ConstantElement> constants = request.index.getConstants(nameKindPrefix, aliasedNames, AliasedElement.Trait.ALIAS);
                for (ConstantElement constant : forName.filter(constants)) {
                    completionResult.add(new PHPCompletionItem.ConstantItem(constant, request));
                }
                ClassDeclaration enclosingClass = PHPCodeCompletion.findEnclosingClass(request.info, CompletionContextFinder.lexerToASTOffset(request.result, request.anchor));
                if (enclosingClass == null) break;
                String clsName = enclosingClass.getName().getName();
                for (String classKeyword : PHP_STATIC_CLASS_KEYWORDS) {
                    if (!classKeyword.toLowerCase().startsWith(prefix)) continue;
                    completionResult.add(new PHPCompletionItem.ClassScopeKeywordItem(clsName, classKeyword, request));
                }
                break;
            }
            case NAMESPACE_KEYWORD: {
                Set<NamespaceElement> namespaces = request.index.getNamespaces(NameKind.prefix(QualifiedName.create(request.prefix).toNotFullyQualified()));
                for (NamespaceElement namespace : namespaces) {
                    completionResult.add(new PHPCompletionItem.NamespaceItem(namespace, request, QualifiedNameKind.QUALIFIED));
                }
                break;
            }
            case GLOBAL: {
                this.autoCompleteGlobals(completionResult, request);
                break;
            }
            case EXPRESSION: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteExpression(completionResult, request);
                break;
            }
            case HTML: 
            case OPEN_TAG: {
                completionResult.add(new PHPCompletionItem.TagItem("<?php", 1, request));
                completionResult.add(new PHPCompletionItem.TagItem("<?=", 2, request));
                break;
            }
            case NEW_CLASS: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteNewClass(completionResult, request);
                break;
            }
            case CLASS_NAME: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteClassNames(completionResult, request, false);
                break;
            }
            case INTERFACE_NAME: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteInterfaceNames(completionResult, request);
                break;
            }
            case USE_KEYWORD: {
                this.autoCompleteAfterUses(completionResult, request, QualifiedNameKind.QUALIFIED, false);
                break;
            }
            case TYPE_NAME: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteTypeNames(completionResult, request);
                break;
            }
            case STRING: {
                String className;
                completionResult.addAll(this.getVariableProposals(request, null));
                if (prefix.length() != 0 && !this.startsWith(PHP_CLASS_KEYWORD_THIS, prefix)) break;
                ClassDeclaration classDecl = PHPCodeCompletion.findEnclosingClass(info, caretOffset);
                if (classDecl != null && (className = CodeUtils.extractClassName(classDecl)) != null) {
                    completionResult.add(new PHPCompletionItem.ClassScopeKeywordItem(className, PHP_CLASS_KEYWORD_THIS, request));
                }
                break;
            }
            case CLASS_MEMBER: {
                this.autoCompleteClassMembers(completionResult, request, false);
                break;
            }
            case STATIC_CLASS_MEMBER: {
                this.autoCompleteClassMembers(completionResult, request, true);
                break;
            }
            case PHPDOC: {
                if (PHPDOCCodeCompletion.isTypeCtx(request)) {
                    this.autoCompleteTypeNames(completionResult, request);
                    break;
                }
                PHPDOCCodeCompletion.complete(completionResult, request);
                break;
            }
            case CLASS_CONTEXT_KEYWORDS: {
                this.autoCompleteInClassContext(info, caretOffset, completionResult, request);
                break;
            }
            case METHOD_NAME: {
                this.autoCompleteMethodName(info, caretOffset, completionResult, request);
                break;
            }
            case IMPLEMENTS: {
                this.autoCompleteKeywords(completionResult, request, Collections.singletonList("implements"));
                break;
            }
            case EXTENDS: {
                this.autoCompleteKeywords(completionResult, request, Collections.singletonList("extends"));
                break;
            }
            case INHERITANCE: {
                this.autoCompleteKeywords(completionResult, request, INHERITANCE_KEYWORDS);
                break;
            }
            case THROW_CATCH: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteExceptions(completionResult, request);
                break;
            }
            case CLASS_MEMBER_IN_STRING: {
                this.autoCompleteClassFields(completionResult, request);
                break;
            }
            case SERVER_ENTRY_CONSTANTS: {
                for (String keyword : PredefinedSymbols.SERVER_ENTRY_CONSTANTS) {
                    if (!keyword.startsWith(request.prefix)) continue;
                    completionResult.add(new PHPCompletionItem.KeywordItem(keyword, request){

                        @Override
                        public ImageIcon getIcon() {
                            return null;
                        }
                    });
                }
                break;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            long time = System.currentTimeMillis() - startTime;
            LOGGER.fine(String.format("complete() took %d ms, result contains %d items", time, completionResult.getItems().size()));
        }
        return completionResult;
    }

    private List<ElementFilter> createTypeFilter(ClassDeclaration enclosingClass) {
        ArrayList<ElementFilter> superTypeIndices = new ArrayList<ElementFilter>();
        Expression superClass = enclosingClass.getSuperClass();
        if (superClass != null) {
            String superClsName = CodeUtils.extractUnqualifiedSuperClassName(enclosingClass);
            superTypeIndices.add(ElementFilter.forSuperClassName(QualifiedName.create(superClsName)));
        }
        List<Expression> interfaces = enclosingClass.getInterfaes();
        HashSet<QualifiedName> superIfaceNames = new HashSet<QualifiedName>();
        for (Expression identifier : interfaces) {
            String ifaceName = CodeUtils.extractUnqualifiedName(identifier);
            if (ifaceName == null) continue;
            superIfaceNames.add(QualifiedName.create(ifaceName));
        }
        if (!superIfaceNames.isEmpty()) {
            superTypeIndices.add(ElementFilter.forSuperInterfaceNames(superIfaceNames));
        }
        return superTypeIndices;
    }

    private void autoCompleteMethodName(ParserResult info, int caretOffset, PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        ClassDeclaration enclosingClass = PHPCodeCompletion.findEnclosingClass(info, CompletionContextFinder.lexerToASTOffset(info, caretOffset));
        if (enclosingClass != null) {
            List<ElementFilter> superTypeIndices = this.createTypeFilter(enclosingClass);
            String clsName = enclosingClass.getName().getName();
            if (clsName != null) {
                FileObject fileObject = request.result.getSnapshot().getSource().getFileObject();
                ElementFilter classFilter = ElementFilter.allOf(ElementFilter.forFiles(fileObject), ElementFilter.allOf(superTypeIndices));
                Set<ClassElement> classes = classFilter.filter(request.index.getClasses(NameKind.exact(clsName)));
                Iterator<ClassElement> i$ = classes.iterator();
                if (i$.hasNext()) {
                    ClassElement classElement = i$.next();
                    ElementFilter methodFilter = ElementFilter.allOf(ElementFilter.forExcludedNames(PHPCodeCompletion.toNames(request.index.getDeclaredMethods(classElement)), PhpElementKind.METHOD), ElementFilter.forName(NameKind.prefix(QualifiedName.create(request.prefix))));
                    Set<MethodElement> accessibleMethods = methodFilter.filter(request.index.getAccessibleMethods(classElement, classElement));
                    for (MethodElement method : accessibleMethods) {
                        if (method.isFinal()) continue;
                        completionResult.add(PHPCompletionItem.MethodDeclarationItem.forMethodName(method, request));
                    }
                    Set<MethodElement> magicMethods = methodFilter.filter(request.index.getAccessibleMagicMethods(classElement));
                    for (MethodElement magicMethod : magicMethods) {
                        if (magicMethod == null) continue;
                        completionResult.add(PHPCompletionItem.MethodDeclarationItem.forMethodName(magicMethod, request));
                    }
                }
            }
        }
    }

    private void autoCompleteNewClass(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        Model model;
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        QualifiedName prefix = QualifiedName.create(request.prefix).toNotFullyQualified();
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.PREFIX);
        Set<ClassElement> classes = request.index.getClasses(nameQuery, ModelUtils.getAliasedNames(model = request.result.getModel(), request.anchor), AliasedElement.Trait.ALIAS);
        if (!classes.isEmpty()) {
            completionResult.setFilterable(false);
        }
        boolean addedExact = false;
        if (classes.size() == 1) {
            ClassElement clazz = (ClassElement)classes.toArray()[0];
            if (!clazz.isAbstract()) {
                NameKind.Prefix query = isCamelCase ? NameKind.create(prefix.toString(), QuerySupport.Kind.CAMEL_CASE) : NameKind.prefix(prefix);
                this.autoCompleteConstructors(completionResult, request, model, query);
            }
        } else {
            NameKind.Exact query = NameKind.exact(prefix);
            for (ClassElement clazz : classes) {
                if (clazz.isAbstract()) continue;
                if (clazz.getName().equals(request.prefix)) {
                    if (addedExact) continue;
                    this.autoCompleteConstructors(completionResult, request, model, query);
                    addedExact = true;
                    continue;
                }
                completionResult.add(new PHPCompletionItem.ClassItem(clazz, request, false, null));
            }
        }
    }

    private void autoCompleteConstructors(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, Model model, NameKind query) {
        Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
        Set<MethodElement> constructors = request.index.getConstructors(query, aliasedNames, AliasedElement.Trait.ALIAS);
        for (MethodElement constructor : constructors) {
            for (PHPCompletionItem.NewClassItem newClassItem : PHPCompletionItem.NewClassItem.getNewClassItems(constructor, request)) {
                completionResult.add(newClassItem);
            }
        }
    }

    private void autoCompleteExceptions(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.PREFIX);
        Set<ClassElement> classes = request.index.getClasses(nameQuery);
        block0: for (ClassElement classElement : classes) {
            if (this.isExceptionClass(classElement)) {
                completionResult.add(new PHPCompletionItem.ClassItem(classElement, request, false, null));
                continue;
            }
            if (classElement.getSuperClassName() == null) continue;
            LinkedHashSet<ClassElement> inheritedClasses = request.index.getInheritedClasses(classElement);
            for (ClassElement inheritedClass : inheritedClasses) {
                if (!this.isExceptionClass(inheritedClass)) continue;
                completionResult.add(new PHPCompletionItem.ClassItem(classElement, request, false, null));
                continue block0;
            }
        }
    }

    private boolean isExceptionClass(ClassElement classElement) {
        return classElement.getFullyQualifiedName().toString().equals(EXCEPTION_CLASS_NAME);
    }

    private void autoCompleteClassNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean endWithDoubleColon) {
        this.autoCompleteClassNames(completionResult, request, endWithDoubleColon, null);
    }

    private void autoCompleteClassNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean endWithDoubleColon, QualifiedNameKind kind) {
        Model model;
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.PREFIX);
        Set<ClassElement> classes = request.index.getClasses(nameQuery, ModelUtils.getAliasedNames(model = request.result.getModel(), request.anchor), AliasedElement.Trait.ALIAS);
        if (!classes.isEmpty()) {
            completionResult.setFilterable(false);
        }
        for (ClassElement clazz : classes) {
            completionResult.add(new PHPCompletionItem.ClassItem(clazz, request, endWithDoubleColon, kind));
        }
    }

    private void autoCompleteInterfaceNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        this.autoCompleteInterfaceNames(completionResult, request, null);
    }

    private void autoCompleteInterfaceNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, QualifiedNameKind kind) {
        Model model;
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.PREFIX);
        Set<InterfaceElement> interfaces = request.index.getInterfaces(nameQuery, ModelUtils.getAliasedNames(model = request.result.getModel(), request.anchor), AliasedElement.Trait.ALIAS);
        if (!interfaces.isEmpty()) {
            completionResult.setFilterable(false);
        }
        for (InterfaceElement iface : interfaces) {
            completionResult.add(new PHPCompletionItem.InterfaceItem(iface, request, kind, false));
        }
    }

    private void autoCompleteTypeNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        this.autoCompleteTypeNames(completionResult, request, null, false);
    }

    private void autoCompleteAfterUses(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, QualifiedNameKind kind, boolean endWithDoubleColon) {
        Set<NamespaceElement> namespaces = request.index.getNamespaces(NameKind.prefix(QualifiedName.create(request.prefix).toNotFullyQualified()));
        for (NamespaceElement namespace : namespaces) {
            completionResult.add(new PHPCompletionItem.NamespaceItem(namespace, request, kind));
        }
        NameKind.Prefix nameQuery = NameKind.prefix(request.prefix);
        for (ClassElement classElement : request.index.getClasses(nameQuery)) {
            completionResult.add(new PHPCompletionItem.ClassItem(classElement, request, endWithDoubleColon, kind));
        }
        for (InterfaceElement interfaceElement : request.index.getInterfaces(nameQuery)) {
            completionResult.add(new PHPCompletionItem.InterfaceItem(interfaceElement, request, kind, false));
        }
        for (FunctionElement functionElement : request.index.getFunctions(nameQuery)) {
            for (PHPCompletionItem.FunctionElementItem functionItem : PHPCompletionItem.FunctionElementItem.getItems(functionElement, request)) {
                completionResult.add(functionItem);
            }
        }
        for (ConstantElement constantElement : request.index.getConstants(nameQuery)) {
            completionResult.add(new PHPCompletionItem.ConstantItem(constantElement, request));
        }
    }

    private void autoCompleteTypeNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, QualifiedNameKind kind, boolean endWithDoubleColon) {
        if (request.prefix.trim().length() > 0) {
            this.autoCompleteClassNames(completionResult, request, endWithDoubleColon, kind);
            this.autoCompleteInterfaceNames(completionResult, request, kind);
        } else {
            Model model = request.result.getModel();
            Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
            Set<PhpElement> allTopLevel = request.index.getTopLevelElements(NameKind.empty(), aliasedNames, AliasedElement.Trait.ALIAS);
            for (PhpElement element : allTopLevel) {
                if (element instanceof ClassElement) {
                    completionResult.add(new PHPCompletionItem.ClassItem((ClassElement)element, request, endWithDoubleColon, kind));
                    continue;
                }
                if (!(element instanceof InterfaceElement)) continue;
                completionResult.add(new PHPCompletionItem.InterfaceItem((InterfaceElement)element, request, kind, endWithDoubleColon));
            }
        }
    }

    private void autoCompleteKeywords(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, List<String> keywordList) {
        for (String keyword : keywordList) {
            if (!keyword.startsWith(request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.KeywordItem(keyword, request));
        }
    }

    private void autoCompleteNamespaces(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        this.autoCompleteNamespaces(completionResult, request, null);
    }

    private void autoCompleteNamespaces(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, QualifiedNameKind kind) {
        QualifiedName prefix = QualifiedName.create(request.prefix).toNotFullyQualified();
        Model model = request.result.getModel();
        Set<NamespaceElement> namespaces = request.index.getNamespaces(NameKind.prefix(prefix), ModelUtils.getAliasedNames(model, request.anchor), AliasedElement.Trait.ALIAS);
        for (NamespaceElement namespace : namespaces) {
            completionResult.add(new PHPCompletionItem.NamespaceItem(namespace, request, kind));
        }
    }

    private void autoCompleteInClassContext(ParserResult info, int caretOffset, PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        ClassDeclaration enclosingClass;
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        TokenSequence tokenSequence = th.tokenSequence(PHPTokenId.language());
        assert (tokenSequence != null);
        tokenSequence.move(caretOffset);
        boolean offerMagicAndInherited = true;
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            int tokenIdOffset = tokenSequence.token().offset(th);
            offerMagicAndInherited = !CompletionContextFinder.lineContainsAny((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, (TokenSequence<PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_PRIVATE, PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_PROTECTED, PHPTokenId.PHP_ABSTRACT, PHPTokenId.PHP_VAR, PHPTokenId.PHP_STATIC, PHPTokenId.PHP_CONST));
        }
        this.autoCompleteKeywords(completionResult, request, CLASS_CONTEXT_KEYWORD_PROPOSAL);
        if (offerMagicAndInherited && (enclosingClass = PHPCodeCompletion.findEnclosingClass(info, CompletionContextFinder.lexerToASTOffset(info, caretOffset))) != null) {
            FileObject fileObject;
            ElementFilter classFilter;
            Set<ClassElement> classes;
            Iterator<ClassElement> i$;
            List<ElementFilter> superTypeIndices = this.createTypeFilter(enclosingClass);
            String clsName = enclosingClass.getName().getName();
            if (clsName != null && (i$ = (classes = (classFilter = ElementFilter.allOf(ElementFilter.forFiles(fileObject = request.result.getSnapshot().getSource().getFileObject()), ElementFilter.allOf(superTypeIndices))).filter(request.index.getClasses(NameKind.exact(clsName)))).iterator()).hasNext()) {
                ClassElement classElement = i$.next();
                ElementFilter methodFilter = ElementFilter.allOf(ElementFilter.forExcludedNames(PHPCodeCompletion.toNames(request.index.getDeclaredMethods(classElement)), PhpElementKind.METHOD), ElementFilter.forName(NameKind.prefix(QualifiedName.create(request.prefix))));
                Set<MethodElement> accessibleMethods = methodFilter.filter(request.index.getAccessibleMethods(classElement, classElement));
                for (MethodElement method : accessibleMethods) {
                    if (method.isFinal()) continue;
                    completionResult.add(PHPCompletionItem.MethodDeclarationItem.getDeclarationItem(method, request));
                }
                Set<MethodElement> magicMethods = methodFilter.filter(request.index.getAccessibleMagicMethods(classElement));
                for (MethodElement magicMethod : magicMethods) {
                    if (magicMethod == null) continue;
                    completionResult.add(PHPCompletionItem.MethodDeclarationItem.getDeclarationItem(magicMethod, request));
                }
            }
        }
    }

    private static Set<String> toNames(Set<? extends PhpElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (PhpElement phpElement : elements) {
            names.add(phpElement.getName());
        }
        return names;
    }

    private void autoCompleteClassMembers(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean staticContext) {
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, request.anchor);
        if (tokenSequence == null) {
            return;
        }
        tokenSequence.move(request.anchor);
        if (tokenSequence.movePrevious()) {
            boolean instanceContext;
            boolean bl = instanceContext = !staticContext;
            if (tokenSequence.token().id() != PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM && tokenSequence.token().id() != PHPTokenId.PHP_OBJECT_OPERATOR) {
                tokenSequence.movePrevious();
            }
            tokenSequence.movePrevious();
            if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                tokenSequence.movePrevious();
            }
            String varName = ((Object)tokenSequence.token().text()).toString();
            tokenSequence.moveNext();
            List<String> invalidProposalsForClsMembers = INVALID_PROPOSALS_FOR_CLS_MEMBERS;
            Model model = request.result.getModel();
            Collection<Object> types = Collections.emptyList();
            if (staticContext && varName.startsWith("$")) {
                return;
            }
            types = ModelUtils.resolveTypeAfterReferenceToken(model, tokenSequence, request.anchor);
            boolean selfContext = false;
            boolean staticLateBindingContext = false;
            if (varName.equals("self")) {
                staticContext = true;
                selfContext = true;
            } else if (varName.equals("parent")) {
                invalidProposalsForClsMembers = Collections.emptyList();
                staticContext = true;
                instanceContext = true;
            } else if (varName.equals("$this")) {
                staticContext = false;
                instanceContext = true;
            } else if (varName.equals("static")) {
                staticContext = true;
                instanceContext = false;
                staticLateBindingContext = true;
            }
            if (types != null) {
                TypeElement enclosingType = this.getEnclosingType(request, types);
                for (TypeScope typeScope : types) {
                    StaticOrInstanceMembersFilter staticFlagFilter = new StaticOrInstanceMembersFilter(staticContext, instanceContext, selfContext, staticLateBindingContext);
                    ElementFilter methodsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.METHOD), ElementFilter.forName(NameKind.prefix(request.prefix)), staticFlagFilter, ElementFilter.forExcludedNames(invalidProposalsForClsMembers, PhpElementKind.METHOD), ElementFilter.forInstanceOf(MethodElement.class));
                    ElementFilter fieldsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.FIELD), ElementFilter.forName(NameKind.prefix(request.prefix)), staticFlagFilter, ElementFilter.forInstanceOf(FieldElement.class));
                    ElementFilter constantsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.TYPE_CONSTANT), ElementFilter.forName(NameKind.prefix(request.prefix)), ElementFilter.forInstanceOf(TypeConstantElement.class));
                    for (TypeMemberElement phpElement : request.index.getAccessibleTypeMembers(typeScope, enclosingType)) {
                        if (methodsFilter.isAccepted(phpElement)) {
                            MethodElement method = (MethodElement)phpElement;
                            List<PHPCompletionItem.MethodElementItem> items = PHPCompletionItem.MethodElementItem.getItems(method, request);
                            for (PHPCompletionItem.MethodElementItem methodItem : items) {
                                completionResult.add(methodItem);
                            }
                            continue;
                        }
                        if (fieldsFilter.isAccepted(phpElement)) {
                            FieldElement field = (FieldElement)phpElement;
                            PHPCompletionItem.FieldItem fieldItem = PHPCompletionItem.FieldItem.getItem(field, request);
                            completionResult.add(fieldItem);
                            continue;
                        }
                        if (!staticContext || !constantsFilter.isAccepted(phpElement)) continue;
                        TypeConstantElement constant = (TypeConstantElement)phpElement;
                        PHPCompletionItem.TypeConstantItem constantItem = PHPCompletionItem.TypeConstantItem.getItem(constant, request);
                        completionResult.add(constantItem);
                    }
                }
            }
        }
    }

    private void autoCompleteClassFields(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, request.anchor);
        Model model = request.result.getModel();
        Collection<? extends TypeScope> types = ModelUtils.resolveTypeAfterReferenceToken(model, tokenSequence, request.anchor);
        ElementFilter fieldsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.FIELD), ElementFilter.forName(NameKind.prefix(request.prefix)), ElementFilter.forInstanceOf(FieldElement.class));
        if (types != null) {
            TypeElement enclosingType = this.getEnclosingType(request, types);
            for (TypeScope typeScope : types) {
                for (TypeMemberElement phpElement : request.index.getAccessibleTypeMembers(typeScope, enclosingType)) {
                    if (!fieldsFilter.isAccepted(phpElement)) continue;
                    FieldElement field = (FieldElement)phpElement;
                    PHPCompletionItem.FieldItem fieldItem = PHPCompletionItem.FieldItem.getItem(field, request);
                    completionResult.add(fieldItem);
                }
            }
        }
    }

    private TypeElement getEnclosingType(PHPCompletionItem.CompletionRequest request, Collection<? extends TypeScope> types) {
        ElementFilter forFiles;
        Set<ClassElement> set;
        ClassDeclaration enclosingClass = PHPCodeCompletion.findEnclosingClass(request.info, CompletionContextFinder.lexerToASTOffset(request.result, request.anchor));
        String enclosingClassName = enclosingClass != null ? CodeUtils.extractClassName(enclosingClass) : null;
        NameKind.Exact enclosingClassNameKind = enclosingClassName != null && !enclosingClassName.trim().isEmpty() ? NameKind.exact(enclosingClassName) : null;
        HashSet<FileObject> preferedFileObjects = new HashSet<FileObject>();
        Set<TypeScope> enclosingTypes = null;
        FileObject currentFile = request.result.getSnapshot().getSource().getFileObject();
        if (currentFile != null) {
            preferedFileObjects.add(currentFile);
        }
        for (TypeScope typeScope : types) {
            FileObject fileObject = typeScope.getFileObject();
            if (fileObject != null) {
                preferedFileObjects.add(fileObject);
            }
            if (enclosingClassNameKind == null || enclosingTypes != null || !enclosingClassNameKind.matchesName(typeScope)) continue;
            enclosingTypes = Collections.singleton(typeScope);
        }
        if (enclosingClassNameKind != null && enclosingTypes == null && !(set = (forFiles = ElementFilter.forFiles(preferedFileObjects.toArray(new FileObject[preferedFileObjects.size()]))).prefer(request.index.getClasses(enclosingClassNameKind))).isEmpty()) {
            enclosingTypes = new HashSet<ClassElement>(set);
        }
        return enclosingTypes == null || enclosingTypes.isEmpty() ? null : (TypeElement)enclosingTypes.iterator().next();
    }

    private static ClassDeclaration findEnclosingClass(ParserResult info, int offset) {
        List<ASTNode> nodes = NavUtils.underCaret(info, offset);
        for (ASTNode node : nodes) {
            if (!(node instanceof ClassDeclaration)) continue;
            return (ClassDeclaration)node;
        }
        return null;
    }

    private void autoCompleteExpression(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        String className;
        for (String keyword : PHP_KEYWORDS.keySet()) {
            if (!this.startsWith(keyword, request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.KeywordItem(keyword, request));
        }
        for (String keyword : PHP_LANGUAGE_CONSTRUCTS_WITH_QUOTES) {
            if (!this.startsWith(keyword, request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.LanguageConstructWithQuotesItem(keyword, request));
        }
        for (String construct : PHP_LANGUAGE_CONSTRUCTS_WITH_PARENTHESES) {
            if (!this.startsWith(construct, request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.LanguageConstructWithParenthesesItem(construct, request));
        }
        for (String construct : PHP_LANGUAGE_CONSTRUCTS_WITH_SEMICOLON) {
            if (!this.startsWith(construct, request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.LanguageConstructWithSemicolonItem(construct, request));
        }
        boolean offerGlobalVariables = OptionsUtils.codeCompletionVariablesScope().equals((Object)CodeCompletionPanel.VariablesScope.ALL);
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind prefix = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.PREFIX);
        HashSet<VariableElement> globalVariables = new HashSet<VariableElement>();
        Model model = request.result.getModel();
        Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
        for (PhpElement element : request.index.getTopLevelElements(prefix, aliasedNames, AliasedElement.Trait.ALIAS)) {
            if (element instanceof FunctionElement) {
                for (PHPCompletionItem.FunctionElementItem functionItem : PHPCompletionItem.FunctionElementItem.getItems((FunctionElement)element, request)) {
                    completionResult.add(functionItem);
                }
                continue;
            }
            if (element instanceof ClassElement) {
                completionResult.add(new PHPCompletionItem.ClassItem((ClassElement)element, request, true, null));
                continue;
            }
            if (element instanceof InterfaceElement) {
                completionResult.add(new PHPCompletionItem.InterfaceItem((InterfaceElement)element, request, true));
                continue;
            }
            if (offerGlobalVariables && element instanceof VariableElement) {
                globalVariables.add((VariableElement)element);
                continue;
            }
            if (!(element instanceof ConstantElement)) continue;
            completionResult.add(new PHPCompletionItem.ConstantItem((ConstantElement)element, request));
        }
        FileObject fileObject = request.result.getSnapshot().getSource().getFileObject();
        ElementFilter forCurrentFile = ElementFilter.forFiles(fileObject);
        completionResult.addAll(this.getVariableProposals(request, forCurrentFile.reverseFilter(globalVariables)));
        ClassDeclaration classDecl = PHPCodeCompletion.findEnclosingClass(request.info, CompletionContextFinder.lexerToASTOffset(request.result, request.anchor));
        if (classDecl != null && (className = CodeUtils.extractClassName(classDecl)) != null) {
            for (String keyword : PHP_CLASS_KEYWORDS) {
                if (!this.startsWith(keyword, request.prefix)) continue;
                completionResult.add(new PHPCompletionItem.ClassScopeKeywordItem(className, keyword, request));
            }
        }
    }

    private void autoCompleteGlobals(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (OptionsUtils.codeCompletionVariablesScope().equals((Object)CodeCompletionPanel.VariablesScope.ALL)) {
            NameKind.Prefix prefix = NameKind.prefix(QualifiedName.create(request.prefix));
            for (VariableElement variableElement : request.index.getTopLevelVariables(prefix)) {
                completionResult.add(new PHPCompletionItem.VariableItem(variableElement, request));
            }
        }
    }

    private Collection<CompletionProposal> getVariableProposals(PHPCompletionItem.CompletionRequest request, Set<VariableElement> globalVariables) {
        LinkedHashMap<String, PHPCompletionItem> proposals = new LinkedHashMap<String, PHPCompletionItem>();
        Model model = request.result.getModel();
        VariableScope variableScope = model.getVariableScope(request.anchor);
        if (variableScope != null) {
            if (variableScope instanceof NamespaceScope) {
                if (globalVariables == null) {
                    FileObject fileObject = request.result.getSnapshot().getSource().getFileObject();
                    ElementFilter forCurrentFile = ElementFilter.forFiles(fileObject);
                    globalVariables = forCurrentFile.reverseFilter(request.index.getTopLevelVariables(NameKind.prefix(QualifiedName.create(request.prefix))));
                }
                for (VariableElement globalVariable : globalVariables) {
                    proposals.put(globalVariable.getName(), new PHPCompletionItem.VariableItem(globalVariable, request));
                }
            }
            List<? extends VariableName> declaredVariables = ModelUtils.filter(variableScope.getDeclaredVariables(), this.nameKind, request.prefix);
            int caretOffset = request.anchor + request.prefix.length();
            for (VariableName variableName : declaredVariables) {
                Set<QualifiedName> qualifiedNames;
                String name;
                String notDollaredName;
                FileObject realFileObject = variableName.getRealFileObject();
                if (realFileObject == null && variableName.getNameRange().getEnd() >= caretOffset || PredefinedSymbols.SUPERGLOBALS.contains(notDollaredName = (name = variableName.getName()).startsWith("$") ? name.substring(1) : name) || variableName.representsThis()) continue;
                Collection typeNames = variableName.getTypeNames(request.anchor);
                String typeName = typeNames.size() > 1 ? "mixed" : (String)ModelUtils.getFirst(typeNames);
                Set<QualifiedName> set = qualifiedNames = typeName != null ? Collections.singleton(QualifiedName.create(typeName)) : Collections.emptySet();
                if (realFileObject != null) {
                    proposals.put(name, new PHPCompletionItem.VariableItem(VariableElementImpl.create(name, 0, realFileObject, variableName.getElementQuery(), TypeResolverImpl.forNames(qualifiedNames)), request){

                        @Override
                        public boolean isSmart() {
                            return true;
                        }
                    });
                    continue;
                }
                proposals.put(name, new PHPCompletionItem.VariableItem(VariableElementImpl.create(name, 0, request.currentlyEditedFileURL, variableName.getElementQuery(), TypeResolverImpl.forNames(qualifiedNames)), request));
            }
            for (String string : PredefinedSymbols.SUPERGLOBALS) {
                if (!this.isPrefix("$" + string, request.prefix)) continue;
                proposals.put(string, new PHPCompletionItem.SuperGlobalItem(request, string));
            }
        }
        return proposals.values();
    }

    private boolean isPrefix(String name, String prefix) {
        return name != null && (name.startsWith(prefix) || this.nameKind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && name.toLowerCase().startsWith(prefix.toLowerCase()));
    }

    public String document(ParserResult info, ElementHandle element) {
        if (element instanceof ModelElement) {
            ModelElement mElem = (ModelElement)element;
            Scope parentElem = mElem.getInScope();
            String fName = mElem.getFileObject().getNameExt();
            String tooltip = null;
            tooltip = parentElem instanceof TypeScope ? (Object)((Object)mElem.getPhpElementKind()) + ": " + parentElem.getName() + "<b> " + mElem.getName() + " </b>" + "(" + fName + ")" : (Object)((Object)mElem.getPhpElementKind()) + ":<b> " + mElem.getName() + " </b>" + "(" + fName + ")";
            return String.format("<div align=\"right\"><font size=-1>%s</font></div>", tooltip);
        }
        return element instanceof MethodElement && ((MethodElement)element).isMagic() ? null : DocRenderer.document(info, element);
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    private static boolean isPHPIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '@';
    }

    private static boolean isPrefixBreaker(char c) {
        return !PHPCodeCompletion.isPHPIdentifierPart(c) && c != '\\' && c != '$' && c != ':';
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        try {
            BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
            if (doc == null) {
                return null;
            }
            int lineBegin = Utilities.getRowStart((BaseDocument)doc, (int)caretOffset);
            if (lineBegin != -1) {
                String prefix;
                int lineOffset;
                int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset);
                String line = doc.getText(lineBegin, lineEnd - lineBegin);
                int start = lineOffset = caretOffset - lineBegin;
                if (lineOffset > 0) {
                    char c = '\u0000';
                    int i = lineOffset - 1;
                    while (i >= 0 && (PHPCodeCompletion.isPHPIdentifierPart(c = line.charAt(i)) || c == '\\')) {
                        start = i--;
                    }
                    if (start == lineOffset && c == '?' && lineOffset - 2 >= 0 && line.charAt(lineOffset - 2) == '<') {
                        start -= 2;
                    }
                }
                if (upToOffset) {
                    prefix = line.substring(start, lineOffset);
                    int lastIndexOfDollar = prefix.lastIndexOf(36);
                    if (lastIndexOfDollar > 0) {
                        prefix = prefix.substring(lastIndexOfDollar);
                    }
                } else if (lineOffset == line.length()) {
                    prefix = line.substring(start);
                } else {
                    char d;
                    int n = line.length();
                    int end = lineOffset;
                    for (int j = lineOffset; j < n && PHPCodeCompletion.isPHPIdentifierPart(d = line.charAt(j)); ++j) {
                        end = j + 1;
                    }
                    prefix = line.substring(start, end);
                }
                if (prefix.length() > 0) {
                    if (prefix.endsWith("::")) {
                        return "";
                    }
                    if (prefix.endsWith(":") && prefix.length() > 1) {
                        return null;
                    }
                    int q = prefix.lastIndexOf("::");
                    if (q != -1) {
                        prefix = prefix.substring(q + 2);
                    }
                    if (prefix.length() == 1) {
                        char c = prefix.charAt(0);
                        if (PHPCodeCompletion.isPrefixBreaker(c)) {
                            return null;
                        }
                    } else if (!"<?".equals(prefix)) {
                        for (int i = prefix.length() - 2; i >= 0; --i) {
                            char c = prefix.charAt(i);
                            if (i == 0 && c == ':' || !PHPCodeCompletion.isPrefixBreaker(c)) continue;
                            prefix = prefix.substring(i + 1);
                            break;
                        }
                    }
                }
                if (prefix != null && prefix.startsWith("@")) {
                    TokenSequence<PHPTokenId> tokenSequence;
                    TokenHierarchy tokenHierarchy = info.getSnapshot().getTokenHierarchy();
                    TokenSequence<PHPTokenId> tokenSequence2 = tokenSequence = tokenHierarchy != null ? LexUtilities.getPHPTokenSequence(tokenHierarchy, caretOffset) : null;
                    if (tokenSequence != null) {
                        Token token;
                        PHPTokenId id;
                        tokenSequence.move(caretOffset);
                        if (tokenSequence.moveNext() && tokenSequence.movePrevious() && ((id = (PHPTokenId)(token = tokenSequence.token()).id()).equals((Object)PHPTokenId.PHP_STRING) || id.equals((Object)PHPTokenId.PHP_TOKEN))) {
                            prefix = prefix.substring(1);
                        }
                    }
                }
                return prefix;
            }
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        int offset;
        if (typedText.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        char lastChar = typedText.charAt(typedText.length() - 1);
        if (AUTOPOPUP_STOP_CHARS.contains(Character.valueOf(lastChar))) {
            return CodeCompletionHandler.QueryType.STOP;
        }
        Document document = component.getDocument();
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(document, offset = component.getCaretPosition());
        if (ts == null) {
            return CodeCompletionHandler.QueryType.STOP;
        }
        Token t = null;
        int diff = ts.move(offset);
        if (diff > 0 && ts.moveNext() || ts.movePrevious()) {
            TokenId id;
            t = ts.token();
            if (OptionsUtils.autoCompletionTypes()) {
                if (lastChar == ' ' || lastChar == '\t') {
                    if (ts.movePrevious() && TOKENS_TRIGGERING_AUTOPUP_TYPES_WS.contains(ts.token().id())) {
                        return CodeCompletionHandler.QueryType.ALL_COMPLETION;
                    }
                    return CodeCompletionHandler.QueryType.STOP;
                }
                if (t.id() == PHPTokenId.PHP_OBJECT_OPERATOR || t.id() == PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM) {
                    return CodeCompletionHandler.QueryType.ALL_COMPLETION;
                }
            }
            if (OptionsUtils.autoCompletionVariables() && (t.id() == PHPTokenId.PHP_TOKEN && lastChar == '$' || t.id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && lastChar == '$')) {
                return CodeCompletionHandler.QueryType.ALL_COMPLETION;
            }
            if (OptionsUtils.autoCompletionNamespaces() && t.id() == PHPTokenId.PHP_NS_SEPARATOR) {
                return PHPCodeCompletion.isPhp_53(document) ? CodeCompletionHandler.QueryType.ALL_COMPLETION : CodeCompletionHandler.QueryType.NONE;
            }
            if (t.id() == PHPTokenId.PHPDOC_COMMENT && lastChar == '@') {
                return CodeCompletionHandler.QueryType.ALL_COMPLETION;
            }
            if (OptionsUtils.autoCompletionFull() && t != null && ((id = t.id()).equals((Object)PHPTokenId.PHP_STRING) || id.equals((Object)PHPTokenId.PHP_VARIABLE)) && t.length() > 0) {
                return CodeCompletionHandler.QueryType.ALL_COMPLETION;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public static boolean isPhp_53(Document document) {
        FileObject fileObject = CodeUtils.getFileObject(document);
        assert (fileObject != null);
        return fileObject != null ? CodeUtils.isPhp_53(fileObject) : false;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        Model model = ((PHPParseResult)info).getModel();
        ParameterInfoSupport infoSupport = model.getParameterInfoSupport(caretOffset);
        return infoSupport.getParameterInfo();
    }

    private boolean startsWith(String theString, String prefix) {
        if (prefix.length() == 0) {
            return true;
        }
        return this.caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private static boolean isCamelCaseForTypeNames(String query) {
        return false;
    }

    static {
        PHP_KEYWORDS.put("use", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("namespace", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("class", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("const", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("continue", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("function", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("new", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("static", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("var", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("final", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("interface", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("instanceof", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("implements", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("extends", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("public", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("private", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("protected", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("abstract", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("clone", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("global", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("goto", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("throw", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("if", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("switch", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("for", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("array", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("foreach", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("while", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("catch", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("try", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_CURLY_BRACKETS);
        PHP_KEYWORDS.put("default", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_COLON);
        PHP_KEYWORDS.put("break", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endif", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endfor", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endforeach", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endwhile", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endswitch", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("case", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_COLON);
        PHP_KEYWORDS.put("and", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("as", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("declare", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("do", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_CURLY_BRACKETS);
        PHP_KEYWORDS.put("else", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_CURLY_BRACKETS);
        PHP_KEYWORDS.put("elseif", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_CURLY_BRACKETS);
        PHP_KEYWORDS.put("enddeclare", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("or", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("xor", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_LANGUAGE_CONSTRUCTS_WITH_QUOTES = new String[]{"echo", "include", "include_once", "require", "require_once", "print"};
        PHP_LANGUAGE_CONSTRUCTS_WITH_PARENTHESES = new String[]{"die", "eval", "exit", "empty", "isset", "list", "unset"};
        PHP_LANGUAGE_CONSTRUCTS_WITH_SEMICOLON = new String[]{"return"};
        PHP_CLASS_KEYWORDS = new String[]{PHP_CLASS_KEYWORD_THIS, "self::", "parent::", "static::"};
        PHP_STATIC_CLASS_KEYWORDS = new String[]{"self::", "parent::", "static::"};
        AUTOPOPUP_STOP_CHARS = new TreeSet<Character>(Arrays.asList(Character.valueOf('='), Character.valueOf(';'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('?')));
        TOKENS_TRIGGERING_AUTOPUP_TYPES_WS = Arrays.asList(PHPTokenId.PHP_NEW, PHPTokenId.PHP_EXTENDS, PHPTokenId.PHP_IMPLEMENTS, PHPTokenId.PHP_INSTANCEOF);
        INVALID_PROPOSALS_FOR_CLS_MEMBERS = Arrays.asList("__construct", "__destruct", "__call", "__callStatic", "__clone", "__get", "__invoke", "__isset", "__set", "__set_state", "__sleep", "__toString", "__unset", "__wakeup");
        CLASS_CONTEXT_KEYWORD_PROPOSAL = Arrays.asList("abstract", "const", "function", "private", "final", "protected", "public", "static", "var");
        INHERITANCE_KEYWORDS = Arrays.asList("extends", "implements");
    }

    private static class StaticOrInstanceMembersFilter
    extends ElementFilter {
        private final boolean forStaticContext;
        private final boolean forInstanceContext;
        private final boolean forSelfContext;
        private final boolean staticAllowed;
        private final boolean nonstaticAllowed;
        private final boolean forStaticLateBinding;

        public StaticOrInstanceMembersFilter(boolean forStaticContext, boolean forInstanceContext, boolean forSelfContext, boolean forStaticLateBinding) {
            this.forStaticContext = forStaticContext;
            this.forInstanceContext = forInstanceContext;
            this.forSelfContext = forSelfContext;
            this.forStaticLateBinding = forStaticLateBinding;
            this.staticAllowed = OptionsUtils.codeCompletionStaticMethods();
            this.nonstaticAllowed = OptionsUtils.codeCompletionNonStaticMethods();
        }

        @Override
        public boolean isAccepted(PhpElement element) {
            if (this.forSelfContext && this.isAcceptedForSelfContext(element)) {
                return true;
            }
            if (this.forStaticContext && this.isAcceptedForStaticContext(element)) {
                return true;
            }
            return this.forInstanceContext && this.isAcceptedForNotStaticContext(element);
        }

        private boolean isAcceptedForNotStaticContext(PhpElement element) {
            boolean isStatic = element.getPhpModifiers().isStatic();
            return !isStatic || this.staticAllowed && element.getPhpElementKind().equals((Object)PhpElementKind.METHOD);
        }

        private boolean isAcceptedForStaticContext(PhpElement element) {
            boolean isStatic = element.getPhpModifiers().isStatic();
            return isStatic || this.nonstaticAllowed && !this.forStaticLateBinding && element.getPhpElementKind().equals((Object)PhpElementKind.METHOD);
        }

        private boolean isAcceptedForSelfContext(PhpElement element) {
            return this.forSelfContext && this.nonstaticAllowed && !element.getPhpElementKind().equals((Object)PhpElementKind.FIELD);
        }
    }
}

