/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WebServiceNotifier;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWsStackProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;

public class ProjectWebServiceNotifier
implements WebServiceNotifier {
    private static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    private Project proj;

    public ProjectWebServiceNotifier(Project project) {
        this.proj = project;
    }

    public void serviceAdded(String string, String string2) {
        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.proj.getProjectDirectory());
        if (jAXWSSupport != null) {
            jAXWSSupport.addService(string, string2, this.isJsr109Supported());
        }
    }

    public void serviceRemoved(String string) {
        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.proj.getProjectDirectory());
        if (jAXWSSupport != null) {
            jAXWSSupport.serviceFromJavaRemoved(string);
        }
    }

    private boolean isJsr109Supported() {
        String string;
        JaxWsModel jaxWsModel = (JaxWsModel)this.proj.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && jaxWsModel.getJsr109() != null) {
            return jaxWsModel.getJsr109();
        }
        EditableProperties editableProperties = null;
        try {
            editableProperties = WSUtils.getEditableProperties((Project)this.proj, (String)"nbproject/private/private.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = false;
        if (editableProperties != null && (string = editableProperties.getProperty(J2EE_SERVER_INSTANCE)) != null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
                WSStack wSStack = JaxWsStackProvider.getJaxWsStack((J2eePlatform)j2eePlatform);
                if (wSStack != null) {
                    bl = wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
                }
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to find J2eePlatform", instanceRemovedException);
            }
        }
        if (!bl) {
            bl = jaxWsModel != null ? JaxWsUtils.askForSunJaxWsConfig(jaxWsModel) : true;
        }
        return bl;
    }
}

