/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsClassesCookie;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JaxWsClassesCookieImpl
implements JaxWsClassesCookie {
    Service service;
    FileObject implClassFO;

    public JaxWsClassesCookieImpl(Service service, FileObject implClassFO) {
        this.service = service;
        this.implClassFO = implClassFO;
    }

    @Override
    public void addOperation(final MethodTree method) {
        JavaSource targetSource = JavaSource.forFileObject((FileObject)this.implClassFO);
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker make = workingCopy.getTreeMaker();
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    PrimitiveTypeTree primitiveType;
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    TypeElement webMethodAn = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
                    TypeElement webParamAn = workingCopy.getElements().getTypeElement("javax.jws.WebParam");
                    AnnotationTree webMethodAnnotation = make.Annotation((Tree)make.QualIdent((Element)webMethodAn), Collections.emptyList());
                    ModifiersTree modifiersTree = make.addModifiersAnnotation(method.getModifiers(), webMethodAnnotation);
                    if (Tree.Kind.PRIMITIVE_TYPE == method.getReturnType().getKind() && TypeKind.VOID == (primitiveType = (PrimitiveTypeTree)method.getReturnType()).getPrimitiveTypeKind()) {
                        TypeElement oneWayAn = workingCopy.getElements().getTypeElement("javax.jws.Oneway");
                        AnnotationTree oneWayAnnotation = make.Annotation((Tree)make.QualIdent((Element)oneWayAn), Collections.emptyList());
                        modifiersTree = make.addModifiersAnnotation(modifiersTree, oneWayAnnotation);
                    }
                    List<? extends VariableTree> parameters = method.getParameters();
                    ArrayList<VariableTree> newParameters = new ArrayList<VariableTree>();
                    for (VariableTree variableTree : parameters) {
                        AnnotationTree paramAnnotation = make.Annotation((Tree)make.QualIdent((Element)webParamAn), Collections.singletonList(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"name"), (ExpressionTree)make.Literal((Object)variableTree.getName().toString()))));
                        newParameters.add(genUtils.addAnnotation(variableTree, paramAnnotation));
                    }
                    MethodTree annotatedMethod = make.Method(modifiersTree, (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), newParameters, method.getThrows(), method.getBody(), (ExpressionTree)method.getDefaultValue());
                    Comment comment = Comment.create((String)NbBundle.getMessage(JaxWsClassesCookieImpl.class, (String)"TXT_WSOperation"));
                    make.addComment((Tree)annotatedMethod, comment, true);
                    ClassTree modifiedClass = make.addClassMember(javaClass, (Tree)annotatedMethod);
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }

            public void cancel() {
            }
        };
        try {
            targetSource.runModificationTask((Task)modificationTask).commit();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }
}

