/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.ServiceCreator;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ProjectInfo;
import org.netbeans.modules.websvc.core.dev.wizard.WsdlServiceHandler;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsServiceCreator
implements ServiceCreator {
    private ProjectInfo projectInfo;
    private WizardDescriptor wiz;
    private boolean addJaxWsLib;
    private int serviceType;
    private int projectType;

    public JaxWsServiceCreator(ProjectInfo projectInfo, WizardDescriptor wizardDescriptor, boolean bl) {
        this.projectInfo = projectInfo;
        this.wiz = wizardDescriptor;
        this.addJaxWsLib = bl;
    }

    public void createService() throws IOException {
        this.serviceType = (Integer)this.wiz.getProperty("webServiceType");
        this.projectType = this.projectInfo.getProjectType();
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        progressHandle.start(100);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    JaxWsServiceCreator.this.generateWebService(progressHandle);
                }
                catch (Exception exception) {
                    progressHandle.finish();
                    String string = exception.getLocalizedMessage();
                    if (string != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)exception);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    public void createServiceFromWsdl() throws IOException {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    progressHandle.start();
                    JaxWsServiceCreator.this.generateWsFromWsdl15(progressHandle);
                }
                catch (Exception exception) {
                    progressHandle.finish();
                    String string = exception.getLocalizedMessage();
                    if (string != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)exception);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    private void generateWebService(ProgressHandle progressHandle) throws Exception {
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String string = Templates.getTargetName((WizardDescriptor)this.wiz);
        Project project = this.projectInfo.getProject();
        if (this.serviceType == 0) {
            JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
            if (jAXWSSupport != null) {
                string = this.getUniqueJaxwsName(jAXWSSupport, string);
                progressHandle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_WS"), 50);
                if (this.addJaxWsLib) {
                    this.addJaxws21Library(project);
                }
                this.generateJaxWSImplFromTemplate(fileObject, string, this.projectType);
                progressHandle.finish();
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_JaxWsNotSupported"), 0));
                progressHandle.finish();
            }
        } else if (this.serviceType == 1 && Util.isJavaEE5orHigher((Project)this.projectInfo.getProject()) && (this.projectType == 1 || this.projectType == 2)) {
            JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
            if (jAXWSSupport != null) {
                string = this.getUniqueJaxwsName(jAXWSSupport, string);
                progressHandle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_SEI_AND_IMPL"), 50);
                Node[] nodeArray = (Node[])this.wiz.getProperty("delegateToSessionBean");
                this.generateWebServiceFromEJB(string, fileObject, this.projectInfo, nodeArray);
                progressHandle.finish();
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_JaxWsNotSupported"), 0));
                progressHandle.finish();
            }
        }
    }

    private FileObject generateJaxWSImplFromTemplate(FileObject fileObject, String string, int n) throws Exception {
        FileObject fileObject2;
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject3 = Templates.getTemplate((WizardDescriptor)this.wiz);
        if (((Boolean)this.wiz.getProperty("endpointAsStatelessBean")).booleanValue()) {
            fileObject2 = fileObject3.getParent();
            fileObject3 = fileObject2.getFileObject("EjbWebService", "java");
        }
        fileObject2 = DataObject.find((FileObject)fileObject3);
        DataObject dataObject = fileObject2.createFromTemplate(dataFolder, string);
        FileObject fileObject4 = dataObject.getPrimaryFile();
        fileObject4.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
        dataObject.setValid(false);
        dataObject = DataObject.find((FileObject)fileObject4);
        final JaxWsModel jaxWsModel = (JaxWsModel)this.projectInfo.getProject().getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            ClassPath classPath = this.getClassPathForFile(this.projectInfo.getProject(), fileObject4);
            if (classPath != null) {
                String string2 = classPath.getResourceName(fileObject4, '.', false);
                Service service = jaxWsModel.addService(string, string2);
                ProjectManager.mutex().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            jaxWsModel.write();
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify((Throwable)iOException);
                        }
                    }
                });
            }
            JaxWsUtils.openFileInEditor(dataObject);
            this.displayDuplicityWarning(fileObject4);
        }
        return fileObject4;
    }

    private String getUniqueJaxwsName(JAXWSSupport jAXWSSupport, String string) {
        List list = jAXWSSupport.getServices();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Object e : list) {
            arrayList.add(((Service)e).getName());
        }
        return this.uniqueWSName(string, arrayList);
    }

    private String uniqueWSName(String string, List<String> list) {
        int n = 0;
        String string2 = string;
        while (list.contains(string2)) {
            string2 = string + String.valueOf(++n);
        }
        return string2;
    }

    private void addJaxws21Library(Project project) throws Exception {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray.length > 0) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
            FileObject fileObject = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
            if (fileObject != null) {
                return;
            }
            Library library = LibraryManager.getDefault().getLibrary("jaxws21");
            if (library != null) {
                try {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
                }
                catch (IOException iOException) {
                    throw new Exception("Unable to add JAXWS 21 Library. " + iOException.getMessage());
                }
            } else {
                throw new Exception("Unable to add JAXWS 2.1 Library. ProjectClassPathExtender or library not found");
            }
            try {
                FileObject fileObject2 = sourceGroupArray[0].getRootFolder();
                WSUtils.addJaxWsApiEndorsed((Project)project, (FileObject)fileObject2);
            }
            catch (IOException iOException) {
                Logger.getLogger(JaxWsServiceCreator.class.getName()).log(Level.FINE, "Cannot add JAX-WS-ENDORSED classpath", iOException);
            }
        }
    }

    private void generateWsFromWsdl15(final ProgressHandle progressHandle) throws Exception {
        File file;
        String string = (String)this.wiz.getProperty("wsdlFilePath");
        URL uRL = null;
        if (string == null) {
            uRL = new URL((String)this.wiz.getProperty("wsdl_url"));
        } else {
            file = FileUtil.normalizeFile((File)new File(string));
            uRL = file.toURI().toURL();
        }
        file = this.projectInfo.getProject();
        URL uRL2 = uRL;
        final WsdlService wsdlService = (WsdlService)this.wiz.getProperty("wsdlService");
        Boolean bl = (Boolean)this.wiz.getProperty("useProvider");
        if (wsdlService == null) {
            FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wiz);
            String string2 = Templates.getTargetName((WizardDescriptor)this.wiz);
            if (fileObject != null) {
                GenerationUtils.createClass((FileObject)fileObject, (String)string2, null);
            }
            WsdlServiceHandler wsdlServiceHandler = (WsdlServiceHandler)this.wiz.getProperty("wsdlServiceHandler");
            JaxWsUtils.generateJaxWsArtifacts((Project)file, fileObject, string2, uRL2, wsdlServiceHandler.getServiceName(), wsdlServiceHandler.getPortName());
            WsdlModeler wsdlModeler = (WsdlModeler)this.wiz.getProperty("wsdlModeler");
            if (wsdlModeler != null && wsdlModeler.getCreationException() != null) {
                progressHandle.finish();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_CannotGenerateArtifacts", (Object)wsdlModeler.getCreationException().getLocalizedMessage()), 0));
            } else {
                progressHandle.finish();
            }
        } else {
            final WsdlPort wsdlPort = (WsdlPort)this.wiz.getProperty("wsdlPort");
            boolean bl2 = (Boolean)this.wiz.getProperty("endpointAsStatelessBean");
            WsdlModeler wsdlModeler = (WsdlModeler)this.wiz.getProperty("wsdlModeler");
            wsdlModeler.generateWsdlModel(new WsdlModelListener((Project)file, uRL2, bl, bl2){
                final /* synthetic */ Project val$p;
                final /* synthetic */ URL val$wsdlURL;
                final /* synthetic */ Boolean val$useProvider;
                final /* synthetic */ boolean val$isStatelessSB;
                {
                    this.val$p = project;
                    this.val$wsdlURL = uRL;
                    this.val$useProvider = bl;
                    this.val$isStatelessSB = bl2;
                }

                public void modelCreated(WsdlModel wsdlModel) {
                    if (wsdlModel == null) {
                        progressHandle.finish();
                        return;
                    }
                    WsdlService wsdlService2 = wsdlModel.getServiceByName(wsdlService.getName());
                    WsdlPort wsdlPort2 = wsdlService2.getPortByName(wsdlPort.getName());
                    wsdlPort2.setSOAPVersion(wsdlPort.getSOAPVersion());
                    FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)JaxWsServiceCreator.this.wiz);
                    String string = Templates.getTargetName((WizardDescriptor)JaxWsServiceCreator.this.wiz);
                    try {
                        JaxWsUtils.generateJaxWsImplementationClass(this.val$p, fileObject, string, this.val$wsdlURL, wsdlService2, wsdlPort2, this.val$useProvider, this.val$isStatelessSB);
                        progressHandle.finish();
                    }
                    catch (Exception exception) {
                        progressHandle.finish();
                        ErrorManager.getDefault().notify(4096, (Throwable)exception);
                    }
                }
            });
        }
    }

    private void generateWebServiceFromEJB(String string, FileObject fileObject, ProjectInfo projectInfo, Node[] nodeArray) throws IOException, ServiceAlreadyExistsExeption, PropertyVetoException {
        EjbReference ejbReference;
        if (nodeArray != null && nodeArray.length == 1 && (ejbReference = (EjbReference)nodeArray[0].getLookup().lookup(EjbReference.class)) != null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wiz);
            FileObject fileObject3 = fileObject2.getParent();
            fileObject2 = (Boolean)this.wiz.getProperty("endpointAsStatelessBean") != false ? fileObject3.getFileObject("EjbWebServiceNoOp", "java") : fileObject3.getFileObject("WebServiceNoOp", "java");
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string);
            FileObject fileObject4 = dataObject2.getPrimaryFile();
            fileObject4.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
            dataObject2.setValid(false);
            dataObject2 = DataObject.find((FileObject)fileObject4);
            ClassPath classPath = this.getClassPathForFile(projectInfo.getProject(), fileObject4);
            if (classPath != null) {
                String string2 = classPath.getResourceName(fileObject4, '.', false);
                this.generateDelegateMethods(fileObject4, ejbReference);
                final JaxWsModel jaxWsModel = (JaxWsModel)projectInfo.getProject().getLookup().lookup(JaxWsModel.class);
                if (jaxWsModel != null) {
                    jaxWsModel.addService(string, string2);
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                jaxWsModel.write();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                    });
                }
            }
            JaxWsUtils.openFileInEditor(dataObject2);
            this.displayDuplicityWarning(fileObject4);
        }
    }

    private void displayDuplicityWarning(final FileObject fileObject) {
        final String string = fileObject.getName() + "Service";
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Service service = JaxWsUtils.findServiceForServiceName(fileObject, string);
                if (service != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_ServiceNameExists", (Object)string, (Object)service.getImplementationClass()), 2));
                }
            }
        });
    }

    private void generateDelegateMethods(final FileObject fileObject, final EjbReference ejbReference) throws IOException {
        final boolean[] blArray = new boolean[1];
        final String[] stringArray = new String[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                if (typeElement != null) {
                    VariableTree variableTree = null;
                    stringArray[0] = ejbReference.getLocal();
                    if (stringArray[0] == null) {
                        stringArray[0] = ejbReference.getRemote();
                    }
                    if (stringArray[0] == null) {
                        stringArray[0] = ejbReference.getEjbClass();
                    }
                    if ((variableTree = JaxWsServiceCreator.this.generateEjbInjection(workingCopy, treeMaker, stringArray[0], blArray)) != null) {
                        String string = "Add business logic below. (Right-click in editor and choose";
                        String string2 = "\"Insert Code > Add Web Service Operation\")";
                        treeMaker.addComment((Tree)variableTree, Comment.create((Comment.Style)Comment.Style.LINE, (int)0, (int)0, (int)4, (String)string), false);
                        treeMaker.addComment((Tree)variableTree, Comment.create((Comment.Style)Comment.Style.LINE, (int)0, (int)0, (int)4, (String)string2), false);
                        ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                        ClassTree classTree2 = treeMaker.insertClassMember(classTree, 0, (Tree)variableTree);
                        if (blArray[0]) {
                            TypeElement typeElement2 = workingCopy.getElements().getTypeElement(stringArray[0]);
                            classTree2 = JaxWsServiceCreator.this.generateMethods(workingCopy, treeMaker, typeElement, classTree2, typeElement2);
                        }
                        workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                    }
                }
            }

            public void cancel() {
            }
        };
        javaSource.runModificationTask((Task)cancellableTask).commit();
        if (!blArray[0]) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_EJB_NOT_ON_CLASSPATH", (Object)stringArray[0], (Object)fileObject.getName()), 2));
                }
            });
        }
    }

    private VariableTree generateEjbInjection(WorkingCopy workingCopy, TreeMaker treeMaker, String string, boolean[] blArray) {
        TypeElement typeElement = workingCopy.getElements().getTypeElement("javax.ejb.EJB");
        TypeElement typeElement2 = workingCopy.getElements().getTypeElement(string);
        AnnotationTree annotationTree = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement), Collections.emptyList());
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE), Collections.singletonList(annotationTree));
        blArray[0] = typeElement2 != null;
        return treeMaker.Variable(modifiersTree, (CharSequence)"ejbRef", blArray[0] ? treeMaker.Type(typeElement2.asType()) : treeMaker.Identifier((CharSequence)string), null);
    }

    private ClassTree generateMethods(WorkingCopy workingCopy, TreeMaker treeMaker, TypeElement typeElement, ClassTree classTree, TypeElement typeElement2) throws IOException {
        GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
        TypeElement typeElement3 = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
        assert (typeElement3 != null);
        if (typeElement3 == null) {
            return classTree;
        }
        TypeMirror typeMirror = typeElement2.getSuperclass();
        boolean bl = TypeKind.NONE != typeMirror.getKind() && !this.isObjectClass((DeclaredType)typeMirror);
        List<? extends Element> list = null;
        list = bl ? workingCopy.getElements().getAllMembers(typeElement2) : typeElement2.getEnclosedElements();
        HashSet<String> hashSet = new HashSet<String>();
        for (Element element : list) {
            Tree tree;
            Object object;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            if (bl && (object7 = element.getEnclosingElement()).getKind() == ElementKind.CLASS && this.isObjectClass((TypeElement)object7)) continue;
            object7 = generatorUtilities.createMethod((DeclaredType)typeElement2.asType(), executableElement);
            Name name = executableElement.getSimpleName();
            boolean bl2 = workingCopy.getTypes().getNoType(TypeKind.VOID) == executableElement.getReturnType();
            String string = this.findUniqueOperationName(hashSet, name.toString());
            hashSet.add(string);
            AssignmentTree assignmentTree = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"operationName"), (ExpressionTree)treeMaker.Literal((Object)string));
            AnnotationTree annotationTree = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement3), Collections.singletonList(assignmentTree));
            ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(annotationTree));
            if (!name.contentEquals(string)) {
                object6 = workingCopy.getElements().getTypeElement("javax.xml.ws.RequestWrapper");
                object5 = workingCopy.getElements().getTypeElement("javax.xml.ws.ResponseWrapper");
                object4 = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"className"), (ExpressionTree)treeMaker.Literal((Object)string));
                object3 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object6), Collections.singletonList(object4));
                modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, (AnnotationTree)object3);
                if (!bl2) {
                    object4 = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"className"), (ExpressionTree)treeMaker.Literal((Object)(string + "Response")));
                    AnnotationTree annotationTree2 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object5), Collections.singletonList(object4));
                    modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, annotationTree2);
                }
            }
            if (bl2 && object7.getThrows().isEmpty()) {
                object6 = workingCopy.getElements().getTypeElement("javax.jws.Oneway");
                object5 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object6), Collections.emptyList());
                modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, (AnnotationTree)object5);
            }
            object6 = object7.getParameters();
            object5 = new ArrayList();
            if (object6.size() > 0) {
                object4 = workingCopy.getElements().getTypeElement("javax.jws.WebParam");
                object3 = object6.iterator();
                while (object3.hasNext()) {
                    VariableTree variableTree = (VariableTree)object3.next();
                    object = variableTree.getName().toString();
                    tree = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"name"), (ExpressionTree)treeMaker.Literal(object));
                    AnnotationTree annotationTree3 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object4), Collections.singletonList(tree));
                    ModifiersTree modifiersTree2 = treeMaker.addModifiersAnnotation(variableTree.getModifiers(), annotationTree3);
                    object5.add(treeMaker.Variable(modifiersTree2, (CharSequence)variableTree.getName(), variableTree.getType(), null));
                }
            }
            object4 = new ArrayList();
            for (VariableElement variableElement : executableElement.getParameters()) {
                object4.add(treeMaker.Identifier((CharSequence)variableElement.getSimpleName()));
            }
            object3 = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"ejbRef"), (CharSequence)name), (List)object4);
            StatementTree object22 = bl2 ? treeMaker.ExpressionStatement((ExpressionTree)object3) : treeMaker.Return((ExpressionTree)object3);
            object = treeMaker.Block(Collections.singletonList(object22), false);
            tree = treeMaker.Method(modifiersTree, (CharSequence)object7.getName(), object7.getReturnType(), object7.getTypeParameters(), (List)object5, object7.getThrows(), (BlockTree)object, null);
            classTree = treeMaker.addClassMember(classTree, tree);
        }
        return classTree;
    }

    private String findUniqueOperationName(Set<String> set, String string) {
        if (!set.contains(string)) {
            return string;
        }
        int n = 1;
        String string2 = string + "_1";
        while (set.contains(string2)) {
            string2 = string + "_" + String.valueOf(++n);
        }
        return string2;
    }

    private ClassPath getClassPathForFile(Project project, FileObject fileObject) {
        SourceGroup[] sourceGroupArray;
        for (SourceGroup sourceGroup : sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject fileObject2 = sourceGroup.getRootFolder();
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
        }
        return null;
    }

    private boolean isObjectClass(DeclaredType declaredType) {
        return this.isObjectClass((TypeElement)declaredType.asElement());
    }

    private boolean isObjectClass(TypeElement typeElement) {
        return TypeKind.NONE == typeElement.getSuperclass().getKind();
    }
}

