/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileObjectBasedFile;
import org.netbeans.modules.remote.api.ui.RemoteFileSystemView;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class FileChooserBuilder {
    private static final String openDialogTitleTextKey = "FileChooser.openDialogTitleText";
    private static final String saveDialogTitleTextKey = "FileChooser.saveDialogTitleText";
    private static final String readOnlyKey = "FileChooser.readOnly";
    private final ExecutionEnvironment env;
    private Preferences forModule;

    public FileChooserBuilder(ExecutionEnvironment env) {
        this.env = env;
    }

    public JFileChooserEx createFileChooser() {
        return this.createFileChooser(null);
    }

    public JFileChooserEx createFileChooser(String selectedPath) {
        if (this.env.isLocal()) {
            return new LocalFileChooserImpl(selectedPath);
        }
        if (selectedPath == null || selectedPath.trim().length() == 0) {
            selectedPath = "/";
        }
        String currentOpenTitle = UIManager.getString(openDialogTitleTextKey);
        String currentSaveTitle = UIManager.getString(saveDialogTitleTextKey);
        Boolean currentReadOnly = UIManager.getBoolean(readOnlyKey);
        UIManager.put(openDialogTitleTextKey, FileChooserBuilder.decorateTitle(currentOpenTitle, this.env));
        UIManager.put(saveDialogTitleTextKey, FileChooserBuilder.decorateTitle(currentSaveTitle, this.env));
        RemoteFileSystemView remoteFileSystemView = new RemoteFileSystemView("/", this.env);
        RemoteFileChooserImpl chooser = new RemoteFileChooserImpl(selectedPath, remoteFileSystemView, this.env, this.forModule);
        remoteFileSystemView.addPropertyChangeListener(chooser);
        chooser.setFileView(new CustomFileView(remoteFileSystemView));
        UIManager.put(openDialogTitleTextKey, currentOpenTitle);
        UIManager.put(saveDialogTitleTextKey, currentSaveTitle);
        UIManager.put(readOnlyKey, currentReadOnly);
        return chooser;
    }

    public FileChooserBuilder setPreferences(Preferences forModule) {
        this.forModule = forModule;
        return this;
    }

    private static String decorateTitle(String title, ExecutionEnvironment env) {
        return NbBundle.getMessage(FileChooserBuilder.class, (String)"REMOTE_CHOOSER_TITLE", (Object)title, (Object)env.getDisplayName());
    }

    private static class CustomFileView
    extends FileView {
        final FileSystemView view;

        public CustomFileView(FileSystemView view) {
            this.view = view;
        }

        @Override
        public Icon getIcon(File f) {
            return this.view.getSystemIcon(f);
        }

        @Override
        public String getName(File f) {
            if (this.view.isRoot(f)) {
                return "/";
            }
            return super.getName(f);
        }

        @Override
        public Boolean isTraversable(File f) {
            return f.isDirectory();
        }
    }

    private static class RemoteFileChooserImpl
    extends JFileChooserEx
    implements PropertyChangeListener {
        private final Preferences forModule;
        private final ExecutionEnvironment env;

        public RemoteFileChooserImpl(String currentDirectory, RemoteFileSystemView fsv, ExecutionEnvironment env, Preferences forModule) {
            super(currentDirectory, (FileSystemView)fsv);
            this.env = env;
            this.forModule = forModule;
        }

        @Override
        public FileObject getSelectedFileObject() {
            File file = this.getSelectedFile();
            return file instanceof FileObjectBasedFile ? ((FileObjectBasedFile)file).getFileObject() : null;
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public FileObject[] getSelectedFileObjects() {
            File[] files = this.getSelectedFiles();
            if (files == null) {
                return null;
            }
            ArrayList<FileObject> result = new ArrayList<FileObject>(files.length);
            for (int i = 0; i < files.length; ++i) {
                if (!(files[i] instanceof FileObjectBasedFile)) continue;
                FileObject fo = ((FileObjectBasedFile)files[i]).getFileObject();
                if (fo != null) {
                    result.add(fo);
                    continue;
                }
                RemoteLogger.getInstance().log(Level.FINEST, "Null file object for {0}", files[i].getAbsolutePath());
            }
            return result.toArray(new FileObject[result.size()]);
        }

        @Override
        protected void setup(FileSystemView view) {
            super.setup(view);
        }

        @Override
        public void approveSelection() {
            File selectedFile = this.getSelectedFile();
            if (selectedFile != null) {
                if (selectedFile.isDirectory() && this.getFileSelectionMode() == 0) {
                    this.setCurrentDirectory(this.getSelectedFile());
                } else {
                    super.approveSelection();
                }
            }
        }

        @Override
        public void setCurrentDirectory(File dir) {
            super.setCurrentDirectory(dir);
        }

        @Override
        protected void fireActionPerformed(String command) {
            super.fireActionPerformed(command);
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if ("ls".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String file = (String)evt.getNewValue();
                        if (file == null) {
                            RemoteFileChooserImpl.this.setCursor(Cursor.getPredefinedCursor(0));
                        } else {
                            RemoteFileChooserImpl.this.setCursor(Cursor.getPredefinedCursor(3));
                        }
                    }
                });
            }
        }

        @Override
        public RemoteFileSystemView getFileSystemView() {
            return (RemoteFileSystemView)super.getFileSystemView();
        }

        @Override
        public void setDialogTitle(String dialogTitle) {
            super.setDialogTitle(FileChooserBuilder.decorateTitle(dialogTitle, this.getFileSystemView().getExecutionEnvironment()));
        }

        @Override
        public int showOpenDialog(Component parent) throws HeadlessException {
            int ret = super.showOpenDialog(parent);
            if (ret != 1 && this.getSelectedFile() != null) {
                String path = this.getSelectedFile().getAbsolutePath();
                if (this.forModule != null) {
                    String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.env);
                    this.forModule.put("FileChooserPath" + envID, path);
                }
            }
            return ret;
        }
    }

    private static class LocalFileChooserImpl
    extends JFileChooserEx {
        public LocalFileChooserImpl(String selectedPath) {
            super(selectedPath);
        }

        @Override
        public FileObject getSelectedFileObject() {
            File file = this.getSelectedFile();
            return file == null ? null : FileUtil.toFileObject((File)file);
        }

        @Override
        public FileObject[] getSelectedFileObjects() {
            File[] files = this.getSelectedFiles();
            if (files == null) {
                return null;
            }
            FileObject[] result = new FileObject[files.length];
            for (int i = 0; i < files.length; ++i) {
                result[i] = FileUtil.toFileObject((File)files[i]);
            }
            return result;
        }
    }

    public static abstract class JFileChooserEx
    extends JFileChooser {
        protected JFileChooserEx(String currentDirectoryPath) {
            super(currentDirectoryPath);
        }

        public JFileChooserEx(String currentDirectoryPath, FileSystemView fsv) {
            super(currentDirectoryPath, fsv);
        }

        public abstract FileObject getSelectedFileObject();

        public abstract FileObject[] getSelectedFileObjects();
    }
}

