/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type
implements PrimitiveType {
    public static final JCNoType noType = new JCNoType(18);
    public static boolean moreInfo = false;
    public int tag;
    public Symbol.TypeSymbol tsym;

    public Object constValue() {
        return null;
    }

    public Type getModelType() {
        return this;
    }

    public static List<Type> getModelTypes(List<Type> ts) {
        ListBuffer<Type> lb = new ListBuffer<Type>();
        for (Type t : ts) {
            lb.append(t.getModelType());
        }
        return lb.toList();
    }

    public <R, S> R accept(Visitor<R, S> v, S s) {
        return v.visitType(this, s);
    }

    public Type(int tag, Symbol.TypeSymbol tsym) {
        this.tag = tag;
        this.tsym = tsym;
    }

    public Type map(Mapping f) {
        return this;
    }

    public static List<Type> map(List<Type> ts, Mapping f) {
        if (ts.nonEmpty()) {
            List<Type> tail1 = Type.map(ts.tail, f);
            Type t = f.apply((Type)ts.head);
            if (tail1 != ts.tail || t != ts.head) {
                return tail1.prepend(t);
            }
        }
        return ts;
    }

    public Type constType(Object constValue) {
        final Object value = constValue;
        Assert.check(this.tag <= 8);
        return new Type(this.tag, this.tsym){

            public Object constValue() {
                return value;
            }

            public Type baseType() {
                return this.tsym.type;
            }
        };
    }

    public Type baseType() {
        return this;
    }

    public static List<Type> baseTypes(List<Type> ts) {
        if (ts.nonEmpty()) {
            Type t = ((Type)ts.head).baseType();
            List<Type> baseTypes = Type.baseTypes(ts.tail);
            if (t != ts.head || baseTypes != ts.tail) {
                return baseTypes.prepend(t);
            }
        }
        return ts;
    }

    @Override
    public String toString() {
        String s;
        String string = s = this.tsym == null || this.tsym.name == null ? "<none>" : this.tsym.name.toString();
        if (moreInfo && this.tag == 14) {
            s = s + this.hashCode();
        }
        return s;
    }

    public static String toString(List<Type> ts) {
        if (ts.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(((Type)ts.head).toString());
        List l = ts.tail;
        while (l.nonEmpty()) {
            buf.append(",").append(((Type)l.head).toString());
            l = l.tail;
        }
        return buf.toString();
    }

    public String stringValue() {
        Object cv = Assert.checkNonNull(this.constValue());
        if (this.tag == 8) {
            return (Integer)cv == 0 ? "false" : "true";
        }
        if (this.tag == 2) {
            return String.valueOf((char)((Integer)cv).intValue());
        }
        return cv.toString();
    }

    @Override
    public boolean equals(Object t) {
        return super.equals(t);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isFalse() {
        return this.tag == 8 && this.constValue() != null && (Integer)this.constValue() == 0;
    }

    public boolean isTrue() {
        return this.tag == 8 && this.constValue() != null && (Integer)this.constValue() != 0;
    }

    public String argtypes(boolean varargs) {
        List<Type> args = this.getParameterTypes();
        if (!varargs) {
            return args.toString();
        }
        StringBuilder buf = new StringBuilder();
        while (args.tail.nonEmpty()) {
            buf.append(args.head);
            args = args.tail;
            buf.append(',');
        }
        if (((Type)args.head).tag == 11) {
            buf.append(((ArrayType)args.head).elemtype);
            buf.append("...");
        } else {
            buf.append(args.head);
        }
        return buf.toString();
    }

    public List<Type> getTypeArguments() {
        return List.nil();
    }

    public Type getEnclosingType() {
        return null;
    }

    public List<Type> getParameterTypes() {
        return List.nil();
    }

    public Type getReturnType() {
        return null;
    }

    public List<Type> getThrownTypes() {
        return List.nil();
    }

    public Type getUpperBound() {
        return null;
    }

    public Type getLowerBound() {
        return null;
    }

    public List<Type> allparams() {
        return List.nil();
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (((Type)l.head).isErroneous()) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isCompound() {
        return this.tsym.completer == null && (this.tsym.flags() & 0x1000000L) != 0L;
    }

    public boolean isInterface() {
        return (this.tsym.flags() & 0x200L) != 0L;
    }

    public boolean isFinal() {
        return (this.tsym.flags() & 0x10L) != 0L;
    }

    public boolean isPrimitive() {
        return this.tag < 9;
    }

    public boolean contains(Type t) {
        return t == this;
    }

    public static boolean contains(List<Type> ts, Type t) {
        List<Type> l = ts;
        while (l.tail != null) {
            if (((Type)l.head).contains(t)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean containsAny(List<Type> ts) {
        for (Type t : ts) {
            if (!this.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(List<Type> ts1, List<Type> ts2) {
        for (Type t : ts1) {
            if (!t.containsAny(ts2)) continue;
            return true;
        }
        return false;
    }

    public static List<Type> filter(List<Type> ts, Filter<Type> tf) {
        ListBuffer buf = ListBuffer.lb();
        for (Type t : ts) {
            if (!tf.accepts(t)) continue;
            buf.append(t);
        }
        return buf.toList();
    }

    public boolean isSuperBound() {
        return false;
    }

    public boolean isExtendsBound() {
        return false;
    }

    public boolean isUnbound() {
        return false;
    }

    public Type withTypeVar(Type t) {
        return this;
    }

    public MethodType asMethodType() {
        throw new AssertionError();
    }

    public void complete() {
    }

    public Symbol.TypeSymbol asElement() {
        return this.tsym;
    }

    @Override
    public TypeKind getKind() {
        switch (this.tag) {
            case 1: {
                return TypeKind.BYTE;
            }
            case 2: {
                return TypeKind.CHAR;
            }
            case 3: {
                return TypeKind.SHORT;
            }
            case 4: {
                return TypeKind.INT;
            }
            case 5: {
                return TypeKind.LONG;
            }
            case 6: {
                return TypeKind.FLOAT;
            }
            case 7: {
                return TypeKind.DOUBLE;
            }
            case 8: {
                return TypeKind.BOOLEAN;
            }
            case 9: {
                return TypeKind.VOID;
            }
            case 17: {
                return TypeKind.NULL;
            }
            case 18: {
                return TypeKind.NONE;
            }
        }
        return TypeKind.OTHER;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        if (this.isPrimitive()) {
            return v.visitPrimitive(this, p);
        }
        throw new AssertionError();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor<R, S> {
        public R visitClassType(ClassType var1, S var2);

        public R visitWildcardType(WildcardType var1, S var2);

        public R visitArrayType(ArrayType var1, S var2);

        public R visitMethodType(MethodType var1, S var2);

        public R visitPackageType(PackageType var1, S var2);

        public R visitTypeVar(TypeVar var1, S var2);

        public R visitCapturedType(CapturedType var1, S var2);

        public R visitForAll(ForAll var1, S var2);

        public R visitUndetVar(UndetVar var1, S var2);

        public R visitErrorType(ErrorType var1, S var2);

        public R visitType(Type var1, S var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ErrorType
    extends ClassType
    implements javax.lang.model.type.ErrorType {
        private Type originalType = null;

        public ErrorType(Type originalType, Symbol.TypeSymbol tsym) {
            this(originalType, tsym, false);
        }

        public ErrorType(Symbol.ClassSymbol c, Type originalType) {
            this(originalType, c, true);
        }

        public ErrorType(Type originalType, Symbol.TypeSymbol tsym, boolean modifyClassSym) {
            super(noType, List.<Type>nil(), tsym);
            this.tag = 19;
            Type type = this.originalType = originalType == null ? noType : originalType;
            if (modifyClassSym && tsym instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)tsym;
                c.type = this;
                c.kind = 31;
                c.members_field = new Scope.ErrorScope(c);
            }
        }

        public ErrorType(Name name, Symbol container, Type originalType) {
            this(new Symbol.ClassSymbol(0x40000009L, name, null, container), originalType);
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitErrorType(this, s);
        }

        @Override
        public Type constType(Object constValue) {
            return this;
        }

        @Override
        public Type getEnclosingType() {
            return this;
        }

        @Override
        public Type getReturnType() {
            return this;
        }

        public Type asSub(Symbol sym) {
            return this;
        }

        @Override
        public Type map(Mapping f) {
            return this;
        }

        public boolean isGenType(Type t) {
            return true;
        }

        @Override
        public boolean isErroneous() {
            return true;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @Override
        public List<Type> allparams() {
            return List.nil();
        }

        @Override
        public List<Type> getTypeArguments() {
            return List.nil();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ERROR;
        }

        public Type getOriginalType() {
            return this.originalType;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitError(this, p);
        }

        @Override
        public String toString() {
            if (this.tsym == null) {
                return "<error>";
            }
            if (this.tsym.type != this) {
                return this.tsym.name.table.names.any.toString();
            }
            return super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BottomType
    extends Type
    implements NullType {
        public BottomType() {
            super(17, null);
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NULL;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNull(this, p);
        }

        @Override
        public Type constType(Object value) {
            return this;
        }

        @Override
        public String stringValue() {
            return "null";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JCNoType
    extends Type
    implements NoType {
        public JCNoType(int tag) {
            super(tag, null);
        }

        @Override
        public TypeKind getKind() {
            switch (this.tag) {
                case 9: {
                    return TypeKind.VOID;
                }
                case 18: {
                    return TypeKind.NONE;
                }
            }
            throw new AssertionError((Object)("Unexpected tag: " + this.tag));
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public boolean isInterface() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UndetVar
    extends DelegatedType {
        public List<Type> lobounds = List.nil();
        public List<Type> hibounds = List.nil();
        public Type inst = null;

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitUndetVar(this, s);
        }

        public UndetVar(Type origin) {
            super(21, origin);
        }

        @Override
        public String toString() {
            if (this.inst != null) {
                return this.inst.toString();
            }
            return this.qtype + "?";
        }

        @Override
        public Type baseType() {
            if (this.inst != null) {
                return this.inst.baseType();
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForAll
    extends DelegatedType
    implements ExecutableType {
        public List<Type> tvars;

        public ForAll(List<Type> tvars, Type qtype) {
            super(16, qtype);
            this.tvars = tvars;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitForAll(this, s);
        }

        @Override
        public String toString() {
            return "<" + this.tvars + ">" + this.qtype;
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.tvars;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }

        public Type inst(List<Type> actuals, Types types) {
            return types.subst(this.qtype, this.tvars, actuals);
        }

        public List<Type> getConstraints(TypeVar tv, ConstraintKind ck) {
            return List.nil();
        }

        @Override
        public Type map(Mapping f) {
            return f.apply(this.qtype);
        }

        @Override
        public boolean contains(Type elem) {
            return this.qtype.contains(elem);
        }

        @Override
        public MethodType asMethodType() {
            return this.qtype.asMethodType();
        }

        @Override
        public void complete() {
            List<Type> l = this.tvars;
            while (l.nonEmpty()) {
                ((TypeVar)l.head).bound.complete();
                l = l.tail;
            }
            this.qtype.complete();
        }

        public List<TypeVar> getTypeVariables() {
            return List.convert(TypeVar.class, this.getTypeArguments());
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ConstraintKind {
            EXTENDS,
            SUPER,
            EQUAL;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DelegatedType
    extends Type {
        public Type qtype;

        public DelegatedType(int tag, Type qtype) {
            super(tag, qtype.tsym);
            this.qtype = qtype;
        }

        @Override
        public String toString() {
            return this.qtype.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.qtype.getTypeArguments();
        }

        @Override
        public Type getEnclosingType() {
            return this.qtype.getEnclosingType();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.qtype.getParameterTypes();
        }

        @Override
        public Type getReturnType() {
            return this.qtype.getReturnType();
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.qtype.getThrownTypes();
        }

        @Override
        public List<Type> allparams() {
            return this.qtype.allparams();
        }

        @Override
        public Type getUpperBound() {
            return this.qtype.getUpperBound();
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CapturedType
    extends TypeVar {
        public WildcardType wildcard;

        public CapturedType(Name name, Symbol owner, Type upper, Type lower, WildcardType wildcard) {
            super(name, owner, lower);
            this.lower = Assert.checkNonNull(lower);
            this.bound = upper;
            this.wildcard = wildcard;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitCapturedType(this, s);
        }

        @Override
        public boolean isCaptured() {
            return true;
        }

        @Override
        public String toString() {
            return "capture#" + ((long)this.hashCode() & 0xFFFFFFFFL) % 997L + " of " + this.wildcard;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeVar
    extends Type
    implements TypeVariable {
        public Type bound = null;
        public Type lower;
        int rank_field = -1;

        public TypeVar(Name name, Symbol owner, Type lower) {
            super(14, null);
            this.tsym = new Symbol.TypeSymbol(0L, name, this, owner);
            assert (lower != null);
            this.lower = lower;
        }

        public TypeVar(Symbol.TypeSymbol tsym, Type bound, Type lower) {
            super(14, tsym);
            assert (lower != null);
            this.bound = bound;
            this.lower = lower;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitTypeVar(this, s);
        }

        @Override
        public Type getUpperBound() {
            return this.bound;
        }

        @Override
        public Type getLowerBound() {
            return this.lower;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.TYPEVAR;
        }

        public boolean isCaptured() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitTypeVariable(this, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackageType
    extends Type
    implements NoType {
        PackageType(Symbol.TypeSymbol tsym) {
            super(13, tsym);
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitPackageType(this, s);
        }

        @Override
        public String toString() {
            return this.tsym.getQualifiedName().toString();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.PACKAGE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodType
    extends Type
    implements ExecutableType {
        public List<Type> argtypes;
        public Type restype;
        public List<Type> thrown;

        public MethodType(List<Type> argtypes, Type restype, List<Type> thrown, Symbol.TypeSymbol methodClass) {
            super(12, methodClass);
            this.argtypes = argtypes;
            this.restype = restype;
            this.thrown = thrown;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitMethodType(this, s);
        }

        @Override
        public String toString() {
            return "(" + this.argtypes + ")" + this.restype;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MethodType)) {
                return false;
            }
            MethodType m = (MethodType)obj;
            List<Type> args1 = this.argtypes;
            List<Type> args2 = m.argtypes;
            while (!args1.isEmpty() && !args2.isEmpty()) {
                if (!((Type)args1.head).equals(args2.head)) {
                    return false;
                }
                args1 = args1.tail;
                args2 = args2.tail;
            }
            if (!args1.isEmpty() || !args2.isEmpty()) {
                return false;
            }
            return this.restype.equals(m.restype);
        }

        @Override
        public int hashCode() {
            int h = 12;
            List<Type> thisargs = this.argtypes;
            while (thisargs.tail != null) {
                h = (h << 5) + ((Type)thisargs.head).hashCode();
                thisargs = thisargs.tail;
            }
            return (h << 5) + this.restype.hashCode();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.argtypes;
        }

        @Override
        public Type getReturnType() {
            return this.restype;
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.thrown;
        }

        @Override
        public boolean isErroneous() {
            return MethodType.isErroneous(this.argtypes) || this.restype != null && this.restype.isErroneous();
        }

        @Override
        public Type map(Mapping f) {
            List<Type> argtypes1 = MethodType.map(this.argtypes, f);
            Type restype1 = f.apply(this.restype);
            List<Type> thrown1 = MethodType.map(this.thrown, f);
            if (argtypes1 == this.argtypes && restype1 == this.restype && thrown1 == this.thrown) {
                return this;
            }
            return new MethodType(argtypes1, restype1, thrown1, this.tsym);
        }

        @Override
        public boolean contains(Type elem) {
            return elem == this || MethodType.contains(this.argtypes, elem) || this.restype.contains(elem);
        }

        @Override
        public MethodType asMethodType() {
            return this;
        }

        @Override
        public void complete() {
            List<Type> l = this.argtypes;
            while (l.nonEmpty()) {
                ((Type)l.head).complete();
                l = l.tail;
            }
            this.restype.complete();
            l = this.thrown;
            while (l.nonEmpty()) {
                ((Type)l.head).complete();
                l = l.tail;
            }
        }

        public List<TypeVar> getTypeVariables() {
            return List.nil();
        }

        @Override
        public Symbol.TypeSymbol asElement() {
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayType
    extends Type
    implements javax.lang.model.type.ArrayType {
        public Type elemtype;

        public ArrayType(Type elemtype, Symbol.TypeSymbol arrayClass) {
            super(11, arrayClass);
            this.elemtype = elemtype;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitArrayType(this, s);
        }

        @Override
        public String toString() {
            return this.elemtype + "[]";
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj instanceof ArrayType && this.elemtype.equals(((ArrayType)obj).elemtype);
        }

        @Override
        public int hashCode() {
            return 352 + this.elemtype.hashCode();
        }

        public boolean isVarargs() {
            return false;
        }

        @Override
        public List<Type> allparams() {
            return this.elemtype.allparams();
        }

        @Override
        public boolean isErroneous() {
            return this.elemtype.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.elemtype.isParameterized();
        }

        @Override
        public boolean isRaw() {
            return this.elemtype.isRaw();
        }

        public ArrayType makeVarargs() {
            return new ArrayType(this.elemtype, this.tsym){

                public boolean isVarargs() {
                    return true;
                }
            };
        }

        @Override
        public Type map(Mapping f) {
            Type elemtype1 = f.apply(this.elemtype);
            if (elemtype1 == this.elemtype) {
                return this;
            }
            return new ArrayType(elemtype1, this.tsym);
        }

        @Override
        public boolean contains(Type elem) {
            return elem == this || this.elemtype.contains(elem);
        }

        @Override
        public void complete() {
            this.elemtype.complete();
        }

        @Override
        public Type getComponentType() {
            return this.elemtype;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ARRAY;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitArray(this, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnionClassType
    extends ClassType
    implements UnionType {
        final List<? extends Type> alternatives_field;

        public UnionClassType(ClassType ct, List<? extends Type> alternatives) {
            super(ct.outer_field, ct.typarams_field, ct.tsym);
            this.allparams_field = ct.allparams_field;
            this.supertype_field = ct.supertype_field;
            this.interfaces_field = ct.interfaces_field;
            this.all_interfaces_field = ct.interfaces_field;
            this.alternatives_field = alternatives;
        }

        public Type getLub() {
            return this.tsym.type;
        }

        @Override
        public java.util.List<? extends TypeMirror> getAlternatives() {
            return Collections.unmodifiableList(this.alternatives_field);
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.UNION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitUnion(this, p);
        }
    }

    public static class ErasedClassType
    extends ClassType {
        public ErasedClassType(Type outer, Symbol.TypeSymbol tsym) {
            super(outer, List.<Type>nil(), tsym);
        }

        public boolean hasErasedSupertypes() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends Type
    implements DeclaredType {
        private Type outer_field;
        public List<Type> typarams_field;
        public List<Type> allparams_field;
        public Type supertype_field;
        public List<Type> interfaces_field;
        public List<Type> all_interfaces_field;
        int rank_field = -1;

        public ClassType(Type outer, List<Type> typarams, Symbol.TypeSymbol tsym) {
            super(10, tsym);
            this.outer_field = outer;
            this.typarams_field = typarams;
            this.allparams_field = null;
            this.supertype_field = null;
            this.interfaces_field = null;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitClassType(this, s);
        }

        @Override
        public Type constType(Object constValue) {
            final Object value = constValue;
            return new ClassType(this.getEnclosingType(), this.typarams_field, this.tsym){

                public Object constValue() {
                    return value;
                }

                public Type baseType() {
                    return this.tsym.type;
                }
            };
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.getEnclosingType().tag == 10 && this.tsym.owner.kind == 2) {
                buf.append(this.getEnclosingType().toString());
                buf.append(".");
                buf.append(this.className(this.tsym, false));
            } else {
                buf.append(this.className(this.tsym, true));
            }
            if (((List)this.getTypeArguments()).nonEmpty()) {
                buf.append('<');
                buf.append(((List)this.getTypeArguments()).toString());
                buf.append(">");
            }
            return buf.toString();
        }

        private String className(Symbol sym, boolean longform) {
            if (sym.name.isEmpty() && (sym.flags() & 0x1000000L) != 0L) {
                StringBuilder s = new StringBuilder(this.supertype_field.toString());
                List<Type> is = this.interfaces_field;
                while (is.nonEmpty()) {
                    s.append("&");
                    s.append(((Type)is.head).toString());
                    is = is.tail;
                }
                return s.toString();
            }
            if (sym.name.isEmpty()) {
                ClassType norm = (ClassType)this.tsym.type;
                String s = norm == null ? Log.getLocalizedString("anonymous.class", new Object[]{null}) : (norm.interfaces_field != null && norm.interfaces_field.nonEmpty() ? Log.getLocalizedString("anonymous.class", norm.interfaces_field.head) : Log.getLocalizedString("anonymous.class", norm.supertype_field));
                if (moreInfo) {
                    s = s + String.valueOf(sym.hashCode());
                }
                return s;
            }
            if (longform) {
                return sym.getQualifiedName().toString();
            }
            return sym.name.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            if (this.typarams_field == null) {
                try {
                    this.complete();
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    // empty catch block
                }
                if (this.typarams_field == null) {
                    this.typarams_field = List.nil();
                }
            }
            return this.typarams_field;
        }

        public boolean hasErasedSupertypes() {
            return this.isRaw();
        }

        @Override
        public Type getEnclosingType() {
            return this.outer_field;
        }

        public void setEnclosingType(Type outer) {
            this.outer_field = outer;
        }

        @Override
        public List<Type> allparams() {
            if (this.allparams_field == null) {
                Type enclosingType = this.getEnclosingType();
                this.allparams_field = enclosingType == null ? this.getTypeArguments() : ((List)this.getTypeArguments()).prependList(enclosingType.allparams());
            }
            return this.allparams_field;
        }

        @Override
        public boolean isErroneous() {
            return this.getEnclosingType().isErroneous() || ClassType.isErroneous((List<Type>)this.getTypeArguments()) || this != this.tsym.type && this.tsym.type.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.allparams().tail != null;
        }

        @Override
        public boolean isRaw() {
            return this != this.tsym.type && this.tsym.type.allparams().nonEmpty() && this.allparams().isEmpty();
        }

        @Override
        public Type map(Mapping f) {
            Type outer = this.getEnclosingType();
            Type outer1 = f.apply(outer);
            java.util.List typarams = this.getTypeArguments();
            List<Type> typarams1 = ClassType.map((List<Type>)typarams, f);
            if (outer1 == outer && typarams1 == typarams) {
                return this;
            }
            return new ClassType(outer1, typarams1, this.tsym);
        }

        @Override
        public boolean contains(Type elem) {
            return elem == this || this.isParameterized() && (this.getEnclosingType().contains(elem) || ClassType.contains((List<Type>)this.getTypeArguments(), elem)) || this.isCompound() && (this.supertype_field.contains(elem) || ClassType.contains(this.interfaces_field, elem));
        }

        @Override
        public void complete() {
            if (this.tsym.completer != null) {
                this.tsym.complete();
            }
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.DECLARED;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitDeclared(this, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WildcardType
    extends Type
    implements javax.lang.model.type.WildcardType {
        public Type type;
        public BoundKind kind;
        public TypeVar bound;
        boolean isPrintingBound = false;

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitWildcardType(this, s);
        }

        public WildcardType(Type type, BoundKind kind, Symbol.TypeSymbol tsym) {
            super(15, tsym);
            this.type = Assert.checkNonNull(type);
            this.kind = kind;
        }

        public WildcardType(WildcardType t, TypeVar bound) {
            this(t.type, t.kind, t.tsym, bound);
        }

        public WildcardType(Type type, BoundKind kind, Symbol.TypeSymbol tsym, TypeVar bound) {
            this(type, kind, tsym);
            this.bound = bound;
        }

        @Override
        public boolean contains(Type t) {
            return this.kind != BoundKind.UNBOUND && this.type.contains(t);
        }

        @Override
        public boolean isSuperBound() {
            return this.kind == BoundKind.SUPER || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isExtendsBound() {
            return this.kind == BoundKind.EXTENDS || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isUnbound() {
            return this.kind == BoundKind.UNBOUND;
        }

        @Override
        public Type withTypeVar(Type t) {
            if (this.bound == t) {
                return this;
            }
            this.bound = (TypeVar)t;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.kind.toString());
            if (this.kind != BoundKind.UNBOUND) {
                s.append(this.type);
            }
            if (moreInfo && this.bound != null && !this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    s.append("{:").append(this.bound.bound).append(":}");
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return s.toString();
        }

        @Override
        public Type map(Mapping f) {
            Type t = this.type;
            if (t != null) {
                t = f.apply(t);
            }
            if (t == this.type) {
                return this;
            }
            return new WildcardType(t, this.kind, this.tsym, this.bound);
        }

        @Override
        public Type getExtendsBound() {
            if (this.kind == BoundKind.EXTENDS) {
                return this.type;
            }
            return null;
        }

        @Override
        public Type getSuperBound() {
            if (this.kind == BoundKind.SUPER) {
                return this.type;
            }
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.WILDCARD;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }
    }

    public static abstract class Mapping {
        private String name;

        public Mapping(String name) {
            this.name = name;
        }

        public abstract Type apply(Type var1);

        public String toString() {
            return this.name;
        }
    }
}

