/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

final class RootNodeChildren
extends Children.Keys<TestsuiteNode> {
    private volatile int filterMask;
    private Collection<Report> reports;
    private volatile int passedSuites;
    private volatile int failedSuites;
    private volatile boolean live = false;
    private String runningSuiteName;
    private TestsuiteNode runningSuiteNode;
    private final TestSession session;
    private List<TestsuiteNode> suiteNodes = new ArrayList<TestsuiteNode>();
    private static final TestsuiteNode[] EMPTY_NODE_ARRAY = new TestsuiteNode[0];

    RootNodeChildren(TestSession session, int filterMask) {
        this.filterMask = filterMask;
        this.session = session;
    }

    void displaySuiteRunning(String suiteName) {
        assert (EventQueue.isDispatchThread());
        this.runningSuiteName = suiteName;
        if (this.live) {
            this.runningSuiteNode = this.session.getNodeFactory().createTestSuiteNode(suiteName, this.filterMask != 0);
            this.runningSuiteNode.setFilterMask(this.filterMask);
            this.suiteNodes.add(this.runningSuiteNode);
            this.addNotify();
        }
        assert (this.runningSuiteName != null);
        assert (this.runningSuiteNode != null == this.live);
    }

    void displaySuiteRunning(TestSuite suite) {
        assert (EventQueue.isDispatchThread());
        this.runningSuiteName = suite.getName();
        if (this.live) {
            this.runningSuiteNode = this.session.getNodeFactory().createTestSuiteNode(suite.getName(), this.filterMask != 0);
            this.runningSuiteNode.setFilterMask(this.filterMask);
            this.runningSuiteNode.setSuite(suite);
            this.suiteNodes.add(this.runningSuiteNode);
            this.addNotify();
        }
        assert (this.runningSuiteName != null);
        assert (this.runningSuiteNode != null == this.live);
    }

    Collection<Report> getReports() {
        return this.reports;
    }

    public TestsuiteNode displayReport(Report report) {
        TestsuiteNode correspondingNode;
        assert (EventQueue.isDispatchThread());
        assert (this.runningSuiteNode != null == (this.live && this.runningSuiteName != null)) : "runningSuiteNode: " + (Object)((Object)this.runningSuiteNode) + ", live: " + this.live + ", runningSuiteName: " + this.runningSuiteName;
        if (this.reports == null) {
            this.reports = new ArrayList<Report>(10);
        }
        if (!this.reports.contains(report)) {
            this.reports.add(report);
        }
        boolean isPassedSuite = this.updateStatistics(report);
        if (this.runningSuiteName != null) {
            if (this.live) {
                correspondingNode = this.runningSuiteNode;
                if (report.completed || !this.isMaskApplied(report, this.filterMask)) {
                    correspondingNode.displayReport(report);
                }
                if (report.completed && this.isMaskApplied(report, this.filterMask)) {
                    this.runningSuiteNode = null;
                    this.refreshKey((Object)correspondingNode);
                }
            } else {
                correspondingNode = null;
            }
        } else if (!(!this.live || report.completed && this.isMaskApplied(report, this.filterMask))) {
            correspondingNode = this.getNode(report);
            this.refreshKey((Object)correspondingNode);
        } else {
            correspondingNode = null;
        }
        if (report.completed) {
            this.runningSuiteName = null;
            this.runningSuiteNode = null;
        }
        return correspondingNode;
    }

    void displayReports(Collection<Report> newReports) {
        assert (EventQueue.isDispatchThread());
        if (this.reports == null) {
            this.reports = new ArrayList<Report>(newReports);
        } else {
            this.reports.addAll(newReports);
        }
        if (!this.live) {
            for (Report report : this.reports) {
                this.updateStatistics(report);
            }
        } else {
            if (this.filterMask == 0) {
                Node[] nodesToAdd = new Node[newReports.size()];
                int index = 0;
                for (Report report : newReports) {
                    this.updateStatistics(report);
                    nodesToAdd[index++] = this.getNode(report);
                }
            } else {
                ArrayList<TestsuiteNode> toAdd = new ArrayList<TestsuiteNode>(newReports.size());
                for (Report report : newReports) {
                    boolean isFailed = !this.updateStatistics(report);
                    if (!isFailed) continue;
                    toAdd.add(this.getNode(report));
                }
                if (!toAdd.isEmpty()) {
                    Node[] nodeArray = toAdd.toArray(new Node[toAdd.size()]);
                }
            }
            this.addNotify();
        }
    }

    private boolean updateStatistics(Report report) {
        this.passedSuites = 0;
        this.failedSuites = 0;
        for (Report rep : this.reports) {
            boolean isPassedSuite;
            boolean bl = isPassedSuite = !rep.containsFailed();
            if (isPassedSuite) {
                ++this.passedSuites;
                continue;
            }
            ++this.failedSuites;
        }
        return !report.containsFailed();
    }

    protected void addNotify() {
        super.addNotify();
        this.live = true;
        this.setKeys(this.suiteNodes);
    }

    protected void removeNotify() {
        super.removeNotify();
        this.live = false;
        this.setKeys((Object[])EMPTY_NODE_ARRAY);
    }

    private TestsuiteNode getNode(Report report) {
        for (TestsuiteNode node : this.suiteNodes) {
            if (node.getReport() != report) continue;
            return node;
        }
        TestsuiteNode node = new TestsuiteNode(report, this.filterMask != 0);
        node.setFilterMask(this.filterMask);
        this.suiteNodes.add(node);
        return node;
    }

    synchronized void setFilterMask(int filterMask) {
        assert (EventQueue.isDispatchThread());
        if (filterMask == this.filterMask) {
            return;
        }
        this.filterMask = filterMask;
        if (!this.live || this.reports == null) {
            return;
        }
        for (TestsuiteNode suite : this.suiteNodes) {
            suite.setFilterMask(filterMask);
            this.refreshKey((Object)suite);
        }
    }

    protected Node[] createNodes(TestsuiteNode suite) {
        Report report = suite.getReport();
        if (suite != this.runningSuiteNode && report != null && this.isMaskApplied(report, this.filterMask)) {
            return EMPTY_NODE_ARRAY;
        }
        return new Node[]{suite};
    }

    private boolean isMaskApplied(Report report, int mask) {
        return (report.getStatusMask() & ~mask) == 0;
    }
}

