/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.common;

import com.sun.javacard.AID;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.common.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class AIDPanel
extends JPanel
implements DocumentListener,
FocusListener,
ActionListener {
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    boolean firing;
    private String pkg = Utils.generateRandomPackageName();
    private String clazz = "MyApplet";
    private String problem;
    private JLabel aidLabel;
    private JButton generateButton;
    private JTextField pixField;
    private JLabel pixHint;
    private JTextField ridField;
    private JLabel ridHint;
    private JLabel slash;
    private JPanel spacer;
    private JLabel titleLabel;

    public AIDPanel() {
        this.initComponents();
        Mnemonics.setLocalizedText((AbstractButton)this.generateButton, (String)this.generateButton.getText());
        GuiUtils.filterNonHexadecimalKeys(this.pixField);
        GuiUtils.filterNonHexadecimalKeys(this.ridField);
        this.pixField.getDocument().addDocumentListener(this);
        this.ridField.getDocument().addDocumentListener(this);
        this.getAID();
        this.pixField.addFocusListener(this);
        this.ridField.addFocusListener(this);
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.EditAppletAID");
    }

    public void removeChangeListener(ChangeListener listener) {
        this.supp.removeChangeListener(listener);
    }

    private void change() {
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        if (this.firing) {
            return;
        }
        this.firing = true;
        try {
            this.supp.fireChange();
        }
        finally {
            this.firing = false;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.supp.addChangeListener(listener);
    }

    @Override
    public void setEnabled(boolean val) {
        super.setEnabled(val);
        for (Component c : this.getComponents()) {
            c.setEnabled(val);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.pixField.requestFocus();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.spacer != null) {
            this.spacer.setBackground(c);
        }
    }

    public void setClassFqn(String clazz) {
        int ix = clazz.lastIndexOf(46);
        if (ix > 0 && ix != clazz.length() - 1) {
            this.clazz = clazz.substring(ix + 1);
            this.pkg = clazz.substring(0, ix);
        } else {
            this.clazz = clazz;
            this.pkg = clazz;
        }
    }

    public void setAID(AID aid) {
        if (aid == null) {
            this.ridField.setText(Utils.getDefaultRIDasString());
            this.pixField.setText("");
        } else {
            this.pixField.setText(aid.getPixAsString());
            this.ridField.setText(aid.getRidAsString());
        }
        this.getAID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AID getAID() {
        String prob = this.problem;
        try {
            String aidString = "//aid/" + this.ridField.getText() + '/' + this.pixField.getText();
            try {
                AID result = AID.parse((String)aidString);
                this.problem = null;
                AID aID = result;
                return aID;
            }
            catch (IllegalArgumentException e) {
                this.problem = e.getMessage();
                AID aID = null;
                if (prob == null ? this.problem != null : !prob.equals(this.problem)) {
                    this.fireChange();
                }
                return aID;
            }
        }
        finally {
            if (prob == null ? this.problem != null : !prob.equals(this.problem)) {
                this.fireChange();
            }
        }
    }

    public String getProblem() {
        return this.problem;
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
        this.getAccessibleContext().setAccessibleName(title);
    }

    public void setGenerateButtonVisible(boolean val) {
        this.generateButton.setVisible(val);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        super.addFocusListener(fl);
        if (this.ridField != null) {
            this.ridField.addFocusListener(fl);
        }
        if (this.pixField != null) {
            this.pixField.addFocusListener(fl);
        }
    }

    @Override
    public void removeFocusListener(FocusListener fl) {
        super.removeFocusListener(fl);
        if (this.ridField != null) {
            this.ridField.removeFocusListener(fl);
        }
        if (this.pixField != null) {
            this.pixField.removeFocusListener(fl);
        }
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        super.addMouseListener(ml);
        if (this.ridField != null) {
            this.ridField.addMouseListener(ml);
        }
        if (this.pixField != null) {
            this.pixField.addMouseListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        super.removeMouseListener(ml);
        if (this.ridField != null) {
            this.ridField.removeMouseListener(ml);
        }
        if (this.pixField != null) {
            this.pixField.removeMouseListener(ml);
        }
    }

    private void initComponents() {
        this.aidLabel = new JLabel();
        this.ridField = new JTextField();
        this.slash = new JLabel();
        this.pixField = new JTextField();
        this.ridHint = new JLabel();
        this.pixHint = new JLabel();
        this.generateButton = new JButton();
        this.titleLabel = new JLabel();
        this.spacer = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setToolTipText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.toolTipText", (Object[])new Object[0]));
        this.setLayout(new GridBagLayout());
        this.aidLabel.setText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.aidLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.aidLabel, gridBagConstraints);
        this.ridField.setText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.ridField.text"));
        this.ridField.setToolTipText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.ridField.toolTipText", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.ridField, gridBagConstraints);
        this.slash.setText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.slash.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.slash, gridBagConstraints);
        this.pixField.setText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.pixField.text"));
        this.pixField.setToolTipText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.pixField.toolTipText", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.pixField, gridBagConstraints);
        this.ridHint.setFont(this.ridHint.getFont().deriveFont(this.ridHint.getFont().getStyle() | 2));
        this.ridHint.setHorizontalAlignment(0);
        this.ridHint.setText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.ridHint.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        this.add((Component)this.ridHint, gridBagConstraints);
        this.pixHint.setFont(this.pixHint.getFont().deriveFont(this.pixHint.getFont().getStyle() | 2));
        this.pixHint.setHorizontalAlignment(0);
        this.pixHint.setText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.pixHint.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        this.add((Component)this.pixHint, gridBagConstraints);
        this.generateButton.setText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.generateButton.text"));
        this.generateButton.setToolTipText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.generateButton.toolTipText", (Object[])new Object[0]));
        this.generateButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.generateButton, gridBagConstraints);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.titleLabel.getFont().getStyle() | 1));
        this.titleLabel.setLabelFor(this.ridField);
        this.titleLabel.setText(NbBundle.getMessage(AIDPanel.class, (String)"AIDPanel.titleLabel.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.titleLabel, gridBagConstraints);
        GroupLayout spacerLayout = new GroupLayout(this.spacer);
        this.spacer.setLayout(spacerLayout);
        spacerLayout.setHorizontalGroup(spacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 512, Short.MAX_VALUE));
        spacerLayout.setVerticalGroup(spacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 4, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spacer, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.generateButton) {
            this.generateButtonActionPerformed(evt);
        }
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        AID old = this.getAID();
        AID aid = Utils.generateAppletAID(this.pkg, this.clazz);
        if (old != null && old.equals((Object)aid)) {
            aid = Utils.generateRandomAppletAid(this.clazz);
        }
        this.setAID(aid);
        this.getAID();
        this.fireChange();
    }

    public void generateAid() {
        this.generateButtonActionPerformed(null);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.change();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.change();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.change();
    }

    @Override
    public void focusGained(FocusEvent e) {
        ((JTextComponent)e.getComponent()).selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

