/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.whitelist.WhiteListQuery;
import org.netbeans.api.whitelist.index.WhiteListIndex;
import org.netbeans.modules.j2ee.common.project.Bundle;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.whitelist.WhiteListQueryImplementation;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public final class WhiteListUpdater
implements PropertyChangeListener {
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    private static final RequestProcessor rp = new RequestProcessor();
    private Project p;
    private PropertyEvaluator eval;
    private String lastWhiteList;

    private WhiteListUpdater(Project p, PropertyEvaluator eval) {
        this.p = p;
        this.eval = eval;
        this.lastWhiteList = this.getServerWhiteList();
        eval.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public static WhiteListUpdater createWhiteListUpdater(Project p, PropertyEvaluator e) {
        return new WhiteListUpdater(p, e);
    }

    private void updateWhitelist(final String oldWhiteListId, final String newWhiteListId) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                WhiteListUpdater.this.updateWhitelist(WhiteListUpdater.this.p, oldWhiteListId, newWhiteListId);
            }
        });
    }

    private void updateWhitelist(Project p, String oldWhiteListId, String newWhiteListId) {
        ArrayList<Project> projs = new ArrayList<Project>();
        projs.add(p);
        projs.addAll(((SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class)).getSubprojects());
        for (Project pp : projs) {
            if (oldWhiteListId != null) {
                WhiteListQuery.enableWhiteListInProject((Project)pp, (String)oldWhiteListId, (boolean)false);
            }
            if (newWhiteListId == null) continue;
            WhiteListQuery.enableWhiteListInProject((Project)pp, (String)newWhiteListId, (boolean)true);
        }
    }

    private void checkWhiteLists() {
        String newWhiteList = this.getServerWhiteList();
        if (newWhiteList == null && this.lastWhiteList == null || newWhiteList != null && this.lastWhiteList != null && newWhiteList.equals(this.lastWhiteList)) {
            return;
        }
        this.updateWhitelist(this.lastWhiteList, newWhiteList);
        this.lastWhiteList = newWhiteList;
    }

    private String getServerWhiteList() {
        String servInstID = this.eval.getProperty(J2EE_SERVER_INSTANCE);
        if (servInstID != null) {
            try {
                J2eePlatform platform = Deployment.getDefault().getServerInstance(servInstID).getJ2eePlatform();
                WhiteListQueryImplementation.UserSelectable sw = (WhiteListQueryImplementation.UserSelectable)platform.getLookup().lookup(WhiteListQueryImplementation.UserSelectable.class);
                if (sw != null) {
                    return sw.getId();
                }
            }
            catch (InstanceRemovedException instanceRemovedException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(J2EE_SERVER_INSTANCE)) {
            this.checkWhiteLists();
        }
        if (evt.getPropertyName().equals("javac.classpath")) {
            this.updateWhitelist(null, this.getServerWhiteList());
        }
    }

    public static boolean isWhitelistViolated(Project p) {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)p).getSourceGroups("java");
        if (sgs.length == 0) {
            return false;
        }
        Collection problems = WhiteListIndex.getDefault().getWhiteListViolations(sgs[0].getRootFolder(), null, new String[]{"oracle"});
        return problems.size() > 0 && DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_WhitelistViolations(), Bundle.MSG_Dialog_Title())) != NotifyDescriptor.YES_OPTION;
    }
}

