/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.css.visual.api.CssPreviewComponent;
import org.netbeans.modules.css.visual.api.CssPreviewComponentFactory;
import org.netbeans.modules.css.visual.api.CssRuleContext;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewGenerator;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class CssPreviewTopComponent
extends TopComponent {
    private static CssPreviewTopComponent instance;
    private static final Logger LOGGER;
    static final String ICON_PATH = "org/netbeans/modules/css/resources/style_sheet_16.png";
    private static final String PREFERRED_ID = "CssPreviewTC";
    private CssPreviewComponent previewPanel;
    private static final String DEFAULT_TC_NAME;
    private JPanel NO_PREVIEW_PANEL;
    private JPanel PREVIEW_ERROR_PANEL;
    private JPanel NO_PREVIEW_COMPONENT_PANEL;
    private boolean previewing;
    private boolean error;
    private SAXParser parserInstance;
    private PropertyChangeListener FACTORY_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CssPreviewTopComponent.this.refreshCssPreviewComponent();
        }
    };

    public void activate(final CssRuleContext content) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.previewPanel == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Previewable activated - POSTING activate task {0}", content);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                final File baseFile = content.base();
                final String title = CssPreviewTopComponent.this.getTitle(content);
                final CharSequence htmlCode = CssPreviewGenerator.getPreviewCode(content);
                final SAXParser parser = CssPreviewTopComponent.this.getParser();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CssPreviewTopComponent.this.preview(baseFile, title, htmlCode, parser);
                    }
                });
            }
        });
    }

    public void deactivate() {
        assert (SwingUtilities.isEventDispatchThread());
        LOGGER.log(Level.FINE, "Preview deactivated");
        this.setNoSelectedRule();
    }

    private CssPreviewTopComponent() {
        this.initComponents();
        this.setToolTipText(NbBundle.getMessage(CssPreviewTopComponent.class, (String)"HINT_CssPreviewTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.NO_PREVIEW_PANEL = this.makeMsgPanel(NbBundle.getBundle((String)"org/netbeans/modules/css/visual/ui/preview/Bundle").getString("No_Preview"));
        this.add(this.NO_PREVIEW_PANEL, "Center");
        this.previewing = false;
        this.error = false;
        this.PREVIEW_ERROR_PANEL = this.makeMsgPanel(NbBundle.getBundle((String)"org/netbeans/modules/css/visual/ui/preview/Bundle").getString("Preview_Error"));
        this.NO_PREVIEW_COMPONENT_PANEL = this.makeMsgPanel(NbBundle.getBundle((String)"org/netbeans/modules/css/visual/ui/preview/Bundle").getString("NoCssPreviewComponent"));
        this.setName(DEFAULT_TC_NAME);
        this.refreshCssPreviewComponent();
    }

    private void refreshCssPreviewComponent() {
        if (this.previewPanel != null) {
            this.previewPanel.dispose();
            this.remove(this.previewPanel.getComponent());
        }
        Collection factories = Lookup.getDefault().lookupAll(CssPreviewComponentFactory.class);
        for (CssPreviewComponentFactory factory : factories) {
            factory.addPropertyChangeListener(this.FACTORY_LISTENER);
            this.previewPanel = factory.createCssPreviewComponent();
            if (this.previewPanel == null) continue;
            break;
        }
        if (this.previewPanel != null) {
            this.add(this.previewPanel.getComponent(), "Center");
            this.revalidate();
            this.repaint();
        } else {
            this.setNoPreviewComponent();
        }
    }

    private JPanel makeMsgPanel(String message) {
        JPanel p = new JPanel();
        p.setBackground(Color.WHITE);
        p.setLayout(new BorderLayout());
        JLabel msgLabel = new JLabel(message);
        p.add((Component)msgLabel, "Center");
        msgLabel.setHorizontalAlignment(0);
        return p;
    }

    private void setNoSelectedRule() {
        if (this.previewing || this.error) {
            this.setName(DEFAULT_TC_NAME);
            LOGGER.log(Level.FINE, "Previewable deactivated");
            this.removeAll();
            this.add(this.NO_PREVIEW_PANEL, "Center");
            this.previewing = false;
            this.error = false;
            this.revalidate();
            this.repaint();
        }
    }

    private void setNoPreviewComponent() {
        this.setName(DEFAULT_TC_NAME);
        LOGGER.log(Level.FINE, "No CssPreviewComponent!");
        this.removeAll();
        this.add(this.NO_PREVIEW_COMPONENT_PANEL, "Center");
        this.previewing = false;
        this.error = false;
        this.revalidate();
        this.repaint();
    }

    void setError() {
        if (!this.error) {
            this.setName(DEFAULT_TC_NAME);
            LOGGER.log(Level.FINE, "Previewable error occured.");
            this.removeAll();
            this.add(this.PREVIEW_ERROR_PANEL, "Center");
            this.previewing = false;
            this.error = true;
            this.revalidate();
            this.repaint();
        }
    }

    private void setPreviewing(String title) {
        this.setName(title);
        this.removeAll();
        this.add(this.previewPanel.getComponent(), "Center");
        this.previewing = true;
        this.error = false;
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized CssPreviewTopComponent getDefault() {
        if (instance == null) {
            instance = new CssPreviewTopComponent();
        }
        return instance;
    }

    public static synchronized CssPreviewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(CssPreviewTopComponent.class.getName()).warning("Cannot find CssPreviewTC component. It will not be located properly in the window system.");
            return CssPreviewTopComponent.getDefault();
        }
        if (win instanceof CssPreviewTopComponent) {
            return (CssPreviewTopComponent)win;
        }
        Logger.getLogger(CssPreviewTopComponent.class.getName()).warning("There seem to be multiple components with the 'CssPreviewTC' ID. That is a potential source of errors and unexpected behavior.");
        return CssPreviewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    private String getTitle(CssRuleContext content) {
        if (content != null && content.selectedRuleContent() != null) {
            return content.selectedRuleContent().rule().name() + " - " + DEFAULT_TC_NAME;
        }
        return DEFAULT_TC_NAME;
    }

    private synchronized SAXParser getParser() {
        if (this.parserInstance == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                this.parserInstance = factory.newSAXParser();
            }
            catch (ParserConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.parserInstance;
    }

    private void preview(File source, String title, CharSequence htmlCode, SAXParser parser) {
        InputSource inputSource;
        assert (SwingUtilities.isEventDispatchThread());
        if (this.previewPanel == null) {
            return;
        }
        if (parser != null) {
            try {
                DefaultHandler handler = new DefaultHandler();
                inputSource = new InputSource(new StringReader(((Object)htmlCode).toString()));
                parser.parse(inputSource, handler);
            }
            catch (SAXException ex) {
                LOGGER.log(Level.INFO, "There is an error in the generated sample document.", ex);
                LOGGER.log(Level.INFO, "Errorneous preview sample code:\n---------------------------------\n{0}", htmlCode);
                this.setError();
                return;
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        this.setPreviewing(title);
        try {
            String relativeURL = null;
            if (source != null) {
                relativeURL = source.toURI().toURL().toExternalForm();
            }
            LOGGER.log(Level.FINE, "preview - setting content {0}", htmlCode);
            inputSource = new InputSource(new StringReader(((Object)htmlCode).toString()));
            this.previewPanel.setDocument(inputSource, relativeURL);
        }
        catch (Throwable e) {
            this.setError();
            LOGGER.log(Level.INFO, "An error occured in the preview component.", e);
            LOGGER.log(Level.INFO, "Errorneous preview sample code:\n---------------------------------\n{0}", htmlCode);
        }
    }

    public void componentClosed() {
        if (this.previewPanel != null) {
            this.previewPanel.dispose();
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        LOGGER = Logger.getLogger("css.visual");
        DEFAULT_TC_NAME = NbBundle.getMessage(CssPreviewTopComponent.class, (String)"CTL_CssPreviewTopComponent");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return CssPreviewTopComponent.getDefault();
        }
    }
}

