/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.css.editor.api.CssCslParserResult;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.visual.CssEditorSupport;
import org.netbeans.modules.css.visual.ui.preview.CssTCController;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public final class CssCaretAwareSourceTask
extends ParserResultTask<CssCslParserResult> {
    private static CssTCController windowController;
    private static final String CSS_MIMETYPE = "text/x-css";
    private boolean cancelled;

    private static synchronized void initializeWindowController() {
        if (windowController == null) {
            windowController = CssTCController.getDefault();
        }
    }

    public int getPriority() {
        return 5000;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CssCslParserResult result, SchedulerEvent event) {
        Node leaf;
        this.cancelled = false;
        if (event == null) {
            return;
        }
        if (!(event instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        int caretOffset = ((CursorMovedSchedulerEvent)event).getCaretOffset();
        Node root = result.getParseTree();
        if (root != null && (leaf = NodeUtil.findNodeAtOffset((Node)root, (int)caretOffset)) != null) {
            Node ruleNode;
            Node node = ruleNode = leaf.type() == NodeType.ruleSet ? leaf : NodeUtil.getAncestorByType((Node)leaf, (NodeType)NodeType.ruleSet);
            if (ruleNode != null) {
                List errors = result.getDiagnostics();
                for (Error e : errors) {
                    if (e.getSeverity() != Severity.ERROR || ruleNode.from() > e.getStartPosition() || ruleNode.to() < e.getEndPosition()) continue;
                    CssEditorSupport.getDefault().parsedWithError(result);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                CssEditorSupport.getDefault().parsed(result, ((CursorMovedSchedulerEvent)event).getCaretOffset());
                return;
            }
        }
        if (this.cancelled) {
            return;
        }
        CssEditorSupport.getDefault().parsed(result, ((CursorMovedSchedulerEvent)event).getCaretOffset());
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            CssCaretAwareSourceTask.initializeWindowController();
            String mimeType = snapshot.getMimeType();
            String sourceMimeType = snapshot.getSource().getMimeType();
            if (sourceMimeType.equals(CssCaretAwareSourceTask.CSS_MIMETYPE) && mimeType.equals(CssCaretAwareSourceTask.CSS_MIMETYPE)) {
                return Collections.singletonList(new CssCaretAwareSourceTask());
            }
            return Collections.emptyList();
        }
    }
}

