/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public class CPUSamplingDataFrameProcessor
extends AbstractDataFrameProcessor {
    private volatile int currentThreadId = -1;
    private String currentThreadName;
    private String currentThreadClassName;
    private StackTraceSnapshotBuilder.SampledThreadInfo currentThread;
    private long currentTimestamp;
    private Map<Integer, ThreadInfo> currentThreadsDump;
    private Map<Integer, ThreadInfo> lastThreadsDump;
    private List<ThreadDump> threadDumps = new ArrayList<ThreadDump>();
    private MethodNameFormatter formatter = MethodNameFormatterFactory.getDefault(new DefaultMethodNameFormatter(4)).getFormatter();
    private StackTraceSnapshotBuilder builder;

    @Override
    public void doProcessDataFrame(byte[] buffer) {
        int position = 0;
        JMethodIdTable methodIdsTable = JMethodIdTable.getDefault();
        this.threadDumps = new ArrayList<ThreadDump>();
        while (position < buffer.length) {
            byte eventType = buffer[position++];
            switch (eventType) {
                case 28: {
                    this.currentThreadsDump = new HashMap<Integer, ThreadInfo>();
                    this.currentTimestamp = ((long)buffer[position++] & 0xFFL) << 48 | ((long)buffer[position++] & 0xFFL) << 40 | ((long)buffer[position++] & 0xFFL) << 32 | ((long)buffer[position++] & 0xFFL) << 24 | ((long)buffer[position++] & 0xFFL) << 16 | ((long)buffer[position++] & 0xFFL) << 8 | (long)buffer[position++] & 0xFFL;
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("Thread dump start: Timestamps:" + this.currentTimestamp);
                    break;
                }
                case 11: {
                    char threadId = (char)((buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF);
                    int strLen = (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                    String threadName = new String(buffer, position, strLen);
                    position += strLen;
                    strLen = (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                    String threadClassName = new String(buffer, position, strLen);
                    position += strLen;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Creating new thread: tId=" + threadId + " name=" + threadName);
                    }
                    this.currentThreadId = threadId;
                    this.currentThreadName = threadName;
                    this.currentThreadClassName = threadClassName;
                    break;
                }
                case 30: {
                    char threadId = (char)((buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF);
                    Integer threadIdObj = threadId;
                    ThreadInfo lastInfo = this.lastThreadsDump.get(threadIdObj);
                    assert (lastInfo != null);
                    this.currentThreadsDump.put(threadIdObj, lastInfo);
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("Thread info identical: tId:" + threadId);
                    break;
                }
                case 31: {
                    char threadId = (char)((buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF);
                    byte state = buffer[position++];
                    int stackLen = (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                    int[] methodIds = new int[stackLen];
                    for (int i = 0; i < stackLen; ++i) {
                        methodIds[i] = (buffer[position++] & 0xFF) << 24 | (buffer[position++] & 0xFF) << 16 | (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                        methodIdsTable.checkMethodId(methodIds[i]);
                    }
                    ThreadInfo info = this.currentThreadId == threadId ? new ThreadInfo(this.currentThreadName, threadId, state, methodIds) : new ThreadInfo(null, threadId, state, methodIds);
                    this.currentThreadsDump.put(Integer.valueOf(threadId), info);
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("Thread info: tId:" + threadId + " state:" + state + " mIds:" + Arrays.toString(methodIds));
                    break;
                }
                case 29: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Thread dump end");
                    }
                    this.lastThreadsDump = this.currentThreadsDump;
                    this.threadDumps.add(new ThreadDump(this.currentTimestamp, this.currentThreadsDump));
                    break;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    this.builder.reset();
                    break;
                }
                default: {
                    LOGGER.log(Level.SEVERE, "*** Profiler Engine: internal error: got unknown event type in CallGraphBuilder: {0} at {1}", new Object[]{(int)eventType, position});
                }
            }
            try {
                methodIdsTable.getNamesForMethodIds(this.client);
            }
            catch (ClientUtils.TargetAppOrVMTerminated ex) {
                ex.printStackTrace();
                return;
            }
            this.processCollectedDumps(methodIdsTable, this.threadDumps);
            this.threadDumps.clear();
        }
    }

    @Override
    public void startup(ProfilerClient client) {
        final CPUCallGraphBuilder[] ccgb = new CPUCallGraphBuilder[1];
        super.startup(client);
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ccgb[0] = (CPUCallGraphBuilder)listener;
            }
        });
        this.builder = new StackTraceSnapshotBuilder(ccgb[0], client.getSettings().getInstrumentationFilter(), client.getStatus());
    }

    private static Thread.State getThreadState(int threadState) {
        switch (threadState) {
            case -1: {
                return Thread.State.TERMINATED;
            }
            case 0: {
                return Thread.State.TERMINATED;
            }
            case 1: {
                return Thread.State.RUNNABLE;
            }
            case 2: {
                return Thread.State.TIMED_WAITING;
            }
            case 3: {
                return Thread.State.BLOCKED;
            }
            case 4: {
                return Thread.State.WAITING;
            }
        }
        return Thread.State.TERMINATED;
    }

    private void processCollectedDumps(JMethodIdTable methodIdTable, List<ThreadDump> threadDumps) {
        HashMap<Integer, StackTraceElement> stackTraceElements = new HashMap<Integer, StackTraceElement>();
        InstrumentationFilter filter = this.builder.getFilter();
        for (ThreadDump td : threadDumps) {
            StackTraceSnapshotBuilder.SampledThreadInfo[] sampledThreadInfos = new StackTraceSnapshotBuilder.SampledThreadInfo[td.threadDumps.length];
            int tindex = 0;
            for (ThreadInfo ti : td.threadDumps) {
                int[] methodIds = ti.methodsIds;
                StackTraceElement[] stackTrace = new StackTraceElement[methodIds.length];
                for (int i = 0; i < methodIds.length; ++i) {
                    int methodId = methodIds[i];
                    StackTraceElement el = (StackTraceElement)stackTraceElements.get(methodId);
                    if (el == null) {
                        JMethodIdTable.JMethodIdTableEntry entry = methodIdTable.getEntry(methodId);
                        String method = this.formatter.formatMethodName(entry.className, entry.methodName, entry.methodSig).toFormatted();
                        String className = entry.className.replace('/', '.');
                        el = new StackTraceElement(className, method, null, -1);
                        stackTraceElements.put(methodId, el);
                    }
                    stackTrace[i] = el;
                }
                sampledThreadInfos[tindex++] = new StackTraceSnapshotBuilder.SampledThreadInfo(ti.threadName, ti.threadId, ti.state, stackTrace, filter);
            }
            this.builder.addStacktrace(sampledThreadInfos, td.timestamp);
        }
    }

    private static final class ThreadDump {
        private long timestamp;
        private ThreadInfo[] threadDumps;

        ThreadDump(long ts, Map<Integer, ThreadInfo> threadsMap) {
            this.timestamp = ts;
            this.threadDumps = threadsMap.values().toArray(new ThreadInfo[threadsMap.size()]);
        }
    }

    private static final class ThreadInfo {
        private int[] methodsIds;
        private Thread.State state;
        private String threadName;
        private long threadId;

        ThreadInfo(String tn, long tid, byte ts, int[] st) {
            this.threadName = tn;
            this.threadId = tid;
            this.state = CPUSamplingDataFrameProcessor.getThreadState(ts);
            this.methodsIds = st;
        }
    }
}

