/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties.parser;

import java.util.StringTokenizer;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.netbeans.modules.css.editor.properties.parser.GrammarElement;
import org.netbeans.modules.css.editor.properties.parser.GroupGrammarElement;
import org.netbeans.modules.css.editor.properties.parser.ValueGrammarElement;

public class GrammarParser {
    public static final char INVISIBLE_PROPERTY_PREFIX = '@';

    public static boolean isArtificialElementName(CharSequence name) {
        if (name.length() == 0) {
            return false;
        }
        return name.charAt(0) == '@';
    }

    public static GroupGrammarElement parse(String expresssion) {
        return GrammarParser.parse(expresssion, null);
    }

    public static GroupGrammarElement parse(String expression, String propertyName) {
        int group_index = 0;
        int openedParenthesis = 0;
        GroupGrammarElement root = new GroupGrammarElement(null, group_index, propertyName);
        ParserInput input = new ParserInput(expression);
        GrammarParser.parseElements(input, root, false, group_index, openedParenthesis);
        if (openedParenthesis != 0) {
            throw new IllegalStateException("Bracket pairing doesn't match: " + openedParenthesis);
        }
        return root;
    }

    private static void parseElements(ParserInput input, GroupGrammarElement parent, boolean ignoreInherits, int group_index, int openedParenthesis) {
        GrammarElement last = null;
        char c;
        block12: while ((c = input.read()) != '\uffff') {
            StringBuilder buf;
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block12;
                }
                case '[': {
                    last = new GroupGrammarElement(parent, ++group_index);
                    GrammarParser.parseElements(input, (GroupGrammarElement)last, false, group_index, ++openedParenthesis);
                    parent.addElement(last);
                    continue block12;
                }
                case '|': {
                    char next = input.read();
                    if (next == '|') {
                        parent.setType(GroupGrammarElement.Type.LIST);
                        continue block12;
                    }
                    input.backup(1);
                    parent.setType(GroupGrammarElement.Type.SET);
                    continue block12;
                }
                case ']': {
                    --openedParenthesis;
                    return;
                }
                case '<': {
                    buf = new StringBuilder();
                    while ((c = input.read()) != '>') {
                        buf.append(c);
                    }
                    String referredElementName = buf.toString();
                    Property p = CssModuleSupport.getProperty(referredElementName);
                    if (p == null) {
                        throw new IllegalStateException("parsing error - no referred element '" + referredElementName + "' found!" + " Read input: " + input.readText());
                    }
                    last = new GroupGrammarElement(parent, ++group_index, referredElementName);
                    ParserInput pinput = new ParserInput(p.getValueGrammar());
                    GrammarParser.parseElements(pinput, (GroupGrammarElement)last, true, group_index, openedParenthesis);
                    parent.addElement(last);
                    continue block12;
                }
                case '!': {
                    buf = new StringBuilder();
                    while ((c = input.read()) != '\uffff') {
                        if (GrammarParser.isEndOfValueChar(c)) {
                            input.backup(1);
                            break;
                        }
                        buf.append(c);
                    }
                    last = new ValueGrammarElement(parent);
                    ((ValueGrammarElement)last).setValue(buf.toString());
                    ((ValueGrammarElement)last).setIsUnit(true);
                    parent.addElement(last);
                    continue block12;
                }
                case '{': {
                    StringBuilder text = new StringBuilder();
                    while ((c = input.read()) != '}') {
                        text.append(c);
                    }
                    StringTokenizer st = new StringTokenizer(text.toString(), ",");
                    int min = Integer.parseInt(st.nextToken());
                    int max = Integer.parseInt(st.nextToken());
                    last.setMinimumOccurances(min);
                    last.setMaximumOccurances(max);
                    continue block12;
                }
                case '+': {
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block12;
                }
                case '*': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block12;
                }
                case '?': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(1);
                    continue block12;
                }
            }
            buf = new StringBuilder();
            while (c != '\uffff') {
                if (GrammarParser.isEndOfValueChar(c)) {
                    input.backup(1);
                    break;
                }
                buf.append(c);
                c = input.read();
            }
            String image = buf.toString();
            if (ignoreInherits && "inherit".equalsIgnoreCase(image)) continue;
            last = new ValueGrammarElement(parent);
            ((ValueGrammarElement)last).setValue(image);
            ((ValueGrammarElement)last).setIsUnit(false);
            parent.addElement(last);
        }
        return;
    }

    private static boolean isEndOfValueChar(char c) {
        return c == ' ' || c == '+' || c == '?' || c == '{' || c == '[' || c == ']' || c == '|';
    }

    private static class ParserInput {
        CharSequence text;
        private int pos = 0;

        private ParserInput(CharSequence text) {
            this.text = text;
        }

        public char read() {
            if (this.pos == this.text.length()) {
                return '\uffff';
            }
            return this.text.charAt(this.pos++);
        }

        public void backup(int chars) {
            this.pos -= chars;
        }

        public CharSequence readText() {
            return this.text.subSequence(0, this.pos);
        }
    }
}

