/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.spi;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.csl.CssColor;
import org.netbeans.modules.css.editor.csl.CssCompletion;
import org.netbeans.modules.css.editor.csl.CssElement;
import org.netbeans.modules.css.editor.csl.CssValueElement;
import org.netbeans.modules.css.editor.properties.parser.GrammarElement;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.util.NbBundle;

public abstract class CssCompletionItem
implements CompletionProposal {
    private int anchorOffset;
    private String value;
    private CssElement element;
    protected boolean addSemicolon;
    protected static String WHITE_COLOR_HEX_CODE = "ffffff";
    protected static final int SORT_PRIORITY = 300;
    private static final byte COLOR_ICON_SIZE = 16;
    private static final byte COLOR_RECT_SIZE = 10;

    public static CssCompletionItem createValueCompletionItem(CssValueElement element, GrammarElement value, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
        return new ValueCompletionItem(element, value.toString(), value.getResolvedOrigin(), anchorOffset, addSemicolon, addSpaceBeforeItem);
    }

    public static CssCompletionItem createColorValueCompletionItem(CssValueElement element, GrammarElement value, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
        return new ColorCompletionItem(element, value.toString(), value.getResolvedOrigin(), anchorOffset, addSemicolon, addSpaceBeforeItem);
    }

    public static CssCompletionItem createPropertyNameCompletionItem(CssElement element, String value, int anchorOffset, boolean addSemicolon) {
        return new PropertyCompletionItem(element, value, anchorOffset, addSemicolon);
    }

    public static CssCompletionItem createRAWCompletionItem(CssElement element, String value, ElementKind kind, int anchorOffset, boolean addSemicolon) {
        return new RAWCompletionItem(element, kind, value, anchorOffset, addSemicolon);
    }

    public static CssCompletionItem createHashColorCompletionItem(CssElement element, String value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem, boolean usedInCurrentFile) {
        return new HashColorCompletionItem(element, value, origin, anchorOffset, addSemicolon, addSpaceBeforeItem, usedInCurrentFile);
    }

    public static CompletionProposal createColorChooserCompletionItem(int anchor, String origin, boolean addSemicolon) {
        return new ColorChooserItem(anchor, origin, addSemicolon);
    }

    public static CssCompletionItem createSelectorCompletionItem(CssElement element, String value, int anchorOffset, boolean related) {
        return new SelectorCompletionItem(element, value, anchorOffset, related);
    }

    public static CssCompletionItem createFileCompletionItem(CssElement element, String value, int anchorOffset, Color color, ImageIcon icon, boolean addQuotes, boolean addSemicolon) {
        return new FileCompletionItem(element, value, anchorOffset, color, icon, addQuotes, addSemicolon);
    }

    private CssCompletionItem() {
    }

    protected CssCompletionItem(CssElement element, String value, int anchorOffset, boolean addSemicolon) {
        this.anchorOffset = anchorOffset;
        this.value = value;
        this.element = element;
        this.addSemicolon = addSemicolon;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public String getName() {
        return this.value;
    }

    public String getInsertPrefix() {
        return this.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.appendText(this.getName());
        return formatter.getText();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSmart() {
        return false;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public int getSortPrioOverride() {
        return 300;
    }

    private static ImageIcon createIcon(String colorCode) {
        boolean defaultIcon;
        BufferedImage i = new BufferedImage(16, 16, 6);
        Graphics2D g = i.createGraphics();
        boolean bl = defaultIcon = colorCode == null;
        if (defaultIcon) {
            colorCode = WHITE_COLOR_HEX_CODE;
        }
        if (colorCode.length() == 3) {
            colorCode = "" + colorCode.charAt(0) + colorCode.charAt(0) + colorCode.charAt(1) + colorCode.charAt(1) + colorCode.charAt(2) + colorCode.charAt(2);
        }
        Color transparent = new Color(0xFFFFFF, true);
        g.setColor(transparent);
        g.fillRect(0, 0, 16, 16);
        try {
            g.setColor(Color.decode("0x" + colorCode));
        }
        catch (NumberFormatException ignoredException) {
            colorCode = WHITE_COLOR_HEX_CODE;
            defaultIcon = true;
        }
        g.fillRect(6, 5, 9, 9);
        g.setColor(Color.DARK_GRAY);
        g.drawRect(5, 4, 10, 10);
        if (defaultIcon) {
            g.drawLine(5, 14, 15, 4);
        }
        return new ImageIcon(i);
    }

    private static class FileCompletionItem
    extends CssCompletionItem {
        private ImageIcon icon;
        private String colorCode;
        private boolean addQuotes;

        private FileCompletionItem(CssElement element, String value, int anchorOffset, Color color, ImageIcon icon, boolean addQuotes, boolean addSemicolon) {
            super(element, value, anchorOffset, false);
            this.icon = icon;
            this.colorCode = WebUtils.toHexCode((Color)color).substring(1);
            this.addQuotes = addQuotes;
            this.addSemicolon = addSemicolon;
        }

        @Override
        public ImageIcon getIcon() {
            return this.icon;
        }

        public ElementKind getKind() {
            return ElementKind.FILE;
        }

        @Override
        public String getInsertPrefix() {
            StringBuilder b = new StringBuilder();
            if (this.addQuotes) {
                b.append('\"');
            }
            b.append(this.getName());
            if (this.addQuotes) {
                b.append('\"');
            }
            if (this.addSemicolon) {
                b.append(';');
            }
            return b.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.appendHtml(String.format("<font color=\"%s\">", this.colorCode));
            formatter.appendText(this.getName());
            formatter.appendHtml("</font>");
            return formatter.getText();
        }
    }

    static class SelectorCompletionItem
    extends CssCompletionItem {
        private static final String RELATED_SELECTOR_COLOR = "007c00";
        private static String GRAY_COLOR_CODE = Integer.toHexString(Color.GRAY.getRGB()).substring(2);
        private boolean related;

        private SelectorCompletionItem(CssElement element, String value, int anchorOffset, boolean related) {
            super(element, value, anchorOffset, false);
            this.related = related;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            StringBuilder buf = new StringBuilder();
            if (this.related) {
                buf.append("<b><font color=#");
                buf.append(RELATED_SELECTOR_COLOR);
            } else {
                buf.append("<font color=#");
                buf.append(GRAY_COLOR_CODE);
            }
            buf.append(">");
            buf.append(this.getName());
            buf.append("</font>");
            if (this.related) {
                buf.append("</b>");
            }
            formatter.appendHtml(buf.toString());
            return formatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        @Override
        public int getSortPrioOverride() {
            return super.getSortPrioOverride() - (this.related ? 1 : 0);
        }
    }

    static class PropertyCompletionItem
    extends CssCompletionItem {
        private PropertyCompletionItem(CssElement element, String value, int anchorOffset, boolean addSemicolon) {
            super(element, value, anchorOffset, addSemicolon);
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            if (Css3Utils.isVendorSpecificProperty(this.getName())) {
                formatter.appendHtml("<i>");
                formatter.appendText(this.getName());
                formatter.appendHtml("</i>");
                return formatter.getText();
            }
            return super.getLhsHtml(formatter);
        }

        @Override
        public String getInsertPrefix() {
            return super.getInsertPrefix() + ": ";
        }
    }

    static class ColorChooserItem
    extends DefaultCompletionProposal {
        private static final JColorChooser COLOR_CHOOSER = new JColorChooser();
        private Color color;
        private boolean addSemicolon;
        private String origin;

        private ColorChooserItem(int anchor, String origin, boolean addSemicolon) {
            this.anchorOffset = anchor;
            this.addSemicolon = addSemicolon;
            this.origin = origin;
        }

        public boolean beforeDefaultAction() {
            JDialog dialog = JColorChooser.createDialog(EditorRegistry.lastFocusedComponent(), NbBundle.getMessage(CssCompletion.class, (String)"MSG_Choose_Color"), true, COLOR_CHOOSER, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorChooserItem.this.color = COLOR_CHOOSER.getColor();
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorChooserItem.this.color = null;
                }
            });
            dialog.setVisible(true);
            dialog.dispose();
            return this.color == null;
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public ElementHandle getElement() {
            return new CssElement(null);
        }

        public ElementKind getKind() {
            return this.getElement().getKind();
        }

        public ImageIcon getIcon() {
            Color c = COLOR_CHOOSER.getColor();
            String colorCode = c == null ? "ffffff" : WebUtils.toHexCode((Color)c).substring(1);
            return CssCompletionItem.createIcon(colorCode);
        }

        public String getName() {
            return this.color == null ? "" : WebUtils.toHexCode((Color)this.color) + (this.addSemicolon ? ";" : "");
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            return "<b>" + NbBundle.getMessage(CssCompletion.class, (String)"MSG_OpenColorChooser") + "</b>";
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return "<font color=999999>" + this.origin + "</font>";
        }

        public boolean isSmart() {
            return true;
        }
    }

    static class HashColorCompletionItem
    extends ColorCompletionItem {
        private static final int HASH_COLOR_SORT_PRIORITY = 290;
        private boolean usedInCurrentFile;

        private HashColorCompletionItem(CssElement element, String value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem, boolean usedInCurrentFile) {
            super(element, value, origin, anchorOffset, addSemicolon, addSpaceBeforeItem);
            this.usedInCurrentFile = usedInCurrentFile;
        }

        @Override
        public ImageIcon getIcon() {
            return CssCompletionItem.createIcon(this.getName().substring(1));
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            return (this.usedInCurrentFile ? "" : "<font color=999999>") + this.getName() + (this.usedInCurrentFile ? "" : "</font>");
        }

        @Override
        public int getSortPrioOverride() {
            return 290 - (this.usedInCurrentFile ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashColorCompletionItem other = (HashColorCompletionItem)obj;
            return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
            return hash;
        }
    }

    static class ColorCompletionItem
    extends ValueCompletionItem {
        private ColorCompletionItem(CssElement element, String value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
            super(element, value, origin, anchorOffset, addSemicolon, addSpaceBeforeItem);
        }

        @Override
        public ImageIcon getIcon() {
            CssColor color = CssColor.getColor(this.getName());
            return CssCompletionItem.createIcon(color == null ? null : color.colorCode());
        }
    }

    static class ValueCompletionItem
    extends CssCompletionItem {
        private String origin;
        private boolean addSpaceBeforeItem;

        private ValueCompletionItem(CssElement element, String value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
            super(element, value, anchorOffset, addSemicolon);
            this.origin = origin;
            this.addSpaceBeforeItem = addSpaceBeforeItem;
        }

        public ElementKind getKind() {
            return ElementKind.FIELD;
        }

        @Override
        public String getInsertPrefix() {
            return (this.addSpaceBeforeItem && this.textsStartsWith(this.getName()) ? " " : "") + this.getName() + (this.addSemicolon ? ";" : "");
        }

        private boolean textsStartsWith(String text) {
            char ch = text.charAt(0);
            return Character.isLetterOrDigit(ch);
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            return "<font color=999999>" + this.origin + "</font>";
        }
    }

    static class RAWCompletionItem
    extends CssCompletionItem {
        private ElementKind kind;

        public RAWCompletionItem(CssElement element, ElementKind kind, String value, int anchorOffset, boolean addSemicolon) {
            super(element, value, anchorOffset, addSemicolon);
            this.kind = kind;
        }

        public ElementKind getKind() {
            return this.kind;
        }
    }
}

