/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.URLRetriever;
import org.netbeans.modules.css.editor.module.spi.CssModule;
import org.netbeans.modules.css.editor.module.spi.HelpResolver;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class StandardPropertiesHelpResolver
extends HelpResolver {
    private static final Logger LOGGER = Logger.getLogger(HelpResolver.class.getName());
    private static final String SPEC_ARCHIVE_NAME = "docs/css3-spec.zip";
    private static final AtomicReference<String> SPEC_ARCHIVE_INTERNAL_URL = new AtomicReference();
    private static final String W3C_SPEC_URL_PREFIX = "http://www.w3.org/TR/";
    private static final String MODULE_ARCHIVE_PATH = "www.w3.org/TR/";
    private static final String INDEX_HTML_FILE_NAME = "index.html";

    @Override
    public String getHelp(Property property) {
        CssModule cssModule = property.getCssModule();
        if (cssModule == null) {
            return null;
        }
        String moduleDocBase = cssModule.getSpecificationURL();
        if (moduleDocBase == null) {
            return null;
        }
        if (moduleDocBase.startsWith(W3C_SPEC_URL_PREFIX)) {
            String moduleFolderName = moduleDocBase.substring(W3C_SPEC_URL_PREFIX.length());
            StringBuilder propertyUrl = new StringBuilder();
            propertyUrl.append(this.getSpecURL());
            propertyUrl.append(MODULE_ARCHIVE_PATH);
            propertyUrl.append(moduleFolderName);
            propertyUrl.append('/');
            propertyUrl.append(INDEX_HTML_FILE_NAME);
            propertyUrl.append('#');
            propertyUrl.append(property.getName());
            try {
                URL propertyHelpURL = new URL(propertyUrl.toString());
                String urlContent = URLRetriever.getURLContentAndCache(propertyHelpURL);
                return urlContent;
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                return null;
            }
        }
        return null;
    }

    @Override
    public URL resolveLink(Property property, String link) {
        return null;
    }

    @Override
    public int getPriority() {
        return 500;
    }

    private String getSpecURL() {
        SPEC_ARCHIVE_INTERNAL_URL.compareAndSet(null, this.createSpecURL());
        return SPEC_ARCHIVE_INTERNAL_URL.get();
    }

    private String createSpecURL() {
        File file = InstalledFileLocator.getDefault().locate(SPEC_ARCHIVE_NAME, null, false);
        if (file != null) {
            try {
                URL urll = file.toURI().toURL();
                assert (FileUtil.isArchiveFile((URL)urll));
                return FileUtil.getArchiveRoot((URL)urll).toExternalForm();
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, String.format("Error obtaining archive root URL for file '%s'", file.getAbsolutePath()), e);
            }
        } else {
            LOGGER.warning(String.format("Cannot locate the css documentation file '%s'.", SPEC_ARCHIVE_NAME));
        }
        return null;
    }
}

