/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.editor.module.spi.Browser;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.FeatureCancel;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.FutureParamTask;
import org.netbeans.modules.css.editor.module.spi.HelpResolver;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.netbeans.modules.css.editor.module.spi.PropertySupportResolver;
import org.netbeans.modules.css.editor.properties.parser.PropertyModel;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.web.common.api.Pair;
import org.openide.util.Lookup;

public class CssModuleSupport {
    private static final Logger LOGGER = Logger.getLogger(CssModuleSupport.class.getSimpleName());
    private static final AtomicReference<Map<String, Property>> PROPERTIES = new AtomicReference();
    private static final Map<String, PropertyModel> PROPERTY_MODELS = new HashMap<String, PropertyModel>();

    public static Collection<? extends CssEditorModule> getModules() {
        return Lookup.getDefault().lookupAll(CssEditorModule.class);
    }

    public static Map<OffsetRange, Set<ColoringAttributes>> getSemanticHighlights(FeatureContext context, FeatureCancel cancel) {
        HashMap<OffsetRange, Set<ColoringAttributes>> all = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getSemanticHighlightingNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptyMap();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Set<OffsetRange> getMarkOccurrences(EditorFeatureContext context, FeatureCancel cancel) {
        HashSet<OffsetRange> all = new HashSet<OffsetRange>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getMarkOccurrencesNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptySet();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Map<String, List<OffsetRange>> getFolds(FeatureContext context, FeatureCancel cancel) {
        HashMap<String, List<OffsetRange>> all = new HashMap<String, List<OffsetRange>>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getFoldsNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptyMap();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Pair<OffsetRange, FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>> getDeclarationLocation(Document document, int caretOffset, FeatureCancel cancel) {
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            if (cancel.isCancelled()) {
                return null;
            }
            Pair<OffsetRange, FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>> declarationLocation = cssEditorModule.getDeclaration(document, caretOffset);
            if (declarationLocation == null) continue;
            return declarationLocation;
        }
        return null;
    }

    public static List<StructureItem> getStructureItems(FeatureContext context, FeatureCancel cancel) {
        ArrayList<StructureItem> all = new ArrayList<StructureItem>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getStructureItemsNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptyList();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Collection<Property> getProperties() {
        PROPERTIES.compareAndSet(null, CssModuleSupport.loadProperties());
        return PROPERTIES.get().values();
    }

    private static Map<String, Property> loadProperties() {
        HashMap<String, Property> all = new HashMap<String, Property>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            for (Property pd : cssEditorModule.getProperties()) {
                Property original = all.put(pd.getName(), pd);
                if (original == null) continue;
            }
        }
        return all;
    }

    public static Property getProperty(String propertyName) {
        PROPERTIES.compareAndSet(null, CssModuleSupport.loadProperties());
        StringBuilder sb = new StringBuilder().append('@').append(propertyName);
        Property invisibleProperty = PROPERTIES.get().get(sb.toString());
        return invisibleProperty != null ? invisibleProperty : PROPERTIES.get().get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyModel getPropertyModel(String name) {
        Map<String, PropertyModel> map = PROPERTY_MODELS;
        synchronized (map) {
            PropertyModel model = PROPERTY_MODELS.get(name);
            if (model == null) {
                Property pd = CssModuleSupport.getProperty(name);
                model = pd != null ? new PropertyModel(pd) : null;
                PROPERTY_MODELS.put(name, model);
            }
            return model;
        }
    }

    public static List<CompletionProposal> getCompletionProposals(CompletionContext context) {
        ArrayList<CompletionProposal> all = new ArrayList<CompletionProposal>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            all.addAll(cssEditorModule.getCompletionProposals(context));
        }
        return all;
    }

    public static Collection<String> getPseudoClasses() {
        HashSet<String> all = new HashSet<String>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<String> vals = cssEditorModule.getPseudoClasses();
            if (vals == null) continue;
            all.addAll(vals);
        }
        return all;
    }

    public static Collection<String> getPseudoElements() {
        HashSet<String> all = new HashSet<String>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<String> vals = cssEditorModule.getPseudoElements();
            if (vals == null) continue;
            all.addAll(vals);
        }
        return all;
    }

    public static SortedSet<Browser> getBrowsers() {
        TreeSet<Browser> all = new TreeSet<Browser>(new Comparator<Browser>(){

            @Override
            public int compare(Browser t, Browser t1) {
                return t.getName().compareTo(t1.getName());
            }
        });
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<Browser> extraBrowsers = cssEditorModule.getExtraBrowsers();
            if (extraBrowsers == null) continue;
            all.addAll(extraBrowsers);
        }
        return all;
    }

    public static boolean isPropertySupported(String propertyName, Browser browser) {
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            PropertySupportResolver resolver;
            PropertySupportResolver.Factory factory = cssEditorModule.getPropertySupportResolverFactory();
            if (factory == null || (resolver = factory.createPropertySupportResolver(browser)) == null || !resolver.isPropertySupported(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static HelpResolver getHelpResolver() {
        return new HelpResolver(){

            @Override
            public String getHelp(Property property) {
                StringBuilder sb = new StringBuilder();
                for (HelpResolver resolver : CssModuleSupport.getSortedHelpResolvers()) {
                    String help = resolver.getHelp(property);
                    if (help == null) continue;
                    sb.append(help);
                }
                return sb.toString();
            }

            @Override
            public URL resolveLink(Property property, String link) {
                for (HelpResolver resolver : CssModuleSupport.getSortedHelpResolvers()) {
                    URL url = resolver.resolveLink(property, link);
                    if (url == null) continue;
                    return url;
                }
                return null;
            }

            @Override
            public int getPriority() {
                return 0;
            }
        };
    }

    private static Collection<HelpResolver> getSortedHelpResolvers() {
        ArrayList<HelpResolver> list = new ArrayList<HelpResolver>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<HelpResolver> resolvers = cssEditorModule.getHelpResolvers();
            if (resolvers == null) continue;
            list.addAll(resolvers);
        }
        Collections.sort(list, new Comparator<HelpResolver>(){

            @Override
            public int compare(HelpResolver t1, HelpResolver t2) {
                int i1 = t1.getPriority();
                int i2 = t2.getPriority();
                return new Integer(i1).compareTo(new Integer(i2));
            }
        });
        return list;
    }
}

