/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.css.editor.CssPreferences;
import org.netbeans.modules.css.editor.csl.CssAnalyser;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.util.NbBundle;

public class CssHintsProvider
implements HintsProvider {
    private boolean cancelled = false;
    private static final CssRule ERROR_RULE = new CssRule(HintSeverity.ERROR);
    private static final CssRule WARNING_RULE = new CssRule(HintSeverity.WARNING);

    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        for (Error e : context.parserResult.getDiagnostics()) {
            if (CssPreferences.isErrorCheckingDisabledForCssErrorKey(e.getKey())) {
                hints.add(new Hint((Rule)new CssRule(HintSeverity.WARNING), CssHintsProvider.getMessageKey(e.getKey(), true), context.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(0, 0), Collections.singletonList(new ErrorCheckFix(context.parserResult.getSnapshot(), e.getKey(), true)), 10));
                continue;
            }
            assert (e.getDescription() != null);
            List fixes = CssAnalyser.isConfigurableError(e.getKey()) ? Collections.singletonList(new ErrorCheckFix(context.parserResult.getSnapshot(), e.getKey(), this.cancelled)) : Collections.emptyList();
            Hint h = new Hint((Rule)CssHintsProvider.getCssRule(e.getSeverity()), e.getDescription(), e.getFile(), new OffsetRange(e.getStartPosition(), e.getEndPosition()), fixes, 10);
            hints.add(h);
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new RuleContext();
    }

    private static CssRule getCssRule(Severity s) {
        switch (s) {
            case WARNING: {
                return WARNING_RULE;
            }
            case ERROR: {
                return ERROR_RULE;
            }
        }
        throw new AssertionError((Object)"Unexpected severity level");
    }

    private static String getMessageKey(String errorKey, boolean enabled) {
        String param = null;
        String keyEnable = null;
        String keyDisable = null;
        if (CssAnalyser.isUnknownPropertyError(errorKey)) {
            keyEnable = "MSG_Disable_Ignore_Property";
            keyDisable = "MSG_Enable_Ignore_Property";
            param = CssAnalyser.getUnknownPropertyName(errorKey);
        } else {
            keyEnable = "MSG_Disable_Check";
            keyDisable = "MSG_Enable_Check";
        }
        return enabled ? NbBundle.getMessage(CssHintsProvider.class, (String)keyEnable, (Object)param) : NbBundle.getMessage(CssHintsProvider.class, (String)keyDisable, (Object)param);
    }

    private static void forceReparse(Snapshot snapshot) {
        final Document doc = snapshot.getSource().getDocument(false);
        if (doc == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                        if (mti != null) {
                            mti.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    private static final class ErrorCheckFix
    implements HintFix {
        private String errorKey;
        private boolean enabled;
        private Snapshot snapshot;

        public ErrorCheckFix(Snapshot snapshot, String errorKey, boolean enabled) {
            assert (CssAnalyser.isConfigurableError(errorKey));
            this.snapshot = snapshot;
            this.errorKey = errorKey;
            this.enabled = enabled;
        }

        public String getDescription() {
            return CssHintsProvider.getMessageKey(this.errorKey, this.enabled);
        }

        public void implement() throws Exception {
            CssPreferences.setCssErrorChecking(this.errorKey, this.enabled);
            CssHintsProvider.forceReparse(this.snapshot);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class CssRule
    implements Rule.ErrorRule {
        private HintSeverity severity;

        private CssRule(HintSeverity severity) {
            this.severity = severity;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return "css";
        }

        public boolean showInTasklist() {
            return true;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }
}

