/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.ProblemDescription;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;

public final class Css3Utils {
    public static final String GENERATED_CODE_MARK = "@@@";

    public static List<Error> getCslErrorForCss3ProblemDescription(FileObject file, List<ProblemDescription> pds) {
        ArrayList<Error> errors = new ArrayList<Error>();
        for (ProblemDescription pd : pds) {
            errors.add(Css3Utils.getCslErrorForCss3ProblemDescription(file, pd));
        }
        return errors;
    }

    private static Error getCslErrorForCss3ProblemDescription(FileObject file, ProblemDescription pd) {
        return new DefaultError(pd.getKey(), pd.getDescription(), pd.getDescription(), file, pd.getFrom(), pd.getTo(), Css3Utils.getCslSeverityForCss3ProblemType(pd.getType()));
    }

    public static Severity getCslSeverityForCss3ProblemType(ProblemDescription.Type problemType) {
        switch (problemType) {
            case ERROR: {
                return Severity.ERROR;
            }
            case FATAL: {
                return Severity.FATAL;
            }
            case INFO: {
                return Severity.INFO;
            }
            case WARNING: {
                return Severity.WARNING;
            }
        }
        return Severity.ERROR;
    }

    public static OffsetRange getOffsetRange(Node node) {
        return new OffsetRange(node.from(), node.to());
    }

    public static OffsetRange getDocumentOffsetRange(Node node, Snapshot snapshot) {
        return new OffsetRange(snapshot.getOriginalOffset(node.from()), snapshot.getOriginalOffset(node.to()));
    }

    public static boolean isValidOffsetRange(OffsetRange range) {
        return range.getStart() != -1 && range.getEnd() != -1;
    }

    public static OffsetRange getValidOrNONEOffsetRange(OffsetRange range) {
        return Css3Utils.isValidOffsetRange(range) ? range : OffsetRange.NONE;
    }

    public static boolean containsGeneratedCode(CharSequence text) {
        return CharSequenceUtilities.indexOf((CharSequence)text, (CharSequence)GENERATED_CODE_MARK) != -1;
    }

    public static boolean isVendorSpecificProperty(CharSequence propertyName) {
        return CharSequenceUtilities.startsWith((CharSequence)propertyName, (CharSequence)"_") || CharSequenceUtilities.startsWith((CharSequence)propertyName, (CharSequence)"-");
    }

    public static List<CompletionProposal> filterCompletionProposals(List<CompletionProposal> proposals, CharSequence prefix, boolean ignoreCase) {
        ArrayList<CompletionProposal> filtered = new ArrayList<CompletionProposal>();
        for (CompletionProposal proposal : proposals) {
            if (!LexerUtils.startsWith((CharSequence)proposal.getInsertPrefix(), (CharSequence)prefix, (boolean)ignoreCase, (boolean)false)) continue;
            filtered.add(proposal);
        }
        return filtered;
    }
}

