/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    private static final boolean IS_UNIX = Utilities.isUnix();
    private static final boolean IS_MAC = Utilities.isMac();
    private static final boolean IS_WINDOWS = Utilities.isWindows();
    public static final String PHP_MIME_TYPE = "text/x-php5";

    private FileUtils() {
    }

    public static boolean isPhpFile(FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        return PHP_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)file, (String[])new String[]{PHP_MIME_TYPE}));
    }

    public static List<String> findFileOnUsersPath(String filename) {
        return FileUtils.findFileOnUsersPath(new String[]{filename});
    }

    public static List<String> findFileOnUsersPath(String ... filename) {
        Parameters.notNull((CharSequence)"filename", (Object)filename);
        String path = System.getenv("PATH");
        LOGGER.log(Level.FINE, "PATH: [{0}]", path);
        if (path == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> dirs = new LinkedHashSet<String>(Arrays.asList(path.split(File.pathSeparator)));
        LOGGER.log(Level.FINE, "PATH dirs: {0}", dirs);
        ArrayList<String> found = new ArrayList<String>(dirs.size() * filename.length);
        for (String f : filename) {
            for (String d : dirs) {
                File file = new File(d, f);
                if (!file.isFile()) continue;
                String absolutePath = FileUtil.normalizeFile((File)file).getAbsolutePath();
                LOGGER.log(Level.FINE, "File ''{0}'' found", absolutePath);
                if (found.contains(absolutePath)) continue;
                LOGGER.log(Level.FINE, "File ''{0}'' added to found files", absolutePath);
                found.add(absolutePath);
            }
        }
        LOGGER.log(Level.FINE, "Found files: {0}", found);
        return found;
    }

    public static String getScriptExtension(boolean withDot) {
        StringBuilder sb = new StringBuilder(4);
        if (withDot) {
            sb.append(".");
        }
        if (IS_WINDOWS) {
            sb.append("bat");
        } else {
            sb.append("sh");
        }
        return sb.toString();
    }

    public static FileObject getFileObject(Lookup context) {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        if (fo != null) {
            return fo;
        }
        DataObject d = (DataObject)context.lookup(DataObject.class);
        if (d != null) {
            return d.getPrimaryFile();
        }
        return null;
    }

    public static XMLReader createXmlReader() throws SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            return factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create SAX parser", ex);
        }
    }

    public static String validateScript(String filePath, String scriptName) {
        if (!StringUtils.hasText(filePath)) {
            return NbBundle.getMessage(FileUtils.class, (String)"MSG_NoScript", (Object)scriptName);
        }
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(FileUtils.class, (String)"MSG_ScriptNotAbsolutePath", (Object)scriptName);
        }
        if (!file.isFile()) {
            return NbBundle.getMessage(FileUtils.class, (String)"MSG_ScriptNotFile", (Object)scriptName);
        }
        if (!file.canRead()) {
            return NbBundle.getMessage(FileUtils.class, (String)"MSG_ScriptCannotRead", (Object)scriptName);
        }
        return null;
    }

    public static String validateDirectory(String dirPath) {
        if (!StringUtils.hasText(dirPath)) {
            return NbBundle.getMessage(FileUtils.class, (String)"MSG_DirEmpty");
        }
        File dir = new File(dirPath);
        if (!dir.isAbsolute()) {
            return NbBundle.getMessage(FileUtils.class, (String)"MSG_DirNotAbsolute");
        }
        if (!dir.isDirectory()) {
            return NbBundle.getMessage(FileUtils.class, (String)"MSG_NotDir");
        }
        if (!FileUtils.isDirectoryWritable(dir)) {
            return NbBundle.getMessage(FileUtils.class, (String)"MSG_DirNotWritable");
        }
        return null;
    }

    public static boolean isDirectoryWritable(File directory) {
        if (!directory.isDirectory()) {
            LOGGER.log(Level.FINE, "{0} is not a folder", directory);
            return false;
        }
        boolean windows = IS_WINDOWS;
        LOGGER.log(Level.FINE, "On Windows: {0}", windows);
        boolean canWrite = directory.canWrite();
        LOGGER.log(Level.FINE, "Folder {0} is writable: {1}", new Object[]{directory, canWrite});
        if (!windows) {
            return canWrite;
        }
        LOGGER.fine("Trying to create temp file");
        try {
            File tmpFile = File.createTempFile("netbeans", null, directory);
            LOGGER.log(Level.FINE, "Temp file {0} created", tmpFile);
            tmpFile.delete();
            LOGGER.log(Level.FINE, "Temp file {0} deleted", tmpFile);
        }
        catch (IOException exc) {
            LOGGER.log(Level.FINE, exc.getMessage(), exc);
            return false;
        }
        return true;
    }

    public static boolean isDirectoryLink(File directory) {
        File canDirectory;
        Parameters.notNull((CharSequence)"directory", (Object)directory);
        if (!IS_UNIX && !IS_MAC) {
            return false;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        try {
            canDirectory = directory.getCanonicalFile();
        }
        catch (IOException ioe) {
            return false;
        }
        String dirPath = directory.getAbsolutePath();
        String canDirPath = canDirectory.getAbsolutePath();
        return IS_MAC ? !dirPath.equalsIgnoreCase(canDirPath) : !dirPath.equals(canDirPath);
    }
}

