/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.creator;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.document.Document;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.util.zip.ZipFacade;
import org.apache.maven.index.util.zip.ZipHandle;
import org.codehaus.plexus.component.annotations.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=IndexCreator.class, hint="maven-archetype")
public class MavenArchetypeArtifactInfoIndexCreator
extends AbstractIndexCreator {
    public static final String ID = "maven-archetype";
    private static final String MAVEN_ARCHETYPE_PACKAGING = "maven-archetype";
    private static final String[] ARCHETYPE_XML_LOCATIONS = new String[]{"META-INF/maven/archetype.xml", "META-INF/archetype.xml", "META-INF/maven/archetype-metadata.xml"};

    @Override
    public void populateArtifactInfo(ArtifactContext ac) {
        File artifact = ac.getArtifact();
        ArtifactInfo ai = ac.getArtifactInfo();
        if (artifact != null && artifact.isFile() && !"maven-archetype".equals(ai.packaging) && artifact.getName().endsWith(".jar")) {
            this.checkMavenArchetype(ai, artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMavenArchetype(ArtifactInfo ai, File artifact) {
        ZipHandle handle = null;
        try {
            handle = ZipFacade.getZipHandle(artifact);
            for (String path : ARCHETYPE_XML_LOCATIONS) {
                if (!handle.hasEntry(path)) continue;
                ai.packaging = "maven-archetype";
                return;
            }
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to exception:", (Throwable)e);
            } else {
                this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to " + e.getMessage());
            }
        }
        finally {
            try {
                ZipFacade.close(handle);
            }
            catch (IOException ex) {}
        }
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        return false;
    }

    public String toString() {
        return "maven-archetype";
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Collections.emptyList();
    }
}

