/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.util;

import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KeywordsPanel
extends JPanel {
    private JLabel keywordsLabel;
    private JList keywordsList;
    private JLabel messageLabel;
    private JScrollPane scrollPane;

    public KeywordsPanel(String label, List<String> knownKeywords, String[] toSelect) {
        int idx;
        this.initComponents();
        this.messageLabel.setText(label);
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String keyword : knownKeywords) {
            model.addElement(keyword);
        }
        this.keywordsList.setModel(model);
        int[] selection = new int[toSelect.length];
        for (int i = 0; i < toSelect.length; ++i) {
            String keyword = toSelect[i];
            int idx2 = model.indexOf(keyword = keyword.trim());
            if (idx2 == -1) {
                idx2 = model.indexOf(keyword.toUpperCase());
            }
            if (idx2 == -1) {
                idx2 = model.indexOf(keyword.toLowerCase());
            }
            selection[i] = idx2;
        }
        this.keywordsList.setSelectedIndices(selection);
        int n = idx = selection.length > 0 ? selection[0] : -1;
        if (idx > -1) {
            this.keywordsList.scrollRectToVisible(this.keywordsList.getCellBounds(idx, idx));
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.keywordsList = new JList();
        this.messageLabel = new JLabel();
        this.keywordsLabel = new JLabel();
        this.scrollPane.setViewportView(this.keywordsList);
        this.keywordsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KeywordsPanel.class, (String)"KeywordsPanel.keywordsList.AccessibleContext.accessibleDescription"));
        this.keywordsLabel.setLabelFor(this.keywordsList);
        Mnemonics.setLocalizedText((JLabel)this.keywordsLabel, (String)NbBundle.getMessage(KeywordsPanel.class, (String)"KeywordsPanel.keywordsLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, 345, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.keywordsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane).addComponent(this.keywordsLabel))));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KeywordsPanel.class, (String)"KeywordsPanel.AccessibleContext.accessibleDescription"));
    }

    public String[] getSelectedKeywords() {
        Object[] values = this.keywordsList.getSelectedValues();
        String[] keywords = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            keywords[i] = values[i].toString();
        }
        return keywords;
    }
}

