/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.STT;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

public class SymTabSection
extends ElfSection {
    private Map<Integer, Integer> sectionMap = new HashMap<Integer, Integer>();

    public SymTabSection(ElfReader reader, int sectionIdx) {
        super(reader, sectionIdx);
        this.read();
    }

    public final SymTabSection read() {
        try {
            if (this.header.sh_entsize == 0L) {
                return this;
            }
            int entries = (int)(this.header.sh_size / this.header.sh_entsize);
            long filePos = this.reader.getFilePointer();
            this.reader.seek(this.header.getSectionOffset());
            for (int i = 0; i < entries; ++i) {
                this.reader.seek(this.header.getSectionOffset() + (long)i * this.header.sh_entsize);
                long name = 0L;
                long addr = 0L;
                long size = 0L;
                byte info = 0;
                byte other = 0;
                short index = 0;
                if (this.reader.is32Bit()) {
                    name = this.reader.readInt();
                    addr = this.reader.readInt();
                    size = this.reader.readInt();
                    info = this.reader.readByte();
                    other = this.reader.readByte();
                    index = this.reader.readShort();
                } else {
                    name = this.reader.readInt();
                    info = this.reader.readByte();
                    other = this.reader.readByte();
                    index = this.reader.readShort();
                    addr = this.reader.read3264();
                    size = this.reader.read3264();
                }
                if (info != STT.STT_SECTION.value()) continue;
                this.sectionMap.put(Integer.valueOf(index), i);
            }
            this.reader.seek(filePos);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public Integer getSectionIndex(int sectionIndex) {
        return this.sectionMap.get(sectionIndex);
    }

    public void dump(PrintStream out) {
        super.dump(out);
        out.printf("Elf section\tSymtab Section\n", new Object[0]);
        for (Map.Entry<Integer, Integer> entry : this.sectionMap.entrySet()) {
            out.printf("%d\t%d\n", entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }
}

