/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfLineInfoSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Offset2LineService {
    private static final boolean TRACE = false;
    private Map<String, String> onePath;

    private Offset2LineService() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Not enough parameters.");
            System.err.println("Usage:");
            System.err.println("java -cp org-netbeans-modules-cnd-dwarfdump.jar org.netbeans.modules.cnd.dwarfdump.Offset2LineService binaryFileName");
            return;
        }
        try {
            Offset2LineService.dump(args[0], System.out);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void dump(String executable, PrintStream out) throws IOException {
        Map<String, AbstractFunctionToLine> res = Offset2LineService.getOffset2Line(executable);
        for (Map.Entry<String, AbstractFunctionToLine> entry : res.entrySet()) {
            out.println(entry.getKey());
            entry.getValue().dump(out);
        }
    }

    public static Map<String, AbstractFunctionToLine> getOffset2Line(BufferedReader out) throws IOException {
        return new Offset2LineService().readOffset2Line(out);
    }

    public static Map<String, AbstractFunctionToLine> getOffset2Line(String executable) throws IOException {
        return new Offset2LineService().getSourceInfo(executable);
    }

    private Map<String, AbstractFunctionToLine> readOffset2Line(BufferedReader out) throws IOException {
        String line;
        this.onePath = new HashMap<String, String>();
        HashMap<String, AbstractFunctionToLine> sourceInfoMap = new HashMap<String, AbstractFunctionToLine>();
        int state = 0;
        String functionName = null;
        String fileName = null;
        int baseLine = 0;
        ArrayList<Integer> lines = new ArrayList<Integer>();
        ArrayList<Integer> startOffset = new ArrayList<Integer>();
        ArrayList<Integer> endOffset = new ArrayList<Integer>();
        block10: while ((line = out.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            switch (state) {
                case 0: {
                    functionName = line;
                    ++state;
                    break;
                }
                case 1: {
                    fileName = line;
                    ++state;
                    break;
                }
                case 2: {
                    try {
                        baseLine = Integer.parseInt(line);
                        lines.clear();
                        startOffset.clear();
                        endOffset.clear();
                        ++state;
                    }
                    catch (NumberFormatException ex) {
                        state = 0;
                    }
                    break;
                }
                case 3: {
                    char c = line.charAt(0);
                    if (c >= '0' && c <= '9') {
                        String[] split = line.split(",");
                        if (split.length <= 2) continue block10;
                        try {
                            lines.add(Integer.valueOf(split[0]));
                            startOffset.add(Integer.valueOf(split[1]));
                            endOffset.add(Integer.valueOf(split[2]));
                        }
                        catch (NumberFormatException ex) {
                            state = 0;
                        }
                        break;
                    }
                    sourceInfoMap.put(functionName, this.createAbstractFunctionToLine(fileName, baseLine, lines, startOffset, endOffset));
                    functionName = line;
                    state = 1;
                }
            }
        }
        if (state > 1) {
            sourceInfoMap.put(functionName, this.createAbstractFunctionToLine(fileName, baseLine, lines, startOffset, endOffset));
        }
        this.onePath = null;
        return sourceInfoMap;
    }

    private AbstractFunctionToLine createAbstractFunctionToLine(String fileName, int baseLine, List<Integer> lines, List<Integer> startOffsets, List<Integer> endOffsets) {
        if (lines.isEmpty()) {
            return new DeclarationToLine(fileName, baseLine, this.onePath);
        }
        return new FunctionToLine(fileName, baseLine, lines, startOffsets, endOffsets, this.onePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AbstractFunctionToLine> getSourceInfo(String executable) throws IOException {
        this.onePath = new HashMap<String, String>();
        HashMap<String, AbstractFunctionToLine> sourceInfoMap = new HashMap<String, AbstractFunctionToLine>();
        Dwarf dwarf = new Dwarf(executable);
        try {
            Iterator<CompilationUnit> iterator = dwarf.iteratorCompilationUnits();
            while (iterator.hasNext()) {
                CompilationUnit compilationUnit = iterator.next();
                TreeSet<DwarfLineInfoSection.LineNumber> lineNumbers = Offset2LineService.getCompilationUnitLines(compilationUnit);
                String filePath = compilationUnit.getSourceFileAbsolutePath();
                String compDir = compilationUnit.getCompilationDir();
                HashSet<Long> antiLoop = new HashSet<Long>();
                this.processEntries(compilationUnit, compilationUnit.getDeclarations(false), filePath, compDir, lineNumbers, sourceInfoMap, antiLoop);
            }
        }
        finally {
            dwarf.dispose();
        }
        this.onePath = null;
        return sourceInfoMap;
    }

    private void processEntries(CompilationUnit compilationUnit, List<DwarfEntry> declarations, String filePath, String compDir, TreeSet<DwarfLineInfoSection.LineNumber> lineNumbers, Map<String, AbstractFunctionToLine> sourceInfoMap, Set<Long> antiLoop) throws IOException {
        for (DwarfEntry entry : declarations) {
            this.prosessEntry(compilationUnit, entry, filePath, compDir, lineNumbers, sourceInfoMap, antiLoop);
        }
    }

    private void prosessEntry(CompilationUnit compilationUnit, DwarfEntry entry, String filePath, String compDir, TreeSet<DwarfLineInfoSection.LineNumber> lineNumbers, Map<String, AbstractFunctionToLine> sourceInfoMap, Set<Long> antiLoop) throws IOException {
        if (antiLoop.contains(entry.getRefference())) {
            return;
        }
        antiLoop.add(entry.getRefference());
        switch (entry.getKind()) {
            case DW_TAG_subprogram: {
                if (entry.getLine() < 0 || entry.getDeclarationFilePath() == null) {
                    return;
                }
                if (entry.getLowAddress() == 0L) {
                    DeclarationToLine functionToLine = new DeclarationToLine(filePath, compDir, entry, this.onePath);
                    sourceInfoMap.put(entry.getQualifiedName(), functionToLine);
                    break;
                }
                FunctionToLine functionToLine = new FunctionToLine(filePath, compDir, entry, lineNumbers, this.onePath);
                sourceInfoMap.put(entry.getQualifiedName(), functionToLine);
                break;
            }
            case DW_TAG_structure_type: 
            case DW_TAG_class_type: {
                this.processEntries(compilationUnit, entry.getChildren(), filePath, compDir, lineNumbers, sourceInfoMap, antiLoop);
                break;
            }
            case DW_TAG_typedef: 
            case DW_TAG_const_type: 
            case DW_TAG_pointer_type: 
            case DW_TAG_reference_type: 
            case DW_TAG_array_type: 
            case DW_TAG_ptr_to_member_type: {
                DwarfEntry type = compilationUnit.getReferencedType(entry);
                if (type == null) break;
                this.prosessEntry(compilationUnit, type, filePath, compDir, lineNumbers, sourceInfoMap, antiLoop);
                break;
            }
        }
    }

    private static TreeSet<DwarfLineInfoSection.LineNumber> getCompilationUnitLines(CompilationUnit unit) throws IOException {
        Set<DwarfLineInfoSection.LineNumber> numbers = unit.getLineNumbers();
        return new TreeSet<DwarfLineInfoSection.LineNumber>(numbers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionToLine
    extends AbstractFunctionToLine {
        private final int[] lineStorage;
        private final int[] startOffsetStorage;
        private final int[] endOffsetStorage;
        private final int baseLine;
        private final String filePath;

        public FunctionToLine(String filePath, String compDir, DwarfEntry entry, TreeSet<DwarfLineInfoSection.LineNumber> numbers, Map<String, String> onePath) throws IOException {
            assert (entry.getKind() == TAG.DW_TAG_subprogram);
            assert (entry.getLowAddress() != 0L);
            this.baseLine = entry.getLine();
            this.filePath = this.initPath(filePath, compDir, entry, onePath);
            long base = entry.getLowAddress();
            long baseHihg = entry.getHighAddress();
            ArrayList<Integer> lineStorageList = new ArrayList<Integer>();
            ArrayList<Integer> startOffsetStorageList = new ArrayList<Integer>();
            ArrayList<Integer> endOffsetStorageList = new ArrayList<Integer>();
            for (DwarfLineInfoSection.LineNumber l : numbers) {
                if (l.startOffset < base || l.endOffset > baseHihg) continue;
                lineStorageList.add(l.line);
                startOffsetStorageList.add((int)(l.startOffset - base));
                endOffsetStorageList.add((int)(l.endOffset - base));
            }
            this.lineStorage = new int[lineStorageList.size()];
            this.startOffsetStorage = new int[startOffsetStorageList.size()];
            this.endOffsetStorage = new int[endOffsetStorageList.size()];
            for (int i = 0; i < lineStorageList.size(); ++i) {
                this.lineStorage[i] = (Integer)lineStorageList.get(i);
                this.startOffsetStorage[i] = (Integer)startOffsetStorageList.get(i);
                this.endOffsetStorage[i] = (Integer)endOffsetStorageList.get(i);
            }
        }

        public FunctionToLine(String filePath, int baseLine, List<Integer> lines, List<Integer> startOffsets, List<Integer> endOffsets, Map<String, String> onePath) {
            assert (lines.size() == startOffsets.size());
            this.baseLine = baseLine;
            this.filePath = this.getPath(filePath, onePath);
            this.lineStorage = new int[lines.size()];
            this.startOffsetStorage = new int[startOffsets.size()];
            this.endOffsetStorage = new int[endOffsets.size()];
            for (int i = 0; i < lines.size(); ++i) {
                this.lineStorage[i] = lines.get(i);
                this.startOffsetStorage[i] = startOffsets.get(i);
                this.endOffsetStorage[i] = endOffsets.get(i);
            }
        }

        @Override
        public SourceLineInfo getLine(int offset) {
            if (offset < 0) {
                if (this.baseLine > 0) {
                    return new SourceLineInfo(this.filePath, this.baseLine);
                }
                if (this.lineStorage.length > 0) {
                    return new SourceLineInfo(this.filePath, this.lineStorage[0]);
                }
                return null;
            }
            int res = -1;
            for (int i = 0; i < this.startOffsetStorage.length; ++i) {
                if (this.startOffsetStorage[i] > offset || offset >= this.endOffsetStorage[i] || res != -1) continue;
                res = i;
            }
            if (res < 0) {
                return new SourceLineInfo(this.filePath, this.baseLine);
            }
            return new SourceLineInfo(this.filePath, this.lineStorage[res]);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("File: " + this.filePath);
            buf.append("\n\tBase Line:  ").append(this.baseLine);
            if (this.lineStorage.length > 0) {
                for (int i = 0; i < this.lineStorage.length; ++i) {
                    buf.append("\n\tLine: ").append(this.lineStorage[i]).append("\t (").append(this.startOffsetStorage[i]).append('-').append(this.endOffsetStorage[i]).append(")");
                }
            }
            return buf.toString();
        }

        @Override
        protected void dump(PrintStream out) {
            out.println(this.filePath);
            out.println("" + this.baseLine);
            for (int i = 0; i < this.lineStorage.length; ++i) {
                out.println("" + this.lineStorage[i] + "," + this.startOffsetStorage[i] + "," + this.endOffsetStorage[i]);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof FunctionToLine) {
                FunctionToLine other = (FunctionToLine)obj;
                if (!this.filePath.equals(other.filePath)) {
                    return false;
                }
                if (this.baseLine != other.baseLine) {
                    return false;
                }
                if (this.lineStorage.length != other.lineStorage.length) {
                    return false;
                }
                for (int i = 0; i < this.lineStorage.length; ++i) {
                    if (this.lineStorage[i] != other.lineStorage[i]) {
                        return false;
                    }
                    if (this.startOffsetStorage[i] == other.startOffsetStorage[i]) continue;
                    return false;
                }
                return true;
            }
            if (obj instanceof DeclarationToLine) {
                DeclarationToLine other = (DeclarationToLine)obj;
                if (!this.filePath.equals(other.filePath)) {
                    return false;
                }
                if (this.baseLine != other.baseLine) {
                    return false;
                }
                return this.lineStorage.length == 0;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DeclarationToLine
    extends AbstractFunctionToLine {
        private final int baseLine;
        private final String filePath;

        public DeclarationToLine(String filePath, String compDir, DwarfEntry entry, Map<String, String> onePath) throws IOException {
            assert (entry.getKind() == TAG.DW_TAG_subprogram);
            this.baseLine = entry.getLine();
            this.filePath = this.initPath(filePath, compDir, entry, onePath);
        }

        public DeclarationToLine(String filePath, int baseLine, Map<String, String> onePath) {
            this.baseLine = baseLine;
            this.filePath = this.getPath(filePath, onePath);
        }

        @Override
        public SourceLineInfo getLine(int offset) {
            return new SourceLineInfo(this.filePath, this.baseLine);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("File: " + this.filePath);
            buf.append("\n\tBase Line:  ").append(this.baseLine);
            return buf.toString();
        }

        @Override
        protected void dump(PrintStream out) {
            out.println(this.filePath);
            out.println("" + this.baseLine);
        }

        public boolean equals(Object obj) {
            if (obj instanceof DeclarationToLine) {
                DeclarationToLine other = (DeclarationToLine)obj;
                if (!this.filePath.equals(other.filePath)) {
                    return false;
                }
                return this.baseLine == other.baseLine;
            }
            if (obj instanceof FunctionToLine) {
                FunctionToLine other = (FunctionToLine)obj;
                if (!this.filePath.equals(other.filePath)) {
                    return false;
                }
                if (this.baseLine != other.baseLine) {
                    return false;
                }
                return other.endOffsetStorage.length == 0;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractFunctionToLine {
        public abstract SourceLineInfo getLine(int var1);

        protected abstract void dump(PrintStream var1);

        protected String initPath(String filePath, String compDir, DwarfEntry entry, Map<String, String> onePath) throws IOException {
            String res = this._initPath(filePath, compDir, entry);
            return this.getPath(res, onePath);
        }

        protected String getPath(String path, Map<String, String> onePath) {
            String cached = onePath.get(path);
            if (cached == null) {
                onePath.put(path, path);
                cached = path;
            }
            return cached;
        }

        private String _initPath(String filePath, String compDir, DwarfEntry entry) throws IOException {
            String entyFilePath = entry.getDeclarationFilePath();
            if (entyFilePath != null && filePath.endsWith(entyFilePath)) {
                return filePath;
            }
            if (entyFilePath != null && (entyFilePath.startsWith("/") || entyFilePath.length() > 2 && entyFilePath.charAt(1) == ':')) {
                return entyFilePath;
            }
            if (compDir.endsWith("/") || compDir.endsWith("\\")) {
                return compDir + entyFilePath;
            }
            return compDir + "/" + entyFilePath;
        }
    }

    public static final class SourceLineInfo {
        private final CharSequence fileName;
        private final int lineNumber;

        public SourceLineInfo(CharSequence fileName, int lineNumber) {
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        public String getFileName() {
            return ((Object)this.fileName).toString();
        }

        public int getLine() {
            return this.lineNumber;
        }

        public String toString() {
            return ((Object)this.fileName).toString() + ':' + this.lineNumber;
        }
    }
}

