/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.registration;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AutomaticRegistration {
    private static final Logger LOGGER = Logger.getLogger(AutomaticRegistration.class.getName());

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Parameters: <ide clusterDir> <GlassFishHome>");
            System.exit(-1);
        }
        int status = AutomaticRegistration.autoregisterGlassFishInstance(args[0], args[1]);
        System.exit(status);
    }

    private static int autoregisterGlassFishInstance(String clusterDirValue, String glassfishRoot) throws IOException {
        System.setProperty("netbeans.user", clusterDirValue);
        File glassfishHome = new File(glassfishRoot);
        if (!glassfishHome.exists()) {
            LOGGER.log(Level.INFO, "Cannot register the default GlassFish server. The GlassFish Root directory " + glassfishRoot + " does not exist.");
            return 3;
        }
        String config = null;
        String deployer = null;
        String defaultDisplayName = null;
        if (new File(glassfishHome, "lib/dtds/glassfish-web-app_3_0-1.dtd").exists()) {
            config = "GlassFishEE6WC/Instances";
            deployer = "deployer:gfv3ee6wc";
            defaultDisplayName = "GlassFish Server 3.1";
        } else if (new File(glassfishHome, "lib/schemas/web-app_3_0.xsd").exists()) {
            config = "GlassFishEE6/Instances";
            deployer = "deployer:gfv3ee6";
            defaultDisplayName = "GlassFish Server 3";
        } else if (!new File(glassfishHome, "lib/schemas/web-app_3_0.xsd").exists()) {
            config = "GlassFish/Instances";
            deployer = "deployer:gfv3";
            defaultDisplayName = "GlassFish v3 Prelude";
        } else {
            LOGGER.log(Level.INFO, "Cannot register the default GlassFish server. The GlassFish Root directory " + glassfishRoot + " is of unknown version.");
            return 4;
        }
        FileObject serverInstanceDir = FileUtil.getConfigFile((String)config);
        if (serverInstanceDir == null && (serverInstanceDir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)config)) == null) {
            LOGGER.log(Level.INFO, "Cannot register the default GlassFish server. The config/" + config + " folder cannot be created.");
            return 2;
        }
        String url = "[" + glassfishRoot + "]" + deployer + ":localhost:4848";
        for (FileObject fo : serverInstanceDir.getChildren()) {
            if (!url.equals(fo.getAttribute("url"))) continue;
            return 0;
        }
        String displayName = AutomaticRegistration.generateUniqueDisplayName(serverInstanceDir, defaultDisplayName);
        boolean ok = AutomaticRegistration.registerServerInstanceFO(serverInstanceDir, url, displayName, glassfishHome);
        if (ok) {
            return 0;
        }
        return 6;
    }

    private static String generateUniqueDisplayName(FileObject serverInstanceDir, String defaultDisplayName) {
        String displayName = defaultDisplayName;
        boolean unique = true;
        int i = 1;
        while (true) {
            for (FileObject fo : serverInstanceDir.getChildren()) {
                if (!displayName.equals(fo.getAttribute("displayName"))) continue;
                unique = false;
                break;
            }
            if (unique) break;
            displayName = defaultDisplayName + " " + i++;
            unique = true;
        }
        return displayName;
    }

    private static boolean registerServerInstanceFO(FileObject serverInstanceDir, String url, String displayName, File glassfishRoot) {
        String name = FileUtil.findFreeFileName((FileObject)serverInstanceDir, (String)"glassfish_autoregistered_instance", null);
        try {
            FileObject instanceFO = serverInstanceDir.createData(name);
            instanceFO.setAttribute("url", (Object)url);
            instanceFO.setAttribute("username", (Object)"admin");
            instanceFO.setAttribute("password", (Object)"");
            instanceFO.setAttribute("displayName", (Object)displayName);
            instanceFO.setAttribute("adminPort", (Object)"4848");
            instanceFO.setAttribute("installfolder", (Object)glassfishRoot.getParent());
            instanceFO.setAttribute("debugPort", (Object)"");
            instanceFO.setAttribute("domainname", (Object)"domain1");
            instanceFO.setAttribute("domainsfolder", (Object)new File(glassfishRoot, "domains").getAbsolutePath());
            instanceFO.setAttribute("driverDeployOn", (Object)"true");
            instanceFO.setAttribute("installfolder", (Object)glassfishRoot.getParent());
            instanceFO.setAttribute("host", (Object)"localhost");
            instanceFO.setAttribute("homefolder", (Object)glassfishRoot.getAbsolutePath());
            instanceFO.setAttribute("java.platform", (Object)"");
            instanceFO.setAttribute("httpportnumber", (Object)"8080");
            instanceFO.setAttribute("httphostname", (Object)"localhost");
            instanceFO.setAttribute("jvmMode", (Object)"normalMode");
            instanceFO.setAttribute("preserveSessionsOn", (Object)true);
            instanceFO.setAttribute("derbyStartOn", (Object)true);
            instanceFO.setAttribute("useIDEProxyOn", (Object)true);
            instanceFO.setAttribute("use.shared.mem", (Object)false);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Cannot register the default GlassFish server.");
            LOGGER.log(Level.INFO, null, e);
            return false;
        }
    }
}

