/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.Dialog;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.imports.ClipboardImportPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClipboardHandler {
    private static final Logger LOG = Logger.getLogger(ClipboardHandler.class.getName());
    private static final RequestProcessor WORKER = new RequestProcessor(ClipboardHandler.class.getName(), 1, false, false);
    static boolean autoImport = false;
    private static final Object NO_IMPORTS = new Object();
    private static final DataFlavor IMPORT_FLAVOR = new DataFlavor(ImportsWrapper.class, NbBundle.getMessage(ClipboardHandler.class, (String)"MSG_ClipboardImportFlavor"));

    public static void install(JTextComponent c) {
        c.setTransferHandler(new ImportingTransferHandler(c.getTransferHandler()));
    }

    private static void doImport(JavaSource js, final Document doc, final int caret, final Map<String, String> simple2ImportFQN, final List<Position[]> inSpans, AtomicBoolean cancel) {
        final HashMap putFQNs = new HashMap();
        try {
            final ModificationResult mr = js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TreePath context = copy.getTreeUtilities().pathFor(caret);
                    ArrayList spans = new ArrayList(inSpans);
                    Collections.sort(spans, new Comparator<Position[]>(){

                        @Override
                        public int compare(Position[] o1, Position[] o2) {
                            return o1[0].getOffset() - o2[0].getOffset();
                        }
                    });
                    HashMap<String, String> imported = new HashMap<String, String>();
                    for (Position[] span : spans) {
                        String currentSimpleName = copy.getText().substring(span[0].getOffset(), span[1].getOffset());
                        String handled = (String)imported.get(currentSimpleName);
                        if (handled == null) {
                            String fqn = (String)simple2ImportFQN.get(currentSimpleName);
                            if (copy.getElements().getTypeElement(fqn) == null) continue;
                            handled = SourceUtils.resolveImport((CompilationInfo)copy, (TreePath)context, (String)fqn);
                            imported.put(currentSimpleName, handled);
                        }
                        putFQNs.put(span, handled);
                    }
                }
            });
            if (cancel.get()) {
                return;
            }
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        mr.commit();
                        for (Map.Entry e : putFQNs.entrySet()) {
                            doc.remove(((Position[])e.getKey())[0].getOffset(), ((Position[])e.getKey())[1].getOffset() - ((Position[])e.getKey())[0].getOffset());
                            doc.insertString(((Position[])e.getKey())[0].getOffset(), (String)e.getValue(), null);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void showImportDialog(final JavaSource js, final Document doc, final int caret, final Map<String, String> simple2ImportFQN, Collection<String> toShow, final List<Position[]> inSpans) {
        if (autoImport) {
            ClipboardHandler.doImport(js, doc, caret, simple2ImportFQN, inSpans, new AtomicBoolean());
            return;
        }
        ClipboardImportPanel panel = new ClipboardImportPanel(toShow);
        final AtomicBoolean cancel = new AtomicBoolean();
        final JButton okButton = new JButton(NbBundle.getMessage(ClipboardHandler.class, (String)"BTN_ClipboardImportOK"));
        JButton cancelButton = new JButton(NbBundle.getMessage(ClipboardHandler.class, (String)"BTN_ClipboardImportCancel"));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ClipboardHandler.class, (String)"MSG_ClipboardImportImportClasses"), true, new Object[]{okButton, cancelButton}, (Object)okButton, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        final Dialog[] d = new Dialog[1];
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                okButton.setEnabled(false);
                WORKER.post(new Runnable(){

                    @Override
                    public void run() {
                        ClipboardHandler.doImport(js, doc, caret, simple2ImportFQN, inSpans, cancel);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                d[0].setVisible(false);
                            }
                        });
                    }
                });
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cancel.set(true);
                d[0].setVisible(false);
            }
        });
        d[0] = DialogDisplayer.getDefault().createDialog(dd);
        d[0].setVisible(true);
    }

    private static Collection<? extends String> needsImports(JavaSource js, final int caret, final Map<String, String> simple2FQNs) {
        final ArrayList unavailable = new ArrayList();
        try {
            Future wait = js.runWhenScanFinished((Task)new Task<CompilationController>(){

                public void run(final CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TreePath tp = cc.getTreeUtilities().pathFor(caret);
                    final Scope context = cc.getTrees().getScope(tp);
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element e, TypeMirror type) {
                            return (e.getKind().isClass() || e.getKind().isInterface()) && cc.getTrees().isAccessible(context, (TypeElement)e);
                        }
                    };
                    SourcePositions[] sps = new SourcePositions[1];
                    for (Map.Entry e : simple2FQNs.entrySet()) {
                        TypeElement type = cc.getElements().getTypeElement((CharSequence)e.getValue());
                        if (type == null) continue;
                        ExpressionTree simpleName = cc.getTreeUtilities().parseExpression((String)e.getKey() + ".class", sps);
                        cc.getTreeUtilities().attributeTree((Tree)simpleName, context);
                        Element el = cc.getTrees().getElement(new TreePath(tp, ((MemberSelectTree)simpleName).getExpression()));
                        if (type.equals(el)) continue;
                        unavailable.add(e.getValue());
                    }
                }
            }, true);
            wait.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (TimeoutException ex) {
            LOG.log(Level.FINE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return unavailable;
    }

    public static final class JavaCutAction
    extends BaseKit.CutAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(final ActionEvent evt, final JTextComponent target) {
            JavaSource js = JavaSource.forDocument((Document)target.getDocument());
            final Object lock = new Object();
            final AtomicBoolean cancel = new AtomicBoolean();
            final AtomicBoolean alreadyRunning = new AtomicBoolean();
            try {
                if (js != null) {
                    Future fut = js.runWhenScanFinished((Task)new Task<CompilationController>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(CompilationController parameter) throws Exception {
                            Object object = lock;
                            synchronized (object) {
                                if (cancel.get()) {
                                    return;
                                }
                                alreadyRunning.set(true);
                            }
                            JavaCutAction.super.actionPerformed(evt, target);
                        }
                    }, true);
                    fut.get(100L, TimeUnit.MILLISECONDS);
                    return;
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (TimeoutException ex) {
                LOG.log(Level.FINE, null, ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            Object object = lock;
            synchronized (object) {
                if (alreadyRunning.get()) {
                    return;
                }
                cancel.set(true);
            }
            try {
                target.putClientProperty(NO_IMPORTS, true);
                super.actionPerformed(evt, target);
            }
            finally {
                target.putClientProperty(NO_IMPORTS, null);
            }
        }
    }

    public static final class ImportsWrapper {
        private final FileObject sourceFO;
        private final Map<String, String> simple2ImportFQN;
        private final List<int[]> identifiers;

        public ImportsWrapper(FileObject sourceFO, Map<String, String> simple2ImportFQN, List<int[]> identifiers) {
            this.sourceFO = sourceFO;
            this.simple2ImportFQN = simple2ImportFQN;
            this.identifiers = identifiers;
        }
    }

    private static final class WrappedTransferable
    implements Transferable {
        private final Transferable delegate;
        private final ImportsWrapper importsData;
        private DataFlavor[] transferDataFlavorsCache;

        public WrappedTransferable(Transferable delegate, ImportsWrapper importsData) {
            this.delegate = delegate;
            this.importsData = importsData;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            if (this.transferDataFlavorsCache != null) {
                return this.transferDataFlavorsCache;
            }
            DataFlavor[] f = this.delegate.getTransferDataFlavors();
            DataFlavor[] result = Arrays.copyOf(f, f.length + 1);
            result[f.length] = IMPORT_FLAVOR;
            this.transferDataFlavorsCache = result;
            return result;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return IMPORT_FLAVOR.equals(flavor) || this.delegate.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (IMPORT_FLAVOR.equals(flavor)) {
                return this.importsData;
            }
            return this.delegate.getTransferData(flavor);
        }
    }

    private static final class ImportingTransferHandler
    extends TransferHandler {
        private final TransferHandler delegate;

        public ImportingTransferHandler(TransferHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return this.delegate.canImport(support);
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return this.delegate.canImport(comp, transferFlavors);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            try {
                Method method = this.delegate.getClass().getDeclaredMethod("createTransferable", JComponent.class);
                method.setAccessible(true);
                return (Transferable)method.invoke((Object)this.delegate, c);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            return null;
        }

        @Override
        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
            this.delegate.exportAsDrag(comp, e, action);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            try {
                Method method = this.delegate.getClass().getDeclaredMethod("exportDone", JComponent.class, Transferable.class, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.delegate, source, data, new Integer(action));
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            JavaSource js;
            if (comp instanceof JTextComponent && comp.getClientProperty(NO_IMPORTS) == null && (js = JavaSource.forDocument((Document)((JTextComponent)comp).getDocument())) != null) {
                JTextComponent tc = (JTextComponent)comp;
                final int start = tc.getSelectionStart();
                final int end = tc.getSelectionEnd();
                try {
                    final HashMap<String, String> simple2ImportFQN = new HashMap<String, String>();
                    final ArrayList<int[]> spans = new ArrayList<int[]>();
                    Future fut = js.runWhenScanFinished((Task)new Task<CompilationController>(){

                        public void run(final CompilationController parameter) throws Exception {
                            parameter.toPhase(JavaSource.Phase.RESOLVED);
                            new TreePathScanner<Void, Void>(){
                                private Tree lastType;

                                @Override
                                public Void visitIdentifier(IdentifierTree node, Void p) {
                                    int s = (int)parameter.getTrees().getSourcePositions().getStartPosition(parameter.getCompilationUnit(), node);
                                    int e = (int)parameter.getTrees().getSourcePositions().getEndPosition(parameter.getCompilationUnit(), node);
                                    Element el = parameter.getTrees().getElement(this.getCurrentPath());
                                    if (s >= start && e <= end && el != null && (el.getKind().isClass() || el.getKind().isInterface())) {
                                        simple2ImportFQN.put(el.getSimpleName().toString(), ((TypeElement)el).getQualifiedName().toString());
                                        spans.add(new int[]{s - start, e - start});
                                    }
                                    return (Void)super.visitIdentifier(node, p);
                                }

                                @Override
                                public Void visitVariable(VariableTree node, Void p) {
                                    if (this.lastType == node.getType()) {
                                        this.scan((Tree)node.getInitializer(), null);
                                        return null;
                                    }
                                    this.lastType = node.getType();
                                    return (Void)super.visitVariable(node, p);
                                }

                                @Override
                                public Void scan(Tree tree, Void p) {
                                    if (tree == null || parameter.getTreeUtilities().isSynthetic(new TreePath(this.getCurrentPath(), tree))) {
                                        return null;
                                    }
                                    return (Void)super.scan(tree, p);
                                }
                            }.scan((Tree)parameter.getCompilationUnit(), (Void)null);
                        }
                    }, true);
                    try {
                        fut.get(100L, TimeUnit.MILLISECONDS);
                        this.delegate.exportToClipboard(comp, clip, action);
                        clip.setContents(new WrappedTransferable(clip.getContents(null), new ImportsWrapper(NbEditorUtilities.getFileObject((Document)tc.getDocument()), simple2ImportFQN, spans)), null);
                        return;
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (TimeoutException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.delegate.exportToClipboard(comp, clip, action);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return this.delegate.getSourceActions(c);
        }

        @Override
        public Icon getVisualRepresentation(Transferable t) {
            return this.delegate.getVisualRepresentation(t);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            return this.delegate.importData(support);
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (t.isDataFlavorSupported(IMPORT_FLAVOR) && comp instanceof JTextComponent) {
                boolean result = false;
                try {
                    final JTextComponent tc = (JTextComponent)comp;
                    final int caret = tc.getSelectionStart();
                    result = this.delegate.importData(comp, t);
                    if (result) {
                        final ImportsWrapper imports = (ImportsWrapper)t.getTransferData(IMPORT_FLAVOR);
                        final FileObject file = NbEditorUtilities.getFileObject((Document)tc.getDocument());
                        final Document doc = tc.getDocument();
                        final ArrayList<Position[]> inSpans = new ArrayList<Position[]>();
                        for (int[] span : imports.identifiers) {
                            inSpans.add(new Position[]{doc.createPosition(caret + span[0]), doc.createPosition(caret + span[1])});
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JavaSource js = JavaSource.forDocument((Document)tc.getDocument());
                                if (js == null) {
                                    return;
                                }
                                Collection unavailable = ClipboardHandler.needsImports(js, caret, imports.simple2ImportFQN);
                                if (unavailable == null) {
                                    unavailable = file == null || !file.equals(imports.sourceFO) ? imports.simple2ImportFQN.values() : Collections.emptyList();
                                }
                                HashSet toShow = new HashSet(imports.simple2ImportFQN.values());
                                toShow.retainAll(unavailable);
                                if (!unavailable.isEmpty()) {
                                    ClipboardHandler.showImportDialog(js, doc, caret, imports.simple2ImportFQN, toShow, inSpans);
                                }
                            }
                        });
                    }
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (UnsupportedFlavorException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return result;
            }
            return this.delegate.importData(comp, t);
        }
    }
}

