/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.java.JavaKit;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class SelectCodeElementAction
extends BaseAction {
    private boolean selectNext;

    public SelectCodeElementAction(String name, boolean selectNext) {
        super(name);
        this.selectNext = selectNext;
        String desc = this.getShortDescription();
        if (desc != null) {
            this.putValue("ShortDescription", desc);
        }
    }

    public String getShortDescription() {
        String shortDesc;
        String name = (String)this.getValue("Name");
        if (name == null) {
            return null;
        }
        try {
            shortDesc = NbBundle.getBundle(JavaKit.class).getString(name);
        }
        catch (MissingResourceException mre) {
            shortDesc = name;
        }
        return shortDesc;
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            int selectionStartOffset = target.getSelectionStart();
            int selectionEndOffset = target.getSelectionEnd();
            if (selectionEndOffset > selectionStartOffset || this.selectNext) {
                SelectionHandler handler = (SelectionHandler)target.getClientProperty(SelectionHandler.class);
                if (handler == null) {
                    handler = new SelectionHandler(target, this.getShortDescription());
                    target.addCaretListener(handler);
                    target.putClientProperty(SelectionHandler.class, handler);
                }
                if (this.selectNext) {
                    handler.selectNext();
                } else {
                    handler.selectPrevious();
                }
            }
        }
    }

    private static final class SelectionInfo {
        private int startOffset;
        private int endOffset;

        SelectionInfo(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    private static final class SelectionHandler
    implements CaretListener,
    Task<CompilationController>,
    Runnable {
        private JTextComponent target;
        private String name;
        private SelectionInfo[] selectionInfos;
        private int selIndex = -1;
        private boolean ignoreNextCaretUpdate;
        private AtomicBoolean cancel;

        SelectionHandler(JTextComponent target, String name) {
            this.target = target;
        }

        public void selectNext() {
            JavaSource js;
            if (this.selectionInfos == null && (js = JavaSource.forDocument((Document)this.target.getDocument())) != null) {
                this.cancel = new AtomicBoolean();
                ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            js.runUserActionTask((Task)SelectionHandler.this, true);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }, (String)this.name, (AtomicBoolean)this.cancel, (boolean)false);
            }
            this.run();
        }

        public synchronized void selectPrevious() {
            if (this.selIndex > 0) {
                this.select(this.selectionInfos[--this.selIndex]);
            }
        }

        private void select(SelectionInfo selectionInfo) {
            Caret caret = this.target.getCaret();
            this.markIgnoreNextCaretUpdate();
            caret.setDot(selectionInfo.getStartOffset());
            this.markIgnoreNextCaretUpdate();
            caret.moveDot(selectionInfo.getEndOffset());
        }

        private void markIgnoreNextCaretUpdate() {
            this.ignoreNextCaretUpdate = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void caretUpdate(CaretEvent e) {
            if (!this.ignoreNextCaretUpdate) {
                SelectionHandler selectionHandler = this;
                synchronized (selectionHandler) {
                    this.selectionInfos = null;
                    this.selIndex = -1;
                }
            }
            this.ignoreNextCaretUpdate = false;
        }

        public void run(CompilationController cc) {
            try {
                if (this.cancel != null && this.cancel.get()) {
                    return;
                }
                cc.toPhase(JavaSource.Phase.RESOLVED);
                if (this.cancel != null && this.cancel.get()) {
                    return;
                }
                this.selectionInfos = this.initSelectionPath(this.target, cc);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private SelectionInfo[] initSelectionPath(JTextComponent target, CompilationController ci) {
            ArrayList<SelectionInfo> positions = new ArrayList<SelectionInfo>();
            SourcePositions sp = ci.getTrees().getSourcePositions();
            TreePath tp = ci.getTreeUtilities().pathFor(target.getCaretPosition());
            for (Tree tree : tp) {
                int startPos = (int)sp.getStartPosition(tp.getCompilationUnit(), tree);
                int endPos = (int)sp.getEndPosition(tp.getCompilationUnit(), tree);
                positions.add(new SelectionInfo(startPos, endPos));
            }
            return positions.toArray(new SelectionInfo[positions.size()]);
        }

        @Override
        public void run() {
            if (this.selectionInfos != null && this.selIndex < this.selectionInfos.length - 1) {
                this.select(this.selectionInfos[++this.selIndex]);
            }
        }
    }
}

