/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class AnalyzeExecLog
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new LinkedHashMap<String, ProviderProperty>();
    public static final String EXEC_LOG_KEY = "exec-log-file";
    private Progress progress;

    public AnalyzeExecLog() {
        this.clean();
    }

    public final void clean() {
        this.myProperties.clear();
        this.myProperties.put(EXEC_LOG_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeExecLog.i18n("Exec_Log_File_Name");
            }

            public String getDescription() {
                return AnalyzeExecLog.i18n("Exec_Log_File_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.MakeLogFile;
            }
        });
        this.myProperties.put("restrict_source_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecLog.i18n("RESTRICT_SOURCE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecLog.i18n("RESTRICT_SOURCE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
        this.myProperties.put("restrict_compile_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecLog.i18n("RESTRICT_COMPILE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecLog.i18n("RESTRICT_COMPILE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
    }

    public String getID() {
        return "exec-log";
    }

    public String getName() {
        return AnalyzeExecLog.i18n("Exec_Log_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeExecLog.i18n("Exec_Log_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    @Override
    public boolean isApplicable(ProjectProxy project) {
        String set = (String)this.getProperty(EXEC_LOG_KEY).getValue();
        return set != null && set.length() != 0;
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project) {
        String set = (String)this.getProperty(EXEC_LOG_KEY).getValue();
        if (set == null || set.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecLog.class, (String)"NotFoundExecLog")));
        }
        return new ApplicableImpl(true, null, null, 80, false, null, null, null, null);
    }

    @Override
    protected List<SourceFileProperties> getSourceFileProperties(String objFileName, Map<String, SourceFileProperties> map, ProjectProxy project, Set<String> dlls, CompileLineStorage storage) {
        ProviderProperty p = this.getProperty("restrict_compile_root");
        String root = "";
        if (p != null) {
            root = (String)p.getValue();
        }
        List<SourceFileProperties> res = this.runLogReader(objFileName, root, this.progress, project, storage);
        this.progress = null;
        return res;
    }

    private List<SourceFileProperties> runLogReader(String objFileName, String root, Progress progress, ProjectProxy project, CompileLineStorage storage) {
        ExecLogReader clrf = new ExecLogReader(objFileName, root, project);
        List<SourceFileProperties> list = clrf.getResults(progress, this.isStoped, storage);
        return list;
    }

    public List<Configuration> analyze(final ProjectProxy project, Progress progress) {
        this.isStoped.set(false);
        ArrayList<Configuration> confs = new ArrayList<Configuration>();
        this.setCommpilerSettings(project);
        this.progress = progress;
        if (!this.isStoped.get()) {
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles = new ArrayList<String>();

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)project);
                }

                public List<String> getDependencies() {
                    return null;
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    String set;
                    if (this.myFileProperties == null && (set = (String)AnalyzeExecLog.this.getProperty(AnalyzeExecLog.EXEC_LOG_KEY).getValue()) != null && set.length() > 0) {
                        this.myFileProperties = AnalyzeExecLog.this.getSourceFileProperties(new String[]{set}, null, project, null, new CompileLineStorage());
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
        }
        return confs;
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(AnalyzeExecLog.class, (String)id);
    }

    private static class ExecSource
    implements SourceFileProperties {
        private String compilePath;
        private String sourceName;
        private String fullName;
        private String compiler;
        private ItemProperties.LanguageKind language;
        private List<String> userIncludes;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private Set<String> includedFiles = Collections.emptySet();
        private final CompileLineStorage storage;
        private int handler = -1;

        private ExecSource(CompileLineStorage storage) {
            this.storage = storage;
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getCompileLine() {
            return this.storage.getCompileLine(this.handler);
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }

        public String getCompilerName() {
            return this.compiler;
        }

        public ItemProperties.LanguageStandard getLanguageStandard() {
            return ItemProperties.LanguageStandard.Unknown;
        }
    }

    private static final class ExecLogReader {
        private static final boolean TRACE = false;
        private final String root;
        private final String fileName;
        private List<SourceFileProperties> result;
        private final ProjectProxy project;
        private final PathMap pathMapper;
        private final FileSystem fileSystem;

        public ExecLogReader(String fileName, String root, ProjectProxy project) {
            this.root = root.length() > 0 ? CndFileUtils.normalizeFile((File)new File(root)).getAbsolutePath() : root;
            this.fileName = fileName;
            this.project = project;
            this.pathMapper = this.getPathMapper(project);
            this.fileSystem = this.getFileSystem(project);
        }

        private PathMap getPathMapper(ProjectProxy project) {
            Project p;
            if (project != null && (p = project.getProject()) != null) {
                return RemoteSyncSupport.getPathMap((Project)p);
            }
            return null;
        }

        private FileSystem getFileSystem(ProjectProxy project) {
            Project p;
            if (project != null && (p = project.getProject()) != null) {
                return RemoteFileUtil.getProjectSourceFileSystem((Project)p);
            }
            return CndFileUtils.getLocalFileSystem();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run(Progress progress, AtomicBoolean isStoped, CompileLineStorage storage) {
            this.result = new ArrayList<SourceFileProperties>();
            File file = new File(this.fileName);
            if (file.exists() && file.canRead()) {
                try {
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    long length = file.length();
                    long read = 0L;
                    int done = 0;
                    if (length <= 0L) {
                        progress = null;
                    }
                    if (progress != null) {
                        progress.start(100);
                    }
                    try {
                        String tool = null;
                        ArrayList<String> params = new ArrayList<String>();
                        while (!isStoped.get()) {
                            String line = in.readLine();
                            if (line == null) {
                                break;
                            }
                            if ((read += (long)(line.length() + 1)) * 100L / length > (long)done && done < 100) {
                                ++done;
                                if (progress != null) {
                                    progress.increment(null);
                                }
                            }
                            if (line.startsWith("called:")) {
                                tool = line.substring(7).trim();
                                continue;
                            }
                            if (line.startsWith("\t")) {
                                params.add(line.substring(1).trim());
                                continue;
                            }
                            if (line.length() != 0) continue;
                            try {
                                this.addSources(tool, params, storage);
                            }
                            catch (Throwable ex) {
                                // empty catch block
                            }
                            tool = null;
                            params = new ArrayList();
                        }
                    }
                    finally {
                        if (progress != null) {
                            progress.done();
                        }
                    }
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }

        public List<SourceFileProperties> getResults(Progress progress, AtomicBoolean isStoped, CompileLineStorage storage) {
            if (this.result == null) {
                this.run(progress, isStoped, storage);
            }
            return this.result;
        }

        /*
         * WARNING - void declaration
         */
        private void addSources(String tool, List<String> args, CompileLineStorage storage) {
            Iterator<String> iterator;
            String compiler = null;
            ItemProperties.LanguageKind language = null;
            String compilePath = null;
            compiler = tool.lastIndexOf(47) > 0 ? tool.substring(tool.lastIndexOf(47) + 1) : tool;
            language = compiler.equals("cc") || compiler.equals("gcc") ? ItemProperties.LanguageKind.C : (compiler.equals("CC") || compiler.equals("g++") || compiler.equals("c++") ? ItemProperties.LanguageKind.CPP : (compiler.equals("ffortran") || compiler.equals("f77") || compiler.equals("f90") || compiler.equals("f95") || compiler.equals("gfortran") || compiler.equals("g77") || compiler.equals("g90") || compiler.equals("g95") ? ItemProperties.LanguageKind.Fortran : ItemProperties.LanguageKind.Unknown));
            if (args.size() > 0) {
                if (this.pathMapper != null) {
                    compilePath = this.pathMapper.getLocalPath(args.get(0));
                    if (compilePath == null) {
                        compilePath = args.get(0);
                    }
                } else {
                    compilePath = args.get(0);
                }
            }
            if ((iterator = args.iterator()).hasNext()) {
                iterator.next();
            }
            if (iterator.hasNext()) {
                iterator.next();
            }
            ArrayList aUserIncludes = new ArrayList();
            HashMap aUserMacros = new HashMap();
            ArrayList languageArtifacts = new ArrayList();
            List sourcesList = DiscoveryUtils.gatherCompilerLine(iterator, (boolean)false, aUserIncludes, aUserMacros, null, languageArtifacts);
            for (String what : sourcesList) {
                FileObject f;
                String sourceName;
                String fullName;
                if (what == null || what.endsWith(".s") || what.endsWith(".S")) continue;
                ArrayList<String> userIncludes = new ArrayList<String>(aUserIncludes.size());
                HashMap<String, String> userMacros = new HashMap<String, String>(aUserMacros.size());
                for (String string : aUserIncludes) {
                    void var19_22;
                    String mapped;
                    if (string.startsWith("/") && this.pathMapper != null && (mapped = this.pathMapper.getLocalPath(string)) != null) {
                        String string2 = mapped;
                    }
                    userIncludes.add(PathCache.getString((String)var19_22));
                }
                userMacros = new HashMap(aUserMacros.size());
                for (Map.Entry entry : aUserMacros.entrySet()) {
                    if (entry.getValue() == null) {
                        userMacros.put(PathCache.getString((String)entry.getKey()), null);
                        continue;
                    }
                    userMacros.put(PathCache.getString((String)entry.getKey()), PathCache.getString((String)entry.getValue()));
                }
                if (what.startsWith("/")) {
                    String mapped;
                    if (this.pathMapper != null && (mapped = this.pathMapper.getLocalPath(what)) != null) {
                        what = mapped;
                    }
                    fullName = what;
                    sourceName = DiscoveryUtils.getRelativePath((String)compilePath, (String)what);
                } else {
                    fullName = compilePath + "/" + what;
                    sourceName = what;
                }
                if ((f = this.fileSystem.findResource(fullName)) == null || !f.isValid() || !f.isData()) continue;
                fullName = PathCache.getString(f.getPath());
                if (languageArtifacts.contains("c")) {
                    language = ItemProperties.LanguageKind.C;
                } else if (languageArtifacts.contains("c++")) {
                    language = ItemProperties.LanguageKind.CPP;
                } else {
                    String string = MIMESupport.getKnownSourceFileMIMETypeByExtension((String)fullName);
                    if ("text/x-c++".equals(string)) {
                        language = ItemProperties.LanguageKind.CPP;
                    } else if ("text/x-c".equals(string)) {
                        language = ItemProperties.LanguageKind.C;
                    }
                }
                ExecSource execSource = new ExecSource(storage);
                execSource.compilePath = compilePath;
                execSource.sourceName = sourceName;
                execSource.fullName = fullName;
                execSource.language = language;
                execSource.userIncludes = userIncludes;
                execSource.userMacros = userMacros;
                if (storage != null) {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 2; i < args.size(); ++i) {
                        if (buf.length() > 0) {
                            buf.append(' ');
                        }
                        buf.append(args.get(i));
                    }
                    execSource.handler = storage.putCompileLine(buf.toString());
                }
                this.result.add(execSource);
            }
        }
    }
}

