/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.repository.FindInRepoPanel;
import org.netbeans.modules.maven.repository.FindResultsPanel;
import org.netbeans.modules.maven.repository.RepositoryNode;
import org.netbeans.modules.maven.repository.register.RepositoryRegisterUI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class M2RepositoryBrowserTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static M2RepositoryBrowserTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/maven/repository/MavenRepoBrowser.png";
    private static final String PREFERRED_ID = "M2RepositoryBrowserTopComponent";
    private BeanTreeView btv;
    private ExplorerManager manager;
    private JButton btnAddRepo;
    private JButton btnFind;
    private JButton btnIndex;
    private JSplitPane jSplitPane1;
    private JPanel pnlBrowse;
    private JPanel pnlExplorer;
    private JPanel pnlFind;
    private JToolBar toolbar;

    private M2RepositoryBrowserTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"CTL_M2RepositoryBrowserTopComponent"));
        this.setToolTipText(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"HINT_M2RepositoryBrowserTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"A11Y_BrowserName"));
        this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"A11Y_BrowserDescription"));
        this.manager = new ExplorerManager();
        this.manager.setRootContext((Node)new AbstractNode(Children.create((ChildFactory)new RootNodes(), (boolean)true)));
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        this.pnlBrowse.add((Component)this.btv, "Center");
        this.hideFind();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void hideFind() {
        this.pnlFind.removeAll();
        this.pnlFind.setVisible(false);
        this.jSplitPane1.setDividerLocation(1.0);
        this.jSplitPane1.setEnabled(false);
    }

    private void showFind(List<QueryField> fields, DialogDescriptor dd) {
        FindResultsPanel pnl = new FindResultsPanel(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                M2RepositoryBrowserTopComponent.this.hideFind();
            }
        }, dd);
        pnl.find(fields);
        this.pnlFind.add(pnl);
        this.pnlFind.setVisible(true);
        this.jSplitPane1.setEnabled(true);
        this.jSplitPane1.setDividerLocation(0.5);
    }

    private void initComponents() {
        this.pnlExplorer = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.pnlBrowse = new JPanel();
        this.pnlFind = new JPanel();
        this.toolbar = new JToolBar();
        this.btnIndex = new JButton();
        this.btnAddRepo = new JButton();
        this.btnFind = new JButton();
        this.setLayout(new BorderLayout());
        this.pnlExplorer.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerSize(3);
        this.jSplitPane1.setOrientation(0);
        this.pnlBrowse.setLayout(new BorderLayout());
        this.jSplitPane1.setTopComponent(this.pnlBrowse);
        this.pnlFind.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.pnlFind);
        this.pnlExplorer.add((Component)this.jSplitPane1, "Center");
        this.add(this.pnlExplorer, "Center");
        this.toolbar.setFloatable(false);
        this.btnIndex.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/maven/repository/refreshRepo.png")));
        this.btnIndex.setToolTipText(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_REPO_Update_Indexes"));
        this.btnIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                M2RepositoryBrowserTopComponent.this.btnIndexActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnIndex);
        this.btnIndex.getAccessibleContext().setAccessibleName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnIndex.AccessibleContext.accessibleName"));
        this.btnIndex.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnIndex.AccessibleContext.accessibleDescription"));
        this.btnAddRepo.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/maven/repository/AddRepo.png")));
        this.btnAddRepo.setToolTipText(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_Add_Repo", (Object[])new Object[0]));
        this.btnAddRepo.setHorizontalTextPosition(0);
        this.btnAddRepo.setVerticalTextPosition(3);
        this.btnAddRepo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                M2RepositoryBrowserTopComponent.this.btnAddRepoActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnAddRepo);
        this.btnAddRepo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnAddRepo.AccessibleContext.accessibleName"));
        this.btnAddRepo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnAddRepo.AccessibleContext.accessibleDescription"));
        this.btnFind.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/maven/repository/FindInRepo.png")));
        this.btnFind.setToolTipText(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_REPO_Find"));
        this.btnFind.setHorizontalTextPosition(0);
        this.btnFind.setVerticalTextPosition(3);
        this.btnFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                M2RepositoryBrowserTopComponent.this.btnFindActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnFind);
        this.btnFind.getAccessibleContext().setAccessibleName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnFind.AccessibleContext.accessibleName"));
        this.btnFind.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnFind.AccessibleContext.accessibleDescription"));
        this.add(this.toolbar, "First");
    }

    private void btnIndexActionPerformed(ActionEvent evt) {
        this.btnIndex.setEnabled(false);
        new RequestProcessor("Maven Repo Index Transfer/Scan").post(new Runnable(){

            @Override
            public void run() {
                List infos = RepositoryPreferences.getInstance().getRepositoryInfos();
                for (RepositoryInfo ri : infos) {
                    RepositoryIndexer.indexRepo((RepositoryInfo)ri);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        M2RepositoryBrowserTopComponent.this.btnIndex.setEnabled(true);
                    }
                });
            }
        });
    }

    private void btnAddRepoActionPerformed(ActionEvent evt) {
        RepositoryRegisterUI rrui = new RepositoryRegisterUI();
        rrui.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_Add_Repo"));
        DialogDescriptor dd = new DialogDescriptor((Object)rrui, NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_Add_Repo"));
        dd.setClosingOptions(new Object[]{rrui.getButton(), DialogDescriptor.CANCEL_OPTION});
        dd.setOptions(new Object[]{rrui.getButton(), DialogDescriptor.CANCEL_OPTION});
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (rrui.getButton() == ret) {
            RepositoryInfo info;
            try {
                info = rrui.getRepositoryInfo();
            }
            catch (URISyntaxException x) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0));
                return;
            }
            RepositoryPreferences.getInstance().addOrModifyRepositoryInfo(info);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    RepositoryIndexer.indexRepo((RepositoryInfo)info);
                }
            });
        }
    }

    private void btnFindActionPerformed(ActionEvent evt) {
        this.hideFind();
        FindInRepoPanel pnl = new FindInRepoPanel();
        pnl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"ACSD_Find_In_Repositories"));
        DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"TIT_Find_In_Repositories"));
        pnl.attachDesc(dd);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == DialogDescriptor.OK_OPTION) {
            this.showFind(pnl.getQuery(), dd);
        }
    }

    public static synchronized M2RepositoryBrowserTopComponent getDefault() {
        if (instance == null) {
            instance = new M2RepositoryBrowserTopComponent();
        }
        return instance;
    }

    public static synchronized M2RepositoryBrowserTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return M2RepositoryBrowserTopComponent.getDefault();
        }
        if (win instanceof M2RepositoryBrowserTopComponent) {
            return (M2RepositoryBrowserTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'M2RepositoryBrowserTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return M2RepositoryBrowserTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public boolean requestFocusInWindow() {
        return this.btv.requestFocusInWindow();
    }

    public void requestFocus() {
        this.btv.requestFocus();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return M2RepositoryBrowserTopComponent.getDefault();
        }
    }

    private static class RootNodes
    extends ChildFactory.Detachable<RepositoryInfo>
    implements ChangeListener {
        private RootNodes() {
        }

        protected boolean createKeys(List<RepositoryInfo> toPopulate) {
            toPopulate.addAll(RepositoryPreferences.getInstance().getRepositoryInfos());
            return true;
        }

        protected Node createNodeForKey(RepositoryInfo key) {
            return new RepositoryNode(key);
        }

        protected void addNotify() {
            RepositoryPreferences.getInstance().addChangeListener((ChangeListener)this);
        }

        protected void removeNotify() {
            RepositoryPreferences.getInstance().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }
    }
}

