/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.support.APTHandlersSupportImpl;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.filesystems.FileSystem;

public class APTPreprocHandlerImpl
implements APTPreprocHandler {
    private boolean compileContext;
    private boolean isValid = true;
    private APTMacroMap macroMap;
    private APTIncludeHandler inclHandler;

    public APTPreprocHandlerImpl(APTMacroMap macroMap, APTIncludeHandler inclHandler, boolean compileContext) {
        this.macroMap = macroMap;
        this.inclHandler = inclHandler;
        this.compileContext = compileContext;
    }

    @Override
    public APTMacroMap getMacroMap() {
        return this.macroMap;
    }

    @Override
    public APTIncludeHandler getIncludeHandler() {
        return this.inclHandler;
    }

    @Override
    public APTPreprocHandler.State getState() {
        return this.createStateImpl();
    }

    @Override
    public void setState(APTPreprocHandler.State state) {
        if (state instanceof StateImpl) {
            ((StateImpl)state).restoreTo(this);
        }
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean isCompileContext() {
        return this.compileContext;
    }

    protected StateImpl createStateImpl() {
        return new StateImpl(this);
    }

    private void setCompileContext(boolean state) {
        this.compileContext = state;
    }

    public String toString() {
        StringBuilder retValue = new StringBuilder();
        retValue.append(this.isCompileContext() ? "\nCompile Context" : "\nDefault/Null State");
        retValue.append("\nInclude Info:\n");
        retValue.append(this.inclHandler);
        retValue.append("\nMACROS info:\n");
        retValue.append(this.macroMap);
        return retValue.toString();
    }

    public static final class StateImpl
    implements APTPreprocHandler.State {
        final APTMacroMap.State macroState;
        final APTIncludeHandler.State inclState;
        private final byte attributes;
        private static final byte COMPILE_CONTEXT_FLAG = 1;
        private static final byte CLEANED_FLAG = 2;
        private static final byte VALID_FLAG = 4;

        private static byte createAttributes(boolean compileContext, boolean cleaned, boolean valid) {
            byte out = 0;
            out = compileContext ? (byte)((byte)(out | 1)) : (byte)((byte)(out & 0xFFFFFFFE));
            out = cleaned ? (byte)((byte)(out | 2)) : (byte)((byte)(out & 0xFFFFFFFD));
            out = valid ? (byte)((byte)(out | 4)) : (byte)((byte)(out & 0xFFFFFFFB));
            return out;
        }

        protected StateImpl(APTPreprocHandlerImpl handler) {
            this.macroState = handler.getMacroMap() != null ? handler.getMacroMap().getState() : null;
            this.inclState = handler.getIncludeHandler() != null ? handler.getIncludeHandler().getState() : null;
            this.attributes = StateImpl.createAttributes(handler.isCompileContext(), false, handler.isValid());
        }

        private StateImpl(StateImpl other, boolean cleanState, boolean compileContext, boolean valid) {
            boolean cleaned;
            if (cleanState && !other.isCleaned()) {
                this.inclState = APTHandlersSupportImpl.copyIncludeState(other.inclState, true);
                this.macroState = APTHandlersSupportImpl.createCleanMacroState(other.macroState);
                cleaned = true;
            } else {
                this.macroState = other.macroState;
                cleaned = other.isCleaned();
                this.inclState = other.inclState;
            }
            this.attributes = StateImpl.createAttributes(compileContext, cleaned, valid);
        }

        private void restoreTo(APTPreprocHandlerImpl handler) {
            if (handler.getMacroMap() != null) {
                handler.getMacroMap().setState(this.macroState);
            }
            if (handler.getIncludeHandler() != null) {
                handler.getIncludeHandler().setState(this.inclState);
            }
            handler.setCompileContext(this.isCompileContext());
            handler.setValid(this.isValid());
            if (!this.isValid()) {
                APTUtils.LOG.log(Level.SEVERE, "setting invalid state {0}", new Object[]{this});
            }
        }

        public String toString() {
            StringBuilder retValue = new StringBuilder();
            retValue.append(this.isCleaned() ? "\nCleaned State;" : "\nNot Cleaned State;");
            retValue.append(this.isCompileContext() ? "Compile Context;" : "Default/Null State;");
            retValue.append(this.isValid() ? "Valid State;" : "Invalid State;");
            retValue.append("\nInclude state Info:\n");
            retValue.append(this.inclState);
            retValue.append("\nMACROS state info:\n");
            retValue.append(this.macroState);
            return retValue.toString();
        }

        boolean equalsIgnoreInvalidFlag(APTPreprocHandler.State obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            if (this.isCompileContext() != other.isCompileContext()) {
                return false;
            }
            return this.inclState == other.inclState || this.inclState != null && this.inclState.equals(other.inclState);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            if (this.isCompileContext() != other.isCompileContext()) {
                return false;
            }
            if (this.isValid() != other.isValid()) {
                return false;
            }
            return this.inclState == other.inclState || this.inclState != null && this.inclState.equals(other.inclState);
        }

        public int hashCode() {
            int hash = 5;
            hash = 83 * hash + (this.isCompileContext() ? 1 : 0);
            hash = 83 * hash + (this.isValid() ? 1 : 0);
            hash = 83 * hash + (this.inclState != null ? this.inclState.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean isCompileContext() {
            return (this.attributes & 1) == 1;
        }

        @Override
        public boolean isCleaned() {
            return (this.attributes & 2) == 2;
        }

        @Override
        public boolean isValid() {
            return (this.attributes & 4) == 4;
        }

        APTPreprocHandler.State copy() {
            return new StateImpl(this, this.isCleaned(), this.isCompileContext(), this.isValid());
        }

        APTPreprocHandler.State copyCleaned() {
            return new StateImpl(this, true, this.isCompileContext(), this.isValid());
        }

        APTPreprocHandler.State copyInvalid() {
            return new StateImpl(this, this.isCleaned(), this.isCompileContext(), false);
        }

        public void write(RepositoryDataOutput output) throws IOException {
            output.writeByte((int)this.attributes);
            APTSerializeUtils.writeIncludeState(this.inclState, output);
            APTSerializeUtils.writeMacroMapState(this.macroState, output);
        }

        public StateImpl(FileSystem fs, RepositoryDataInput input) throws IOException {
            this.attributes = input.readByte();
            this.inclState = APTSerializeUtils.readIncludeState(fs, input);
            this.macroState = APTSerializeUtils.readMacroMapState(input);
        }
    }
}

