/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.parser;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CancellationException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParser;
import org.netbeans.modules.groovy.editor.java.ElementSearch;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.openide.util.Exceptions;

final class CompilationUnit
extends org.codehaus.groovy.control.CompilationUnit {
    public CompilationUnit(GroovyParser parser, CompilerConfiguration configuration, CodeSource security, GroovyClassLoader loader, GroovyClassLoader transformationLoader, JavaSource javaSource) {
        super(configuration, security, loader, transformationLoader);
        this.ast = new CompileUnit(parser, this.classLoader, security, this.configuration, javaSource);
    }

    private static class CompileUnit
    extends org.codehaus.groovy.ast.CompileUnit {
        private final GroovyParser parser;
        private final JavaSource javaSource;
        private final Map<String, ClassNode> cache = new HashMap<String, ClassNode>();

        public CompileUnit(GroovyParser parser, GroovyClassLoader classLoader, CodeSource codeSource, CompilerConfiguration config, JavaSource javaSource) {
            super(classLoader, codeSource, config);
            this.parser = parser;
            this.javaSource = javaSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClassNode getClass(final String name) {
            ClassNode classNode;
            if (this.parser.isCancelled()) {
                throw new CancellationException();
            }
            Map<String, ClassNode> map = this.cache;
            synchronized (map) {
                classNode = this.cache.get(name);
                if (classNode != null) {
                    return this.cache.get(name);
                }
            }
            classNode = super.getClass(name);
            if (classNode != null) {
                return classNode;
            }
            map = this.cache;
            synchronized (map) {
                if (this.cache.containsKey(name)) {
                    return null;
                }
            }
            try {
                Task<CompilationController> task = new Task<CompilationController>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController controller) throws Exception {
                        Elements elements = controller.getElements();
                        TypeElement typeElement = ElementSearch.getClass(elements, name);
                        Map map = CompileUnit.this.cache;
                        synchronized (map) {
                            if (typeElement != null) {
                                ClassNode node = CompileUnit.this.createClassNode(name, typeElement);
                                if (node != null) {
                                    CompileUnit.this.cache.put(name, node);
                                }
                            } else if (!CompileUnit.this.cache.containsKey(name)) {
                                CompileUnit.this.cache.put(name, null);
                            }
                        }
                    }
                };
                this.javaSource.runUserActionTask((Task)task, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            map = this.cache;
            synchronized (map) {
                return this.cache.get(name);
            }
        }

        private ClassNode createClassNode(String name, TypeElement typeElement) {
            int modifiers = 0;
            ClassNode superClass = null;
            HashSet<ClassNode> interfaces = new HashSet<ClassNode>();
            if (typeElement.getKind().isInterface()) {
                if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                    return null;
                }
                modifiers |= 0x200;
                for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                    interfaces.add(new ClassNode(((Object)Utilities.getClassName(typeMirror)).toString(), 512, null));
                }
            } else {
                TypeMirror typeMirror;
                Stack<DeclaredType> supers = new Stack<DeclaredType>();
                while (typeElement != null && typeElement.asType().getKind() != TypeKind.NONE && (typeMirror = typeElement.getSuperclass()).getKind() == TypeKind.DECLARED) {
                    DeclaredType superType = (DeclaredType)typeElement.getSuperclass();
                    supers.push(superType);
                    Element element = superType.asElement();
                    if ((element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.ENUM) && element instanceof TypeElement) {
                        typeElement = (TypeElement)element;
                        continue;
                    }
                    typeElement = null;
                }
                while (!supers.empty()) {
                    superClass = this.createClassNode(((Object)Utilities.getClassName((TypeMirror)supers.pop())).toString(), 0, superClass, Collections.<ClassNode>emptySet());
                }
            }
            return this.createClassNode(name, modifiers, superClass, interfaces);
        }

        private ClassNode createClassNode(String name, int modifiers, ClassNode superClass, Set<ClassNode> interfaces) {
            if ("java.lang.Object".equals(name) && superClass == null) {
                return ClassHelper.OBJECT_TYPE;
            }
            return new ClassNode(name, modifiers, superClass, interfaces.toArray(new ClassNode[interfaces.size()]), MixinNode.EMPTY_ARRAY);
        }
    }
}

