/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements;

import groovy.lang.MetaMethod;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.groovy.editor.api.elements.AstElement;
import org.netbeans.modules.groovy.editor.api.elements.MethodElement;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;

public class AstMethodElement
extends AstElement
implements MethodElement {
    private List<String> parameters;
    private Modifier access = Modifier.PUBLIC;
    private Class clz;
    private MetaMethod method;
    boolean GDK;
    private String methodSignature;

    public AstMethodElement(GroovyParserResult info, ASTNode node) {
        super(info, node);
    }

    public AstMethodElement(GroovyParserResult info, ASTNode node, Class clz, MetaMethod method, boolean GDK) {
        super(info, node);
        this.clz = clz;
        this.method = method;
        this.GDK = GDK;
    }

    public boolean isGDK() {
        return this.GDK;
    }

    public MetaMethod getMethod() {
        return this.method;
    }

    public Class getClz() {
        return this.clz;
    }

    @Override
    public List<String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
            for (Parameter parameter : ((MethodNode)this.node).getParameters()) {
                this.parameters.add(parameter.getName());
            }
        }
        return this.parameters;
    }

    @Override
    public String getSignature() {
        if (this.methodSignature == null) {
            StringBuilder builder = new StringBuilder(super.getSignature());
            Parameter[] params = ((MethodNode)this.node).getParameters();
            if (params.length > 0) {
                builder.append("(");
                for (Parameter parameter : params) {
                    builder.append(parameter.getType().getName());
                    builder.append(",");
                }
                builder.setLength(builder.length() - 1);
                builder.append(")");
            }
            this.methodSignature = builder.toString();
        }
        return this.methodSignature;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.node instanceof ConstructorNode) {
                this.name = ((ConstructorNode)this.node).getDeclaringClass().getNameWithoutPackage();
            } else if (this.node instanceof MethodNode) {
                this.name = ((MethodNode)this.node).getName();
            }
            if (this.name == null) {
                this.name = this.node.toString();
            }
        }
        return this.name;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = modifiers;
    }

    public void setAccess(Modifier access) {
        this.access = access;
        this.modifiers = this.modifiers != null && this.modifiers.contains(Modifier.STATIC) ? EnumSet.of(Modifier.STATIC, access) : null;
    }

    @Override
    public ElementKind getKind() {
        if (this.node instanceof ConstructorNode) {
            return ElementKind.CONSTRUCTOR;
        }
        return ElementKind.METHOD;
    }

    @Override
    public boolean isTopLevel() {
        return false;
    }

    @Override
    public boolean isInherited() {
        return false;
    }
}

