/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.beans.beaninfo.BiNode;
import org.netbeans.modules.beans.beaninfo.BiPanel;
import org.netbeans.modules.beans.beaninfo.GenerateBeanInfoAction;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public final class BIEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie,
PrintCookie,
EditorCookie.Observable {
    private static final String MV_JAVA_ID = "java";
    private static final String MV_BEANINFO_ID = "beaninfo";
    private static final String MIME_BEAN_INFO = "text/x-java-beaninfo";
    private BIGES guardedEditor;
    private GuardedSectionsProvider guardedProvider;
    private GenerateBeanInfoAction.BeanInfoWorker worker;
    private static final Set<BIEditorSupport> opened = Collections.synchronizedSet(new HashSet());
    private static Map<FileSystem, FileStatusListener> fsToStatusListener = new HashMap<FileSystem, FileStatusListener>();
    private CloneableTopComponent multiviewTC;
    private TopComponentsListener topComponentsListener;

    public BIEditorSupport(DataObject obj, CookieSet cookieSet) {
        super(obj, (CloneableEditorSupport.Env)new Environment(obj, cookieSet));
        this.setMIMEType("text/x-java");
    }

    public GuardedSectionManager getGuardedSectionManager() {
        try {
            StyledDocument doc = this.openDocument();
            return GuardedSectionManager.getInstance((StyledDocument)doc);
        }
        catch (IOException ex) {
            throw (IllegalStateException)new IllegalStateException("cannot open document").initCause(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        if (this.guardedEditor == null) {
            this.guardedEditor = new BIGES();
            GuardedSectionsFactory gFactory = GuardedSectionsFactory.find((String)((DataEditorSupport.Env)this.env).getMimeType());
            if (gFactory != null) {
                this.guardedProvider = gFactory.create((GuardedEditorSupport)this.guardedEditor);
            }
        }
        if (this.guardedProvider != null) {
            this.guardedEditor.doc = doc;
            Charset c = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Reader reader = this.guardedProvider.createGuardedReader(stream, c);
            try {
                kit.read(reader, (Document)doc, 0);
            }
            finally {
                reader.close();
            }
        } else {
            super.loadFromStreamToKit(doc, stream, kit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        if (this.guardedProvider != null) {
            Charset c = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Writer writer = this.guardedProvider.createGuardedWriter(stream, c);
            try {
                kit.write(writer, (Document)doc, 0, doc.getLength());
            }
            finally {
                writer.close();
            }
        } else {
            super.saveFromKitToStream(doc, kit, stream);
        }
    }

    public void saveDocument() throws IOException {
        if (this.worker != null && this.worker.isModelModified()) {
            this.worker.generateSources();
            this.worker.waitFinished();
        }
        super.saveDocument();
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        ((Environment)this.env).addSaveCookie();
        this.updateMVTCName();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        ((Environment)this.env).removeSaveCookie();
        this.updateMVTCName();
    }

    protected void notifyClosed() {
        opened.remove((Object)this);
        if (opened.isEmpty()) {
            BIEditorSupport.detachStatusListeners();
        }
        super.notifyClosed();
        this.worker = null;
        if (this.topComponentsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this.topComponentsListener);
            this.topComponentsListener = null;
        }
    }

    protected CloneableEditorSupport.Pane createPane() {
        DataObject dobj = this.getDataObject();
        if (dobj == null || !dobj.isValid()) {
            return super.createPane();
        }
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)MIME_BEAN_INFO, (Serializable)this.getDataObject());
    }

    private void setTopComponent(TopComponent topComp) {
        this.multiviewTC = (CloneableTopComponent)topComp;
        this.updateMVTCName();
        if (this.topComponentsListener == null) {
            this.topComponentsListener = new TopComponentsListener();
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.topComponentsListener);
        }
        opened.add(this);
        try {
            this.addStatusListener(this.getDataObject().getPrimaryFile().getFileSystem());
        }
        catch (FileStateInvalidException fsiex) {
            Exceptions.printStackTrace((Throwable)fsiex);
        }
    }

    private void addStatusListener(FileSystem fs) {
        FileStatusListener fsl = fsToStatusListener.get(fs);
        if (fsl == null) {
            fsl = new FileStatusListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void annotationChanged(FileStatusEvent ev) {
                    Set set = opened;
                    synchronized (set) {
                        for (BIEditorSupport fes : opened) {
                            if (!ev.hasChanged(fes.getDataObject().getPrimaryFile())) continue;
                            fes.updateMVTCName();
                        }
                    }
                }
            };
            fs.addFileStatusListener(fsl);
            fsToStatusListener.put(fs, fsl);
        }
    }

    private static void detachStatusListeners() {
        for (Map.Entry<FileSystem, FileStatusListener> entry : fsToStatusListener.entrySet()) {
            FileSystem fs = entry.getKey();
            FileStatusListener fsl = entry.getValue();
            fs.removeFileStatusListener(fsl);
        }
        fsToStatusListener.clear();
    }

    private void updateMVTCName() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                BIEditorSupport.this.updateMVTCNameInAwt();
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    private void updateMVTCNameInAwt() {
        CloneableTopComponent topComp = this.multiviewTC;
        if (topComp != null) {
            String htmlname = this.messageHtmlName();
            String name = this.messageName();
            String tip = this.messageToolTip();
            for (CloneableTopComponent o : NbCollections.iterable((Enumeration)topComp.getReference().getComponents())) {
                topComp.setHtmlDisplayName(htmlname);
                topComp.setDisplayName(name);
                topComp.setName(name);
                topComp.setToolTipText(tip);
            }
        }
    }

    static boolean isLastView(TopComponent tc) {
        if (!(tc instanceof CloneableTopComponent)) {
            return false;
        }
        boolean oneOrLess = true;
        Enumeration en = ((CloneableTopComponent)tc).getReference().getComponents();
        if (en.hasMoreElements()) {
            en.nextElement();
            if (en.hasMoreElements()) {
                oneOrLess = false;
            }
        }
        return oneOrLess;
    }

    static BIEditorSupport findEditor(DataObject dobj) {
        return (BIEditorSupport)((Object)dobj.getLookup().lookup(BIEditorSupport.class));
    }

    final CloseOperationState canCloseElement(TopComponent tc) {
        if (!BIEditorSupport.isLastView(tc)) {
            return CloseOperationState.STATE_OK;
        }
        if (!this.isModified()) {
            return CloseOperationState.STATE_OK;
        }
        AbstractAction save = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BIEditorSupport.this.saveDocument();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        save.putValue("LongDescription", NbBundle.getMessage(BIEditorSupport.class, (String)"MSG_MODIFIED", (Object)this.getDataObject().getPrimaryFile().getNameExt()));
        return MultiViewFactory.createUnsafeCloseState((String)"ID_BEANINFO_CLOSING", (Action)save, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    private class TopComponentsListener
    implements PropertyChangeListener {
        private TopComponentsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("opened".equals(evt.getPropertyName())) {
                Set closed = (Set)evt.getOldValue();
                closed.removeAll((Set)evt.getNewValue());
                for (TopComponent o : closed) {
                    if (!(o instanceof CloneableTopComponent)) continue;
                    CloneableTopComponent topComponent = (CloneableTopComponent)o;
                    Enumeration en = topComponent.getReference().getComponents();
                    if (BIEditorSupport.this.multiviewTC != topComponent) continue;
                    if (en.hasMoreElements()) {
                        BIEditorSupport.this.multiviewTC = (CloneableTopComponent)en.nextElement();
                        continue;
                    }
                    BIEditorSupport.this.notifyClosed();
                }
            }
        }
    }

    private static final class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -1L;
        private final transient CookieSet cookieSet;
        private transient SaveSupport saveCookie = null;

        public Environment(DataObject obj, CookieSet cookieSet) {
            super(obj);
            this.cookieSet = cookieSet;
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return BIEditorSupport.findEditor(this.getDataObject());
        }

        public void addSaveCookie() {
            DataObject javaData = this.getDataObject();
            if (javaData.getCookie(SaveCookie.class) == null) {
                if (this.saveCookie == null) {
                    this.saveCookie = new SaveSupport();
                }
                this.cookieSet.add((Node.Cookie)this.saveCookie);
                javaData.setModified(true);
            }
        }

        public void removeSaveCookie() {
            DataObject javaData = this.getDataObject();
            if (javaData.getCookie(SaveCookie.class) != null) {
                this.cookieSet.remove((Node.Cookie)this.saveCookie);
                javaData.setModified(false);
            }
        }

        private final class SaveSupport
        implements SaveCookie {
            private SaveSupport() {
            }

            public void save() throws IOException {
                DataObject dobj = Environment.this.getDataObject();
                ((DataEditorSupport)Environment.this.findCloneableOpenSupport()).saveDocument();
                dobj.setModified(false);
            }
        }
    }

    private static final class BIGES
    implements GuardedEditorSupport {
        StyledDocument doc = null;

        private BIGES() {
        }

        public StyledDocument getDocument() {
            return this.doc;
        }
    }

    public static final class BeanInfoElement
    extends CloneableTopComponent
    implements MultiViewElement,
    Externalizable {
        private static final long serialVersionUID = 1L;
        private MultiViewElementCallback callback;
        private DataObject dataObject;
        private boolean isInitialized = false;
        private final JPanel emptyToolbar = new JPanel();
        private BiPanel biPanel;

        public BeanInfoElement(Lookup lookup) {
            this.dataObject = (DataObject)lookup.lookup(DataObject.class);
            this.setActivatedNodes(new Node[]{this.dataObject.getNodeDelegate()});
        }

        private BeanInfoElement() {
        }

        public JComponent getVisualRepresentation() {
            return this;
        }

        public JComponent getToolbarRepresentation() {
            return this.emptyToolbar;
        }

        public void setMultiViewCallback(MultiViewElementCallback callback) {
            this.callback = callback;
            BIEditorSupport editor = BIEditorSupport.findEditor(this.dataObject);
            editor.setTopComponent(callback.getTopComponent());
        }

        public CloseOperationState canCloseElement() {
            BIEditorSupport editor = BIEditorSupport.findEditor(this.dataObject);
            return editor.canCloseElement(this.callback.getTopComponent());
        }

        public void componentActivated() {
            super.componentActivated();
        }

        public void componentDeactivated() {
            super.componentDeactivated();
        }

        public void componentHidden() {
            super.componentHidden();
        }

        public void componentShowing() {
            super.componentShowing();
            this.initialize();
        }

        public void componentClosed() {
            super.componentClosed();
        }

        public void componentOpened() {
            super.componentOpened();
        }

        private void initialize() {
            if (!this.isInitialized) {
                this.setLayout(new BorderLayout());
                this.biPanel = new BiPanel();
                this.add((Component)((Object)this.biPanel), "Center");
                this.isInitialized = true;
            } else {
                this.biPanel.setContext((Node)new BiNode.Wait());
            }
            FileObject biFile = this.dataObject.getPrimaryFile();
            String name = biFile.getName();
            name = name.substring(0, name.length() - "BeanInfo".length());
            FileObject javaFile = biFile.getParent().getFileObject(name, biFile.getExt());
            BIEditorSupport editor = BIEditorSupport.findEditor(this.dataObject);
            if (javaFile != null) {
                final GenerateBeanInfoAction.BeanInfoWorker beanInfoWorker = new GenerateBeanInfoAction.BeanInfoWorker(javaFile, this.biPanel);
                editor.worker = beanInfoWorker;
                beanInfoWorker.analyzePatterns().addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        beanInfoWorker.updateUI();
                    }
                });
            } else {
                this.biPanel.setContext(BiNode.createNoSourceNode(biFile));
            }
        }

        @Override
        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
            super.readExternal(oi);
            this.dataObject = (DataObject)oi.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput oo) throws IOException {
            super.writeExternal(oo);
            oo.writeObject(this.dataObject);
        }
    }

    public static final class JavaElement
    extends CloneableEditor
    implements MultiViewElement,
    Externalizable {
        private static final long serialVersionUID = 1L;
        private MultiViewElementCallback callback;
        private DataObject dataObject;

        public JavaElement(Lookup context) {
            super((CloneableEditorSupport)context.lookup(DataEditorSupport.class));
            this.dataObject = (DataObject)context.lookup(DataObject.class);
        }

        private JavaElement() {
        }

        public JComponent getVisualRepresentation() {
            return this;
        }

        public JComponent getToolbarRepresentation() {
            Document doc;
            JToolBar toolbar = null;
            JEditorPane jepane = this.getEditorPane();
            if (jepane != null && (doc = jepane.getDocument()) instanceof NbDocument.CustomToolbar) {
                toolbar = ((NbDocument.CustomToolbar)doc).createToolbar(jepane);
            }
            return toolbar;
        }

        public void setMultiViewCallback(MultiViewElementCallback callback) {
            this.callback = callback;
            BIEditorSupport editor = (BIEditorSupport)this.cloneableEditorSupport();
            editor.setTopComponent(callback.getTopComponent());
        }

        public CloseOperationState canCloseElement() {
            BIEditorSupport editor = BIEditorSupport.findEditor(this.dataObject);
            return editor.canCloseElement(this.callback.getTopComponent());
        }

        public void componentActivated() {
            super.componentActivated();
            BIEditorSupport editor = (BIEditorSupport)this.cloneableEditorSupport();
            if (editor.worker != null && editor.worker.isModelModified()) {
                editor.worker.generateSources();
            }
        }

        public void componentDeactivated() {
            super.componentDeactivated();
        }

        public void componentHidden() {
            super.componentHidden();
        }

        public void componentShowing() {
            super.componentShowing();
        }

        public void componentClosed() {
            super.canClose(null, true);
            super.componentClosed();
        }

        protected boolean closeLast() {
            return true;
        }

        public void componentOpened() {
            super.componentOpened();
        }

        public void updateName() {
            super.updateName();
            if (this.callback != null) {
                this.callback.updateTitle(this.getDisplayName());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
        }
    }
}

