/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.io.IOException;
import org.netbeans.api.java.loaders.JavaDataSupport;
import org.netbeans.modules.beans.beaninfo.BIDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

final class BIDataLoader
extends UniFileLoader {
    public static final String REQUIRED_MIME = "text/x-java";
    private static final String BEANINFO_SFX = "BeanInfo";
    private static final long serialVersionUID = 1L;

    public BIDataLoader() {
        super("org.netbeans.modules.beans.beaninfo.BIDataObject");
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(BIDataLoader.class, (String)"LBL_BeanInfo_loader_name");
    }

    protected void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(REQUIRED_MIME);
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new BIDataObject(primaryFile, this);
    }

    protected String actionsContext() {
        return "Loaders/text/x-java/Actions";
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return JavaDataSupport.createJavaFileEntry((MultiDataObject)obj, (FileObject)primaryFile);
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.getAttribute("template") != null && fo.getAttribute("javax.script.ScriptEngine") != null) {
            return null;
        }
        return BIDataLoader.isBeanInfo(fo) ? fo : null;
    }

    public static boolean isBeanInfo(FileObject fo) {
        String name;
        return fo != null && !fo.isFolder() && (name = fo.getName()).length() > BEANINFO_SFX.length() && name.endsWith(BEANINFO_SFX) && "java".equals(fo.getExt());
    }
}

