/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.addproperty;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.JButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.beans.addproperty.AddPropertyConfig;
import org.netbeans.modules.beans.addproperty.AddPropertyGenerator;
import org.netbeans.modules.beans.addproperty.AddPropertyPanel;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AddPropertyCodeGenerator
implements CodeGenerator {
    private JTextComponent component;
    private String className;
    private List<String> existingFields;
    private String[] pcsName;
    private String[] vcsName;

    public AddPropertyCodeGenerator(JTextComponent component, String className, List<String> existingFields, String[] pcsName, String[] vcsName) {
        this.component = component;
        this.className = className;
        this.existingFields = existingFields;
        this.pcsName = pcsName;
        this.vcsName = vcsName;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AddPropertyCodeGenerator.class, (String)"DN_AddProperty");
    }

    public void invoke() {
        Object o = this.component.getDocument().getProperty("stream");
        if (o instanceof DataObject) {
            DataObject d = (DataObject)o;
            this.perform(d.getPrimaryFile(), this.component);
        }
    }

    public void perform(FileObject file, JTextComponent pane) {
        JButton ok = new JButton(NbBundle.getMessage(AddPropertyCodeGenerator.class, (String)"LBL_ButtonOK"));
        AddPropertyPanel addPropertyPanel = new AddPropertyPanel(file, this.className, this.existingFields, this.pcsName, this.vcsName, ok);
        String caption = NbBundle.getMessage(AddPropertyCodeGenerator.class, (String)"CAP_AddProperty");
        String cancel = NbBundle.getMessage(AddPropertyCodeGenerator.class, (String)"LBL_ButtonCancel");
        DialogDescriptor dd = new DialogDescriptor((Object)addPropertyPanel, caption, true, new Object[]{ok, cancel}, (Object)ok, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == ok) {
            AddPropertyCodeGenerator.insertCode2(file, pane, addPropertyPanel.getAddPropertyConfig());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void insertCode2(FileObject file, final JTextComponent pane, AddPropertyConfig config) {
        final Document doc = pane.getDocument();
        final Reformat r = Reformat.get((Document)pane.getDocument());
        final String code = new AddPropertyGenerator().generate(config);
        final Position[] bounds = new Position[2];
        r.lock();
        try {
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int startOffset = pane.getCaretPosition();
                        GuardedSectionManager manager = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)doc));
                        if (manager != null) {
                            GuardedSection guard;
                            Iterator i$ = manager.getGuardedSections().iterator();
                            while (i$.hasNext() && (guard = (GuardedSection)i$.next()).contains(doc.createPosition(startOffset), true)) {
                                startOffset = guard.getEndPosition().getOffset() + 1;
                            }
                        }
                        doc.insertString(startOffset, code, null);
                        Position start = doc.createPosition(startOffset);
                        Position end = doc.createPosition(startOffset + code.length());
                        r.reformat(Utilities.getRowStart((JTextComponent)pane, (int)start.getOffset()), Utilities.getRowEnd((JTextComponent)pane, (int)end.getOffset()));
                        bounds[0] = start;
                        bounds[1] = end;
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            r.unlock();
        }
        if (bounds[0] != null) {
            try {
                JavaSource.forFileObject((FileObject)file).runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.RESOLVED);
                        Position start = bounds[0];
                        Position end = bounds[1];
                        new ImportFQNsHack(parameter, start.getOffset(), end.getOffset()).scan(parameter.getCompilationUnit(), null);
                        CompilationUnitTree cut = parameter.getCompilationUnit();
                        parameter.rewrite((Tree)cut, (Tree)parameter.getTreeMaker().CompilationUnit(cut.getPackageAnnotations(), cut.getPackageName(), cut.getImports(), cut.getTypeDecls(), cut.getSourceFile()));
                    }
                }).commit();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static void insertCode(final FileObject file, final JTextComponent pane, final AddPropertyConfig config) {
        try {
            JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)file), (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    AddPropertyCodeGenerator.insertCodeImpl(file, pane, config);
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void insertCodeImpl(final FileObject file, final JTextComponent pane, final AddPropertyConfig config) {
        try {
            final Document doc = pane.getDocument();
            final Reformat r = Reformat.get((Document)pane.getDocument());
            r.lock();
            try {
                NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)doc), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String code = new AddPropertyGenerator().generate(config);
                            int startOffset = pane.getCaretPosition();
                            doc.insertString(startOffset, code, null);
                            final Position start = doc.createPosition(startOffset);
                            final Position end = doc.createPosition(startOffset + code.length());
                            JavaSource.forFileObject((FileObject)file).runModificationTask((Task)new Task<WorkingCopy>(){

                                public void run(WorkingCopy parameter) throws Exception {
                                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                                    new ImportFQNsHack(parameter, start.getOffset(), end.getOffset()).scan(parameter.getCompilationUnit(), null);
                                    CompilationUnitTree cut = parameter.getCompilationUnit();
                                    parameter.rewrite((Tree)cut, (Tree)parameter.getTreeMaker().CompilationUnit(cut.getPackageName(), cut.getImports(), cut.getTypeDecls(), cut.getSourceFile()));
                                }
                            }).commit();
                            r.reformat(Utilities.getRowStart((JTextComponent)pane, (int)start.getOffset()), Utilities.getRowEnd((JTextComponent)pane, (int)end.getOffset()));
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            finally {
                r.unlock();
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static final class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            TreePath path;
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController cc = (CompilationController)context.lookup(CompilationController.class);
            for (path = (TreePath)context.lookup(TreePath.class); path != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()); path = path.getParentPath()) {
            }
            if (component == null || cc == null || path == null) {
                return Collections.emptyList();
            }
            Element e = cc.getTrees().getElement(path);
            if (e == null || !e.getKind().isClass()) {
                return Collections.emptyList();
            }
            TypeMirror pcs = Factory.resolve((CompilationInfo)cc, "java.beans.PropertyChangeSupport");
            TypeMirror vcs = Factory.resolve((CompilationInfo)cc, "java.beans.VetoableChangeSupport");
            if (pcs == null || vcs == null) {
                return Collections.emptyList();
            }
            LinkedList<String> existingFields = new LinkedList<String>();
            String[] pcsName = new String[2];
            String[] vcsName = new String[2];
            for (VariableElement field : ElementFilter.fieldsIn(e.getEnclosedElements())) {
                int i;
                existingFields.add(field.getSimpleName().toString());
                if (((Object)field.asType()).equals(pcs)) {
                    i = field.getModifiers().contains((Object)Modifier.STATIC) ? 1 : 0;
                    pcsName[i] = field.getSimpleName().toString();
                }
                if (!((Object)field.asType()).equals(vcs)) continue;
                i = field.getModifiers().contains((Object)Modifier.STATIC) ? 1 : 0;
                vcsName[i] = field.getSimpleName().toString();
            }
            String className = ((TypeElement)e).getQualifiedName().toString();
            return Collections.singletonList(new AddPropertyCodeGenerator(component, className, existingFields, pcsName, vcsName));
        }

        private static TypeMirror resolve(CompilationInfo info, String s) {
            TypeElement te = info.getElements().getTypeElement(s);
            if (te == null) {
                return null;
            }
            return te.asType();
        }
    }

    private static final class ImportFQNsHack
    extends TreePathScanner<Void, Void> {
        private WorkingCopy wc;
        private int start;
        private int end;

        public ImportFQNsHack(WorkingCopy wc, int start, int end) {
            this.wc = wc;
            this.start = start;
            this.end = end;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, Void p) {
            Element el;
            int s = (int)this.wc.getTrees().getSourcePositions().getStartPosition(this.wc.getCompilationUnit(), node);
            int e = (int)this.wc.getTrees().getSourcePositions().getEndPosition(this.wc.getCompilationUnit(), node);
            if (s >= this.start && e <= this.end && (el = this.wc.getTrees().getElement(this.getCurrentPath())) != null && (el.getKind().isClass() || el.getKind().isInterface()) && ((TypeElement)el).asType().getKind() != TypeKind.ERROR) {
                this.wc.rewrite((Tree)node, (Tree)this.wc.getTreeMaker().QualIdent(el));
                return null;
            }
            return (Void)super.visitMemberSelect(node, p);
        }

        @Override
        public Void visitMethod(MethodTree node, Void p) {
            return (Void)super.visitMethod(node, p);
        }
    }
}

