/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.samples;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.api.JavaFXProjectUtils;
import org.netbeans.modules.javafx2.samples.PanelConfigureProject;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;

public class PanelOptionsVisual
extends JPanel
implements TaskListener {
    private PanelConfigureProject panel;
    private volatile RequestProcessor.Task task;
    private DetectPlatformTask detectPlatformTask;
    private ComboBoxModel platformsModel;
    private ListCellRenderer platformsCellRenderer;
    private JavaPlatformChangeListener jpcl;
    private JButton btnManagePlatforms;
    private JLabel lblPlatform;
    private JComboBox platformComboBox;
    private JCheckBox setAsMainCheckBox;

    public PanelOptionsVisual(PanelConfigureProject panel) {
        this.panel = panel;
        this.detectPlatformTask = new DetectPlatformTask();
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
    }

    private void preInitComponents() {
        this.platformsModel = JavaFXProjectUtils.createPlatformComboBoxModel((String)"default_platform");
        this.platformsCellRenderer = JavaFXProjectUtils.createPlatformListCellRenderer();
    }

    private void postInitComponents() {
        this.platformComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.jpcl = new JavaPlatformChangeListener();
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.jpcl, (Object)JavaPlatformManager.getDefault()));
        this.selectJavaFXEnabledPlatform();
    }

    private void initComponents() {
        this.setAsMainCheckBox = new JCheckBox();
        this.lblPlatform = new JLabel();
        this.platformComboBox = new JComboBox();
        this.btnManagePlatforms = new JButton();
        this.setAsMainCheckBox.setMnemonic(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_SetAsMain_CheckBoxMnemonic").charAt(0));
        this.setAsMainCheckBox.setSelected(true);
        this.setAsMainCheckBox.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_SetAsMain_CheckBox"));
        this.setAsMainCheckBox.setActionCommand("Set as Main Project");
        this.lblPlatform.setLabelFor(this.platformComboBox);
        this.lblPlatform.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_Platform_ComboBox"));
        this.platformComboBox.setModel(this.platformsModel);
        this.platformComboBox.setRenderer(this.platformsCellRenderer);
        this.platformComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.platformComboBoxItemStateChanged(evt);
            }
        });
        this.btnManagePlatforms.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Manage_Button"));
        this.btnManagePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.btnManagePlatformsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.setAsMainCheckBox, -2, 293, -2).addGroup(layout.createSequentialGroup().addComponent(this.lblPlatform).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.platformComboBox, 0, 315, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnManagePlatforms)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPlatform).addComponent(this.platformComboBox, -2, 23, -2).addComponent(this.btnManagePlatforms)).addGap(18, 18, 18).addComponent(this.setAsMainCheckBox).addContainerGap(198, Short.MAX_VALUE)));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_NWP1_SetAsMain_A11YDesc"));
    }

    private void btnManagePlatformsActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getSelectedPlatform());
    }

    private void platformComboBoxItemStateChanged(ItemEvent evt) {
        this.panel.fireChangeEvent();
    }

    private JavaPlatform getSelectedPlatform() {
        Object selectedItem = this.platformComboBox.getSelectedItem();
        JavaPlatform platform = selectedItem == null ? null : JavaFXProjectUtils.getPlatform((Object)selectedItem);
        return platform;
    }

    private void selectJavaFXEnabledPlatform() {
        for (int i = 0; i < this.platformsModel.getSize(); ++i) {
            JavaPlatform platform = JavaFXProjectUtils.getPlatform(this.platformsModel.getElementAt(i));
            if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)platform)) continue;
            this.platformComboBox.setSelectedIndex(i);
            break;
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)this.getSelectedPlatform())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.notFXPlatform"));
            return false;
        }
        return true;
    }

    void store(WizardDescriptor d) {
        d.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        String platformName = (String)this.getSelectedPlatform().getProperties().get("platform.ant.name");
        d.putProperty("java.platform.name", (Object)platformName);
    }

    void read(WizardDescriptor d) {
        if (this.task == null) {
            this.checkPlatforms();
        }
    }

    private void checkPlatforms() {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        boolean fxPlatformExists = false;
        for (JavaPlatform javaPlatform : platforms) {
            if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)javaPlatform)) continue;
            fxPlatformExists = true;
            break;
        }
        if (!fxPlatformExists) {
            if (this.task != null) {
                this.task.removeTaskListener((TaskListener)this);
            }
            this.task = RequestProcessor.getDefault().create((Runnable)this.detectPlatformTask);
            this.task.addTaskListener((TaskListener)this);
            this.task.schedule(0);
        }
    }

    public synchronized void taskFinished(Task task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaPlatform platform = PanelOptionsVisual.this.detectPlatformTask.getPlatform();
                if (platform != null) {
                    PanelOptionsVisual.this.platformComboBox.setModel(PanelOptionsVisual.this.platformsModel);
                    PanelOptionsVisual.this.selectJavaFXEnabledPlatform();
                }
            }
        });
        this.task = null;
    }

    private class DetectPlatformTask
    implements Runnable {
        private JavaPlatform platform;

        private DetectPlatformTask() {
        }

        public JavaPlatform getPlatform() {
            return this.platform;
        }

        @Override
        public void run() {
            this.platform = JavaFXPlatformUtils.createDefaultJavaFXPlatform();
        }
    }

    private class JavaPlatformChangeListener
    implements PropertyChangeListener {
        private JavaPlatformChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PanelOptionsVisual.this.panel.fireChangeEvent();
        }
    }
}

