/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.phpdoc.ui.PhpDocPreferences;
import org.netbeans.modules.php.phpdoc.ui.options.PhpDocOptions;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class PhpDocScript
extends PhpProgram {
    public static final String SCRIPT_NAME = "phpdoc";
    public static final String SCRIPT_NAME_LONG = "phpdoc" + FileUtils.getScriptExtension((boolean)true);
    public static final String OPTIONS_SUB_PATH = "PhpDoc";
    private static final boolean IS_WINDOWS = Utilities.isWindows();

    private PhpDocScript(String command) {
        super(command);
    }

    public static PhpDocScript getDefault() throws PhpProgram.InvalidPhpProgramException {
        return PhpDocScript.getCustom(PhpDocOptions.getInstance().getPhpDoc());
    }

    private static PhpDocScript getCustom(String command) throws PhpProgram.InvalidPhpProgramException {
        String error = PhpDocScript.validate(command);
        if (error != null) {
            throw new PhpProgram.InvalidPhpProgramException(error);
        }
        return new PhpDocScript(command);
    }

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/PhpDoc";
    }

    public String validate() {
        return FileUtils.validateScript((String)this.getProgram(), (String)NbBundle.getMessage(PhpDocScript.class, (String)"LBL_PhpDocScript"));
    }

    public void generateDocumentation(PhpModule phpModule) {
        String phpDocTarget = PhpDocPreferences.getPhpDocTarget(phpModule, true);
        if (phpDocTarget == null) {
            return;
        }
        String sanitizedPhpDocTarget = this.sanitizePath(phpDocTarget);
        ExternalProcessBuilder processBuilder = this.getProcessBuilder().addArgument("-d").addArgument(this.sanitizePath(FileUtil.toFile((FileObject)phpModule.getSourceDirectory()).getAbsolutePath())).addArgument("-t").addArgument(sanitizedPhpDocTarget).addArgument("-ti").addArgument(PhpDocPreferences.getPhpDocTitle(phpModule));
        ExecutionDescriptor executionDescriptor = PhpDocScript.getExecutionDescriptor().frontWindow(false).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)new ErrorFileLineConvertorFactory(sanitizedPhpDocTarget)).optionsPath(PhpDocScript.getOptionsPath());
        try {
            File index;
            int status = PhpDocScript.executeAndWait((ExternalProcessBuilder)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)NbBundle.getMessage(PhpDocScript.class, (String)"LBL_GeneratingPhpDocForProject", (Object)phpModule.getDisplayName()));
            if (status == 0 && (index = new File(phpDocTarget, "index.html")).isFile()) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(index.toURI().toURL());
            }
        }
        catch (CancellationException ex) {
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)OPTIONS_SUB_PATH);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
    }

    private String sanitizePath(String path) {
        if (IS_WINDOWS) {
            return path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public static String validate(String command) {
        return new PhpDocScript(command).validate();
    }

    private class ErrorFileOutputListener
    implements OutputListener {
        private URL url;

        public ErrorFileOutputListener(URL url) {
            this.url = url;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.url);
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private class ErrorFileLineConvertor
    implements LineConvertor {
        private final Pattern pattern;

        public ErrorFileLineConvertor(Pattern pattern) {
            this.pattern = pattern;
        }

        public List<ConvertedLine> convert(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.matches()) {
                try {
                    URL url = new URL("file://" + matcher.group(2));
                    LinkedList<ConvertedLine> lines = new LinkedList<ConvertedLine>();
                    if (!matcher.group(1).trim().isEmpty()) {
                        lines.add(ConvertedLine.forText((String)matcher.group(1), null));
                    }
                    lines.add(ConvertedLine.forText((String)matcher.group(2), (OutputListener)new ErrorFileOutputListener(url)));
                    if (!matcher.group(3).trim().isEmpty()) {
                        lines.add(ConvertedLine.forText((String)matcher.group(3), null));
                    }
                    return lines;
                }
                catch (MalformedURLException ex) {
                    LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
                }
            }
            return null;
        }
    }

    private class ErrorFileLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        private String docTarget;

        public ErrorFileLineConvertorFactory(String docTarget) {
            this.docTarget = docTarget;
        }

        public LineConvertor newLineConvertor() {
            Pattern pattern = Pattern.compile("(.*)(" + Pattern.quote(this.docTarget) + "/?errors\\.html)(.*)");
            return new ErrorFileLineConvertor(pattern);
        }
    }
}

