/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;

public class GroupOptionProcessor
extends OptionProcessor {
    private static final Option OPEN_OPTION = Option.shortDescription((Option)Option.displayName((Option)Option.requiredArgument((char)'\uffff', (String)"open-group"), (String)Bundle.class.getName(), (String)"GroupOptionProcessor.open.name"), (String)Bundle.class.getName(), (String)"GroupOptionProcessor.open.desc");
    private static final Option CLOSE_OPTION = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"close-group"), (String)Bundle.class.getName(), (String)"GroupOptionProcessor.close.desc");
    private static final Option LIST_OPTION = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"list-groups"), (String)Bundle.class.getName(), (String)"GroupOptionProcessor.list.desc");

    protected Set<Option> getOptions() {
        return new LinkedHashSet<Option>(Arrays.asList(OPEN_OPTION, CLOSE_OPTION, LIST_OPTION));
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        String[] val = optionValues.get(OPEN_OPTION);
        if (val != null) {
            String name = val[0];
            for (Group g : Group.allGroups()) {
                if (!g.id.equals(name) && !g.getName().equals(name)) continue;
                Group.setActiveGroup(g);
                return;
            }
            throw new CommandException(2, Bundle.GroupOptionProcessor_no_such_group(name));
        }
        if (optionValues.containsKey(CLOSE_OPTION)) {
            Group.setActiveGroup(null);
        } else if (optionValues.containsKey(LIST_OPTION)) {
            int max_size = Bundle.GroupOptionProcessor_column_id().length();
            for (Group g : Group.allGroups()) {
                max_size = Math.max(max_size, g.id.length());
            }
            PrintStream ps = env.getOutputStream();
            ps.printf("%-" + max_size + "s  %s\n", Bundle.GroupOptionProcessor_column_id(), Bundle.GroupOptionProcessor_column_name());
            for (Group g : Group.allGroups()) {
                ps.printf("%-" + max_size + "s  %s\n", g.id, g.getName());
            }
        }
    }
}

