/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.project.ui.Bundle;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class PhysicalView {
    private static final Logger LOG = Logger.getLogger(PhysicalView.class.getName());

    private PhysicalView() {
    }

    public static boolean isProjectDirNode(Node n) {
        GroupNodeInfo i = (GroupNodeInfo)n.getLookup().lookup(GroupNodeInfo.class);
        return i != null && i.isProjectDir;
    }

    public static Node[] createNodesForProject(Project p) {
        Sources s = ProjectUtils.getSources((Project)p);
        SourceGroup[] groups = s.getSourceGroups("generic");
        FileObject projectDirectory = p.getProjectDirectory();
        ArrayList<ProjectIconNode> nodesList = new ArrayList<ProjectIconNode>(groups.length);
        for (SourceGroup group : groups) {
            FileObject rootFolder;
            if ("sharedlibraries".equals(group.getName()) || !(rootFolder = group.getRootFolder()).isValid() || !rootFolder.isFolder()) continue;
            nodesList.add(new ProjectIconNode((Node)new GroupNode(p, group, projectDirectory.equals(rootFolder) || FileUtil.isParentOf((FileObject)rootFolder, (FileObject)projectDirectory), DataFolder.findFolder((FileObject)rootFolder)), true));
        }
        Node[] nodes = new Node[nodesList.size()];
        nodesList.toArray(nodes);
        return nodes;
    }

    public static class PathFinder {
        private SourceGroup group;

        public PathFinder(SourceGroup group) {
            this.group = group;
        }

        public Node findPath(Node root, Object object) {
            block10: {
                if (!(object instanceof FileObject)) {
                    return null;
                }
                FileObject fo = (FileObject)object;
                FileObject groupRoot = this.group.getRootFolder();
                if (FileUtil.isParentOf((FileObject)groupRoot, (FileObject)fo)) {
                    String relPath = FileUtil.getRelativePath((FileObject)groupRoot, (FileObject)fo);
                    ArrayList<String> path = new ArrayList<String>();
                    StringTokenizer strtok = new StringTokenizer(relPath, "/");
                    while (strtok.hasMoreTokens()) {
                        path.add(strtok.nextToken());
                    }
                    if (path.size() <= 0) {
                        return null;
                    }
                    path.remove(path.size() - 1);
                    try {
                        DataObject dobj;
                        Node parent = NodeOp.findPath((Node)root, Collections.enumeration(path));
                        if (parent == null) break block10;
                        Node[] nds = parent.getChildren().getNodes(true);
                        for (int i = 0; i < nds.length; ++i) {
                            dobj = (DataObject)nds[i].getLookup().lookup(DataObject.class);
                            if (dobj == null || !fo.equals(dobj.getPrimaryFile())) continue;
                            return nds[i];
                        }
                        String name = fo.getName();
                        try {
                            dobj = DataObject.find((FileObject)fo);
                            name = dobj.getNodeDelegate().getName();
                        }
                        catch (DataObjectNotFoundException ex) {
                            // empty catch block
                        }
                        return parent.getChildren().findChild(name);
                    }
                    catch (NodeNotFoundException e) {
                        return null;
                    }
                }
                if (groupRoot.equals(fo)) {
                    return root;
                }
            }
            return null;
        }
    }

    private static final class ProjectBadgingChildren
    extends FilterNode.Children {
        public ProjectBadgingChildren(Node orig) {
            super(orig);
        }

        protected Node copyNode(Node orig) {
            return new ProjectIconNode(orig, false);
        }
    }

    static final class ProjectIconNode
    extends FilterNode
    implements NodeListener {
        private final boolean root;

        public ProjectIconNode(Node orig, boolean root) {
            super(orig, (Children)(orig.isLeaf() ? FilterNode.Children.LEAF : new ProjectBadgingChildren(orig)));
            this.root = root;
            this.addNodeListener(this);
        }

        protected NodeListener createNodeListener() {
            return new FilterNode.NodeAdapter(this){

                protected void propertyChange(FilterNode fn, PropertyChangeEvent ev) {
                    super.propertyChange(fn, ev);
                    if ("leaf".equals(ev.getPropertyName())) {
                        Node orig = ProjectIconNode.this.getOriginal();
                        ProjectIconNode.this.setChildren((Children)(orig.isLeaf() ? FilterNode.Children.LEAF : new ProjectBadgingChildren(orig)));
                    }
                }
            };
        }

        public Image getIcon(int type) {
            return this.swap(super.getIcon(type));
        }

        public Image getOpenedIcon(int type) {
            return this.swap(super.getOpenedIcon(type));
        }

        private Image swap(Image base) {
            Icon icon;
            ProjectManager.Result r;
            DataFolder folder;
            if (!this.root && (folder = (DataFolder)this.getOriginal().getLookup().lookup(DataFolder.class)) != null && (r = ProjectManager.getDefault().isProject2(folder.getPrimaryFile())) != null && (icon = r.getIcon()) != null) {
                return ImageUtilities.icon2Image((Icon)icon);
            }
            return base;
        }

        public String getShortDescription() {
            DataFolder folder = (DataFolder)this.getOriginal().getLookup().lookup(DataFolder.class);
            if (folder != null) {
                try {
                    Project p = ProjectManager.getDefault().findProject(folder.getPrimaryFile());
                    if (p != null) {
                        return ProjectUtils.getInformation((Project)p).getDisplayName();
                    }
                }
                catch (IOException x) {
                    LOG.log(Level.FINE, null, x);
                }
            }
            return super.getShortDescription();
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    static final class GroupNode
    extends FilterNode
    implements PropertyChangeListener {
        private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
        private ProjectInformation pi;
        private SourceGroup group;
        private boolean isProjectDir;

        public GroupNode(Project project, SourceGroup group, boolean isProjectDir, DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER), GroupNode.createLookup(project, group, dataFolder, isProjectDir));
            this.pi = ProjectUtils.getInformation((Project)project);
            this.group = group;
            this.isProjectDir = isProjectDir;
            this.pi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pi));
            group.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group));
        }

        public String getName() {
            if (this.isProjectDir) {
                return this.pi.getName();
            }
            String n = this.group.getName();
            if (n == null) {
                n = "???";
                LOG.log(Level.WARNING, "SourceGroup impl of type {0} specified a null getName(); this is illegal", this.group.getClass().getName());
            }
            return n;
        }

        public String getDisplayName() {
            if (this.isProjectDir) {
                return this.pi.getDisplayName();
            }
            return Bundle.FMT_PhysicalView_GroupName(this.group.getDisplayName(), this.pi.getDisplayName(), this.getOriginal().getDisplayName());
        }

        public String getShortDescription() {
            FileObject gdir = this.group.getRootFolder();
            String dir = FileUtil.getFileDisplayName((FileObject)gdir);
            return this.isProjectDir ? Bundle.HINT_project(dir) : Bundle.HINT_group(dir);
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean context) {
            Action[] projectActions;
            if (context) {
                return super.getActions(true);
            }
            Action[] folderActions = super.getActions(false);
            if (this.isProjectDir) {
                projectActions = new Action[folderActions.length];
                for (int i = 0; i < folderActions.length; ++i) {
                    projectActions[i] = folderActions[i] instanceof PropertiesAction ? CommonProjectActions.customizeProjectAction() : folderActions[i];
                }
            } else {
                projectActions = folderActions;
            }
            return projectActions;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String prop = evt.getPropertyName();
                    boolean ok = false;
                    if (prop == null || "displayName".equals(prop)) {
                        GroupNode.this.fireDisplayNameChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "name".equals(prop)) {
                        GroupNode.this.fireNameChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "icon".equals(prop)) {
                        ok = true;
                    }
                    if (prop == null || "name".equals(prop)) {
                        GroupNode.this.fireNameChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "displayName".equals(prop)) {
                        GroupNode.this.fireDisplayNameChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "icon".equals(prop)) {
                        ok = true;
                    }
                    if (prop == null || "rootFolder".equals(prop)) {
                        GroupNode.this.fireNameChange(null, null);
                        GroupNode.this.fireDisplayNameChange(null, null);
                        GroupNode.this.fireShortDescriptionChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "containership".equals(prop)) {
                        ok = true;
                    }
                    if (!ok) assert (false) : "Attempt to fire an unsupported property change event from " + GroupNode.access$900(GroupNode.this).getClass().getName() + ": " + prop;
                }
            };
            SwingUtilities.invokeLater(r);
        }

        private static Lookup createLookup(Project p, SourceGroup group, DataFolder dataFolder, boolean isProjectDir) {
            return new ProxyLookup(new Lookup[]{dataFolder.getNodeDelegate().getLookup(), Lookups.fixed((Object[])new Object[]{p, new PathFinder(group), new GroupNodeInfo(isProjectDir)}), p.getLookup()});
        }

        static /* synthetic */ ProjectInformation access$900(GroupNode x0) {
            return x0.pi;
        }
    }

    static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter,
    DataFilter.FileBased {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptFileObject(obj.getPrimaryFile());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    VisibilityQueryDataFilter.this.changeSupport.fireChange();
                }
            };
            SwingUtilities.invokeLater(r);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public boolean acceptFileObject(FileObject fo) {
            return VisibilityQuery.getDefault().isVisible(fo);
        }
    }

    private static final class GroupNodeInfo {
        public final boolean isProjectDir;

        public GroupNodeInfo(boolean isProjectDir) {
            this.isProjectDir = isProjectDir;
        }
    }
}

