/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.project.ui.ExtIcon;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class OpenProjectListSettings {
    private static OpenProjectListSettings INSTANCE = new OpenProjectListSettings();
    private static final String RECENT_PROJECTS_DISPLAY_NAMES = "RecentProjectsDisplayNames";
    private static final String RECENT_PROJECTS_DISPLAY_ICONS = "RecentProjectsIcons";
    private static final String LAST_OPEN_PROJECT_DIR = "lastOpenProjectDir";
    private static final String PROP_PROJECT_CATEGORY = "lastSelectedProjectCategory";
    private static final String PROP_PROJECT_TYPE = "lastSelectedProjectType";
    private static final String MAIN_PROJECT_URL = "mainProjectURL";
    private static final String OPEN_AS_MAIN = "openAsMain";
    private static final String OPEN_PROJECTS_URLS = "openProjectsURLs";
    private static final String OPEN_PROJECTS_DISPLAY_NAMES = "openProjectsDisplayNames";
    private static final String OPEN_PROJECTS_ICONS = "openProjectsIcons";
    private static final String OPEN_SUBPROJECTS = "openSubprojects";
    private static final String PROP_PROJECTS_FOLDER = "projectsFolder";
    private static final String RECENT_PROJECTS_URLS = "recentProjectsURLs";
    private static final String RECENT_TEMPLATES = "recentTemplates";
    public static final String PROP_CREATED_PROJECTS_FOLDER = "createdProjectsFolderInWizard";

    private OpenProjectListSettings() {
    }

    public static OpenProjectListSettings getInstance() {
        return INSTANCE;
    }

    protected final String putProperty(String key, String value, boolean notify) {
        String retval = this.getProperty(key);
        if (value != null) {
            this.getPreferences().put(key, value);
        } else {
            this.getPreferences().remove(key);
        }
        return retval;
    }

    protected final String getProperty(String key) {
        return this.getPreferences().get(key, null);
    }

    protected final List<URL> getURLList(String key) {
        List<String> strs = this.getStringList(key);
        ArrayList<URL> toRet = new ArrayList<URL>();
        for (String val : strs) {
            try {
                toRet.add(new URL(val));
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return toRet;
    }

    protected final List<String> getStringList(String key) {
        Preferences pref = this.getPreferences();
        int count = 0;
        String val = pref.get(key + "." + count, null);
        ArrayList<String> toRet = new ArrayList<String>();
        while (val != null) {
            toRet.add(val);
            val = pref.get(key + "." + ++count, null);
        }
        return toRet;
    }

    protected final List<ExtIcon> getIconList(String key) {
        Preferences pref = this.getPreferences();
        int count = 0;
        byte[] val = pref.getByteArray(key + "." + count, null);
        ArrayList<ExtIcon> toRet = new ArrayList<ExtIcon>();
        while (val != null) {
            toRet.add(val.length > 0 ? new ExtIcon(val) : new ExtIcon());
            val = pref.getByteArray(key + "." + ++count, null);
        }
        return toRet;
    }

    protected final void setIconList(String basekey, List<ExtIcon> list) throws IOException {
        assert (list != null);
        Preferences pref = this.getPreferences();
        int count = 0;
        String key = basekey + "." + count;
        String val = pref.get(key, null);
        Iterator<ExtIcon> it = list.iterator();
        while (val != null || it.hasNext()) {
            if (it.hasNext()) {
                byte[] data = it.next().getBytes();
                if (data == null) {
                    data = new byte[]{};
                }
                pref.putByteArray(key, data);
            } else {
                pref.remove(key);
            }
            key = basekey + "." + ++count;
            val = pref.get(key, null);
        }
    }

    protected final void setStringList(String basekey, List<String> list) {
        assert (list != null);
        Preferences pref = this.getPreferences();
        int count = 0;
        String key = basekey + "." + count;
        String val = pref.get(key, null);
        Iterator<String> it = list.iterator();
        while (val != null || it.hasNext()) {
            if (it.hasNext()) {
                pref.put(key, it.next());
            } else {
                pref.remove(key);
            }
            key = basekey + "." + ++count;
            val = pref.get(key, null);
        }
    }

    protected final void setURLList(String basekey, List<URL> list) {
        assert (list != null);
        ArrayList<String> strs = new ArrayList<String>(list.size());
        for (URL url : list) {
            strs.add(url.toExternalForm());
        }
        this.setStringList(basekey, strs);
    }

    protected final Preferences getPreferences() {
        return NbPreferences.forModule(OpenProjectListSettings.class);
    }

    public List<URL> getOpenProjectsURLs() {
        return this.getURLList(OPEN_PROJECTS_URLS);
    }

    public void setOpenProjectsURLs(List<URL> list) {
        this.setURLList(OPEN_PROJECTS_URLS, list);
    }

    public void setOpenProjectsURLsAsStrings(List<String> list) {
        this.setStringList(OPEN_PROJECTS_URLS, list);
    }

    public List<String> getOpenProjectsDisplayNames() {
        return this.getStringList(OPEN_PROJECTS_DISPLAY_NAMES);
    }

    public void setOpenProjectsDisplayNames(List<String> list) {
        this.setStringList(OPEN_PROJECTS_DISPLAY_NAMES, list);
    }

    public List<ExtIcon> getOpenProjectsIcons() {
        return this.getIconList(OPEN_PROJECTS_ICONS);
    }

    public void setOpenProjectsIcons(List<ExtIcon> list) {
        try {
            this.setIconList(OPEN_PROJECTS_ICONS, list);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isOpenSubprojects() {
        return this.getPreferences().getBoolean(OPEN_SUBPROJECTS, false);
    }

    public void setOpenSubprojects(boolean openSubprojects) {
        this.getPreferences().putBoolean(OPEN_SUBPROJECTS, openSubprojects);
    }

    public boolean isOpenAsMain() {
        return this.getPreferences().getBoolean(OPEN_AS_MAIN, false);
    }

    public void setOpenAsMain(boolean openAsMain) {
        this.getPreferences().putBoolean(OPEN_AS_MAIN, openAsMain);
    }

    public URL getMainProjectURL() {
        String str = this.getProperty(MAIN_PROJECT_URL);
        if (str != null) {
            try {
                return new URL(str);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public void setMainProjectURL(URL mainProjectURL) {
        this.setMainProjectURL(mainProjectURL != null ? mainProjectURL.toString() : null);
    }

    public void setMainProjectURL(String mainProjectURL) {
        this.putProperty(MAIN_PROJECT_URL, mainProjectURL, true);
    }

    public String getLastOpenProjectDir() {
        String result = this.getProperty(LAST_OPEN_PROJECT_DIR);
        if (result == null) {
            result = this.getProjectsFolder(false).getAbsolutePath();
        }
        return result;
    }

    public void setLastOpenProjectDir(String path) {
        this.putProperty(LAST_OPEN_PROJECT_DIR, path, true);
    }

    public List<URL> getRecentProjectsURLs() {
        return this.getURLList(RECENT_PROJECTS_URLS);
    }

    public List<String> getRecentProjectsDisplayNames() {
        return this.getStringList(RECENT_PROJECTS_DISPLAY_NAMES);
    }

    public List<ExtIcon> getRecentProjectsIcons() {
        return this.getIconList(RECENT_PROJECTS_DISPLAY_ICONS);
    }

    public void setRecentProjectsURLs(List<URL> list) {
        this.setURLList(RECENT_PROJECTS_URLS, list);
    }

    public void setRecentProjectsDisplayNames(List<String> list) {
        this.setStringList(RECENT_PROJECTS_DISPLAY_NAMES, list);
    }

    public void setRecentProjectsIcons(List<ExtIcon> list) {
        try {
            this.setIconList(RECENT_PROJECTS_DISPLAY_ICONS, list);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public File getProjectsFolder(boolean create) {
        String result = this.getProperty(PROP_PROJECTS_FOLDER);
        if (result == null || !new File(result).exists()) {
            File f;
            String userPrjDir = System.getProperty("netbeans.projects.dir");
            if (userPrjDir != null && (f = new File(userPrjDir)).exists() && f.isDirectory()) {
                return FileUtil.normalizeFile((File)f);
            }
            if (Boolean.getBoolean("netbeans.full.hack")) {
                return FileUtil.normalizeFile((File)new File(System.getProperty("java.io.tmpdir", "")));
            }
            File defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
            if (defaultDir != null && defaultDir.exists() && defaultDir.isDirectory()) {
                boolean created;
                String nbPrjDirName = NbBundle.getMessage(OpenProjectListSettings.class, (String)"DIR_NetBeansProjects");
                File nbPrjDir = new File(defaultDir, nbPrjDirName);
                if (nbPrjDir.exists() && nbPrjDir.canWrite()) {
                    return nbPrjDir;
                }
                boolean bl = created = create && nbPrjDir.mkdir();
                if (created) {
                    this.getPreferences().put(PROP_CREATED_PROJECTS_FOLDER, nbPrjDir.getAbsolutePath());
                    return nbPrjDir;
                }
            }
            result = System.getProperty("user.home");
        }
        return FileUtil.normalizeFile((File)new File(result));
    }

    public void setProjectsFolder(File folder) {
        if (folder == null) {
            this.putProperty(PROP_PROJECTS_FOLDER, null, true);
        } else {
            this.putProperty(PROP_PROJECTS_FOLDER, folder.getAbsolutePath(), true);
        }
    }

    public List<String> getRecentTemplates() {
        return this.getStringList(RECENT_TEMPLATES);
    }

    public void setRecentTemplates(List<String> templateNames) {
        this.setStringList(RECENT_TEMPLATES, templateNames);
    }

    public String getLastSelectedProjectCategory() {
        return this.getProperty(PROP_PROJECT_CATEGORY);
    }

    public void setLastSelectedProjectCategory(String category) {
        this.putProperty(PROP_PROJECT_CATEGORY, category, true);
    }

    public String getLastSelectedProjectType() {
        return this.getProperty(PROP_PROJECT_TYPE);
    }

    public void setLastSelectedProjectType(String type) {
        this.putProperty(PROP_PROJECT_TYPE, type, true);
    }
}

