/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.index;

import java.io.IOException;
import org.netbeans.modules.cnd.repository.sfs.index.CompactFileIndex;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndex;
import org.netbeans.modules.cnd.repository.sfs.index.SimpleFileIndex;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.AbstractObjectFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileIndexFactory
extends AbstractObjectFactory {
    private static FileIndexFactory theFactory;
    private static final Object lock;
    private static final int FIRST_INDEX = 0;
    private static final int FILE_INDEX_SIMPLE = 0;
    private static final int FILE_INDEX_COMPACT = 1;
    public static final int LAST_INDEX = 1;

    protected FileIndexFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileIndexFactory getDefaultFactory() {
        Object object = lock;
        synchronized (object) {
            if (theFactory == null) {
                theFactory = new FileIndexFactory();
            }
        }
        return theFactory;
    }

    public void writeIndex(FileIndex anIndex, RepositoryDataOutput aStream) throws IOException {
        assert (anIndex instanceof SelfPersistent);
        super.writeSelfPersistent((SelfPersistent)anIndex, aStream);
    }

    public FileIndex readIndex(RepositoryDataInput aStream) throws IOException {
        assert (aStream != null);
        SelfPersistent out = super.readSelfPersistent(aStream);
        assert (out instanceof FileIndex);
        return (FileIndex)out;
    }

    protected int getHandler(Object object) {
        int aHandle;
        if (object instanceof SimpleFileIndex) {
            aHandle = 0;
        } else if (object instanceof CompactFileIndex) {
            aHandle = 1;
        } else {
            throw new IllegalArgumentException("The Index is an instance of the unknown final class " + object.getClass().getName());
        }
        return aHandle;
    }

    protected SelfPersistent createObject(int handler, RepositoryDataInput stream) throws IOException {
        SelfPersistent anIndex;
        switch (handler) {
            case 0: {
                anIndex = new SimpleFileIndex(stream);
                break;
            }
            case 1: {
                anIndex = new CompactFileIndex(stream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hander for index was provided: " + handler);
            }
        }
        return anIndex;
    }

    static {
        lock = new Object();
    }
}

