/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.spi.configurations;

import java.util.Iterator;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.openide.util.Lookup;

public abstract class CompileOptionsProvider {
    private static CompileOptionsProvider DEFAULT = new Default();

    public abstract void rename(MakeConfiguration var1, String var2);

    public abstract void remove(MakeConfiguration var1);

    public abstract AllOptionsProvider getOptions(Item var1);

    protected CompileOptionsProvider() {
    }

    public static synchronized CompileOptionsProvider getDefault() {
        return DEFAULT;
    }

    private static final class Default
    extends CompileOptionsProvider {
        private final Lookup.Result<CompileOptionsProvider> res = Lookup.getDefault().lookupResult(CompileOptionsProvider.class);
        private static final boolean FIX_SERVICE = true;
        private CompileOptionsProvider fixedSelector;

        Default() {
        }

        private CompileOptionsProvider getService() {
            CompileOptionsProvider service = this.fixedSelector;
            if (service == null) {
                Iterator i$ = this.res.allInstances().iterator();
                if (i$.hasNext()) {
                    CompileOptionsProvider selector;
                    service = selector = (CompileOptionsProvider)i$.next();
                }
                if (service != null) {
                    this.fixedSelector = service;
                }
            }
            return service;
        }

        @Override
        public AllOptionsProvider getOptions(Item item) {
            CompileOptionsProvider service = this.getService();
            if (service != null) {
                return service.getOptions(item);
            }
            return null;
        }

        @Override
        public void rename(MakeConfiguration makeConfiguration, String newName) {
            CompileOptionsProvider service = this.getService();
            if (service != null) {
                service.rename(makeConfiguration, newName);
            }
        }

        @Override
        public void remove(MakeConfiguration makeConfiguration) {
            CompileOptionsProvider service = this.getService();
            if (service != null) {
                service.remove(makeConfiguration);
            }
        }
    }
}

